/*
 * Decompiled with CFR 0.152.
 */
package org.python.netty.buffer;

import java.nio.ByteOrder;
import org.python.netty.buffer.ByteBuf;
import org.python.netty.buffer.CompositeByteBuf;
import org.python.netty.buffer.SimpleLeakAwareByteBuf;
import org.python.netty.buffer.WrappedCompositeByteBuf;
import org.python.netty.util.ResourceLeak;

final class SimpleLeakAwareCompositeByteBuf
extends WrappedCompositeByteBuf {
    private final ResourceLeak leak;

    SimpleLeakAwareCompositeByteBuf(CompositeByteBuf wrapped, ResourceLeak leak) {
        super(wrapped);
        this.leak = leak;
    }

    @Override
    public boolean release() {
        boolean deallocated = super.release();
        if (deallocated) {
            this.leak.close();
        }
        return deallocated;
    }

    @Override
    public boolean release(int decrement) {
        boolean deallocated = super.release(decrement);
        if (deallocated) {
            this.leak.close();
        }
        return deallocated;
    }

    @Override
    public ByteBuf order(ByteOrder endianness) {
        this.leak.record();
        if (this.order() == endianness) {
            return this;
        }
        return new SimpleLeakAwareByteBuf(super.order(endianness), this.leak);
    }

    @Override
    public ByteBuf slice() {
        return new SimpleLeakAwareByteBuf(super.slice(), this.leak);
    }

    @Override
    public ByteBuf retainedSlice() {
        return new SimpleLeakAwareByteBuf(super.retainedSlice(), this.leak);
    }

    @Override
    public ByteBuf slice(int index, int length) {
        return new SimpleLeakAwareByteBuf(super.slice(index, length), this.leak);
    }

    @Override
    public ByteBuf retainedSlice(int index, int length) {
        return new SimpleLeakAwareByteBuf(super.retainedSlice(index, length), this.leak);
    }

    @Override
    public ByteBuf duplicate() {
        return new SimpleLeakAwareByteBuf(super.duplicate(), this.leak);
    }

    @Override
    public ByteBuf retainedDuplicate() {
        return new SimpleLeakAwareByteBuf(super.retainedDuplicate(), this.leak);
    }

    @Override
    public ByteBuf readSlice(int length) {
        return new SimpleLeakAwareByteBuf(super.readSlice(length), this.leak);
    }

    @Override
    public ByteBuf readRetainedSlice(int length) {
        return new SimpleLeakAwareByteBuf(super.readRetainedSlice(length), this.leak);
    }

    @Override
    public ByteBuf asReadOnly() {
        return new SimpleLeakAwareByteBuf(super.asReadOnly(), this.leak);
    }
}

