/*
 * Decompiled with CFR 0.152.
 */
package org.python.netty.resolver;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.python.netty.resolver.InetSocketAddressResolver;
import org.python.netty.resolver.NameResolver;
import org.python.netty.util.concurrent.EventExecutor;
import org.python.netty.util.concurrent.Future;
import org.python.netty.util.concurrent.FutureListener;
import org.python.netty.util.concurrent.Promise;
import org.python.netty.util.internal.ThreadLocalRandom;

public class RoundRobinInetSocketAddressResolver
extends InetSocketAddressResolver {
    public RoundRobinInetSocketAddressResolver(EventExecutor executor, NameResolver<InetAddress> nameResolver) {
        super(executor, nameResolver);
    }

    @Override
    protected void doResolve(final InetSocketAddress unresolvedAddress, final Promise<InetSocketAddress> promise) throws Exception {
        this.nameResolver.resolveAll(unresolvedAddress.getHostName()).addListener(new FutureListener<List<InetAddress>>(){

            @Override
            public void operationComplete(Future<List<InetAddress>> future) throws Exception {
                if (future.isSuccess()) {
                    List<InetAddress> inetAddresses = future.getNow();
                    int numAddresses = inetAddresses.size();
                    if (numAddresses == 0) {
                        promise.setFailure(new UnknownHostException(unresolvedAddress.getHostName()));
                    } else {
                        int index = numAddresses == 1 ? 0 : ThreadLocalRandom.current().nextInt(numAddresses);
                        promise.setSuccess(new InetSocketAddress(inetAddresses.get(index), unresolvedAddress.getPort()));
                    }
                } else {
                    promise.setFailure(future.cause());
                }
            }
        });
    }
}

