/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.python.core.CodeFlag;
import org.python.core.CompilerFlags;
import org.python.core.Py;
import org.python.core.PyBaseCode;
import org.python.core.PyCell;
import org.python.core.PyCode;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyFrame;
import org.python.core.PyFunction;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PySequenceList;
import org.python.core.PySet;
import org.python.core.PySlice;
import org.python.core.PyString;
import org.python.core.PySystemState;
import org.python.core.PyTraceback;
import org.python.core.PyTuple;
import org.python.core.ThreadState;
import org.python.core.Traverseproc;
import org.python.core.Untraversable;
import org.python.core.Visitproc;
import org.python.core.__builtin__;
import org.python.core.imp;

public class PyBytecode
extends PyBaseCode
implements Traverseproc {
    public static boolean defaultDebug = false;
    private static boolean debug;
    private static PyObject dis;
    private static PyObject opname;
    private int count = 0;
    private int maxCount = -1;
    public static final int CO_MAXBLOCKS = 20;
    public final byte[] co_code;
    public final PyObject[] co_consts;
    public final String[] co_names;
    public final int co_stacksize;
    public final byte[] co_lnotab;
    private static final int CALL_FLAG_VAR = 1;
    private static final int CALL_FLAG_KW = 2;
    private static final String[] __members__;

    private static synchronized PyObject get_dis() {
        if (dis == null) {
            dis = __builtin__.__import__("dis");
        }
        return dis;
    }

    private static synchronized PyObject get_opname() {
        if (opname == null) {
            opname = PyBytecode.get_dis().__getattr__("opname");
        }
        return opname;
    }

    public static void _allDebug(boolean setting) {
        defaultDebug = setting;
    }

    public PyObject _debug(int maxCount) {
        debug = maxCount > 0;
        this.maxCount = maxCount;
        return Py.None;
    }

    public PyBytecode(int argcount, int nlocals, int stacksize, int flags, String codestring, PyObject[] constants, String[] names, String[] varnames, String filename, String name, int firstlineno, String lnotab) {
        this(argcount, nlocals, stacksize, flags, codestring, constants, names, varnames, filename, name, firstlineno, lnotab, null, null);
    }

    public PyBytecode(int argcount, int nlocals, int stacksize, int flags, String codestring, PyObject[] constants, String[] names, String[] varnames, String filename, String name, int firstlineno, String lnotab, String[] cellvars, String[] freevars) {
        debug = defaultDebug;
        if (argcount < 0) {
            throw Py.ValueError("code: argcount must not be negative");
        }
        if (nlocals < 0) {
            throw Py.ValueError("code: nlocals must not be negative");
        }
        this.co_argcount = this.nargs = argcount;
        this.co_varnames = varnames;
        this.co_nlocals = nlocals;
        this.co_filename = filename;
        this.co_firstlineno = firstlineno;
        this.co_cellvars = cellvars;
        this.co_freevars = freevars;
        this.co_name = name;
        this.co_flags = new CompilerFlags(flags);
        this.varargs = this.co_flags.isFlagSet(CodeFlag.CO_VARARGS);
        this.varkwargs = this.co_flags.isFlagSet(CodeFlag.CO_VARKEYWORDS);
        this.co_stacksize = stacksize;
        this.co_consts = constants;
        this.co_names = names;
        this.co_code = PyBytecode.getBytes(codestring);
        this.co_lnotab = PyBytecode.getBytes(lnotab);
    }

    @Override
    public PyObject __dir__() {
        PyObject[] members = new PyString[__members__.length];
        for (int i = 0; i < __members__.length; ++i) {
            members[i] = new PyString(__members__[i]);
        }
        return new PyList(members);
    }

    private void throwReadonly(String name) {
        for (int i = 0; i < __members__.length; ++i) {
            if (__members__[i] != name) continue;
            throw Py.TypeError("readonly attribute");
        }
        throw Py.AttributeError(name);
    }

    @Override
    public void __setattr__(String name, PyObject value) {
        this.throwReadonly(name);
    }

    @Override
    public void __delattr__(String name) {
        this.throwReadonly(name);
    }

    private static PyTuple toPyStringTuple(String[] ar) {
        if (ar == null) {
            return Py.EmptyTuple;
        }
        int sz = ar.length;
        PyObject[] pystr = new PyString[sz];
        for (int i = 0; i < sz; ++i) {
            pystr[i] = new PyString(ar[i]);
        }
        return new PyTuple(pystr);
    }

    @Override
    public PyObject __findattr_ex__(String name) {
        if (name == "co_varnames") {
            return PyBytecode.toPyStringTuple(this.co_varnames);
        }
        if (name == "co_cellvars") {
            return PyBytecode.toPyStringTuple(this.co_cellvars);
        }
        if (name == "co_freevars") {
            return PyBytecode.toPyStringTuple(this.co_freevars);
        }
        if (name == "co_filename") {
            return new PyString(this.co_filename);
        }
        if (name == "co_name") {
            return new PyString(this.co_name);
        }
        if (name == "co_code") {
            return new PyString(PyBytecode.getString(this.co_code));
        }
        if (name == "co_lnotab") {
            return new PyString(PyBytecode.getString(this.co_lnotab));
        }
        if (name == "co_consts") {
            return new PyTuple(this.co_consts);
        }
        if (name == "co_flags") {
            return Py.newInteger(this.co_flags.toBits());
        }
        return super.__findattr_ex__(name);
    }

    private static String stringify_blocks(PyFrame f) {
        if (f.f_exits == null || f.f_lineno == 0) {
            return "[]";
        }
        StringBuilder buf = new StringBuilder("[");
        for (int i = 0; i < f.f_exits.length; ++i) {
            buf.append(f.f_exits[i].toString());
            if (i >= f.f_exits.length - 1) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    private void print_debug(int count2, int next_instr, int line, int opcode, int oparg, PyStack stack, PyFrame f) {
        if (debug) {
            System.err.println(this.co_name + " " + line + ":" + count2 + "," + f.f_lasti + "> " + opcode + " " + PyBytecode.get_opname().__getitem__(Py.newInteger(opcode)) + (opcode >= 90 ? " " + oparg : "") + ", stack: " + stack.toString() + ", blocks: " + PyBytecode.stringify_blocks(f));
        }
    }

    private static PyTryBlock popBlock(PyFrame f) {
        return (PyTryBlock)((PyList)f.f_exits[0]).pop();
    }

    private static void pushBlock(PyFrame f, PyTryBlock block) {
        if (f.f_exits == null) {
            f.f_exits = new PyObject[1];
            f.f_exits[0] = new PyList();
        }
        ((PyList)f.f_exits[0]).append(block);
    }

    private boolean blocksLeft(PyFrame f) {
        if (f.f_exits != null) {
            return ((PyList)f.f_exits[0]).__nonzero__();
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected PyObject interpret(PyFrame f, ThreadState ts) {
        stack = new PyStack(this.co_stacksize);
        next_instr = -1;
        oparg = 0;
        why = Why.NOT;
        retval = null;
        lineCache = null;
        last_line = -1;
        line = 0;
        if (PyBytecode.debug) {
            System.err.println(this.co_name + ":" + f.f_lasti + "/" + this.co_code.length + ", cells:" + Arrays.toString(this.co_cellvars) + ", free:" + Arrays.toString(this.co_freevars));
            i = 0;
            for (String cellvar : this.co_cellvars) {
                System.err.println(cellvar + " = " + f.f_env[i++]);
            }
            for (String freevar : this.co_freevars) {
                System.err.println(freevar + " = " + f.f_env[i++]);
            }
            PyBytecode.get_dis().invoke("disassemble", this);
        }
        if (f.f_lasti >= this.co_code.length) {
            throw Py.SystemError("");
        }
        next_instr = f.f_lasti;
        checkGeneratorInput = false;
        if (f.f_savedlocals != null) {
            for (i = 0; i < f.f_savedlocals.length; ++i) {
                v = (PyObject)f.f_savedlocals[i];
                stack.push(v);
            }
            checkGeneratorInput = true;
            f.f_savedlocals = null;
        }
        while (!PyBytecode.debug || this.maxCount == -1 || this.count < this.maxCount) {
            block211: {
                if (f.tracefunc != null || PyBytecode.debug) {
                    if (lineCache == null) {
                        lineCache = new LineCache();
                        if (PyBytecode.debug) {
                            System.err.println("LineCache: " + lineCache.toString());
                        }
                    }
                    if ((line = LineCache.access$100(lineCache, next_instr)) != last_line) {
                        f.setline(line);
                    }
                }
                try {
                    if (checkGeneratorInput) {
                        checkGeneratorInput = false;
                        generatorInput = f.getGeneratorInput();
                        if (generatorInput instanceof PyException) {
                            throw (PyException)generatorInput;
                        }
                        stack.push((PyObject)generatorInput);
                    }
                    if ((opcode = PyBytecode.getUnsigned(this.co_code, next_instr)) >= 'Z') {
                        oparg = (PyBytecode.getUnsigned(this.co_code, next_instr += 2) << 8) + PyBytecode.getUnsigned(this.co_code, next_instr - 1);
                    }
                    this.print_debug(this.count, next_instr, line, opcode, oparg, stack, f);
                    ++this.count;
                    f.f_lasti = ++next_instr;
                    block3 : switch (opcode) {
                        case '\t': {
                            break;
                        }
                        case '|': {
                            stack.push(f.getlocal(oparg));
                            break;
                        }
                        case 'd': {
                            stack.push(this.co_consts[oparg]);
                            break;
                        }
                        case '}': {
                            f.setlocal(oparg, stack.pop());
                            break;
                        }
                        case '\u0001': {
                            stack.pop();
                            break;
                        }
                        case '\u0002': {
                            stack.rot2();
                            break;
                        }
                        case '\u0003': {
                            stack.rot3();
                            break;
                        }
                        case '\u0005': {
                            stack.rot4();
                            break;
                        }
                        case '\u0004': {
                            stack.dup();
                            break;
                        }
                        case 'c': {
                            if (oparg == 2 || oparg == 3) {
                                stack.dup(oparg);
                                break;
                            }
                            throw Py.RuntimeError("invalid argument to DUP_TOPX (bytecode corruption?)");
                        }
                        case '\n': {
                            stack.push(stack.pop().__pos__());
                            break;
                        }
                        case '\u000b': {
                            stack.push(stack.pop().__neg__());
                            break;
                        }
                        case '\f': {
                            stack.push(stack.pop().__not__());
                            break;
                        }
                        case '\r': {
                            stack.push(stack.pop().__repr__());
                            break;
                        }
                        case '\u000f': {
                            stack.push(stack.pop().__invert__());
                            break;
                        }
                        case '\u0013': {
                            b = stack.pop();
                            a = stack.pop();
                            stack.push(a._pow(b));
                            break;
                        }
                        case '\u0014': {
                            b = stack.pop();
                            a = stack.pop();
                            stack.push(a._mul(b));
                            break;
                        }
                        case '\u0015': {
                            b = stack.pop();
                            a = stack.pop();
                            if (!this.co_flags.isFlagSet(CodeFlag.CO_FUTURE_DIVISION)) {
                                stack.push(a._div(b));
                                break;
                            }
                            stack.push(a._truediv(b));
                            break;
                        }
                        case '\u001b': {
                            b = stack.pop();
                            a = stack.pop();
                            stack.push(a._truediv(b));
                            break;
                        }
                        case '\u001a': {
                            b = stack.pop();
                            a = stack.pop();
                            stack.push(a._floordiv(b));
                            break;
                        }
                        case '\u0016': {
                            b = stack.pop();
                            a = stack.pop();
                            stack.push(a._mod(b));
                            break;
                        }
                        case '\u0017': {
                            b = stack.pop();
                            a = stack.pop();
                            stack.push(a._add(b));
                            break;
                        }
                        case '\u0018': {
                            b = stack.pop();
                            a = stack.pop();
                            stack.push(a._sub(b));
                            break;
                        }
                        case '\u0019': {
                            b = stack.pop();
                            a = stack.pop();
                            stack.push(a.__getitem__(b));
                            break;
                        }
                        case '>': {
                            b = stack.pop();
                            a = stack.pop();
                            stack.push(a._lshift(b));
                            break;
                        }
                        case '?': {
                            b = stack.pop();
                            a = stack.pop();
                            stack.push(a._rshift(b));
                            break;
                        }
                        case '@': {
                            b = stack.pop();
                            a = stack.pop();
                            stack.push(a._and(b));
                            break;
                        }
                        case 'A': {
                            b = stack.pop();
                            a = stack.pop();
                            stack.push(a._xor(b));
                            break;
                        }
                        case 'B': {
                            b = stack.pop();
                            a = stack.pop();
                            stack.push(a._or(b));
                            break;
                        }
                        case '^': {
                            b = stack.pop();
                            a = (PyList)stack.top(oparg);
                            a.append(b);
                            break;
                        }
                        case '\u0092': {
                            b = stack.pop();
                            a = (PySet)stack.top(oparg);
                            a.add(b);
                            break;
                        }
                        case 'C': {
                            b = stack.pop();
                            a = stack.pop();
                            stack.push(a._ipow(b));
                            break;
                        }
                        case '9': {
                            b = stack.pop();
                            a = stack.pop();
                            stack.push(a._imul(b));
                            break;
                        }
                        case ':': {
                            b = stack.pop();
                            a = stack.pop();
                            if (!this.co_flags.isFlagSet(CodeFlag.CO_FUTURE_DIVISION)) {
                                stack.push(a._idiv(b));
                                break;
                            }
                            stack.push(a._itruediv(b));
                            break;
                        }
                        case '\u001d': {
                            b = stack.pop();
                            a = stack.pop();
                            stack.push(a._itruediv(b));
                            break;
                        }
                        case '\u001c': {
                            b = stack.pop();
                            a = stack.pop();
                            stack.push(a._ifloordiv(b));
                            break;
                        }
                        case ';': {
                            b = stack.pop();
                            a = stack.pop();
                            stack.push(a._imod(b));
                            break;
                        }
                        case '7': {
                            b = stack.pop();
                            a = stack.pop();
                            stack.push(a._iadd(b));
                            break;
                        }
                        case '8': {
                            b = stack.pop();
                            a = stack.pop();
                            stack.push(a._isub(b));
                            break;
                        }
                        case 'K': {
                            b = stack.pop();
                            a = stack.pop();
                            stack.push(a._ilshift(b));
                            break;
                        }
                        case 'L': {
                            b = stack.pop();
                            a = stack.pop();
                            stack.push(a._irshift(b));
                            break;
                        }
                        case 'M': {
                            b = stack.pop();
                            a = stack.pop();
                            stack.push(a._iand(b));
                            break;
                        }
                        case 'N': {
                            b = stack.pop();
                            a = stack.pop();
                            stack.push(a._ixor(b));
                            break;
                        }
                        case 'O': {
                            b = stack.pop();
                            a = stack.pop();
                            stack.push(a._ior(b));
                            break;
                        }
                        case '\u001e': 
                        case '\u001f': 
                        case ' ': 
                        case '!': {
                            stop = (opcode - 30 & 2) != 0 ? stack.pop() : null;
                            start = (opcode - 30 & 1) != 0 ? stack.pop() : null;
                            obj = stack.pop();
                            stack.push(obj.__getslice__(start, stop));
                            break;
                        }
                        case '(': 
                        case ')': 
                        case '*': 
                        case '+': {
                            stop = (opcode - 40 & 2) != 0 ? stack.pop() : null;
                            start = (opcode - 40 & 1) != 0 ? stack.pop() : null;
                            obj = stack.pop();
                            value = stack.pop();
                            obj.__setslice__(start, stop, value);
                            break;
                        }
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': {
                            stop = (opcode - 50 & 2) != 0 ? stack.pop() : null;
                            start = (opcode - 50 & 1) != 0 ? stack.pop() : null;
                            obj = stack.pop();
                            obj.__delslice__(start, stop);
                            break;
                        }
                        case '<': {
                            key = stack.pop();
                            obj = stack.pop();
                            value = stack.pop();
                            obj.__setitem__(key, value);
                            break;
                        }
                        case '=': {
                            key = stack.pop();
                            obj = stack.pop();
                            obj.__delitem__(key);
                            break;
                        }
                        case 'F': {
                            PySystemState.displayhook(stack.pop());
                            break;
                        }
                        case 'I': {
                            Py.printComma(stack.pop(), stack.pop());
                            break;
                        }
                        case 'G': {
                            Py.printComma(stack.pop());
                            break;
                        }
                        case 'J': {
                            Py.printlnv(stack.pop());
                            break;
                        }
                        case 'H': {
                            Py.println();
                            break;
                        }
                        case '\u0082': {
                            switch (oparg) {
                                case 3: {
                                    tb = (PyTraceback)stack.pop();
                                    value = stack.pop();
                                    type = stack.pop();
                                    throw PyException.doRaise(type, value, tb);
                                }
                                case 2: {
                                    value = stack.pop();
                                    type = stack.pop();
                                    throw PyException.doRaise(type, value, null);
                                }
                                case 1: {
                                    type = stack.pop();
                                    throw PyException.doRaise(type, null, null);
                                }
                                case 0: {
                                    throw PyException.doRaise(null, null, null);
                                }
                            }
                            throw Py.SystemError("bad RAISE_VARARGS oparg");
                        }
                        case 'R': {
                            stack.push(f.f_locals);
                            break;
                        }
                        case 'S': {
                            retval = stack.pop();
                            why = Why.RETURN;
                            break;
                        }
                        case 'V': {
                            retval = stack.pop();
                            why = Why.YIELD;
                            break;
                        }
                        case 'U': {
                            locals = stack.pop();
                            globals = stack.pop();
                            code = stack.pop();
                            Py.exec(code, globals == Py.None ? null : globals, locals == Py.None ? null : locals);
                            break;
                        }
                        case 'W': {
                            b = PyBytecode.popBlock(f);
                            while (stack.size() > b.b_level) {
                                stack.pop();
                            }
                            break;
                        }
                        case 'X': {
                            v = stack.pop();
                            if (v instanceof PyStackWhy) {
                                why = ((PyStackWhy)v).why;
                                if (!PyBytecode.$assertionsDisabled && why == Why.YIELD) {
                                    throw new AssertionError();
                                }
                                if (why == Why.RETURN || why == Why.CONTINUE) {
                                    retval = stack.pop();
                                }
                            } else {
                                if (v instanceof PyStackException) {
                                    stack.top -= 2;
                                    ts.exception = ((PyStackException)v).exception;
                                    why = Why.RERAISE;
                                    break;
                                }
                                if (v instanceof PyString) {
                                    value = stack.pop();
                                    traceback = stack.pop();
                                    ts.exception = new PyException(v, value, (PyTraceback)traceback);
                                    why = Why.RERAISE;
                                    break;
                                }
                                if (v != Py.None) {
                                    throw Py.SystemError("'finally' pops bad exception");
                                }
                            }
                            break;
                        }
                        case 'Y': {
                            methods = stack.pop();
                            bases = ((PySequenceList)stack.pop()).getArray();
                            name = stack.pop().toString();
                            stack.push(Py.makeClass(name, bases, methods));
                            break;
                        }
                        case 'Z': {
                            f.setlocal(this.co_names[oparg], stack.pop());
                            break;
                        }
                        case '[': {
                            f.dellocal(this.co_names[oparg]);
                            break;
                        }
                        case '\\': {
                            PyBytecode.unpack_iterable(oparg, stack);
                            break;
                        }
                        case '_': {
                            obj = stack.pop();
                            v = stack.pop();
                            obj.__setattr__(this.co_names[oparg], v);
                            break;
                        }
                        case '`': {
                            stack.pop().__delattr__(this.co_names[oparg]);
                            break;
                        }
                        case 'a': {
                            f.setglobal(this.co_names[oparg], stack.pop());
                            break;
                        }
                        case 'b': {
                            f.delglobal(this.co_names[oparg]);
                            break;
                        }
                        case 'e': {
                            stack.push(f.getname(this.co_names[oparg]));
                            break;
                        }
                        case 't': {
                            stack.push(f.getglobal(this.co_names[oparg]));
                            break;
                        }
                        case '~': {
                            f.dellocal(oparg);
                            break;
                        }
                        case '\u0087': {
                            cell = (PyCell)f.getclosure(oparg);
                            if (cell.ob_ref == null) {
                                name = oparg >= this.co_cellvars.length ? this.co_freevars[oparg - this.co_cellvars.length] : this.co_cellvars[oparg];
                                if (f.f_fastlocals != null) {
                                    i = 0;
                                    matched = false;
                                    for (String match : this.co_varnames) {
                                        if (match.equals(name)) {
                                            matched = true;
                                            break;
                                        }
                                        ++i;
                                    }
                                    if (matched) {
                                        cell.ob_ref = f.f_fastlocals[i];
                                    }
                                } else {
                                    cell.ob_ref = f.f_locals.__finditem__(name);
                                }
                            }
                            stack.push(cell);
                            break;
                        }
                        case '\u0088': {
                            cell = (PyCell)f.getclosure(oparg);
                            if (cell.ob_ref == null) {
                                name = oparg >= this.co_cellvars.length ? this.co_freevars[oparg - this.co_cellvars.length] : this.co_cellvars[oparg];
                                if (f.f_fastlocals != null) {
                                    i = 0;
                                    matched = false;
                                    for (String match : this.co_varnames) {
                                        if (match.equals(name)) {
                                            matched = true;
                                            break;
                                        }
                                        ++i;
                                    }
                                    if (matched) {
                                        cell.ob_ref = f.f_fastlocals[i];
                                    }
                                } else {
                                    cell.ob_ref = f.f_locals.__finditem__(name);
                                }
                            }
                            stack.push(cell.ob_ref);
                            break;
                        }
                        case '\u0089': {
                            f.setderef(oparg, stack.pop());
                            break;
                        }
                        case 'f': {
                            stack.push(new PyTuple(stack.popN(oparg)));
                            break;
                        }
                        case 'g': {
                            stack.push(new PyList(stack.popN(oparg)));
                            break;
                        }
                        case 'h': {
                            stack.push(new PySet(stack.popN(oparg)));
                            break;
                        }
                        case 'i': {
                            stack.push(new PyDictionary(PyDictionary.TYPE, oparg));
                            break;
                        }
                        case '6': {
                            key = stack.pop();
                            val = stack.pop();
                            stack.top().__setitem__(key, val);
                            break;
                        }
                        case '\u0093': {
                            key = stack.pop();
                            val = stack.pop();
                            stack.top(oparg).__setitem__(key, val);
                            break;
                        }
                        case 'j': {
                            name = this.co_names[oparg];
                            stack.push(stack.pop().__getattr__(name));
                            break;
                        }
                        case 'k': {
                            b = stack.pop();
                            a = stack.pop();
                            switch (oparg) {
                                case 0: {
                                    stack.push(a._lt(b));
                                    break block3;
                                }
                                case 1: {
                                    stack.push(a._le(b));
                                    break block3;
                                }
                                case 2: {
                                    stack.push(a._eq(b));
                                    break block3;
                                }
                                case 3: {
                                    stack.push(a._ne(b));
                                    break block3;
                                }
                                case 4: {
                                    stack.push(a._gt(b));
                                    break block3;
                                }
                                case 5: {
                                    stack.push(a._ge(b));
                                    break block3;
                                }
                                case 6: {
                                    stack.push(a._in(b));
                                    break block3;
                                }
                                case 7: {
                                    stack.push(a._notin(b));
                                    break block3;
                                }
                                case 8: {
                                    stack.push(a._is(b));
                                    break block3;
                                }
                                case 9: {
                                    stack.push(a._isnot(b));
                                    break block3;
                                }
                                case 10: {
                                    if (a instanceof PyStackException) {
                                        pye = ((PyStackException)a).exception;
                                        stack.push(Py.newBoolean(pye.match(b)));
                                        break block3;
                                    }
                                    stack.push(Py.newBoolean(new PyException(a).match(b)));
                                }
                            }
                            break;
                        }
                        case 'l': {
                            __import__ = f.f_builtins.__finditem__("__import__");
                            if (__import__ == null) {
                                throw Py.ImportError("__import__ not found");
                            }
                            name = Py.newString(this.co_names[oparg]);
                            fromlist = stack.pop();
                            level = stack.pop();
                            if (level.asInt() != -1) {
                                stack.push(__import__.__call__(new PyObject[]{name, f.f_globals, f.f_locals, fromlist, level}));
                                break;
                            }
                            stack.push(__import__.__call__(new PyObject[]{name, f.f_globals, f.f_locals, fromlist}));
                            break;
                        }
                        case 'T': {
                            module = stack.pop();
                            imp.importAll(module, f);
                            break;
                        }
                        case 'm': {
                            name = this.co_names[oparg];
                            try {
                                stack.push(stack.top().__getattr__(name));
                                break;
                            }
                            catch (PyException pye) {
                                if (pye.match(Py.AttributeError)) {
                                    throw Py.ImportError(String.format("cannot import name %.230s", new Object[]{name}));
                                }
                                throw pye;
                            }
                        }
                        case 'n': {
                            next_instr += oparg;
                            break;
                        }
                        case 'r': {
                            if (!stack.pop().__nonzero__()) {
                                next_instr = oparg;
                            }
                            break;
                        }
                        case 's': {
                            if (stack.pop().__nonzero__()) {
                                next_instr = oparg;
                            }
                            break;
                        }
                        case 'o': {
                            if (stack.top().__nonzero__()) {
                                --stack.top;
                                break;
                            }
                            next_instr = oparg;
                            break;
                        }
                        case 'p': {
                            if (!stack.top().__nonzero__()) {
                                --stack.top;
                                break;
                            }
                            next_instr = oparg;
                            break;
                        }
                        case 'q': {
                            next_instr = oparg;
                            break;
                        }
                        case 'D': {
                            it = stack.top().__iter__();
                            if (it != null) {
                                stack.set_top(it);
                            }
                            break;
                        }
                        case ']': {
                            it = stack.pop();
                            try {
                                x = it.__iternext__();
                                if (x != null) {
                                    stack.push(it);
                                    stack.push(x);
                                    break;
                                }
                            }
                            catch (PyException pye) {
                                if (pye.match(Py.StopIteration)) ** GOTO lbl578
                                throw pye;
                            }
lbl578:
                            // 2 sources

                            next_instr += oparg;
                            break;
                        }
                        case 'P': {
                            why = Why.BREAK;
                            break;
                        }
                        case 'w': {
                            retval = Py.newInteger(oparg);
                            if (retval.__nonzero__()) {
                                why = Why.CONTINUE;
                            }
                            break;
                        }
                        case 'x': 
                        case 'y': 
                        case 'z': {
                            PyBytecode.pushBlock(f, new PyTryBlock(opcode, next_instr + oparg, stack.size()));
                            break;
                        }
                        case '\u008f': {
                            w = stack.top();
                            exit = w.__getattr__("__exit__");
                            if (exit == null) break;
                            stack.set_top(exit);
                            enter = w.__getattr__("__enter__");
                            if (enter == null || (w = enter.__call__()) == null) break;
                            PyBytecode.pushBlock(f, new PyTryBlock(opcode, next_instr + oparg, stack.size()));
                            stack.push(w);
                            break;
                        }
                        case 'Q': {
                            u = stack.pop();
                            if (u == Py.None) {
                                exit = stack.top();
                                stack.set_top(u);
                                v = w = Py.None;
                            } else if (u instanceof PyStackWhy) {
                                switch (1.$SwitchMap$org$python$core$PyBytecode$Why[((PyStackWhy)u).why.ordinal()]) {
                                    case 1: 
                                    case 2: {
                                        exit = stack.top(2);
                                        stack.set_top(2, stack.top());
                                        stack.set_top(u);
                                        break;
                                    }
                                    default: {
                                        exit = stack.top();
                                        stack.set_top(u);
                                    }
                                }
                                v = w = Py.None;
                                u = w;
                            } else {
                                v = stack.top();
                                w = stack.top(2);
                                exit = stack.top(3);
                                stack.set_top(u);
                                stack.set_top(2, v);
                                stack.set_top(3, w);
                            }
                            x = null;
                            if (u instanceof PyStackException) {
                                exc = ((PyStackException)u).exception;
                                x = exit.__call__(exc.type, exc.value, (PyObject)exc.traceback);
                            } else {
                                x = exit.__call__(u, v, w);
                            }
                            if (u != Py.None && x != null && x.__nonzero__()) {
                                stack.top -= 2;
                                stack.set_top(Py.None);
                            }
                            break;
                        }
                        case '\u0083': {
                            na = oparg & 255;
                            nk = oparg >> 8 & 255;
                            if (nk == 0) {
                                PyBytecode.call_function(na, stack);
                                break;
                            }
                            PyBytecode.call_function(na, nk, stack);
                            break;
                        }
                        case '\u008c': 
                        case '\u008d': 
                        case '\u008e': {
                            na = oparg & 255;
                            nk = oparg >> 8 & 255;
                            flags = opcode - 131 & 3;
                            PyBytecode.call_function(na, nk, (flags & 1) != 0, (flags & 2) != 0, stack);
                            break;
                        }
                        case '\u0084': {
                            code = (PyCode)stack.pop();
                            defaults = stack.popN(oparg);
                            doc = null;
                            if (code instanceof PyBytecode && ((PyBytecode)code).co_consts.length > 0) {
                                doc = ((PyBytecode)code).co_consts[0];
                            }
                            func = new PyFunction(f.f_globals, defaults, code, doc);
                            stack.push(func);
                            break;
                        }
                        case '\u0086': {
                            code = (PyCode)stack.pop();
                            closure_cells = ((PySequenceList)stack.pop()).getArray();
                            defaults = stack.popN(oparg);
                            doc = null;
                            if (code instanceof PyBytecode && ((PyBytecode)code).co_consts.length > 0) {
                                doc = ((PyBytecode)code).co_consts[0];
                            }
                            func = new PyFunction(f.f_globals, defaults, code, doc, closure_cells);
                            stack.push(func);
                            break;
                        }
                        case '\u0085': {
                            step = oparg == 3 ? stack.pop() : null;
                            stop = stack.pop();
                            start = stack.pop();
                            stack.push(new PySlice(start, stop, step));
                            break;
                        }
                        case '\u0091': {
                            opcode = PyBytecode.getUnsigned(this.co_code, next_instr++);
                            oparg = oparg << 16 | (PyBytecode.getUnsigned(this.co_code, next_instr += 2) << 8) + PyBytecode.getUnsigned(this.co_code, next_instr - 1);
                            break;
                        }
                        default: {
                            Py.print(Py.getSystemState().stderr, Py.newString(String.format("XXX lineno: %d, opcode: %d\n", new Object[]{f.f_lasti, (int)opcode})));
                            throw Py.SystemError("unknown opcode");
                        }
                    }
                }
                catch (Throwable t) {
                    pye = Py.setException(t, f);
                    why = Why.EXCEPTION;
                    ts.exception = pye;
                    if (!PyBytecode.debug) break block211;
                    System.err.println("Caught exception:" + pye);
                }
            }
            if (why == Why.YIELD) break;
            if (why == Why.RERAISE) {
                why = Why.EXCEPTION;
            }
            while (why != Why.NOT && this.blocksLeft(f)) {
                b = PyBytecode.popBlock(f);
                if (PyBytecode.debug) {
                    System.err.println("Processing block: " + b);
                }
                if (!PyBytecode.$assertionsDisabled && why == Why.YIELD) {
                    throw new AssertionError();
                }
                if (b.b_type == 120 && why == Why.CONTINUE) {
                    PyBytecode.pushBlock(f, b);
                    why = Why.NOT;
                    next_instr = retval.asInt();
                    break;
                }
                while (stack.size() > b.b_level) {
                    stack.pop();
                }
                if (b.b_type == 120 && why == Why.BREAK) {
                    why = Why.NOT;
                    next_instr = b.b_handler;
                    break;
                }
                if (b.b_type != 122 && (b.b_type != 121 || why != Why.EXCEPTION) && b.b_type != 143) continue;
                if (why == Why.EXCEPTION) {
                    exc = ts.exception;
                    if (b.b_type == 121 || b.b_type == 143) {
                        exc.normalize();
                    }
                    stack.push(exc.traceback);
                    stack.push(exc.value);
                    stack.push(new PyStackException(exc));
                } else {
                    if (why == Why.RETURN || why == Why.CONTINUE) {
                        stack.push(retval);
                    }
                    stack.push(new PyStackWhy(why));
                }
                why = Why.NOT;
                next_instr = b.b_handler;
                break;
            }
            if (why == Why.NOT) continue;
        }
        if (why != Why.YIELD) {
            while (stack.size() > 0) {
                stack.pop();
            }
            if (why != Why.RETURN) {
                retval = Py.None;
            }
        } else {
            f.f_savedlocals = stack.popN(stack.size());
        }
        f.f_lasti = next_instr;
        if (PyBytecode.debug) {
            System.err.println(this.count + "," + f.f_lasti + "> Returning from " + (Object)why + ": " + retval + ", stack: " + stack.toString() + ", blocks: " + PyBytecode.stringify_blocks(f));
        }
        if (why == Why.EXCEPTION) {
            throw ts.exception;
        }
        if (this.co_flags.isFlagSet(CodeFlag.CO_GENERATOR) && why == Why.RETURN && retval == Py.None) {
            f.f_lasti = -1;
        }
        return retval;
    }

    private static void call_function(int na, PyStack stack) {
        switch (na) {
            case 0: {
                PyObject callable = stack.pop();
                stack.push(callable.__call__());
                break;
            }
            case 1: {
                PyObject arg = stack.pop();
                PyObject callable = stack.pop();
                stack.push(callable.__call__(arg));
                break;
            }
            case 2: {
                PyObject arg1 = stack.pop();
                PyObject arg0 = stack.pop();
                PyObject callable = stack.pop();
                stack.push(callable.__call__(arg0, arg1));
                break;
            }
            case 3: {
                PyObject arg2 = stack.pop();
                PyObject arg1 = stack.pop();
                PyObject arg0 = stack.pop();
                PyObject callable = stack.pop();
                stack.push(callable.__call__(arg0, arg1, arg2));
                break;
            }
            case 4: {
                PyObject arg3 = stack.pop();
                PyObject arg2 = stack.pop();
                PyObject arg1 = stack.pop();
                PyObject arg0 = stack.pop();
                PyObject callable = stack.pop();
                stack.push(callable.__call__(arg0, arg1, arg2, arg3));
                break;
            }
            default: {
                PyObject[] args = stack.popN(na);
                PyObject callable = stack.pop();
                stack.push(callable.__call__(args));
            }
        }
    }

    private static void call_function(int na, int nk, PyStack stack) {
        int i;
        int n = na + nk * 2;
        PyObject[] params = stack.popN(n);
        PyObject callable = stack.pop();
        PyObject[] args = new PyObject[na + nk];
        String[] keywords = new String[nk];
        for (i = 0; i < na; ++i) {
            args[i] = params[i];
        }
        int j = 0;
        while (i < n) {
            keywords[j] = params[i].toString();
            args[na + j] = params[i + 1];
            i += 2;
            ++j;
        }
        stack.push(callable.__call__(args, keywords));
    }

    private static void call_function(int na, int nk, boolean var, boolean kw, PyStack stack) {
        int i;
        int n = na + nk * 2;
        PyObject kwargs = kw ? stack.pop() : null;
        PyObject starargs = var ? stack.pop() : null;
        PyObject[] params = stack.popN(n);
        PyObject callable = stack.pop();
        PyObject[] args = new PyObject[na + nk];
        String[] keywords = new String[nk];
        for (i = 0; i < na; ++i) {
            args[i] = params[i];
        }
        int j = 0;
        while (i < n) {
            keywords[j] = params[i].toString();
            args[na + j] = params[i + 1];
            i += 2;
            ++j;
        }
        stack.push(callable._callextra(args, keywords, starargs, kwargs));
    }

    private static void unpack_iterable(int oparg, PyStack stack) {
        PyObject v = stack.pop();
        int i = oparg;
        PyObject[] items = new PyObject[oparg];
        for (PyObject item : v.asIterable()) {
            if (i <= 0) {
                throw Py.ValueError("too many values to unpack");
            }
            items[--i] = item;
        }
        if (i > 0) {
            throw Py.ValueError(String.format("need more than %d value%s to unpack", i, i == 1 ? "" : "s"));
        }
        for (i = 0; i < oparg; ++i) {
            stack.push(items[i]);
        }
    }

    @Override
    protected int getline(PyFrame f) {
        int addrq = f.f_lasti;
        int size = this.co_lnotab.length / 2;
        int p = 0;
        int line = this.co_firstlineno;
        int addr = 0;
        while (--size >= 0 && (addr += PyBytecode.getUnsigned(this.co_lnotab, p++)) <= addrq) {
            line += PyBytecode.getUnsigned(this.co_lnotab, p++);
        }
        return line;
    }

    private static char getUnsigned(byte[] x, int i) {
        byte b = x[i];
        if (b < 0) {
            return (char)(b + 256);
        }
        return (char)b;
    }

    private static String getString(byte[] x) {
        StringBuilder buffer = new StringBuilder(x.length);
        for (int i = 0; i < x.length; ++i) {
            buffer.append(PyBytecode.getUnsigned(x, i));
        }
        return buffer.toString();
    }

    private static byte[] getBytes(String s) {
        int len = s.length();
        byte[] x = new byte[len];
        for (int i = 0; i < len; ++i) {
            x[i] = (byte)(s.charAt(i) & 0xFF);
        }
        return x;
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        if (this.co_consts != null) {
            for (PyObject ob : this.co_consts) {
                int retValue;
                if (ob == null || (retValue = visit.visit(ob, arg)) == 0) continue;
                return retValue;
            }
        }
        return 0;
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) {
        if (ob == null || this.co_consts == null) {
            return false;
        }
        for (PyObject obj : this.co_consts) {
            if (obj != ob) continue;
            return true;
        }
        return false;
    }

    static {
        __members__ = new String[]{"co_name", "co_argcount", "co_varnames", "co_filename", "co_firstlineno", "co_flags", "co_cellvars", "co_freevars", "co_nlocals", "co_code", "co_consts", "co_names", "co_lnotab", "co_stacksize"};
    }

    private class LineCache {
        List<Integer> addr_breakpoints = new ArrayList<Integer>();
        List<Integer> lines = new ArrayList<Integer>();

        private LineCache() {
            int size = PyBytecode.this.co_lnotab.length / 2;
            int p = 0;
            int lastline = -1;
            int line = PyBytecode.this.co_firstlineno;
            int addr = 0;
            while (--size >= 0) {
                char byte_incr = PyBytecode.getUnsigned(PyBytecode.this.co_lnotab, p++);
                char line_incr = PyBytecode.getUnsigned(PyBytecode.this.co_lnotab, p++);
                if (byte_incr > '\u0000') {
                    if (line != lastline) {
                        this.addr_breakpoints.add(addr);
                        this.lines.add(line);
                        lastline = line;
                    }
                    addr += byte_incr;
                }
                line += line_incr;
            }
            if (line != lastline) {
                this.lines.add(line);
            }
        }

        private int getline(int addrq) {
            int lo = 0;
            int hi = this.addr_breakpoints.size();
            while (lo < hi) {
                int mid = (lo + hi) / 2;
                if (addrq < this.addr_breakpoints.get(mid)) {
                    hi = mid;
                    continue;
                }
                lo = mid + 1;
            }
            return this.lines.get(lo);
        }

        public String toString() {
            return this.addr_breakpoints.toString() + ";" + this.lines.toString();
        }

        static /* synthetic */ int access$100(LineCache x0, int x1) {
            return x0.getline(x1);
        }
    }

    @Untraversable
    private static class PyTryBlock
    extends PyObject {
        int b_type;
        int b_handler;
        int b_level;

        PyTryBlock(int type, int handler, int level) {
            this.b_type = type;
            this.b_handler = handler;
            this.b_level = level;
        }

        @Override
        public String toString() {
            return "<" + PyBytecode.get_opname().__getitem__(Py.newInteger(this.b_type)) + "," + this.b_handler + "," + this.b_level + ">";
        }
    }

    private static class PyStack {
        final PyObject[] stack;
        int top = -1;

        PyStack(int size) {
            this.stack = new PyObject[size];
        }

        PyObject top() {
            return this.stack[this.top];
        }

        PyObject top(int n) {
            return this.stack[this.top - n + 1];
        }

        PyObject pop() {
            return this.stack[this.top--];
        }

        void push(PyObject v) {
            this.stack[++this.top] = v;
        }

        void set_top(PyObject v) {
            this.stack[this.top] = v;
        }

        void set_top(int n, PyObject v) {
            this.stack[this.top - n + 1] = v;
        }

        void dup() {
            this.stack[this.top + 1] = this.stack[this.top];
            ++this.top;
        }

        void dup(int n) {
            int oldTop = this.top;
            this.top += n;
            for (int i = 0; i < n; ++i) {
                this.stack[this.top - i] = this.stack[oldTop - i];
            }
        }

        PyObject[] popN(int n) {
            PyObject[] ret = new PyObject[n];
            this.top -= n;
            for (int i = 0; i < n; ++i) {
                ret[i] = this.stack[this.top + i + 1];
            }
            return ret;
        }

        void rot2() {
            PyObject topv = this.stack[this.top];
            this.stack[this.top] = this.stack[this.top - 1];
            this.stack[this.top - 1] = topv;
        }

        void rot3() {
            PyObject v = this.stack[this.top];
            PyObject w = this.stack[this.top - 1];
            PyObject x = this.stack[this.top - 2];
            this.stack[this.top] = w;
            this.stack[this.top - 1] = x;
            this.stack[this.top - 2] = v;
        }

        void rot4() {
            PyObject u = this.stack[this.top];
            PyObject v = this.stack[this.top - 1];
            PyObject w = this.stack[this.top - 2];
            PyObject x = this.stack[this.top - 3];
            this.stack[this.top] = v;
            this.stack[this.top - 1] = w;
            this.stack[this.top - 2] = x;
            this.stack[this.top - 3] = u;
        }

        int size() {
            return this.top + 1;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            int size = this.size();
            int N = size > 4 ? 4 : size;
            buffer.append("[");
            for (int i = 0; i < N; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                PyObject item = this.stack[N - i - 1];
                buffer.append(this.upto(item.__repr__().toString()));
            }
            if (N < size) {
                buffer.append(String.format(", %d more...", size - N));
            }
            buffer.append("]");
            return buffer.toString();
        }

        private String upto(String x) {
            return this.upto(x, 100);
        }

        private String upto(String x, int n) {
            if ((x = x.replace('\n', '|')).length() > n) {
                StringBuilder item = new StringBuilder(x.substring(0, n));
                item.append("...");
                return item.toString();
            }
            return x;
        }
    }

    private static class PyStackException
    extends PyObject
    implements Traverseproc {
        PyException exception;

        PyStackException(PyException exception) {
            this.exception = exception;
        }

        @Override
        public String toString() {
            return String.format("PyStackException<%s,%s,%.100s>", this.exception.type, this.exception.value, this.exception.traceback);
        }

        @Override
        public int traverse(Visitproc visit, Object arg) {
            return this.exception != null ? this.exception.traverse(visit, arg) : 0;
        }

        @Override
        public boolean refersDirectlyTo(PyObject ob) {
            return ob != null && this.exception.refersDirectlyTo(ob);
        }
    }

    @Untraversable
    private static class PyStackWhy
    extends PyObject {
        Why why;

        PyStackWhy(Why why) {
            this.why = why;
        }

        @Override
        public String toString() {
            return this.why.toString();
        }
    }

    static enum Why {
        NOT,
        EXCEPTION,
        RERAISE,
        RETURN,
        BREAK,
        CONTINUE,
        YIELD;

    }
}

