/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.posix;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotLinkException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import java.util.ListIterator;
import java.util.Map;
import jnr.constants.Constant;
import jnr.constants.platform.Sysconf;
import jnr.constants.platform.linux.Errno;
import jnr.posix.FileStat;
import jnr.posix.POSIX;
import jnr.posix.POSIXFactory;
import jnr.posix.Times;
import jnr.posix.util.FieldAccess;
import jnr.posix.util.Platform;
import org.python.core.BufferProtocol;
import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.core.PyBuffer;
import org.python.core.PyBuiltinFunctionNarrow;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyFile;
import org.python.core.PyFloat;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.Untraversable;
import org.python.core.imp;
import org.python.core.io.FileIO;
import org.python.core.io.IOBase;
import org.python.core.io.RawIOBase;
import org.python.core.util.StringUtil;
import org.python.google.common.io.Files;
import org.python.modules.posix.Hide;
import org.python.modules.posix.Hider;
import org.python.modules.posix.OS;
import org.python.modules.posix.PosixImpl;
import org.python.modules.posix.PyStatResult;
import org.python.modules.posix.PythonPOSIXHandler;

public class PosixModule
implements ClassDictInit {
    public static final PyString __doc__ = new PyString("This module provides access to operating system functionality that is\nstandardized by the C Standard and the POSIX standard (a thinly\ndisguised Unix interface).  Refer to the library manual and\ncorresponding Unix manual entries for more information on calls.");
    private static final OS os = OS.getOS();
    private static final POSIX posix = POSIXFactory.getPOSIX(new PythonPOSIXHandler(), true);
    private static final int O_RDONLY = 0;
    private static final int O_WRONLY = 1;
    private static final int O_RDWR = 2;
    private static final int O_APPEND = 8;
    private static final int O_SYNC = 128;
    private static final int O_CREAT = 512;
    private static final int O_TRUNC = 1024;
    private static final int O_EXCL = 2048;
    private static final int F_OK = 0;
    private static final int X_OK = 1;
    private static final int W_OK = 2;
    private static final int R_OK = 4;
    public static PyString __doc___exit = new PyString("_exit(status)\n\nExit to the system with specified status, without normal exit processing.");
    public static PyString __doc__access = new PyString("access(path, mode) -> True if granted, False otherwise\n\nUse the real uid/gid to test for access to a path.  Note that most\noperations will use the effective uid/gid, therefore this routine can\nbe used in a suid/sgid environment to test if the invoking user has the\nspecified access to the path.  The mode argument can be F_OK to test\nexistence, or the inclusive-OR of R_OK, W_OK, and X_OK.");
    public static PyString __doc__chdir = new PyString("chdir(path)\n\nChange the current working directory to the specified path.");
    public static PyString __doc__chmod = new PyString("chmod(path, mode)\n\nChange the access permissions of a file.");
    public static PyString __doc__chown = new PyString("chown(path, uid, gid)\n\nChange the owner and group id of path to the numeric uid and gid.");
    public static PyString __doc__close = new PyString("close(fd)\n\nClose a file descriptor (for low level IO).");
    public static PyString __doc__fdopen = new PyString("fdopen(fd [, mode='r' [, bufsize]]) -> file_object\n\nReturn an open file object connected to a file descriptor.");
    public static PyString __doc__fdatasync = new PyString("fdatasync(fildes)\n\nforce write of file with filedescriptor to disk.\ndoes not force update of metadata.");
    public static PyString __doc__fsync = new PyString("fsync(fildes)\n\nforce write of file with filedescriptor to disk.");
    public static PyString __doc__ftruncate = new PyString("ftruncate(fd, length)\n\nTruncate a file to a specified length.");
    public static PyString __doc__getcwd = new PyString("getcwd() -> path\n\nReturn a string representing the current working directory.");
    public static PyString __doc__getcwdu = new PyString("getcwd() -> path\n\nReturn a unicode string representing the current working directory.");
    public static PyString __doc__getegid = new PyString("getegid() -> egid\n\nReturn the current process's effective group id.");
    public static PyString __doc__geteuid = new PyString("geteuid() -> euid\n\nReturn the current process's effective user id.");
    public static PyString __doc__getgid = new PyString("getgid() -> gid\n\nReturn the current process's group id.");
    public static PyString __doc__getlogin = new PyString("getlogin() -> string\n\nReturn the actual login name.");
    public static PyString __doc__getppid = new PyString("getppid() -> ppid\n\nReturn the parent's process id.");
    public static PyString __doc__getuid = new PyString("getuid() -> uid\n\nReturn the current process's user id.");
    public static PyString __doc__getpid = new PyString("getpid() -> pid\n\nReturn the current process id");
    public static PyString __doc__getpgrp = new PyString("getpgrp() -> pgrp\n\nReturn the current process group id.");
    public static PyString __doc__isatty = new PyString("isatty(fd) -> bool\n\nReturn True if the file descriptor 'fd' is an open file descriptor\nconnected to the slave end of a terminal.");
    public static PyString __doc__kill = new PyString("kill(pid, sig)\n\nKill a process with a signal.");
    public static PyString __doc__lchmod = new PyString("lchmod(path, mode)\n\nChange the access permissions of a file. If path is a symlink, this\naffects the link itself rather than the target.");
    public static PyString __doc__lchown = new PyString("lchown(path, uid, gid)\n\nChange the owner and group id of path to the numeric uid and gid.\nThis function will not follow symbolic links.");
    public static PyString __doc__link = new PyString("link(src, dst)\n\nCreate a hard link to a file.");
    public static PyString __doc__listdir = new PyString("listdir(path) -> list_of_strings\n\nReturn a list containing the names of the entries in the directory.\n\npath: path of directory to list\n\nThe list is in arbitrary order.  It does not include the special\nentries '.' and '..' even if they are present in the directory.");
    public static PyString __doc__lseek = new PyString("lseek(fd, pos, how) -> newpos\n\nSet the current position of a file descriptor.");
    public static PyString __doc__mkdir = new PyString("mkdir(path [, mode=0777])\n\nCreate a directory.");
    public static PyString __doc__open = new PyString("open(filename, flag [, mode=0777]) -> fd\n\nOpen a file (for low level IO).\n\nNote that the mode argument is not currently supported on Jython.");
    public static PyString __doc__popen = new PyString("popen(command [, mode='r' [, bufsize]]) -> pipe\n\nOpen a pipe to/from a command returning a file object.");
    public static PyString __doc__putenv = new PyString("putenv(key, value)\n\nChange or add an environment variable.");
    public static PyString __doc__read = new PyString("read(fd, buffersize) -> string\n\nRead a file descriptor.");
    public static PyString __doc__readlink = new PyString("readlink(path) -> path\n\nReturn a string representing the path to which the symbolic link points.");
    public static PyString __doc__remove = new PyString("remove(path)\n\nRemove a file (same as unlink(path)).");
    public static PyString __doc__rename = new PyString("rename(old, new)\n\nRename a file or directory.");
    public static PyString __doc__rmdir = new PyString("rmdir(path)\n\nRemove a directory.");
    public static PyString __doc__setpgrp = new PyString("setpgrp()\n\nMake this process a session leader.");
    public static PyString __doc__setsid = new PyString("setsid()\n\nCall the system call setsid().");
    public static PyString __doc__strerror = new PyString("strerror(code) -> string\n\nTranslate an error code to a message string.");
    public static PyString __doc__symlink = new PyString("symlink(src, dst)\n\nCreate a symbolic link pointing to src named dst.");
    public static PyString __doc__times = new PyString("times() -> (utime, stime, cutime, cstime, elapsed_time)\n\nReturn a tuple of floating point numbers indicating process times.");
    public static PyString __doc__umask = new PyString("umask(new_mask) -> old_mask\n\nSet the current numeric umask and return the previous umask.");
    public static PyString __doc__unlink = new PyString("unlink(path)\n\nRemove a file (same as remove(path)).");
    public static PyString __doc__utime = new PyString("utime(path, (atime, mtime))\nutime(path, None)\n\nSet the access and modified time of the file to the given values.  If the\nsecond form is used, set the access and modified times to the current time.");
    public static PyString __doc__wait = new PyString("wait() -> (pid, status)\n\nWait for completion of a child process.");
    public static PyString __doc__waitpid = new PyString("wait() -> (pid, status)\n\nWait for completion of a child process.");
    public static PyString __doc__write = new PyString("write(fd, string) -> byteswritten\n\nWrite a string to a file descriptor.");
    public static PyString __doc__unsetenv = new PyString("unsetenv(key)\n\nDelete an environment variable.");
    public static PyString __doc__urandom = new PyString("urandom(n) -> str\n\nReturn a string of n random bytes suitable for cryptographic use.");

    public static void classDictInit(PyObject dict) {
        dict.__setitem__("O_RDONLY", (PyObject)Py.newInteger(0));
        dict.__setitem__("O_WRONLY", (PyObject)Py.newInteger(1));
        dict.__setitem__("O_RDWR", (PyObject)Py.newInteger(2));
        dict.__setitem__("O_APPEND", (PyObject)Py.newInteger(8));
        dict.__setitem__("O_SYNC", (PyObject)Py.newInteger(128));
        dict.__setitem__("O_CREAT", (PyObject)Py.newInteger(512));
        dict.__setitem__("O_TRUNC", (PyObject)Py.newInteger(1024));
        dict.__setitem__("O_EXCL", (PyObject)Py.newInteger(2048));
        dict.__setitem__("F_OK", (PyObject)Py.newInteger(0));
        dict.__setitem__("X_OK", (PyObject)Py.newInteger(1));
        dict.__setitem__("W_OK", (PyObject)Py.newInteger(2));
        dict.__setitem__("R_OK", (PyObject)Py.newInteger(4));
        dict.__setitem__("EX_OK", (PyObject)Py.Zero);
        boolean nativePosix = false;
        try {
            nativePosix = posix.isNative();
            dict.__setitem__("_native_posix", (PyObject)Py.newBoolean(nativePosix));
            dict.__setitem__("_posix_impl", Py.java2py(posix));
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        dict.__setitem__("environ", PosixModule.getEnviron());
        dict.__setitem__("error", Py.OSError);
        dict.__setitem__("stat_result", (PyObject)PyStatResult.TYPE);
        dict.__setitem__("fstat", (PyObject)new FstatFunction());
        if (os == OS.NT) {
            WindowsStatFunction stat = new WindowsStatFunction();
            dict.__setitem__("lstat", (PyObject)stat);
            dict.__setitem__("stat", (PyObject)stat);
        } else {
            dict.__setitem__("lstat", (PyObject)new LstatFunction());
            dict.__setitem__("stat", (PyObject)new StatFunction());
        }
        Hider.hideFunctions(PosixModule.class, dict, os, nativePosix);
        dict.__setitem__("classDictInit", null);
        dict.__setitem__("__init__", null);
        dict.__setitem__("getPOSIX", null);
        dict.__setitem__("getOSName", null);
        dict.__setitem__("badFD", null);
        PyList keys = (PyList)dict.invoke("keys");
        ListIterator it = keys.listIterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!key.startsWith("__doc__")) continue;
            it.remove();
            dict.__setitem__(key, null);
        }
        dict.__setitem__("__all__", (PyObject)keys);
        dict.__setitem__("__name__", (PyObject)new PyString(os.getModuleName()));
        dict.__setitem__("__doc__", (PyObject)__doc__);
    }

    private static FDUnion getFD(PyObject fdObj) {
        if (fdObj.isInteger()) {
            int intFd = fdObj.asInt();
            switch (intFd) {
                case 0: {
                    return new FDUnion(FileDescriptor.in);
                }
                case 1: {
                    return new FDUnion(FileDescriptor.out);
                }
                case 2: {
                    return new FDUnion(FileDescriptor.err);
                }
            }
            return new FDUnion(intFd);
        }
        Object tojava = fdObj.__tojava__(FileDescriptor.class);
        if (tojava != Py.NoConversion) {
            return new FDUnion((FileDescriptor)tojava);
        }
        tojava = fdObj.__tojava__(FileIO.class);
        if (tojava != Py.NoConversion) {
            return new FDUnion(((FileIO)tojava).getFD());
        }
        throw Py.TypeError("an integer or Java/Jython file descriptor is required");
    }

    public static void _exit() {
        PosixModule._exit(0);
    }

    public static void _exit(int status) {
        System.exit(status);
    }

    public static boolean access(PyObject path, int mode) {
        File file = PosixModule.absolutePath(path).toFile();
        boolean result = true;
        if (!file.exists()) {
            result = false;
        }
        if ((mode & 4) != 0 && !file.canRead()) {
            result = false;
        }
        if ((mode & 2) != 0 && !file.canWrite()) {
            result = false;
        }
        if ((mode & 1) != 0 && !file.canExecute()) {
            result = false;
        }
        return result;
    }

    public static void chdir(PyObject path) {
        Path absolutePath = PosixModule.absolutePath(path);
        if (!PosixModule.basicstat(path, absolutePath).isDirectory()) {
            throw Py.OSError(jnr.constants.platform.Errno.ENOTDIR, path);
        }
        try {
            Py.getSystemState().setCurrentWorkingDir(absolutePath.toRealPath(new LinkOption[0]).toString());
        }
        catch (IOException ioe) {
            throw Py.OSError(ioe);
        }
    }

    public static void chmod(PyObject path, int mode) {
        block5: {
            if (os == OS.NT) {
                try {
                    if (!PosixModule.absolutePath(path).toFile().setWritable((mode & 0x80) != 0)) {
                        throw Py.OSError(jnr.constants.platform.Errno.EPERM, path);
                    }
                    break block5;
                }
                catch (SecurityException ex) {
                    throw Py.OSError(jnr.constants.platform.Errno.EACCES, path);
                }
            }
            if (posix.chmod(PosixModule.absolutePath(path).toString(), mode) < 0) {
                throw PosixModule.errorFromErrno(path);
            }
        }
    }

    @Hide(value={OS.NT})
    public static void chown(PyObject path, int uid, int gid) {
        if (posix.chown(PosixModule.absolutePath(path).toString(), uid, gid) < 0) {
            throw PosixModule.errorFromErrno(path);
        }
    }

    public static void close(PyObject fd) {
        Object obj = fd.__tojava__(RawIOBase.class);
        if (obj != Py.NoConversion) {
            ((RawIOBase)obj).close();
        } else {
            posix.close(PosixModule.getFD(fd).getIntFD());
        }
    }

    public static void closerange(PyObject fd_lowObj, PyObject fd_highObj) {
        int fd_low = PosixModule.getFD(fd_lowObj).getIntFD(false);
        int fd_high = PosixModule.getFD(fd_highObj).getIntFD(false);
        for (int i = fd_low; i < fd_high; ++i) {
            try {
                posix.close(i);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static PyObject fdopen(PyObject fd) {
        return PosixModule.fdopen(fd, "r");
    }

    public static PyObject fdopen(PyObject fd, String mode) {
        return PosixModule.fdopen(fd, mode, -1);
    }

    public static PyObject fdopen(PyObject fd, String mode, int bufsize) {
        if (mode.length() == 0 || !"rwa".contains("" + mode.charAt(0))) {
            throw Py.ValueError(String.format("invalid file mode '%s'", mode));
        }
        Object javaobj = fd.__tojava__(RawIOBase.class);
        if (javaobj == Py.NoConversion) {
            PosixModule.getFD(fd).getIntFD();
            throw Py.NotImplementedError("Integer file descriptors not currently supported for fdopen");
        }
        RawIOBase rawIO = (RawIOBase)javaobj;
        if (rawIO.closed()) {
            throw PosixModule.badFD();
        }
        try {
            return new PyFile(rawIO, "<fdopen>", mode, bufsize);
        }
        catch (PyException pye) {
            if (!pye.match(Py.IOError)) {
                throw pye;
            }
            throw Py.OSError(jnr.constants.platform.Errno.EINVAL);
        }
    }

    @Hide(value={OS.NT})
    public static void fdatasync(PyObject fd) {
        Object javaobj = fd.__tojava__(RawIOBase.class);
        if (javaobj != Py.NoConversion) {
            PosixModule.fsync((RawIOBase)javaobj, false);
        } else {
            posix.fdatasync(PosixModule.getFD(fd).getIntFD());
        }
    }

    public static void fsync(PyObject fd) {
        Object javaobj = fd.__tojava__(RawIOBase.class);
        if (javaobj != Py.NoConversion) {
            PosixModule.fsync((RawIOBase)javaobj, true);
        } else {
            posix.fsync(PosixModule.getFD(fd).getIntFD());
        }
    }

    private static void fsync(RawIOBase rawIO, boolean metadata) {
        rawIO.checkClosed();
        Channel channel = rawIO.getChannel();
        if (!(channel instanceof FileChannel)) {
            throw Py.OSError(jnr.constants.platform.Errno.EINVAL);
        }
        try {
            ((FileChannel)channel).force(metadata);
        }
        catch (ClosedChannelException cce) {
            throw Py.ValueError("I/O operation on closed file");
        }
        catch (IOException ioe) {
            throw Py.OSError(ioe);
        }
    }

    public static void ftruncate(PyObject fd, long length) {
        Object javaobj = fd.__tojava__(RawIOBase.class);
        if (javaobj != Py.NoConversion) {
            try {
                ((RawIOBase)javaobj).truncate(length);
            }
            catch (PyException pye) {
                throw Py.OSError(jnr.constants.platform.Errno.EBADF);
            }
        } else {
            posix.ftruncate(PosixModule.getFD(fd).getIntFD(), length);
        }
    }

    public static PyObject getcwd() {
        return Py.newStringOrUnicode(Py.getSystemState().getCurrentWorkingDir());
    }

    public static PyObject getcwdu() {
        return Py.newUnicode(Py.getSystemState().getCurrentWorkingDir());
    }

    @Hide(value={OS.NT})
    public static int getegid() {
        return posix.getegid();
    }

    @Hide(value={OS.NT})
    public static int geteuid() {
        return posix.geteuid();
    }

    @Hide(value={OS.NT}, posixImpl=PosixImpl.JAVA)
    public static int getgid() {
        return posix.getgid();
    }

    @Hide(value={OS.NT}, posixImpl=PosixImpl.JAVA)
    public static PyObject getlogin() {
        return new PyString(posix.getlogin());
    }

    @Hide(value={OS.NT}, posixImpl=PosixImpl.JAVA)
    public static int getppid() {
        return posix.getppid();
    }

    @Hide(value={OS.NT}, posixImpl=PosixImpl.JAVA)
    public static int getuid() {
        return posix.getuid();
    }

    @Hide(posixImpl=PosixImpl.JAVA)
    public static int getpid() {
        return posix.getpid();
    }

    @Hide(value={OS.NT}, posixImpl=PosixImpl.JAVA)
    public static int getpgrp() {
        return posix.getpgrp();
    }

    @Hide(posixImpl=PosixImpl.JAVA)
    public static boolean isatty(PyObject fdObj) {
        Object tojava = fdObj.__tojava__(IOBase.class);
        if (tojava != Py.NoConversion) {
            try {
                return ((IOBase)tojava).isatty();
            }
            catch (PyException pye) {
                if (pye.match(Py.ValueError)) {
                    return false;
                }
                throw pye;
            }
        }
        FDUnion fd = PosixModule.getFD(fdObj);
        if (fd.javaFD != null) {
            return posix.isatty(fd.javaFD);
        }
        try {
            fd.getIntFD();
        }
        catch (PyException pye) {
            if (pye.match(Py.OSError)) {
                return false;
            }
            throw pye;
        }
        throw Py.NotImplementedError("Integer file descriptor compatibility only available for stdin, stdout and stderr (0-2)");
    }

    @Hide(value={OS.NT}, posixImpl=PosixImpl.JAVA)
    public static void kill(int pid, int sig) {
        if (posix.kill(pid, sig) < 0) {
            throw PosixModule.errorFromErrno();
        }
    }

    @Hide(value={OS.NT}, posixImpl=PosixImpl.JAVA)
    public static void lchmod(PyObject path, int mode) {
        if (posix.lchmod(PosixModule.absolutePath(path).toString(), mode) < 0) {
            throw PosixModule.errorFromErrno(path);
        }
    }

    @Hide(value={OS.NT}, posixImpl=PosixImpl.JAVA)
    public static void lchown(PyObject path, int uid, int gid) {
        if (posix.lchown(PosixModule.absolutePath(path).toString(), uid, gid) < 0) {
            throw PosixModule.errorFromErrno(path);
        }
    }

    @Hide(value={OS.NT})
    public static void link(PyObject src, PyObject dst) {
        try {
            java.nio.file.Files.createLink(Paths.get(PosixModule.asPath(dst), new String[0]), Paths.get(PosixModule.asPath(src), new String[0]));
        }
        catch (FileAlreadyExistsException ex) {
            throw Py.OSError(jnr.constants.platform.Errno.EEXIST);
        }
        catch (NoSuchFileException ex) {
            throw Py.OSError(jnr.constants.platform.Errno.ENOENT);
        }
        catch (IOException ioe) {
            System.err.println("Got this exception " + ioe);
            throw Py.OSError(ioe);
        }
        catch (SecurityException ex) {
            throw Py.OSError(jnr.constants.platform.Errno.EACCES);
        }
    }

    public static PyList listdir(PyObject path) {
        File file = PosixModule.absolutePath(path).toFile();
        String[] names = file.list();
        if (names == null) {
            if (!file.isDirectory()) {
                throw Py.OSError(jnr.constants.platform.Errno.ENOTDIR, path);
            }
            if (!file.canRead()) {
                throw Py.OSError(jnr.constants.platform.Errno.EACCES, path);
            }
            throw Py.OSError("listdir(): an unknown error occurred: " + path);
        }
        PyList list = new PyList();
        for (String name : names) {
            list.append(Py.newStringOrUnicode(path, name));
        }
        return list;
    }

    public static long lseek(PyObject fd, long pos, int how) {
        Object javaobj = fd.__tojava__(RawIOBase.class);
        if (javaobj != Py.NoConversion) {
            try {
                return ((RawIOBase)javaobj).seek(pos, how);
            }
            catch (PyException pye) {
                throw PosixModule.badFD();
            }
        }
        return posix.lseek(PosixModule.getFD(fd).getIntFD(), pos, how);
    }

    public static void mkdir(PyObject path) {
        PosixModule.mkdir(path, 511);
    }

    public static void mkdir(PyObject path, int mode) {
        if (os == OS.NT) {
            try {
                Path nioPath = PosixModule.absolutePath(path);
                java.nio.file.Files.createDirectory(nioPath, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException ex) {
                throw Py.OSError(jnr.constants.platform.Errno.EEXIST, path);
            }
            catch (IOException ioe) {
                throw Py.OSError(ioe);
            }
            catch (SecurityException ex) {
                throw Py.OSError(jnr.constants.platform.Errno.EACCES, path);
            }
        } else if (posix.mkdir(PosixModule.absolutePath(path).toString(), mode) < 0) {
            throw PosixModule.errorFromErrno(path);
        }
    }

    public static FileIO open(PyObject path, int flag) {
        return PosixModule.open(path, flag, 511);
    }

    public static FileIO open(PyObject path, int flag, int mode) {
        boolean sync;
        File file = PosixModule.absolutePath(path).toFile();
        boolean reading = (flag & 0) != 0;
        boolean writing = (flag & 1) != 0;
        boolean updating = (flag & 2) != 0;
        boolean creating = (flag & 0x200) != 0;
        boolean appending = (flag & 8) != 0;
        boolean truncating = (flag & 0x400) != 0;
        boolean exclusive = (flag & 0x800) != 0;
        boolean bl = sync = (flag & 0x80) != 0;
        if (updating && writing) {
            throw Py.OSError(jnr.constants.platform.Errno.EINVAL, path);
        }
        if (!creating && !file.exists()) {
            throw Py.OSError(jnr.constants.platform.Errno.ENOENT, path);
        }
        if (!writing) {
            if (updating) {
                writing = true;
            } else {
                reading = true;
            }
        }
        if (truncating && !writing) {
            new FileIO((PyString)path, "w").close();
        }
        if (exclusive && creating) {
            try {
                if (!file.createNewFile()) {
                    throw Py.OSError(jnr.constants.platform.Errno.EEXIST, path);
                }
            }
            catch (IOException ioe) {
                throw Py.OSError(ioe);
            }
        }
        String fileIOMode = (reading ? "r" : "") + (!appending && writing ? "w" : "") + (appending && (writing || updating) ? "a" : "") + (updating ? "+" : "");
        if (sync && (writing || updating)) {
            try {
                return new FileIO(new RandomAccessFile(file, "rws").getChannel(), fileIOMode);
            }
            catch (FileNotFoundException fnfe) {
                throw Py.OSError(file.isDirectory() ? jnr.constants.platform.Errno.EISDIR : jnr.constants.platform.Errno.ENOENT, path);
            }
        }
        return new FileIO((PyString)path, fileIOMode);
    }

    public static PyObject popen(PyObject[] args, String[] kwds) {
        return imp.load("os").__getattr__("popen").__call__(args, kwds);
    }

    public static void putenv(String key, String value) {
        PyObject environ = imp.load("os").__getattr__("environ");
        environ.__setitem__(key, (PyObject)new PyString(value));
    }

    public static PyObject read(PyObject fd, int buffersize) {
        Object javaobj = fd.__tojava__(RawIOBase.class);
        if (javaobj != Py.NoConversion) {
            try {
                return new PyString(StringUtil.fromBytes(((RawIOBase)javaobj).read(buffersize)));
            }
            catch (PyException pye) {
                throw PosixModule.badFD();
            }
        }
        ByteBuffer buffer = ByteBuffer.allocate(buffersize);
        posix.read(PosixModule.getFD(fd).getIntFD(), buffer, buffersize);
        return new PyString(StringUtil.fromBytes(buffer));
    }

    @Hide(value={OS.NT})
    public static PyString readlink(PyObject path) {
        try {
            return Py.newStringOrUnicode(path, java.nio.file.Files.readSymbolicLink(PosixModule.absolutePath(path)).toString());
        }
        catch (NotLinkException ex) {
            throw Py.OSError(jnr.constants.platform.Errno.EINVAL, path);
        }
        catch (NoSuchFileException ex) {
            throw Py.OSError(jnr.constants.platform.Errno.ENOENT, path);
        }
        catch (IOException ioe) {
            throw Py.OSError(ioe);
        }
        catch (SecurityException ex) {
            throw Py.OSError(jnr.constants.platform.Errno.EACCES, path);
        }
    }

    public static void remove(PyObject path) {
        PosixModule.unlink(path);
    }

    public static void rename(PyObject oldpath, PyObject newpath) {
        if (!PosixModule.absolutePath(oldpath).toFile().renameTo(PosixModule.absolutePath(newpath).toFile())) {
            PyTuple args = new PyTuple(Py.Zero, new PyString("Couldn't rename file"));
            throw new PyException(Py.OSError, args);
        }
    }

    public static void rmdir(PyObject path) {
        File file = PosixModule.absolutePath(path).toFile();
        if (!file.exists()) {
            throw Py.OSError(jnr.constants.platform.Errno.ENOENT, path);
        }
        if (!file.isDirectory()) {
            throw Py.OSError(jnr.constants.platform.Errno.ENOTDIR, path);
        }
        if (!file.delete()) {
            PyTuple args = new PyTuple(Py.Zero, new PyString("Couldn't delete directory"), path);
            throw new PyException(Py.OSError, args);
        }
    }

    @Hide(value={OS.NT}, posixImpl=PosixImpl.JAVA)
    public static void setpgrp() {
        if (posix.setpgrp(0, 0) < 0) {
            throw PosixModule.errorFromErrno();
        }
    }

    @Hide(value={OS.NT}, posixImpl=PosixImpl.JAVA)
    public static void setsid() {
        if (posix.setsid() < 0) {
            throw PosixModule.errorFromErrno();
        }
    }

    public static PyObject strerror(int code) {
        Constant errno2 = jnr.constants.platform.Errno.valueOf(code);
        if (errno2 == jnr.constants.platform.Errno.__UNKNOWN_CONSTANT__) {
            return new PyString("Unknown error: " + code);
        }
        if (errno2.name() == ((Object)errno2).toString()) {
            errno2 = Enum.valueOf(Errno.class, errno2.name());
        }
        return new PyString(((Object)errno2).toString());
    }

    @Hide(value={OS.NT})
    public static void symlink(PyObject src, PyObject dst) {
        try {
            java.nio.file.Files.createSymbolicLink(Paths.get(PosixModule.asPath(dst), new String[0]), Paths.get(PosixModule.asPath(src), new String[0]), new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException ex) {
            throw Py.OSError(jnr.constants.platform.Errno.EEXIST);
        }
        catch (IOException ioe) {
            throw Py.OSError(ioe);
        }
        catch (SecurityException ex) {
            throw Py.OSError(jnr.constants.platform.Errno.EACCES);
        }
    }

    private static PyFloat ratio(long num, long div) {
        return Py.newFloat((double)num / (double)div);
    }

    @Hide(posixImpl=PosixImpl.JAVA)
    public static PyTuple times() {
        Times times = posix.times();
        long CLK_TCK = Sysconf._SC_CLK_TCK.longValue();
        return new PyTuple(PosixModule.ratio(times.utime(), CLK_TCK), PosixModule.ratio(times.stime(), CLK_TCK), PosixModule.ratio(times.cutime(), CLK_TCK), PosixModule.ratio(times.cstime(), CLK_TCK), PosixModule.ratio(ManagementFactory.getRuntimeMXBean().getUptime(), 1000L));
    }

    @Hide(posixImpl=PosixImpl.JAVA)
    public static int umask(int mask) {
        return posix.umask(mask);
    }

    public static void unlink(PyObject path) {
        Path nioPath = PosixModule.absolutePath(path);
        try {
            if (java.nio.file.Files.isDirectory(nioPath, LinkOption.NOFOLLOW_LINKS)) {
                throw Py.OSError(jnr.constants.platform.Errno.EISDIR, path);
            }
            if (!java.nio.file.Files.deleteIfExists(nioPath)) {
                PosixModule.basicstat(path, nioPath);
                if (!java.nio.file.Files.isWritable(nioPath)) {
                    throw Py.OSError(jnr.constants.platform.Errno.EACCES, path);
                }
                throw Py.OSError("unlink(): an unknown error occurred: " + nioPath.toString());
            }
        }
        catch (IOException ex) {
            PyException pyError = Py.OSError("unlink(): an unknown error occurred: " + nioPath.toString());
            pyError.initCause(ex);
            throw pyError;
        }
    }

    public static void utime(PyObject path, PyObject times) {
        long[] atimeval;
        long[] mtimeval;
        if (times == Py.None) {
            mtimeval = null;
            atimeval = null;
        } else if (times instanceof PyTuple && times.__len__() == 2) {
            atimeval = PosixModule.extractTimeval(times.__getitem__(0));
            mtimeval = PosixModule.extractTimeval(times.__getitem__(1));
        } else {
            throw Py.TypeError("utime() arg 2 must be a tuple (atime, mtime)");
        }
        if (posix.utimes(PosixModule.absolutePath(path).toString(), atimeval, mtimeval) < 0) {
            throw PosixModule.errorFromErrno(path);
        }
    }

    private static long[] extractTimeval(PyObject seconds) {
        long[] timeval = new long[]{Platform.IS_32_BIT ? (long)seconds.asInt() : seconds.asLong(), 0L};
        if (seconds instanceof PyFloat) {
            long usec = (long)((seconds.asDouble() - (double)timeval[0]) * 1000000.0);
            if (usec < 0L) {
                usec = 0L;
            }
            timeval[1] = usec;
        }
        return timeval;
    }

    @Hide(value={OS.NT}, posixImpl=PosixImpl.JAVA)
    public static PyObject wait$() {
        int[] status = new int[1];
        int pid = posix.wait(status);
        if (pid < 0) {
            throw PosixModule.errorFromErrno();
        }
        return new PyTuple(Py.newInteger(pid), Py.newInteger(status[0]));
    }

    @Hide(posixImpl=PosixImpl.JAVA)
    public static PyObject waitpid(int pid, int options) {
        int[] status = new int[1];
        if ((pid = posix.waitpid(pid, status, options)) < 0) {
            throw PosixModule.errorFromErrno();
        }
        return new PyTuple(Py.newInteger(pid), Py.newInteger(status[0]));
    }

    public static int write(PyObject fd, BufferProtocol bytes) {
        try (PyBuffer buf = bytes.getBuffer(8);){
            ByteBuffer bb = buf.getNIOByteBuffer();
            Object javaobj = fd.__tojava__(RawIOBase.class);
            if (javaobj != Py.NoConversion) {
                try {
                    int n = ((RawIOBase)javaobj).write(bb);
                    return n;
                }
                catch (PyException pye) {
                    throw PosixModule.badFD();
                }
            }
            int n = posix.write(PosixModule.getFD(fd).getIntFD(), bb, bb.position());
            return n;
        }
    }

    public static void unsetenv(String key) {
        block2: {
            PyObject environ = imp.load("os").__getattr__("environ");
            try {
                environ.__delitem__(key);
            }
            catch (PyException pye) {
                if (pye.match(Py.KeyError)) break block2;
                throw pye;
            }
        }
    }

    public static PyObject urandom(int n) {
        byte[] buf = new byte[n];
        UrandomSource.INSTANCE.nextBytes(buf);
        return new PyString(StringUtil.fromBytes(buf));
    }

    public static PyObject _get_shell_commands() {
        String[][] commands = os.getShellCommands();
        PyObject[] commandsTup = new PyObject[commands.length];
        int i = 0;
        for (String[] command : commands) {
            PyList args = new PyList();
            for (String arg : command) {
                args.append(new PyString(arg));
            }
            commandsTup[i++] = args;
        }
        return new PyTuple(commandsTup);
    }

    private static PyObject getEnviron() {
        Map<String, String> env;
        PyDictionary environ = new PyDictionary();
        try {
            env = System.getenv();
        }
        catch (SecurityException se) {
            return environ;
        }
        for (Map.Entry<String, String> entry : env.entrySet()) {
            ((PyObject)environ).__setitem__(Py.newStringOrUnicode(entry.getKey()), (PyObject)Py.newStringOrUnicode(entry.getValue()));
        }
        return environ;
    }

    private static String asPath(PyObject path) {
        if (path instanceof PyString) {
            return path.toString();
        }
        throw Py.TypeError(String.format("coercing to Unicode: need string, %s type found", path.getType().fastGetName()));
    }

    private static Path absolutePath(PyObject pathObj) {
        String pathStr = PosixModule.asPath(pathObj);
        if (pathStr.equals("")) {
            throw Py.OSError(jnr.constants.platform.Errno.ENOENT, pathObj);
        }
        try {
            Path path = FileSystems.getDefault().getPath(pathStr, new String[0]);
            if (!path.isAbsolute()) {
                path = FileSystems.getDefault().getPath(Py.getSystemState().getCurrentWorkingDir(), pathStr);
            }
            return path.toAbsolutePath();
        }
        catch (InvalidPathException ex) {
            throw Py.OSError(jnr.constants.platform.Errno.EINVAL, pathObj);
        }
    }

    private static PyException badFD() {
        return Py.OSError(jnr.constants.platform.Errno.EBADF);
    }

    private static PyException errorFromErrno() {
        return Py.OSError(jnr.constants.platform.Errno.valueOf(posix.errno()));
    }

    private static PyException errorFromErrno(PyObject path) {
        return Py.OSError(jnr.constants.platform.Errno.valueOf(posix.errno()), path);
    }

    public static POSIX getPOSIX() {
        return posix;
    }

    public static String getOSName() {
        return os.getModuleName();
    }

    private static void checkTrailingSlash(PyObject path, Map<String, Object> attributes) {
        String pathStr;
        Boolean isDirectory = (Boolean)attributes.get("isDirectory");
        if (isDirectory != null && !isDirectory.booleanValue() && ((pathStr = path.toString()).endsWith(File.separator) || pathStr.endsWith("/."))) {
            throw Py.OSError(jnr.constants.platform.Errno.ENOTDIR, path);
        }
    }

    private static BasicFileAttributes basicstat(PyObject path, Path absolutePath) {
        try {
            String pathStr;
            BasicFileAttributes attributes = java.nio.file.Files.readAttributes(absolutePath, BasicFileAttributes.class, new LinkOption[0]);
            if (!attributes.isDirectory() && ((pathStr = path.toString()).endsWith(File.separator) || pathStr.endsWith("/"))) {
                throw Py.OSError(jnr.constants.platform.Errno.ENOTDIR, path);
            }
            return attributes;
        }
        catch (NoSuchFileException ex) {
            throw Py.OSError(jnr.constants.platform.Errno.ENOENT, path);
        }
        catch (IOException ioe) {
            throw Py.OSError(jnr.constants.platform.Errno.EBADF, path);
        }
        catch (SecurityException ex) {
            throw Py.OSError(jnr.constants.platform.Errno.EACCES, path);
        }
    }

    @Untraversable
    static class FstatFunction
    extends PyBuiltinFunctionNarrow {
        FstatFunction() {
            super("fstat", 1, 1, "fstat(fd) -> stat result\\n\\nLike stat(), but for an open file descriptor.");
        }

        @Override
        public PyObject __call__(PyObject fdObj) {
            try {
                FDUnion fd = PosixModule.getFD(fdObj);
                FileStat stat = fd.isIntFD() ? posix.fstat(fd.intFD) : posix.fstat(fd.javaFD);
                return PyStatResult.fromFileStat(stat);
            }
            catch (PyException ex) {
                throw Py.OSError(jnr.constants.platform.Errno.EBADF);
            }
        }
    }

    @Untraversable
    static class WindowsStatFunction
    extends PyBuiltinFunctionNarrow {
        private static final int _S_IFDIR = 16384;
        private static final int _S_IFREG = 32768;

        WindowsStatFunction() {
            super("stat", 1, 1, "stat(path) -> stat result\n\nPerform a stat system call on the given path.\n\nNote that some platforms may return only a small subset of the\nstandard fields");
        }

        static int attributes_to_mode(DosFileAttributes attr) {
            int m = 0;
            m = attr.isDirectory() ? (m |= 0x4049) : (m |= 0x8000);
            m = attr.isReadOnly() ? (m |= 0x124) : (m |= 0x1B6);
            return m;
        }

        @Override
        public PyObject __call__(PyObject path) {
            Path absolutePath = PosixModule.absolutePath(path);
            try {
                String pathStr;
                DosFileAttributes attributes = java.nio.file.Files.readAttributes(absolutePath, DosFileAttributes.class, new LinkOption[0]);
                if (!attributes.isDirectory() && ((pathStr = path.toString()).endsWith(File.separator) || pathStr.endsWith("/"))) {
                    throw Py.OSError(jnr.constants.platform.Errno.ENOTDIR, path);
                }
                int mode = WindowsStatFunction.attributes_to_mode(attributes);
                String extension = Files.getFileExtension(absolutePath.toString());
                if (extension.equals("bat") || extension.equals("cmd") || extension.equals("exe") || extension.equals("com")) {
                    mode |= 0x49;
                }
                return PyStatResult.fromDosFileAttributes(mode, attributes);
            }
            catch (NoSuchFileException ex) {
                throw Py.OSError(jnr.constants.platform.Errno.ENOENT, path);
            }
            catch (IOException ioe) {
                throw Py.OSError(jnr.constants.platform.Errno.EBADF, path);
            }
            catch (SecurityException ex) {
                throw Py.OSError(jnr.constants.platform.Errno.EACCES, path);
            }
        }
    }

    @Untraversable
    static class StatFunction
    extends PyBuiltinFunctionNarrow {
        StatFunction() {
            super("stat", 1, 1, "stat(path) -> stat result\n\nPerform a stat system call on the given path.\n\nNote that some platforms may return only a small subset of the\nstandard fields");
        }

        @Override
        public PyObject __call__(PyObject path) {
            Path absolutePath = PosixModule.absolutePath(path);
            try {
                Map<String, Object> attributes = java.nio.file.Files.readAttributes(absolutePath, "unix:*", new LinkOption[0]);
                PosixModule.checkTrailingSlash(path, attributes);
                return PyStatResult.fromUnixFileAttributes(attributes);
            }
            catch (NoSuchFileException ex) {
                throw Py.OSError(jnr.constants.platform.Errno.ENOENT, path);
            }
            catch (IOException ioe) {
                throw Py.OSError(jnr.constants.platform.Errno.EBADF, path);
            }
            catch (SecurityException ex) {
                throw Py.OSError(jnr.constants.platform.Errno.EACCES, path);
            }
        }
    }

    @Untraversable
    static class LstatFunction
    extends PyBuiltinFunctionNarrow {
        LstatFunction() {
            super("lstat", 1, 1, "lstat(path) -> stat result\n\nLike stat(path), but do not follow symbolic links.");
        }

        @Override
        public PyObject __call__(PyObject path) {
            Path absolutePath = PosixModule.absolutePath(path);
            try {
                Map<String, Object> attributes = java.nio.file.Files.readAttributes(absolutePath, "unix:*", LinkOption.NOFOLLOW_LINKS);
                Boolean isSymbolicLink = (Boolean)attributes.get("isSymbolicLink");
                if (isSymbolicLink != null && isSymbolicLink.booleanValue() && path.toString().endsWith("/")) {
                    Path symlink = java.nio.file.Files.readSymbolicLink(absolutePath);
                    symlink = absolutePath.getParent().resolve(symlink);
                    attributes = java.nio.file.Files.readAttributes(symlink, "unix:*", LinkOption.NOFOLLOW_LINKS);
                } else {
                    PosixModule.checkTrailingSlash(path, attributes);
                }
                return PyStatResult.fromUnixFileAttributes(attributes);
            }
            catch (NoSuchFileException ex) {
                throw Py.OSError(jnr.constants.platform.Errno.ENOENT, path);
            }
            catch (IOException ioe) {
                throw Py.OSError(jnr.constants.platform.Errno.EBADF, path);
            }
            catch (SecurityException ex) {
                throw Py.OSError(jnr.constants.platform.Errno.EACCES, path);
            }
        }
    }

    private static class FDUnion {
        volatile int intFD;
        final FileDescriptor javaFD;

        FDUnion(int fd) {
            this.intFD = fd;
            this.javaFD = null;
        }

        FDUnion(FileDescriptor fd) {
            this.intFD = -1;
            this.javaFD = fd;
        }

        boolean isIntFD() {
            return this.intFD != -1;
        }

        int getIntFD() {
            return this.getIntFD(true);
        }

        int getIntFD(boolean checkFD) {
            if (this.intFD == -1) {
                if (!(this.javaFD instanceof FileDescriptor)) {
                    throw Py.OSError(jnr.constants.platform.Errno.EBADF);
                }
                try {
                    Field fdField = FieldAccess.getProtectedField(FileDescriptor.class, "fd");
                    this.intFD = fdField.getInt(this.javaFD);
                }
                catch (SecurityException securityException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            if (checkFD) {
                if (this.intFD == -1) {
                    throw Py.OSError(jnr.constants.platform.Errno.EBADF);
                }
                posix.fstat(this.intFD);
            }
            return this.intFD;
        }

        public String toString() {
            return "FDUnion(int=" + this.intFD + ", java=" + this.javaFD + ")";
        }
    }

    private static class UrandomSource {
        static final SecureRandom INSTANCE = new SecureRandom();

        private UrandomSource() {
        }
    }
}

