/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import org.python.antlr.ParseException;
import org.python.antlr.PythonTree;
import org.python.antlr.ast.Return;
import org.python.antlr.base.expr;
import org.python.compiler.ArgListCompiler;
import org.python.compiler.CompilationContext;
import org.python.compiler.ScopeConstants;
import org.python.compiler.SymInfo;
import org.python.core.Options;

public class ScopeInfo
implements ScopeConstants {
    public PythonTree scope_node;
    public String scope_name;
    public int level;
    public int func_level;
    public int kind;
    public boolean unqual_exec;
    public boolean exec;
    public boolean from_import_star;
    public boolean contains_ns_free_vars;
    public boolean generator;
    private boolean hasReturnWithValue;
    public int yield_count;
    public int max_with_count;
    public ArgListCompiler ac;
    public Map<String, SymInfo> tbl = new LinkedHashMap<String, SymInfo>();
    public Vector<String> names = new Vector();
    public int local = 0;
    private static final Object PRESENT = new Object();
    public Hashtable<String, Object> inner_free = new Hashtable();
    public Vector<String> cellvars = new Vector();
    public Vector<String> jy_paramcells = new Vector();
    public int jy_npurecell;
    public int cell;
    public int distance;
    public ScopeInfo up;
    public Vector<String> freevars = new Vector();

    public void dump() {
        if (Options.verbose < 3) {
            return;
        }
        for (int i = 0; i < this.level; ++i) {
            System.err.print(' ');
        }
        System.err.print((this.kind != 2 ? this.scope_name : "class " + this.scope_name) + ": ");
        for (Map.Entry<String, SymInfo> entry : this.tbl.entrySet()) {
            String name = entry.getKey();
            SymInfo info = entry.getValue();
            int flags = info.flags;
            System.err.print(name);
            if ((flags & 1) != 0) {
                System.err.print('=');
            }
            if ((flags & 2) != 0) {
                System.err.print('G');
            } else if ((flags & 0x40) != 0) {
                System.err.print('g');
            }
            if ((flags & 4) != 0) {
                System.err.print('P');
            } else if ((flags & 8) != 0) {
                System.err.print('p');
            }
            if ((flags & 0x10) != 0) {
                System.err.print('!');
            }
            if ((flags & 0x20) != 0) {
                System.err.print(",f");
            }
            System.err.print(" ");
        }
        System.err.println();
    }

    public ScopeInfo(String name, PythonTree node, int level, int kind, int func_level, ArgListCompiler ac) {
        this.scope_name = name;
        this.scope_node = node;
        this.level = level;
        this.kind = kind;
        this.func_level = func_level;
        this.ac = ac;
    }

    public int addGlobal(String name) {
        int global = this.kind == 2 ? 64 : 2;
        SymInfo info = this.tbl.get(name);
        if (info == null) {
            this.tbl.put(name, new SymInfo(global | 1));
            return -1;
        }
        int prev = info.flags;
        info.flags |= global | 1;
        return prev;
    }

    public void addParam(String name) {
        this.tbl.put(name, new SymInfo(5, this.local++));
        this.names.addElement(name);
    }

    public void markFromParam() {
        for (SymInfo info : this.tbl.values()) {
            info.flags |= 8;
        }
    }

    public void addBound(String name) {
        SymInfo info = this.tbl.get(name);
        if (info == null) {
            this.tbl.put(name, new SymInfo(1));
            return;
        }
        info.flags |= 1;
    }

    public void addUsed(String name) {
        if (this.tbl.get(name) == null) {
            this.tbl.put(name, new SymInfo(0));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void cook(ScopeInfo up, int distance, CompilationContext ctxt) throws Exception {
        if (up == null) {
            return;
        }
        this.up = up;
        this.distance = distance;
        boolean func = this.kind == 1;
        Vector<String> purecells = new Vector<String>();
        this.cell = 0;
        boolean some_inner_free = this.inner_free.size() > 0;
        Enumeration<String> e = this.inner_free.keys();
        while (e.hasMoreElements()) {
            String name = e.nextElement();
            SymInfo info = this.tbl.get(name);
            if (info == null) {
                this.tbl.put(name, new SymInfo(32));
                continue;
            }
            int n = info.flags;
            if (func) {
                if ((n & 2) != 0 || (n & 1) == 0) continue;
                info.flags |= 0x10;
                if ((info.flags & 4) != 0) {
                    this.jy_paramcells.addElement(name);
                }
                this.cellvars.addElement(name);
                ++this.cell;
                info.env_index = info.env_index;
                if ((n & 4) != 0) continue;
                purecells.addElement(name);
                continue;
            }
            info.flags |= 0x20;
        }
        boolean some_free = false;
        boolean nested = up.kind != 0;
        for (Map.Entry entry : this.tbl.entrySet()) {
            String name = (String)entry.getKey();
            SymInfo info = (SymInfo)entry.getValue();
            int flags = info.flags;
            if (nested && (flags & 0x20) != 0) {
                up.inner_free.put(name, PRESENT);
            }
            if ((flags & 0x56) != 0) continue;
            if ((flags & 1) != 0) {
                this.names.addElement(name);
                ++this.local;
                info.locals_index = info.locals_index;
                continue;
            }
            info.flags |= 0x20;
            some_free = true;
            if (!nested) continue;
            up.inner_free.put(name, PRESENT);
        }
        this.jy_npurecell = purecells.size();
        if (this.jy_npurecell > 0) {
            void var10_16;
            int sz = purecells.size();
            boolean bl = false;
            while (var10_16 < sz) {
                this.names.addElement((String)purecells.elementAt((int)var10_16));
                ++var10_16;
            }
        }
        if (some_free && nested) {
            up.contains_ns_free_vars = true;
        }
        if (this.unqual_exec || this.from_import_star) {
            if (some_inner_free) {
                this.dynastuff_trouble(true, ctxt);
            } else if (this.func_level > 1 && some_free) {
                this.dynastuff_trouble(false, ctxt);
            }
        }
    }

    private void dynastuff_trouble(boolean inner_free, CompilationContext ctxt) throws Exception {
        StringBuilder illegal = new StringBuilder();
        if (this.unqual_exec && this.from_import_star) {
            illegal.append("function '").append(this.scope_name).append("' uses import * and bare exec, which are illegal");
        } else if (this.unqual_exec) {
            illegal.append("unqualified exec is not allowed in function '").append(this.scope_name).append("'");
        } else {
            illegal.append("import * is not allowed in function '").append(this.scope_name).append("'");
        }
        if (inner_free) {
            illegal.append(" because it contains a function with free variables");
        } else {
            illegal.append(" because it contains free variables");
        }
        ctxt.error(illegal.toString(), true, this.scope_node);
    }

    public void setup_closure() {
        this.setup_closure(this.up);
    }

    public void setup_closure(ScopeInfo up) {
        int free = this.cell;
        Map<String, SymInfo> up_tbl = up.tbl;
        boolean nested = up.kind != 0;
        for (Map.Entry<String, SymInfo> entry : this.tbl.entrySet()) {
            String name = entry.getKey();
            SymInfo info = entry.getValue();
            int flags = info.flags;
            if ((flags & 0x20) == 0) continue;
            SymInfo up_info = up_tbl.get(name);
            if (up_info != null) {
                int up_flags = up_info.flags;
                if ((up_flags & 0x30) != 0) {
                    info.env_index = free++;
                    this.freevars.addElement(name);
                    continue;
                }
                if (nested && (up_flags & 2) != 0) {
                    info.flags = 3;
                    continue;
                }
            }
            info.flags &= 0xFFFFFFDF;
        }
    }

    public String toString() {
        return "ScopeInfo[" + this.scope_name + " " + this.kind + "]@" + System.identityHashCode(this);
    }

    public void defineAsGenerator(expr node) {
        this.generator = true;
        if (this.hasReturnWithValue) {
            throw new ParseException("'return' with argument inside generator", node);
        }
    }

    public void noteReturnValue(Return node) {
        if (this.generator) {
            throw new ParseException("'return' with argument inside generator", node);
        }
        this.hasReturnWithValue = true;
    }
}

