/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Set;
import org.python.compiler.ClassConstants;
import org.python.compiler.ClassFile;
import org.python.compiler.Code;
import org.python.compiler.CodeCompiler;
import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.core.PyMethod;
import org.python.core.PyObject;
import org.python.core.PyProxy;
import org.python.core.PyReflectedFunction;
import org.python.objectweb.asm.Label;
import org.python.objectweb.asm.Opcodes;
import org.python.util.Generic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyMaker
implements ClassConstants,
Opcodes {
    public static final int tBoolean = 0;
    public static final int tByte = 1;
    public static final int tShort = 2;
    public static final int tInteger = 3;
    public static final int tLong = 4;
    public static final int tFloat = 5;
    public static final int tDouble = 6;
    public static final int tCharacter = 7;
    public static final int tVoid = 8;
    public static final int tOther = 9;
    public static final int tNone = 10;
    public static Map<Class<?>, Integer> types = ProxyMaker.fillTypes();
    Class<?> superclass;
    Class<?>[] interfaces;
    Set<String> names;
    Set<String> supernames = Generic.set();
    public ClassFile classfile;
    public String myClass;

    public static Map<Class<?>, Integer> fillTypes() {
        Map<Class<?>, Integer> typeMap = Generic.map();
        typeMap.put(Boolean.TYPE, 0);
        typeMap.put(Byte.TYPE, 1);
        typeMap.put(Short.TYPE, 2);
        typeMap.put(Integer.TYPE, 3);
        typeMap.put(Long.TYPE, 4);
        typeMap.put(Float.TYPE, 5);
        typeMap.put(Double.TYPE, 6);
        typeMap.put(Character.TYPE, 7);
        typeMap.put(Void.TYPE, 8);
        return typeMap;
    }

    public static int getType(Class<?> c) {
        if (c == null) {
            return 10;
        }
        Integer i = types.get(c);
        if (i == null) {
            return 9;
        }
        return i;
    }

    public static PyObject findPython(PyProxy proxy, String name) {
        PyObject ret;
        PyObject o = proxy._getPyInstance();
        if (o == null) {
            proxy.__initProxy__(new Object[0]);
            o = proxy._getPyInstance();
        }
        if ((ret = o.__findattr__(name)) instanceof PyMethod) {
            PyMethod meth = (PyMethod)ret;
            if (meth.im_func instanceof PyReflectedFunction) {
                PyReflectedFunction func = (PyReflectedFunction)meth.im_func;
                if (func.nargs > 0 && proxy.getClass() == func.argslist[0].declaringClass) {
                    return null;
                }
            }
        }
        Py.setSystemState(proxy._getPySystemState());
        return ret;
    }

    public ProxyMaker(String classname, Class<?> superclass) {
        this.myClass = "org.python.proxies." + classname;
        if (superclass.isInterface()) {
            this.superclass = Object.class;
            this.interfaces = new Class[]{superclass};
        } else {
            this.superclass = superclass;
            this.interfaces = new Class[0];
        }
    }

    public ProxyMaker(String myClass, Class<?> superclass, Class<?>[] interfaces) {
        this.myClass = myClass;
        if (superclass == null) {
            superclass = Object.class;
        }
        this.superclass = superclass;
        if (interfaces == null) {
            interfaces = new Class[]{};
        }
        this.interfaces = interfaces;
    }

    public static String mapClass(Class<?> c) {
        String name = c.getName();
        int index = name.indexOf(".");
        if (index == -1) {
            return name;
        }
        StringBuffer buf = new StringBuffer(name.length());
        int last_index = 0;
        while (index != -1) {
            buf.append(name.substring(last_index, index));
            buf.append("/");
            last_index = index + 1;
            index = name.indexOf(".", last_index);
        }
        buf.append(name.substring(last_index, name.length()));
        return buf.toString();
    }

    public static String mapType(Class<?> type) {
        if (type.isArray()) {
            return "[" + ProxyMaker.mapType(type.getComponentType());
        }
        switch (ProxyMaker.getType(type)) {
            case 1: {
                return "B";
            }
            case 7: {
                return "C";
            }
            case 6: {
                return "D";
            }
            case 5: {
                return "F";
            }
            case 3: {
                return "I";
            }
            case 4: {
                return "J";
            }
            case 2: {
                return "S";
            }
            case 0: {
                return "Z";
            }
            case 8: {
                return "V";
            }
        }
        return "L" + ProxyMaker.mapClass(type) + ";";
    }

    public static String makeSignature(Class<?>[] sig, Class<?> ret) {
        StringBuffer buf = new StringBuffer();
        buf.append("(");
        for (Class<?> element : sig) {
            buf.append(ProxyMaker.mapType(element));
        }
        buf.append(")");
        buf.append(ProxyMaker.mapType(ret));
        return buf.toString();
    }

    public void doConstants() throws Exception {
        Code code = this.classfile.addMethod("<clinit>", "()V", 8);
        code.return_();
    }

    public static void doReturn(Code code, Class<?> type) throws Exception {
        switch (ProxyMaker.getType(type)) {
            case 10: {
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                code.ireturn();
                break;
            }
            case 4: {
                code.lreturn();
                break;
            }
            case 5: {
                code.freturn();
                break;
            }
            case 6: {
                code.dreturn();
                break;
            }
            case 8: {
                code.return_();
                break;
            }
            default: {
                code.areturn();
            }
        }
    }

    public static void doNullReturn(Code code, Class<?> type) throws Exception {
        switch (ProxyMaker.getType(type)) {
            case 10: {
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                code.iconst_0();
                code.ireturn();
                break;
            }
            case 4: {
                code.lconst_0();
                code.lreturn();
                break;
            }
            case 5: {
                code.fconst_0();
                code.freturn();
                break;
            }
            case 6: {
                code.dconst_0();
                code.dreturn();
                break;
            }
            case 8: {
                code.return_();
                break;
            }
            default: {
                code.aconst_null();
                code.areturn();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void callSuper(Code code, String name, String superclass, Class<?>[] parameters, Class<?> ret, String sig) throws Exception {
        void local_index;
        code.aload(0);
        boolean bl = false;
        int i = 1;
        while (local_index < parameters.length) {
            switch (ProxyMaker.getType(parameters[local_index])) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 7: {
                    code.iload(i);
                    ++i;
                    break;
                }
                case 4: {
                    code.lload(i);
                    i += 2;
                    break;
                }
                case 5: {
                    code.fload(i);
                    ++i;
                    break;
                }
                case 6: {
                    code.dload(i);
                    i += 2;
                    break;
                }
                default: {
                    code.aload(i);
                    ++i;
                }
            }
            ++local_index;
        }
        code.invokespecial(superclass, name, sig);
        ProxyMaker.doReturn(code, ret);
    }

    public void doJavaCall(Code code, String name, String type, String jcallName) throws Exception {
        code.invokevirtual("org/python/core/PyObject", jcallName, "([Ljava/lang/Object;)Lorg/python/core/PyObject;");
        code.invokestatic("org/python/core/Py", "py2" + name, "(Lorg/python/core/PyObject;)" + type);
    }

    /*
     * WARNING - void declaration
     */
    public void getArgs(Code code, Class<?>[] parameters) throws Exception {
        if (parameters.length == 0) {
            code.getstatic("org/python/core/Py", "EmptyObjects", "[Lorg/python/core/PyObject;");
        } else {
            void local_index;
            code.iconst(parameters.length);
            code.anewarray("java/lang/Object");
            int array = code.getLocal("[org/python/core/PyObject");
            code.astore(array);
            boolean bl = false;
            int i = 1;
            while (local_index < parameters.length) {
                code.aload(array);
                code.iconst((int)local_index);
                switch (ProxyMaker.getType(parameters[local_index])) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        code.iload(i);
                        ++i;
                        code.invokestatic("org/python/core/Py", "newInteger", "(I)Lorg/python/core/PyInteger;");
                        break;
                    }
                    case 4: {
                        code.lload(i);
                        i += 2;
                        code.invokestatic("org/python/core/Py", "newInteger", "(J)Lorg/python/core/PyObject;");
                        break;
                    }
                    case 5: {
                        code.fload(i);
                        ++i;
                        code.invokestatic("org/python/core/Py", "newFloat", "(F)Lorg/python/core/PyFloat;");
                        break;
                    }
                    case 6: {
                        code.dload(i);
                        i += 2;
                        code.invokestatic("org/python/core/Py", "newFloat", "(D)Lorg/python/core/PyFloat;");
                        break;
                    }
                    case 7: {
                        code.iload(i);
                        ++i;
                        code.invokestatic("org/python/core/Py", "newString", "(C)Lorg/python/core/PyString;");
                        break;
                    }
                    default: {
                        code.aload(i);
                        ++i;
                    }
                }
                code.aastore();
                ++local_index;
            }
            code.aload(array);
        }
    }

    public void callMethod(Code code, String name, Class<?>[] parameters, Class<?> ret, Class<?>[] exceptions2) throws Exception {
        Label start = null;
        Label end = null;
        String jcallName = "_jcall";
        int instLocal = 0;
        if (exceptions2.length > 0) {
            start = new Label();
            end = new Label();
            jcallName = "_jcallexc";
            instLocal = code.getLocal("org/python/core/PyObject");
            code.astore(instLocal);
            code.label(start);
            code.aload(instLocal);
        }
        this.getArgs(code, parameters);
        switch (ProxyMaker.getType(ret)) {
            case 7: {
                this.doJavaCall(code, "char", "C", jcallName);
                break;
            }
            case 0: {
                this.doJavaCall(code, "boolean", "Z", jcallName);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                this.doJavaCall(code, "int", "I", jcallName);
                break;
            }
            case 4: {
                this.doJavaCall(code, "long", "J", jcallName);
                break;
            }
            case 5: {
                this.doJavaCall(code, "float", "F", jcallName);
                break;
            }
            case 6: {
                this.doJavaCall(code, "double", "D", jcallName);
                break;
            }
            case 8: {
                this.doJavaCall(code, "void", "V", jcallName);
                break;
            }
            default: {
                code.invokevirtual("org/python/core/PyObject", jcallName, "([Ljava/lang/Object;)Lorg/python/core/PyObject;");
                code.ldc(ret.getName());
                code.invokestatic("java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
                code.invokestatic("org/python/core/Py", "tojava", "(Lorg/python/core/PyObject;Ljava/lang/Class;)Ljava/lang/Object;");
                code.checkcast(ProxyMaker.mapClass(ret));
            }
        }
        if (end != null) {
            code.label(end);
        }
        ProxyMaker.doReturn(code, ret);
        if (exceptions2.length > 0) {
            boolean throwableFound = false;
            Label handlerStart = null;
            for (Class<?> exception : exceptions2) {
                handlerStart = new Label();
                code.label(handlerStart);
                int excLocal = code.getLocal("java/lang/Throwable");
                code.astore(excLocal);
                code.aload(excLocal);
                code.athrow();
                code.visitTryCatchBlock(start, end, handlerStart, ProxyMaker.mapClass(exception));
                ProxyMaker.doNullReturn(code, ret);
                code.freeLocal(excLocal);
                if (exception != Throwable.class) continue;
                throwableFound = true;
            }
            if (!throwableFound) {
                handlerStart = new Label();
                code.label(handlerStart);
                int excLocal = code.getLocal("java/lang/Throwable");
                code.astore(excLocal);
                code.aload(instLocal);
                code.aload(excLocal);
                code.invokevirtual("org/python/core/PyObject", "_jthrow", "(Ljava/lang/Throwable;)V");
                code.visitTryCatchBlock(start, end, handlerStart, "java/lang/Throwable");
                code.freeLocal(excLocal);
                ProxyMaker.doNullReturn(code, ret);
            }
            code.freeLocal(instLocal);
        }
    }

    public void addMethod(Method method, int access) throws Exception {
        boolean isAbstract = false;
        if (Modifier.isAbstract(access)) {
            access &= 0xFFFFFBFF;
            isAbstract = true;
        }
        Class<?>[] parameters = method.getParameterTypes();
        Class<?> ret = method.getReturnType();
        String sig = ProxyMaker.makeSignature(parameters, ret);
        String name = method.getName();
        this.names.add(name);
        Code code = this.classfile.addMethod(name, sig, access);
        code.aload(0);
        code.ldc(name);
        if (!isAbstract) {
            int tmp = code.getLocal("org/python/core/PyObject");
            code.invokestatic("org/python/compiler/ProxyMaker", "findPython", "(Lorg/python/core/PyProxy;Ljava/lang/String;)Lorg/python/core/PyObject;");
            code.astore(tmp);
            code.aload(tmp);
            Label callPython = new Label();
            code.ifnonnull(callPython);
            String superClass = ProxyMaker.mapClass(method.getDeclaringClass());
            this.callSuper(code, name, superClass, parameters, ret, sig);
            code.label(callPython);
            code.aload(tmp);
            this.callMethod(code, name, parameters, ret, method.getExceptionTypes());
            this.addSuperMethod("super__" + name, name, superClass, parameters, ret, sig, access);
        } else {
            code.invokestatic("org/python/compiler/ProxyMaker", "findPython", "(Lorg/python/core/PyProxy;Ljava/lang/String;)Lorg/python/core/PyObject;");
            code.dup();
            Label returnNull = new Label();
            code.ifnull(returnNull);
            this.callMethod(code, name, parameters, ret, method.getExceptionTypes());
            code.label(returnNull);
            code.pop();
            ProxyMaker.doNullReturn(code, ret);
        }
    }

    private String methodString(Method m) {
        Class<?>[] params;
        StringBuffer buf = new StringBuffer(m.getName());
        buf.append(":");
        for (Class<?> param : params = m.getParameterTypes()) {
            buf.append(param.getName());
            buf.append(",");
        }
        return buf.toString();
    }

    protected void addMethods(Class<?> c, Set<String> t) throws Exception {
        Class<?>[] ifaces;
        Method[] methods;
        for (Method method : methods = c.getDeclaredMethods()) {
            String s = this.methodString(method);
            if (t.contains(s)) continue;
            t.add(s);
            int access = method.getModifiers();
            if (Modifier.isStatic(access) || Modifier.isPrivate(access)) continue;
            if (Modifier.isNative(access)) {
                access &= 0xFFFFFEFF;
            }
            if (Modifier.isProtected(access)) {
                if (Modifier.isFinal(access = access & 0xFFFFFFFB | 1)) {
                    this.addSuperMethod(method, access);
                    continue;
                }
            } else if (Modifier.isFinal(access)) continue;
            this.addMethod(method, access);
        }
        Class<?> sc = c.getSuperclass();
        if (sc != null) {
            this.addMethods(sc, t);
        }
        for (Class<?> iface : ifaces = c.getInterfaces()) {
            this.addMethods(iface, t);
        }
    }

    public void addConstructor(String name, Class<?>[] parameters, Class<?> ret, String sig, int access) throws Exception {
        Code code = this.classfile.addMethod("<init>", sig, access);
        this.callSuper(code, "<init>", name, parameters, Void.TYPE, sig);
    }

    public void addConstructors(Class<?> c) throws Exception {
        Constructor<?>[] constructors = c.getDeclaredConstructors();
        String name = ProxyMaker.mapClass(c);
        for (Constructor<?> constructor : constructors) {
            int access = constructor.getModifiers();
            if (Modifier.isPrivate(access)) continue;
            if (Modifier.isNative(access)) {
                access &= 0xFFFFFEFF;
            }
            if (Modifier.isProtected(access)) {
                access = access & 0xFFFFFFFB | 1;
            }
            Class<?>[] parameters = constructor.getParameterTypes();
            String sig = ProxyMaker.makeSignature(parameters, Void.TYPE);
            this.addConstructor(name, parameters, Void.TYPE, sig, access);
        }
    }

    public void addSuperMethod(Method method, int access) throws Exception {
        String superName;
        Class<?>[] parameters = method.getParameterTypes();
        Class<?> ret = method.getReturnType();
        String sig = ProxyMaker.makeSignature(parameters, ret);
        String superClass = ProxyMaker.mapClass(method.getDeclaringClass());
        String methodName = superName = method.getName();
        if (Modifier.isFinal(access)) {
            methodName = "super__" + superName;
            access &= 0xFFFFFFEF;
        }
        this.addSuperMethod(methodName, superName, superClass, parameters, ret, sig, access);
    }

    public void addSuperMethod(String methodName, String superName, String declClass, Class<?>[] parameters, Class<?> ret, String sig, int access) throws Exception {
        if (methodName.startsWith("super__")) {
            try {
                this.superclass.getMethod(methodName, parameters);
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException e) {
                return;
            }
        }
        this.supernames.add(methodName);
        Code code = this.classfile.addMethod(methodName, sig, access);
        this.callSuper(code, superName, declClass, parameters, ret, sig);
    }

    public void addProxy() throws Exception {
        this.classfile.addField("__proxy", "Lorg/python/core/PyObject;", 4);
        Code code = this.classfile.addMethod("_setPyInstance", "(Lorg/python/core/PyObject;)V", 1);
        code.aload(0);
        code.aload(1);
        code.putfield(this.classfile.name, "__proxy", "Lorg/python/core/PyObject;");
        code.return_();
        code = this.classfile.addMethod("_getPyInstance", "()Lorg/python/core/PyObject;", 1);
        code.aload(0);
        code.getfield(this.classfile.name, "__proxy", "Lorg/python/core/PyObject;");
        code.areturn();
        this.classfile.addField("__systemState", "Lorg/python/core/PySystemState;", 132);
        code = this.classfile.addMethod("_setPySystemState", "(Lorg/python/core/PySystemState;)V", 1);
        code.aload(0);
        code.aload(1);
        code.putfield(this.classfile.name, "__systemState", "Lorg/python/core/PySystemState;");
        code.return_();
        code = this.classfile.addMethod("_getPySystemState", "()Lorg/python/core/PySystemState;", 1);
        code.aload(0);
        code.getfield(this.classfile.name, "__systemState", "Lorg/python/core/PySystemState;");
        code.areturn();
    }

    public void addClassDictInit() throws Exception {
        this.classfile.addInterface(ProxyMaker.mapClass(ClassDictInit.class));
        Code code = this.classfile.addMethod("classDictInit", "(Lorg/python/core/PyObject;)V", 9);
        code.aload(0);
        code.ldc("__supernames__");
        int strArray = CodeCompiler.makeStrings(code, this.supernames);
        code.aload(strArray);
        code.freeLocal(strArray);
        code.invokestatic("org/python/core/Py", "java2py", "(Ljava/lang/Object;)Lorg/python/core/PyObject;");
        code.invokevirtual("org/python/core/PyObject", "__setitem__", "(Ljava/lang/String;Lorg/python/core/PyObject;)V");
        code.return_();
    }

    public void build() throws Exception {
        this.names = Generic.set();
        int access = this.superclass.getModifiers();
        if ((access & 0x10) != 0) {
            throw new InstantiationException("can't subclass final class");
        }
        access = 33;
        this.classfile = new ClassFile(this.myClass, ProxyMaker.mapClass(this.superclass), access);
        this.addProxy();
        this.addConstructors(this.superclass);
        this.classfile.addInterface("org/python/core/PyProxy");
        Set<String> seenmethods = Generic.set();
        this.addMethods(this.superclass, seenmethods);
        for (Class<?> iface : this.interfaces) {
            if (iface.isAssignableFrom(this.superclass)) {
                Py.writeWarning("compiler", "discarding redundant interface: " + iface.getName());
                continue;
            }
            this.classfile.addInterface(ProxyMaker.mapClass(iface));
            this.addMethods(iface, seenmethods);
        }
        this.doConstants();
        this.addClassDictInit();
    }

    public static File makeFilename(String name, File dir) {
        int index = name.indexOf(".");
        if (index == -1) {
            return new File(dir, name + ".class");
        }
        return ProxyMaker.makeFilename(name.substring(index + 1, name.length()), new File(dir, name.substring(0, index)));
    }

    public static OutputStream getFile(String d, String name) throws IOException {
        File dir = new File(d);
        File file = ProxyMaker.makeFilename(name, dir);
        file.getParentFile().mkdirs();
        return new FileOutputStream(file);
    }
}

