/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import junit.framework.TestCase;
import org.python.core.BufferProtocol;
import org.python.core.Py;
import org.python.core.PyBuffer;
import org.python.core.PyByteArray;
import org.python.core.PyException;
import org.python.core.PyString;
import org.python.core.buffer.BaseBuffer;
import org.python.core.buffer.SimpleBuffer;
import org.python.core.buffer.SimpleStringBuffer;
import org.python.core.buffer.SimpleWritableBuffer;
import org.python.util.PythonInterpreter;

public class PyBufferTest
extends TestCase {
    protected int verbosity = 0;
    PythonInterpreter interp;
    private static final ByteMaterial byteMaterial = new ByteMaterial(0, 16, 17);
    private static final ByteMaterial abcMaterial = new ByteMaterial("abcdefgh");
    private static final ByteMaterial stringMaterial = new ByteMaterial("Mon c\u00f4t\u00e9 f\u00e2cheux");
    private static final ByteMaterial emptyMaterial = new ByteMaterial(new byte[0]);
    public static final int LONG = 1000;
    private static final ByteMaterial longMaterial = new ByteMaterial(0, 1000, 5);
    private static final int[] sliceLengths = new int[]{1, 2, 5, 0, 250};
    private static final int[] sliceSteps = new int[]{1, 2, 3, 7};
    private List<BufferTestPair> buffersToRead = new LinkedList<BufferTestPair>();
    private List<BufferTestPair> buffersToWrite = new LinkedList<BufferTestPair>();
    private List<BufferTestPair> buffersToFailToWrite = new LinkedList<BufferTestPair>();
    private static final int[] simpleFlags = new int[]{0, 8, 24, 280, 284};
    private static final int[] simpleTassles = new int[]{0, 4, 56, 88, 152};
    private static final int[] strided1DFlags = new int[]{24, 280, 284};
    private static final int[] strided1DTassles = new int[]{0, 4};
    private static final String[] validOrders = new String[]{"C-contiguous test fail", "F-contiguous test fail", "Any-contiguous test fail"};

    public PyBufferTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.interp = new PythonInterpreter();
        this.genWritable(new SimpleWritableExporter(abcMaterial.getBytes()), abcMaterial);
        this.genReadonly(new SimpleExporter(byteMaterial.getBytes()), byteMaterial);
        this.genReadonly(new StringExporter(PyBufferTest.stringMaterial.string), stringMaterial);
        this.genWritable(new SimpleWritableExporter(emptyMaterial.getBytes()), emptyMaterial);
        this.genWritable(new PyByteArray(abcMaterial.getBytes()), abcMaterial);
        this.genWritable(new PyByteArray(longMaterial.getBytes()), longMaterial);
        this.genWritable(new PyByteArray(), emptyMaterial);
        this.genReadonly(new PyString(PyBufferTest.abcMaterial.string), abcMaterial);
        this.genReadonly(new PyString(), emptyMaterial);
        PyByteArray truncated = new PyByteArray(stringMaterial.getBytes());
        truncated.delRange(0, 4);
        ByteMaterial truncatedMaterial = new ByteMaterial(PyBufferTest.stringMaterial.string.substring(4));
        assert (truncated.__alloc__() > truncatedMaterial.length);
        this.genWritable(truncated, truncatedMaterial);
    }

    private void genWritable(BufferProtocol exporter, ByteMaterial material) {
        this.generate(exporter, material, false);
    }

    private void genReadonly(BufferProtocol exporter, ByteMaterial material) {
        this.generate(exporter, material, true);
    }

    private void generate(BufferProtocol exporter, ByteMaterial material, boolean readonly) {
        PyBuffer direct = this.queue(exporter, material, readonly);
        int N = material.length;
        int M = (N + 4) / 4;
        for (int start = 0; start <= N; start += M) {
            for (int length : sliceLengths) {
                if (length == 0) {
                    this.queue(direct, material, start, 0, 1, readonly);
                    this.queue(direct, material, start, 0, 2, readonly);
                    continue;
                }
                if (length == 1 && start < N) {
                    this.queue(direct, material, start, 1, 1, readonly);
                    this.queue(direct, material, start, 1, 2, readonly);
                    continue;
                }
                if (start >= N) continue;
                for (int step : sliceSteps) {
                    if (start + (length - 1) * step >= N) continue;
                    this.queue(direct, material, start, length, step, readonly);
                }
                for (int step : sliceSteps) {
                    if (start - (length - 1) * step < 0) continue;
                    this.queue(direct, material, start, length, -step, readonly);
                }
            }
        }
    }

    private PyBuffer queue(BufferProtocol exporter, ByteMaterial material, boolean readonly) {
        if (this.verbosity > 2) {
            System.out.printf("queue non-slice: length=%d, readonly=%s\n", material.length, readonly);
        }
        BufferTestPair pair = new BufferTestPair(exporter, material, readonly);
        this.queue(pair);
        return pair.view;
    }

    private PyBuffer queue(PyBuffer direct, ByteMaterial material, int start, int length, int step, boolean readonly) {
        PyBuffer subject;
        block3: {
            int flags = readonly ? 284 : 285;
            subject = null;
            try {
                if (this.verbosity > 2) {
                    System.out.printf("  queue slice: start=%4d, length=%4d, step=%4d\n", start, length, step);
                }
                subject = direct.getBufferSlice(flags, start, length, step);
                ByteMaterial sliceMaterial = material.slice(start, length, step);
                BufferTestPair pair = new BufferTestPair(subject, sliceMaterial, step, readonly);
                this.queue(pair);
            }
            catch (Exception e) {
                if (this.verbosity <= 2) break block3;
                System.out.printf("*** SKIP %s\n", e);
            }
        }
        return subject;
    }

    private void queue(BufferTestPair pair) {
        this.buffersToRead.add(pair);
        if (pair.readonly) {
            this.buffersToFailToWrite.add(pair);
        } else {
            this.buffersToWrite.add(pair);
        }
    }

    public void testIsReadonly() {
        for (BufferTestPair test : this.buffersToWrite) {
            if (this.verbosity > 0) {
                System.out.println("isReadonly: " + test);
            }
            PyBufferTest.assertFalse((boolean)test.view.isReadonly());
        }
        for (BufferTestPair test : this.buffersToFailToWrite) {
            if (this.verbosity > 0) {
                System.out.println("isReadonly: " + test);
            }
            PyBufferTest.assertTrue((boolean)test.view.isReadonly());
        }
    }

    public void testGetNdim() {
        for (BufferTestPair test : this.buffersToRead) {
            if (this.verbosity > 0) {
                System.out.println("getNdim: " + test);
            }
            PyBufferTest.assertEquals((String)"unexpected ndim", (int)test.shape.length, (int)test.view.getNdim());
        }
    }

    public void testGetShape() {
        for (BufferTestPair test : this.buffersToRead) {
            if (this.verbosity > 0) {
                System.out.println("getShape: " + test);
            }
            int[] shape = test.view.getShape();
            PyBufferTest.assertNotNull((String)"shape[] should always be provided", (Object)shape);
            PyBufferTest.assertIntsEqual("unexpected shape", test.shape, shape);
        }
    }

    public void testGetLen() {
        for (BufferTestPair test : this.buffersToRead) {
            if (this.verbosity > 0) {
                System.out.println("getLen: " + test);
            }
            PyBufferTest.assertEquals((String)"unexpected length", (int)test.material.length, (int)test.view.getLen());
        }
    }

    public void testByteAt() {
        for (BufferTestPair test : this.buffersToRead) {
            if (this.verbosity > 0) {
                System.out.println("byteAt: " + test);
            }
            int n = test.material.length;
            byte[] exp = test.material.bytes;
            for (int i = 0; i < n; ++i) {
                PyBufferTest.assertEquals((byte)exp[i], (byte)test.view.byteAt(i));
            }
        }
    }

    public void testByteAtNdim() {
        int[] index = new int[1];
        for (BufferTestPair test : this.buffersToRead) {
            if (this.verbosity > 0) {
                System.out.println("byteAt(array): " + test);
            }
            if (test.view.getShape().length != 1) {
                PyBufferTest.fail((String)"Test not implemented if dimensions != 1");
            }
            byte[] exp = test.material.bytes;
            int n = test.material.length;
            for (int i = 0; i < n; ++i) {
                index[0] = i;
                PyBufferTest.assertEquals((byte)exp[i], (byte)test.view.byteAt(index));
            }
            try {
                test.view.byteAt(0, 0);
                PyBufferTest.fail((String)"Use of 2D index did not raise exception");
            }
            catch (PyException pye) {
                PyBufferTest.assertEquals((Object)Py.BufferError, (Object)pye.type);
            }
        }
    }

    public void testIntAt() {
        for (BufferTestPair test : this.buffersToRead) {
            if (this.verbosity > 0) {
                System.out.println("intAt: " + test);
            }
            int n = test.material.length;
            int[] exp = test.material.ints;
            for (int i = 0; i < n; ++i) {
                PyBufferTest.assertEquals((int)exp[i], (int)test.view.intAt(i));
            }
        }
    }

    public void testIntAtNdim() {
        int[] index = new int[1];
        for (BufferTestPair test : this.buffersToRead) {
            if (this.verbosity > 0) {
                System.out.println("intAt(array): " + test);
            }
            if (test.view.getShape().length != 1) {
                PyBufferTest.fail((String)"Test not implemented for dimensions != 1");
            }
            int[] exp = test.material.ints;
            int n = test.material.length;
            for (int i = 0; i < n; ++i) {
                index[0] = i;
                PyBufferTest.assertEquals((int)exp[i], (int)test.view.intAt(index));
            }
            try {
                test.view.intAt(0, 0);
                PyBufferTest.fail((String)"Use of 2D index did not raise exception");
            }
            catch (PyException pye) {
                PyBufferTest.assertEquals((Object)Py.BufferError, (Object)pye.type);
            }
        }
    }

    public void testStoreAt() {
        for (BufferTestPair test : this.buffersToWrite) {
            int i;
            if (this.verbosity > 0) {
                System.out.println("storeAt: " + test);
            }
            int n = test.material.length;
            int[] exp = test.material.ints;
            for (i = 0; i < n; ++i) {
                byte v = (byte)(exp[i] ^ 3);
                test.view.storeAt(v, i);
            }
            for (i = 0; i < n; ++i) {
                PyBufferTest.assertEquals((int)(exp[i] ^ 3), (int)test.view.intAt(i));
            }
        }
    }

    public void testStoreAtNdim() {
        for (BufferTestPair test : this.buffersToWrite) {
            int i;
            if (this.verbosity > 0) {
                System.out.println("storeAt: " + test);
            }
            int n = test.material.length;
            int[] exp = test.material.ints;
            for (i = 0; i < n; ++i) {
                byte v = (byte)(exp[i] ^ 3);
                test.view.storeAt(v, i);
            }
            for (i = 0; i < n; ++i) {
                PyBufferTest.assertEquals((int)(exp[i] ^ 3), (int)test.view.intAt(i));
            }
            try {
                test.view.storeAt((byte)1, 0, 0);
                PyBufferTest.fail((String)"Use of 2D index did not raise exception");
            }
            catch (PyException pye) {
                PyBufferTest.assertEquals((Object)Py.BufferError, (Object)pye.type);
            }
        }
    }

    public void testCopyTo() {
        int OFFSET = 5;
        for (BufferTestPair test : this.buffersToRead) {
            if (this.verbosity > 0) {
                System.out.println("copyTo: " + test);
            }
            int n = test.material.length;
            byte[] actual = new byte[n];
            test.view.copyTo(actual, 0);
            PyBufferTest.assertBytesEqual("copyTo() incorrect", test.material.bytes, actual, 0);
            actual = new byte[n + 10];
            test.view.copyTo(actual, 5);
            PyBufferTest.assertBytesEqual("copyTo(offset) incorrect", test.material.bytes, actual, 5);
            PyBufferTest.assertEquals((String)"data before destination", (int)0, (int)actual[4]);
            PyBufferTest.assertEquals((String)"data after destination", (int)0, (int)actual[5 + n]);
        }
    }

    public void testSliceCopyTo() {
        int OFFSET = 5;
        int BLANK = 7;
        for (BufferTestPair test : this.buffersToRead) {
            if (this.verbosity > 0) {
                System.out.println("copyTo(from slice): " + test);
            }
            PyBuffer view = test.view;
            int n = test.material.length;
            byte[] actual = new byte[n + 10];
            for (int destPos = 0; destPos <= 5; destPos += 5) {
                for (int srcIndex = 0; srcIndex <= 5; srcIndex += 5) {
                    int length = 0;
                    while (srcIndex + length <= n) {
                        if (this.verbosity > 1) {
                            System.out.printf("  copy src[%d:%d] (%d) to dst[%d:%d] (%d)\n", srcIndex, srcIndex + length, n, destPos, destPos + length, actual.length);
                        }
                        Arrays.fill(actual, (byte)7);
                        view.copyTo(srcIndex, actual, destPos, length);
                        PyBufferTest.assertBytesEqual("copyTo(slice) incorrect", test.material.bytes, srcIndex, length, actual, destPos);
                        if (destPos > 0) {
                            PyBufferTest.assertEquals((String)"data before destination", (byte)7, (byte)actual[destPos - 1]);
                        }
                        PyBufferTest.assertEquals((String)"data after destination", (byte)7, (byte)actual[destPos + length]);
                        length = 2 * length + 1;
                    }
                    int trim = 0;
                    while (srcIndex + trim <= n) {
                        int length2 = n - srcIndex - trim;
                        if (this.verbosity > 1) {
                            System.out.printf("  copy src[%d:%d] (%d) to dst[%d:%d] (%d)\n", srcIndex, srcIndex + length2, n, destPos, destPos + length2, actual.length);
                        }
                        Arrays.fill(actual, (byte)7);
                        view.copyTo(srcIndex, actual, destPos, length2);
                        PyBufferTest.assertBytesEqual("copyTo(slice) incorrect", test.material.bytes, srcIndex, length2, actual, destPos);
                        if (destPos > 0) {
                            PyBufferTest.assertEquals((String)"data before destination", (byte)7, (byte)actual[destPos - 1]);
                        }
                        PyBufferTest.assertEquals((String)"data after destination", (byte)7, (byte)actual[destPos + length2]);
                        trim = 2 * trim + 1;
                    }
                }
            }
        }
    }

    public void testCopyFrom() {
        int OFFSET = 5;
        int BLANK = 7;
        for (BufferTestPair test : this.buffersToWrite) {
            if (this.verbosity > 0) {
                System.out.println("copyFrom(): " + test);
            }
            PyBuffer view = test.view;
            int n = test.material.length;
            byte[] actual = new byte[n];
            byte[] expected = new byte[n];
            byte[] src = new byte[n + 5];
            for (int i = 0; i < src.length; ++i) {
                src[i] = (byte)i;
            }
            for (int destIndex = 0; destIndex <= 5; destIndex += 5) {
                for (int srcPos = 0; srcPos <= 5; srcPos += 5) {
                    int length = 0;
                    while (destIndex + length <= n) {
                        int i;
                        if (this.verbosity > 1) {
                            System.out.printf("  copy src[%d:%d] (%d) to dst[%d:%d] (%d)\n", srcPos, srcPos + length, n, destIndex, destIndex + length, actual.length);
                        }
                        for (i = 0; i < n; ++i) {
                            expected[i] = 7;
                            view.storeAt((byte)7, i);
                        }
                        view.copyFrom(src, srcPos, destIndex, length);
                        view.copyTo(actual, 0);
                        for (i = 0; i < length; ++i) {
                            expected[destIndex + i] = src[srcPos + i];
                        }
                        PyBufferTest.assertBytesEqual("copyFrom() incorrect", expected, actual, 0);
                        length = 2 * length + 1;
                    }
                    int trim = 0;
                    while (destIndex + trim <= n) {
                        int i;
                        int length2 = n - destIndex - trim;
                        if (this.verbosity > 1) {
                            System.out.printf("  copy src[%d:%d] (%d) to dst[%d:%d] (%d)\n", srcPos, srcPos + length2, n, destIndex, destIndex + length2, actual.length);
                        }
                        for (i = 0; i < n; ++i) {
                            expected[i] = 7;
                            view.storeAt((byte)7, i);
                        }
                        view.copyFrom(src, srcPos, destIndex, length2);
                        view.copyTo(actual, 0);
                        for (i = 0; i < length2; ++i) {
                            expected[destIndex + i] = src[srcPos + i];
                        }
                        PyBufferTest.assertBytesEqual("copyFrom() incorrect", expected, actual, 0);
                        trim = 2 * trim + 1;
                    }
                }
            }
        }
    }

    public void testGetBuffer() {
        PyBuffer view;
        for (BufferTestPair test : this.buffersToRead) {
            if (this.verbosity > 0) {
                System.out.println("getBuffer(): " + test);
            }
            for (int flags : test.validFlags) {
                for (int tassle : test.validTassles) {
                    view = test.subject.getBuffer(flags | tassle);
                    PyBufferTest.assertNotNull((Object)view);
                }
            }
        }
        for (BufferTestPair test : this.buffersToWrite) {
            if (this.verbosity > 0) {
                System.out.println("getBuffer(WRITABLE): " + test);
            }
            for (int flags : test.validFlags) {
                for (int tassle : test.validTassles) {
                    view = test.subject.getBuffer(flags | tassle | 1);
                    PyBufferTest.assertNotNull((Object)view);
                }
            }
        }
        for (BufferTestPair test : this.buffersToFailToWrite) {
            if (this.verbosity > 0) {
                System.out.println("getBuffer(WRITABLE): " + test);
            }
            for (int flags : test.validFlags) {
                try {
                    test.subject.getBuffer(flags | 1);
                    PyBufferTest.fail((String)("Write access not prevented: " + test));
                }
                catch (PyException pye) {
                    PyBufferTest.assertEquals((Object)Py.BufferError, (Object)pye.type);
                }
            }
        }
    }

    public void testRelease() {
        HashSet<PyBuffer> uniqueBuffers = new HashSet<PyBuffer>();
        for (BufferTestPair test : this.buffersToRead) {
            this.doTestRelease(test);
            uniqueBuffers.add(test.view);
        }
        for (PyBuffer view : uniqueBuffers) {
            this.doTestOverRelease(view);
        }
        for (BufferTestPair test : this.buffersToRead) {
            if (test.subject instanceof PyBuffer) continue;
            this.doTestGetAfterRelease(test);
        }
    }

    private void doTestRelease(BufferTestPair test) {
        if (this.verbosity > 0) {
            System.out.println("release: " + test);
        }
        int flags = 28;
        BufferProtocol sub = test.subject;
        PyBuffer a = test.view;
        PyBuffer b = sub.getBuffer(284);
        PyBuffer c = sub.getBuffer(flags);
        this.checkExporting(sub);
        b.release();
        a.release();
        this.checkExporting(sub);
        PyBuffer d = c.getBuffer(flags);
        c.release();
        this.checkExporting(sub);
        d.release();
    }

    private void doTestOverRelease(PyBuffer view) {
        PyBufferTest.assertTrue((String)"Buffer not finally released as expected", (boolean)view.isReleased());
        try {
            view.release();
            PyBufferTest.fail((String)"excess release not detected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void doTestGetAfterRelease(BufferTestPair test) {
        if (this.verbosity > 0) {
            System.out.println("get again: " + test);
        }
        BufferProtocol sub = test.subject;
        this.checkNotExporting(sub);
        try {
            test.view.getBuffer(284);
            PyBufferTest.fail((String)"PyBuffer.getBuffer after final release not detected");
        }
        catch (Exception e) {
            this.checkNotExporting(sub);
        }
        try {
            test.view.getBufferSlice(284, 0, 0);
            PyBufferTest.fail((String)"PyBuffer.getBufferSlice after final release not detected");
        }
        catch (Exception e) {
            this.checkNotExporting(sub);
        }
        PyBuffer b = sub.getBuffer(284);
        this.checkExporting(sub);
        b.release();
        this.checkNotExporting(sub);
    }

    private void checkExporting(BufferProtocol subject) {
        if (subject instanceof TestableExporter) {
            PyBufferTest.assertTrue((String)"exports not being counted", (boolean)((TestableExporter)subject).isExporting());
        } else if (subject instanceof PyBuffer) {
            PyBufferTest.assertFalse((String)"exports not being counted (PyBuffer)", (boolean)((PyBuffer)subject).isReleased());
        } else if (subject instanceof PyByteArray) {
            try {
                ((PyByteArray)subject).bytearray_extend(Py.One);
                PyBufferTest.fail((String)"bytearray_extend with exports should fail");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void checkNotExporting(BufferProtocol subject) {
        if (subject instanceof TestableExporter) {
            PyBufferTest.assertFalse((String)"exports counted incorrectly", (boolean)((TestableExporter)subject).isExporting());
        } else if (subject instanceof PyBuffer) {
            PyBufferTest.assertTrue((String)"exports counted incorrectly (PyBuffer)", (boolean)((PyBuffer)subject).isReleased());
        } else if (subject instanceof PyByteArray) {
            try {
                PyByteArray sub = (PyByteArray)subject;
                sub.bytearray_append(Py.Zero);
                sub.del(sub.__len__() - 1);
            }
            catch (Exception e) {
                PyBufferTest.fail((String)"bytearray unexpectedly locked");
            }
        }
    }

    public void testGetBufferSliceWithStride() {
        for (BufferTestPair test : this.buffersToRead) {
            if (this.verbosity > 0) {
                System.out.println("getBufferSliceWithStride: " + test);
            }
            ByteMaterial material = test.material;
            PyBuffer view = test.view;
            boolean readonly = test.readonly;
            int N = material.length;
            int M = (N + 4) / 4;
            for (int start = 0; start <= N; start += M) {
                for (int length : sliceLengths) {
                    if (length == 0) {
                        this.checkSlice(view, material, start, 0, 1, readonly);
                        this.checkSlice(view, material, start, 0, 2, readonly);
                        continue;
                    }
                    if (length == 1 && start < N) {
                        this.checkSlice(view, material, start, 1, 1, readonly);
                        this.checkSlice(view, material, start, 1, 2, readonly);
                        continue;
                    }
                    if (start >= N) continue;
                    for (int step : sliceSteps) {
                        if (start + (length - 1) * step >= N) continue;
                        this.checkSlice(view, material, start, length, step, readonly);
                    }
                    for (int step : sliceSteps) {
                        if (start - (length - 1) * step < 0) continue;
                        this.checkSlice(view, material, start, length, -step, readonly);
                    }
                }
            }
        }
    }

    private void checkSlice(PyBuffer view, ByteMaterial material, int start, int length, int step, boolean readonly) {
        int flags;
        int n = flags = readonly ? 284 : 285;
        if (this.verbosity > 1) {
            System.out.printf("  checkSlice: start=%4d, length=%4d, step=%4d \n", start, length, step);
        }
        byte[] expected = PyBufferTest.sliceBytes(material.bytes, start, length, step);
        PyBuffer sliceView = view.getBufferSlice(flags, start, length, step);
        byte[] result = PyBufferTest.bytesFromByteAt(sliceView);
        PyBufferTest.assertBytesEqual("  testGetBufferSliceWithStride failure: ", expected, result);
    }

    public void testGetBuf() {
        for (BufferTestPair test : this.buffersToRead) {
            PyBuffer.Pointer bp;
            PyBuffer view;
            int flags;
            int stride;
            if (this.verbosity > 0) {
                System.out.println("getBuf: " + test);
            }
            if ((stride = test.strides[0]) == 1) {
                flags = test.readonly ? 0 : 1;
                view = test.subject.getBuffer(flags);
                bp = view.getBuf();
                PyBufferTest.assertBytesEqual("buffer does not match reference", test.material.bytes, bp);
                continue;
            }
            flags = test.readonly ? 24 : 25;
            view = test.subject.getBuffer(flags);
            stride = view.getStrides()[0];
            bp = view.getBuf();
            PyBufferTest.assertBytesEqual("buffer does not match reference", test.material.bytes, bp, stride);
        }
    }

    public void testGetPointer() {
        for (BufferTestPair test : this.buffersToRead) {
            if (this.verbosity > 0) {
                System.out.println("getPointer: " + test);
            }
            PyBuffer view = test.view;
            int n = test.material.length;
            int itemsize = view.getItemsize();
            byte[] exp = new byte[itemsize];
            byte[] bytes = test.material.bytes;
            for (int i = 0; i < n; ++i) {
                int p = i * itemsize;
                for (int j = 0; j < itemsize; ++j) {
                    exp[j] = bytes[p + j];
                }
                PyBuffer.Pointer bp = view.getPointer(i);
                PyBufferTest.assertBytesEqual("getPointer value", exp, bp);
            }
        }
    }

    public void testGetPointerNdim() {
        int[] index = new int[1];
        for (BufferTestPair test : this.buffersToRead) {
            if (this.verbosity > 0) {
                System.out.println("getPointer(array): " + test);
            }
            PyBuffer view = test.view;
            int n = test.material.length;
            int itemsize = view.getItemsize();
            byte[] exp = new byte[itemsize];
            byte[] bytes = test.material.bytes;
            int i = 0;
            while (i < n) {
                int p = i * itemsize;
                for (int j = 0; j < itemsize; ++j) {
                    exp[j] = bytes[p + j];
                }
                index[0] = i++;
                PyBuffer.Pointer bp = view.getPointer(index);
                PyBufferTest.assertBytesEqual("getPointer value", exp, bp);
            }
            try {
                view.getPointer(0, 0);
                PyBufferTest.fail((String)"Use of 2D index did not raise exception");
            }
            catch (PyException pye) {
                PyBufferTest.assertEquals((Object)Py.BufferError, (Object)pye.type);
            }
        }
    }

    public void testGetStrides() {
        for (BufferTestPair test : this.buffersToRead) {
            if (this.verbosity > 0) {
                System.out.println("getStrides: " + test);
            }
            for (int flags : test.validFlags) {
                PyBuffer view = test.subject.getBuffer(flags);
                int[] strides = view.getStrides();
                PyBufferTest.assertNotNull((String)"strides[] should always be provided", (Object)strides);
                if (test.material.bytes.length <= 1) continue;
                PyBufferTest.assertIntsEqual("unexpected strides", test.strides, strides);
            }
        }
    }

    public void testGetSuboffsets() {
        for (BufferTestPair test : this.buffersToRead) {
            if (this.verbosity > 0) {
                System.out.println("getSuboffsets: " + test);
            }
            PyBufferTest.assertNull((Object)test.view.getSuboffsets());
        }
    }

    public void testIsContiguous() {
        for (BufferTestPair test : this.buffersToRead) {
            if (this.verbosity > 0) {
                System.out.println("isContiguous: " + test);
            }
            for (String orderMsg : validOrders) {
                char order = orderMsg.charAt(0);
                PyBufferTest.assertTrue((String)orderMsg, (boolean)test.view.isContiguous(order));
            }
        }
    }

    public void testGetFormat() {
        for (BufferTestPair test : this.buffersToRead) {
            if (this.verbosity > 0) {
                System.out.println("getFormat: " + test);
            }
            for (int flags : test.validFlags) {
                PyBuffer view = test.subject.getBuffer(flags);
                PyBufferTest.assertNotNull((String)"format should always be provided", (Object)view.getFormat());
                PyBufferTest.assertEquals((String)"B", (String)view.getFormat());
                view = test.subject.getBuffer(flags | 4);
                PyBufferTest.assertEquals((String)"B", (String)view.getFormat());
            }
        }
    }

    public void testGetItemsize() {
        for (BufferTestPair test : this.buffersToRead) {
            if (this.verbosity > 0) {
                System.out.println("getItemsize: " + test);
            }
            PyBufferTest.assertEquals((int)1, (int)test.view.getItemsize());
        }
    }

    public void testToString() {
        for (BufferTestPair test : this.buffersToRead) {
            if (this.verbosity > 0) {
                System.out.println("toString: " + test);
            }
            String r = test.view.toString();
            PyBufferTest.assertEquals((String)"buffer does not match reference", (String)test.material.string, (String)r);
        }
    }

    static byte[] bytesFromByteAt(PyBuffer v) {
        int N = v.getLen();
        byte[] a = new byte[N];
        for (int i = 0; i < N; ++i) {
            a[i] = v.byteAt(i);
        }
        return a;
    }

    static byte[] sliceBytes(byte[] b, int start, int length, int stride) {
        byte[] a = new byte[length];
        int i = 0;
        int j = start;
        while (i < length) {
            a[i] = b[j];
            ++i;
            j += stride;
        }
        return a;
    }

    static void assertBytesEqual(String message, byte[] expected, PyBuffer.Pointer bp) {
        PyBufferTest.assertBytesEqual(message, expected, bp, 1);
    }

    static void assertBytesEqual(String message, byte[] expected, PyBuffer.Pointer bp, int stride) {
        PyBufferTest.assertBytesEqual(message, expected, 0, expected.length, bp.storage, bp.offset, stride);
    }

    static void assertBytesEqual(String message, byte[] expected, int expectedStart, int n, PyBuffer.Pointer bp, int stride) {
        PyBufferTest.assertBytesEqual(message, expected, expectedStart, n, bp.storage, bp.offset, stride);
    }

    static void assertBytesEqual(String message, byte[] expected, byte[] actual) {
        PyBufferTest.assertEquals((String)(message + " (array size)"), (int)expected.length, (int)actual.length);
        PyBufferTest.assertBytesEqual(message, expected, 0, expected.length, actual, 0, 1);
    }

    static void assertBytesEqual(String message, byte[] expected, byte[] actual, int actualStart) {
        PyBufferTest.assertBytesEqual(message, expected, 0, expected.length, actual, actualStart, 1);
    }

    static void assertBytesEqual(String message, byte[] expected, int expectedStart, int n, byte[] actual, int actualStart) {
        PyBufferTest.assertBytesEqual(message, expected, expectedStart, n, actual, actualStart, 1);
    }

    static void assertBytesEqual(String message, byte[] expected, int expectedStart, int n, byte[] actual, int actualStart, int stride) {
        if (actualStart < 0) {
            PyBufferTest.fail((String)(message + " (start<0 in result)"));
        } else if (expectedStart < 0) {
            PyBufferTest.fail((String)(message + " (start<0 in expected result): bug in test?"));
        } else if (actualStart + (n - 1) * stride + 1 > actual.length) {
            PyBufferTest.fail((String)(message + " (result too short)"));
        } else if (expectedStart + n > expected.length) {
            PyBufferTest.fail((String)(message + " (expected result too short): bug in test?"));
        } else {
            int j;
            int i = actualStart;
            int jLimit = expectedStart + n;
            for (j = expectedStart; j < jLimit && actual[i] == expected[j]; ++j) {
                i += stride;
            }
            if (j < jLimit) {
                System.out.println("  expected:" + Arrays.toString(Arrays.copyOfRange(expected, expectedStart, expectedStart + n)));
                System.out.println("    actual:" + Arrays.toString(Arrays.copyOfRange(actual, actualStart, actualStart + n)));
                System.out.println("  _actual_:" + Arrays.toString(actual));
                PyBufferTest.fail((String)(message + " (byte at " + j + ")"));
            }
        }
    }

    static void assertIntsEqual(String message, int[] expected, int[] actual, int offset) {
        int n = expected.length;
        if (offset < 0) {
            PyBufferTest.fail((String)(message + " (offset<0)"));
        } else if (offset + n > actual.length) {
            PyBufferTest.fail((String)(message + " (too short)"));
        } else {
            int j;
            int i = offset;
            for (j = 0; j < n && actual[i++] == expected[j]; ++j) {
            }
            if (j < n) {
                System.out.println("  expected:" + Arrays.toString(expected));
                System.out.println("    actual:" + Arrays.toString(actual));
                PyBufferTest.fail((String)(message + " (int at " + j + ")"));
            }
        }
    }

    static void assertIntsEqual(String message, int[] expected, int[] actual) {
        int j;
        int n = expected.length;
        PyBufferTest.assertEquals((String)message, (int)n, (int)actual.length);
        for (j = 0; j < n && actual[j] == expected[j]; ++j) {
        }
        if (j < n) {
            System.out.println("  expected:" + Arrays.toString(expected));
            System.out.println("    actual:" + Arrays.toString(actual));
            PyBufferTest.fail((String)(message + " (int at " + j + ")"));
        }
    }

    private static class BufferTestPair {
        final BufferProtocol subject;
        final ByteMaterial material;
        final PyBuffer view;
        final boolean readonly;
        final int[] validFlags;
        final int[] validTassles;
        static final int[] STRIDES_1D = new int[]{1};
        int[] shape;
        int[] strides;

        public BufferTestPair(BufferProtocol subject, ByteMaterial material, int[] shape, int[] strides, boolean readonly, int[] validFlags, int[] validTassles) {
            int flags;
            this.subject = subject;
            this.material = new ByteMaterial(material.ints);
            this.shape = shape;
            this.strides = strides;
            this.readonly = readonly;
            this.validFlags = validFlags;
            this.validTassles = validTassles;
            int n = flags = readonly ? 284 : 285;
            if (subject instanceof PyBuffer) {
                this.view = (PyBuffer)subject;
            } else {
                PyBuffer v = null;
                try {
                    v = subject.getBuffer(flags);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.view = v;
            }
        }

        public BufferTestPair(BufferProtocol subject, ByteMaterial material, boolean readonly) {
            this(subject, material, new int[1], STRIDES_1D, readonly, simpleFlags, simpleTassles);
            this.shape[0] = material.length;
        }

        public BufferTestPair(PyBuffer subject, ByteMaterial material, int stride, boolean readonly) {
            this(subject, material, new int[1], new int[1], readonly, strided1DFlags, strided1DTassles);
            this.shape[0] = material.length;
            this.strides[0] = stride;
        }

        public String toString() {
            int offset = this.view.getBuf().offset;
            String offsetSpec = offset > 0 ? "[0@(" + offset + "):" : "[:";
            int stride = this.strides[0];
            String sliceSpec = offsetSpec + this.shape[0] + (stride != 1 ? "*(" + stride + ")]" : "]");
            return this.subject.getClass().getSimpleName() + sliceSpec + " ( " + this.material.toString() + " )";
        }
    }

    protected static class ByteMaterial {
        final String string;
        final byte[] bytes;
        final int[] ints;
        final int length;

        public ByteMaterial(String s) {
            this.string = s;
            this.length = s.length();
            this.bytes = new byte[this.length];
            this.ints = new int[this.length];
            for (int i = 0; i < this.length; ++i) {
                char x = s.charAt(i);
                this.ints[i] = x;
                this.bytes[i] = (byte)x;
            }
        }

        public ByteMaterial(byte[] b) {
            this.length = b.length;
            StringBuilder buf = new StringBuilder(this.length);
            this.bytes = new byte[this.length];
            this.ints = new int[this.length];
            for (int i = 0; i < this.length; ++i) {
                int x;
                this.ints[i] = x = 0xFF & b[i];
                this.bytes[i] = (byte)x;
                buf.appendCodePoint(x);
            }
            this.string = buf.toString();
        }

        public ByteMaterial(int[] a) {
            this.length = a.length;
            StringBuilder buf = new StringBuilder(this.length);
            this.bytes = new byte[this.length];
            this.ints = new int[this.length];
            for (int i = 0; i < this.length; ++i) {
                int x;
                this.ints[i] = x = a[i];
                this.bytes[i] = (byte)x;
                buf.appendCodePoint(x);
            }
            this.string = buf.toString();
        }

        public ByteMaterial(int start, int count2, int inc) {
            this.length = count2;
            StringBuilder buf = new StringBuilder(this.length);
            this.bytes = new byte[this.length];
            this.ints = new int[this.length];
            int x = start;
            for (int i = 0; i < this.length; ++i) {
                this.ints[i] = x;
                this.bytes[i] = (byte)x;
                buf.appendCodePoint(x);
                x = x + inc & 0xFF;
            }
            this.string = buf.toString();
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(100);
            buf.append("byte[").append(this.length).append("]={ ");
            for (int i = 0; i < this.length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                if (i >= 5) {
                    buf.append(" ...");
                    break;
                }
                buf.append(this.ints[i]);
            }
            buf.append(" }");
            return buf.toString();
        }

        byte[] getBytes() {
            return (byte[])this.bytes.clone();
        }

        ByteMaterial slice(int start, int length, int stride) {
            return new ByteMaterial(PyBufferTest.sliceBytes(this.bytes, start, length, stride));
        }
    }

    static class SimpleWritableExporter
    extends TestableExporter {
        protected byte[] storage;

        public SimpleWritableExporter(byte[] storage) {
            this.storage = storage;
        }

        @Override
        public PyBuffer getBuffer(int flags) {
            BaseBuffer pybuf = this.getExistingBuffer(flags);
            if (pybuf == null) {
                pybuf = new SimpleWritableBuffer(flags, this.storage){

                    @Override
                    protected void releaseAction() {
                        SimpleWritableExporter.this.export = null;
                    }
                };
                this.export = new WeakReference<BaseBuffer>(pybuf);
            }
            return pybuf;
        }
    }

    static class StringExporter
    extends TestableExporter {
        String storage;

        public StringExporter(String s) {
            this.storage = s;
        }

        @Override
        public PyBuffer getBuffer(int flags) {
            BaseBuffer pybuf = this.getExistingBuffer(flags);
            if (pybuf == null) {
                pybuf = new SimpleStringBuffer(flags, this.storage);
                this.export = new SoftReference<BaseBuffer>(pybuf);
            }
            return pybuf;
        }
    }

    static abstract class TestableExporter
    implements BufferProtocol {
        protected Reference<BaseBuffer> export;

        TestableExporter() {
        }

        protected BaseBuffer getExistingBuffer(int flags) {
            BaseBuffer pybuf = null;
            if (this.export != null && (pybuf = this.export.get()) != null) {
                pybuf = pybuf.getBufferAgain(flags);
            }
            return pybuf;
        }

        public boolean isExporting() {
            if (this.export != null) {
                PyBuffer pybuf = this.export.get();
                if (pybuf != null) {
                    return !pybuf.isReleased();
                }
                this.export = null;
            }
            return false;
        }
    }

    static class SimpleExporter
    implements BufferProtocol {
        protected byte[] storage;

        public SimpleExporter(byte[] storage) {
            this.storage = storage;
        }

        @Override
        public PyBuffer getBuffer(int flags) {
            return new SimpleBuffer(flags, this.storage);
        }
    }
}

