/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import com.kenai.jffi.CallContext;
import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Function;
import com.kenai.jffi.HeapInvocationBuffer;
import com.kenai.jffi.Invoker;
import com.kenai.jffi.Platform;
import java.nio.Buffer;
import jnr.ffi.Address;
import jnr.ffi.NativeLong;
import jnr.ffi.NativeType;
import jnr.ffi.Pointer;
import jnr.ffi.Struct;
import jnr.ffi.byref.ByReference;
import jnr.ffi.mapper.FromNativeConverter;
import jnr.ffi.mapper.ToNativeConverter;
import jnr.ffi.provider.InvocationSession;
import jnr.ffi.provider.jffi.AsmBuilder;
import jnr.ffi.provider.jffi.AsmRuntime;
import jnr.ffi.provider.jffi.AsmUtil;
import jnr.ffi.provider.jffi.BaseMethodGenerator;
import jnr.ffi.provider.jffi.CodegenUtils;
import jnr.ffi.provider.jffi.LocalVariable;
import jnr.ffi.provider.jffi.LocalVariableAllocator;
import jnr.ffi.provider.jffi.NumberUtil;
import jnr.ffi.provider.jffi.ParameterType;
import jnr.ffi.provider.jffi.ResultType;
import jnr.ffi.provider.jffi.Signature;
import jnr.ffi.provider.jffi.SkinnyMethodAdapter;

final class BufferMethodGenerator
extends BaseMethodGenerator {
    BufferMethodGenerator() {
    }

    void generate(AsmBuilder builder, SkinnyMethodAdapter mv, LocalVariableAllocator localVariableAllocator, Function function, ResultType resultType, ParameterType[] parameterTypes, boolean ignoreError) {
        this.generateBufferInvocation(builder, mv, localVariableAllocator, function, resultType, parameterTypes);
    }

    public boolean isSupported(Signature signature) {
        return true;
    }

    public boolean isSupported(ResultType resultType, ParameterType[] parameterTypes, CallingConvention callingConvention) {
        return true;
    }

    static void emitInvocationBufferNumericParameter(SkinnyMethodAdapter mv, ParameterType parameterType, Class javaParameterType) {
        String paramMethod;
        Class<Number> nativeParamType = Integer.TYPE;
        switch (parameterType.nativeType) {
            case SCHAR: 
            case UCHAR: {
                paramMethod = "putByte";
                break;
            }
            case SSHORT: 
            case USHORT: {
                paramMethod = "putShort";
                break;
            }
            case SINT: 
            case UINT: {
                paramMethod = "putInt";
                break;
            }
            case SLONG: 
            case ULONG: {
                if (NumberUtil.sizeof(parameterType) == 4) {
                    paramMethod = "putInt";
                    nativeParamType = Integer.TYPE;
                    break;
                }
                paramMethod = "putLong";
                nativeParamType = Long.TYPE;
                break;
            }
            case SLONGLONG: 
            case ULONGLONG: {
                paramMethod = "putLong";
                nativeParamType = Long.TYPE;
                break;
            }
            case FLOAT: {
                paramMethod = "putFloat";
                nativeParamType = Float.TYPE;
                break;
            }
            case DOUBLE: {
                paramMethod = "putDouble";
                nativeParamType = Double.TYPE;
                break;
            }
            case ADDRESS: {
                paramMethod = "putAddress";
                nativeParamType = Long.TYPE;
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported parameter type " + parameterType);
            }
        }
        if (!javaParameterType.isPrimitive()) {
            AsmUtil.unboxNumber(mv, javaParameterType, nativeParamType, parameterType.nativeType);
        } else {
            NumberUtil.convertPrimitive(mv, javaParameterType, nativeParamType, parameterType.nativeType);
        }
        mv.invokevirtual(HeapInvocationBuffer.class, paramMethod, Void.TYPE, nativeParamType);
    }

    static boolean isSessionRequired(ParameterType parameterType) {
        Class javaType = parameterType.toNativeConverter != null ? parameterType.toNativeConverter.nativeType() : parameterType.getDeclaredType();
        return StringBuilder.class.isAssignableFrom(javaType) || StringBuffer.class.isAssignableFrom(javaType) || ByReference.class.isAssignableFrom(javaType) || javaType.isArray() && Pointer.class.isAssignableFrom(javaType.getComponentType()) || javaType.isArray() && CharSequence.class.isAssignableFrom(javaType.getComponentType()) || javaType.isArray() && NativeLong.class.isAssignableFrom(javaType.getComponentType()) || javaType.isArray() && NumberUtil.isLong32(javaType.getComponentType(), parameterType.annotations);
    }

    static boolean isSessionRequired(ParameterType[] parameterTypes) {
        for (ParameterType parameterType : parameterTypes) {
            if (!BufferMethodGenerator.isSessionRequired(parameterType)) continue;
            return true;
        }
        return false;
    }

    static void marshal(SkinnyMethodAdapter mv, Class ... parameterTypes) {
        mv.invokestatic(CodegenUtils.p(AsmRuntime.class), "marshal", CodegenUtils.sig(Void.TYPE, CodegenUtils.ci(HeapInvocationBuffer.class), parameterTypes));
    }

    static void sessionmarshal(SkinnyMethodAdapter mv, Class ... parameterTypes) {
        mv.invokestatic(CodegenUtils.p(AsmRuntime.class), "marshal", CodegenUtils.sig(Void.TYPE, CodegenUtils.ci(HeapInvocationBuffer.class) + CodegenUtils.ci(InvocationSession.class), parameterTypes));
    }

    void generateBufferInvocation(AsmBuilder builder, SkinnyMethodAdapter mv, LocalVariableAllocator localVariableAllocator, Function function, ResultType resultType, ParameterType[] parameterTypes) {
        Class<Number> nativeReturnType;
        String invokeMethod;
        Class javaReturnType;
        boolean sessionRequired = BufferMethodGenerator.isSessionRequired(parameterTypes);
        LocalVariable session = localVariableAllocator.allocate(InvocationSession.class);
        if (sessionRequired) {
            mv.newobj(CodegenUtils.p(InvocationSession.class));
            mv.dup();
            mv.invokespecial(InvocationSession.class, "<init>", Void.TYPE, new Class[0]);
            mv.astore(session);
        }
        mv.aload(0);
        mv.getfield(builder.getClassNamePath(), builder.getCallContextFieldName(function), CodegenUtils.ci(CallContext.class));
        mv.invokestatic(AsmRuntime.class, "newHeapInvocationBuffer", HeapInvocationBuffer.class, CallContext.class);
        LocalVariable[] parameters = AsmUtil.getParameterVariables(parameterTypes);
        LocalVariable[] converted = new LocalVariable[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class javaParameterType;
            mv.dup();
            if (BufferMethodGenerator.isSessionRequired(parameterTypes[i])) {
                mv.aload(session);
            }
            BufferMethodGenerator.loadAndConvertParameter(builder, mv, parameters[i], parameterTypes[i]);
            if (parameterTypes[i].toNativeConverter instanceof ToNativeConverter.PostInvocation) {
                mv.dup();
                converted[i] = localVariableAllocator.allocate(Object.class);
                mv.astore(converted[i]);
            }
            int parameterFlags = AsmUtil.getParameterFlags(parameterTypes[i].annotations);
            int nativeArrayFlags = AsmUtil.getNativeArrayFlags(parameterFlags) | ((parameterFlags & 2) != 0 ? 4 : 0);
            ToNativeConverter parameterConverter = parameterTypes[i].toNativeConverter;
            Class clazz = javaParameterType = parameterConverter != null ? parameterConverter.nativeType() : parameterTypes[i].getDeclaredType();
            if (javaParameterType.isArray() && javaParameterType.getComponentType().isPrimitive()) {
                mv.pushInt(nativeArrayFlags);
                if (NumberUtil.isLong32(javaParameterType.getComponentType(), parameterTypes[i].annotations)) {
                    mv.invokestatic(CodegenUtils.p(AsmRuntime.class), "marshal32", CodegenUtils.sig(Void.TYPE, CodegenUtils.ci(HeapInvocationBuffer.class) + CodegenUtils.ci(InvocationSession.class), javaParameterType, Integer.TYPE));
                    continue;
                }
                BufferMethodGenerator.marshal(mv, javaParameterType, Integer.TYPE);
                continue;
            }
            if (Pointer.class.isAssignableFrom(javaParameterType)) {
                mv.pushInt(nativeArrayFlags);
                BufferMethodGenerator.marshal(mv, Pointer.class, Integer.TYPE);
                continue;
            }
            if (Address.class.isAssignableFrom(javaParameterType)) {
                BufferMethodGenerator.marshal(mv, Address.class);
                continue;
            }
            if (Buffer.class.isAssignableFrom(javaParameterType)) {
                mv.pushInt(nativeArrayFlags);
                BufferMethodGenerator.marshal(mv, javaParameterType, Integer.TYPE);
                continue;
            }
            if (StringBuilder.class.isAssignableFrom(javaParameterType) || StringBuffer.class.isAssignableFrom(javaParameterType)) {
                mv.pushInt(parameterFlags);
                mv.pushInt(nativeArrayFlags);
                BufferMethodGenerator.sessionmarshal(mv, javaParameterType, Integer.TYPE, Integer.TYPE);
                continue;
            }
            if (CharSequence.class.isAssignableFrom(javaParameterType)) {
                BufferMethodGenerator.marshal(mv, CharSequence.class);
                continue;
            }
            if (javaParameterType.isArray() && CharSequence.class.isAssignableFrom(javaParameterType.getComponentType())) {
                mv.pushInt(parameterFlags);
                mv.pushInt(nativeArrayFlags);
                BufferMethodGenerator.sessionmarshal(mv, CharSequence[].class, Integer.TYPE, Integer.TYPE);
                continue;
            }
            if (Struct.class.isAssignableFrom(javaParameterType)) {
                mv.pushInt(parameterFlags);
                mv.pushInt(nativeArrayFlags);
                BufferMethodGenerator.marshal(mv, Struct.class, Integer.TYPE, Integer.TYPE);
                continue;
            }
            if (javaParameterType.isArray() && Struct.class.isAssignableFrom(javaParameterType.getComponentType())) {
                mv.pushInt(parameterFlags);
                mv.pushInt(nativeArrayFlags);
                BufferMethodGenerator.marshal(mv, Struct[].class, Integer.TYPE, Integer.TYPE);
                continue;
            }
            if (javaParameterType.isArray() && Pointer.class.isAssignableFrom(javaParameterType.getComponentType())) {
                mv.pushInt(parameterFlags);
                mv.pushInt(nativeArrayFlags);
                BufferMethodGenerator.sessionmarshal(mv, Pointer[].class, Integer.TYPE, Integer.TYPE);
                continue;
            }
            if (javaParameterType.isPrimitive() || Number.class.isAssignableFrom(javaParameterType) || Boolean.class == javaParameterType) {
                BufferMethodGenerator.emitInvocationBufferNumericParameter(mv, parameterTypes[i], javaParameterType);
                continue;
            }
            throw new IllegalArgumentException("unsupported parameter type " + parameterTypes[i]);
        }
        FromNativeConverter resultConverter = resultType.fromNativeConverter;
        Class clazz = javaReturnType = resultConverter != null ? resultConverter.nativeType() : resultType.getDeclaredType();
        if (NativeType.SCHAR == resultType.nativeType || NativeType.UCHAR == resultType.nativeType || NativeType.SSHORT == resultType.nativeType || NativeType.USHORT == resultType.nativeType || NativeType.SINT == resultType.nativeType || NativeType.UINT == resultType.nativeType || NativeType.VOID == resultType.nativeType) {
            invokeMethod = "invokeInt";
            nativeReturnType = Integer.TYPE;
        } else if ((NativeType.SLONG == resultType.nativeType || NativeType.ULONG == resultType.nativeType) && NumberUtil.sizeof(resultType) == 4) {
            invokeMethod = "invokeInt";
            nativeReturnType = Integer.TYPE;
        } else if ((NativeType.SLONG == resultType.nativeType || NativeType.ULONG == resultType.nativeType) && NumberUtil.sizeof(resultType) == 8) {
            invokeMethod = "invokeLong";
            nativeReturnType = Long.TYPE;
        } else if (NativeType.SLONGLONG == resultType.nativeType || NativeType.ULONGLONG == resultType.nativeType) {
            invokeMethod = "invokeLong";
            nativeReturnType = Long.TYPE;
        } else if (Pointer.class == javaReturnType || Address.class == javaReturnType || Struct.class.isAssignableFrom(javaReturnType) || String.class.isAssignableFrom(javaReturnType)) {
            invokeMethod = Platform.getPlatform().addressSize() == 32 ? "invokeInt" : "invokeLong";
            nativeReturnType = Platform.getPlatform().addressSize() == 32 ? Integer.TYPE : Long.TYPE;
        } else if (Float.class == javaReturnType || Float.TYPE == javaReturnType) {
            invokeMethod = "invokeFloat";
            nativeReturnType = Float.TYPE;
        } else if (Double.class == javaReturnType || Double.TYPE == javaReturnType) {
            invokeMethod = "invokeDouble";
            nativeReturnType = Double.TYPE;
        } else {
            throw new IllegalArgumentException("unsupported return type " + javaReturnType);
        }
        mv.invokevirtual(Invoker.class, invokeMethod, nativeReturnType, CallContext.class, Long.TYPE, HeapInvocationBuffer.class);
        BufferMethodGenerator.emitPostInvoke(builder, mv, parameterTypes, parameters, converted);
        if (sessionRequired) {
            mv.aload(session);
            mv.invokevirtual(CodegenUtils.p(InvocationSession.class), "finish", "()V");
        }
        Class unboxedResultType = AsmUtil.unboxedReturnType(javaReturnType);
        NumberUtil.convertPrimitive(mv, nativeReturnType, unboxedResultType, resultType.nativeType);
        BufferMethodGenerator.convertAndReturnResult(builder, mv, resultType, unboxedResultType);
    }
}

