/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.python.antlr.base.mod;
import org.python.compiler.Module;
import org.python.core.AnnotationReader;
import org.python.core.BytecodeLoader;
import org.python.core.CompileMode;
import org.python.core.CompilerFlags;
import org.python.core.ContainsPyBytecode;
import org.python.core.JavaImportHelper;
import org.python.core.Options;
import org.python.core.ParserFacade;
import org.python.core.Py;
import org.python.core.PyBaseCode;
import org.python.core.PyBaseString;
import org.python.core.PyCode;
import org.python.core.PyException;
import org.python.core.PyFrame;
import org.python.core.PyJavaPackage;
import org.python.core.PyList;
import org.python.core.PyModule;
import org.python.core.PyNullImporter;
import org.python.core.PyObject;
import org.python.core.PyRunnable;
import org.python.core.PyString;
import org.python.core.PySystemState;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.core.__builtin__;
import org.python.core.util.FileUtil;
import org.python.core.util.PlatformUtil;

public class imp {
    private static final String IMPORT_LOG = "import";
    private static final String UNKNOWN_SOURCEFILE = "<unknown>";
    private static final int APIVersion = 37;
    public static final int NO_MTIME = -1;
    public static final int DEFAULT_LEVEL = -1;
    private static final PyObject nonEmptyFromlist = new PyTuple(Py.newString("__doc__"));
    private static final PyTuple all = new PyTuple(Py.newString('*'));

    public static ClassLoader getSyspathJavaLoader() {
        return Py.getSystemState().getSyspathJavaLoader();
    }

    public static ClassLoader getParentClassLoader() {
        ClassLoader current = imp.class.getClassLoader();
        ClassLoader context = Thread.currentThread().getContextClassLoader();
        if (context == current) {
            return current;
        }
        if (context == null) {
            return current;
        }
        if (current == null) {
            return context;
        }
        if (imp.isParentClassLoader(context, current)) {
            return current;
        }
        if (imp.isParentClassLoader(current, context)) {
            return context;
        }
        return current;
    }

    private static boolean isParentClassLoader(ClassLoader suspectedParent, ClassLoader child) {
        try {
            ClassLoader parent = child.getParent();
            if (suspectedParent == parent) {
                return true;
            }
            if (parent == null || parent == child) {
                return false;
            }
            return imp.isParentClassLoader(suspectedParent, parent);
        }
        catch (SecurityException e) {
            return false;
        }
    }

    private imp() {
    }

    public static PyModule addModule(String name) {
        PyObject modules = Py.getSystemState().modules;
        PyModule module = (PyModule)modules.__finditem__(name = name.intern());
        if (module != null) {
            return module;
        }
        module = new PyModule(name, null);
        PyModule __builtin__2 = (PyModule)modules.__finditem__("__builtin__");
        PyObject __dict__ = module.__getattr__("__dict__");
        __dict__.__setitem__("__builtins__", __builtin__2.__getattr__("__dict__"));
        __dict__.__setitem__("__package__", Py.None);
        modules.__setitem__(name, (PyObject)module);
        return module;
    }

    private static void removeModule(String name) {
        block3: {
            PyObject modules = Py.getSystemState().modules;
            if (modules.__finditem__(name = name.intern()) != null) {
                try {
                    modules.__delitem__(name);
                }
                catch (PyException pye) {
                    if (pye.match(Py.KeyError)) break block3;
                    throw pye;
                }
            }
        }
    }

    private static byte[] readBytes(InputStream fp) {
        try {
            byte[] byArray = FileUtil.readBytes(fp);
            return byArray;
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
        finally {
            try {
                fp.close();
            }
            catch (IOException e) {
                throw Py.IOError(e);
            }
        }
    }

    private static InputStream makeStream(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
    }

    static PyObject createFromPyClass(String name, InputStream fp, boolean testing, String sourceName, String compiledName) {
        return imp.createFromPyClass(name, fp, testing, sourceName, compiledName, -1L);
    }

    static PyObject createFromPyClass(String name, InputStream fp, boolean testing, String sourceName, String compiledName, long mtime) {
        return imp.createFromPyClass(name, fp, testing, sourceName, compiledName, mtime, CodeImport.source);
    }

    static PyObject createFromPyClass(String name, InputStream fp, boolean testing, String sourceName, String compiledName, long mtime, CodeImport source) {
        PyCode code2;
        CodeData data;
        block6: {
            data = null;
            try {
                data = imp.readCodeData(compiledName, fp, testing, mtime);
            }
            catch (IOException ioe) {
                if (testing) break block6;
                throw Py.ImportError(ioe.getMessage() + "[name=" + name + ", source=" + sourceName + ", compiled=" + compiledName + "]");
            }
        }
        if (testing && data == null) {
            return null;
        }
        try {
            code2 = BytecodeLoader.makeCode(name + "$py", data.getBytes(), source == CodeImport.compiled_only ? data.getFilename() : sourceName);
        }
        catch (Throwable t) {
            if (testing) {
                return null;
            }
            throw Py.JavaError(t);
        }
        Py.writeComment(IMPORT_LOG, String.format("import %s # precompiled from %s", name, compiledName));
        return imp.createFromCode(name, code2, compiledName);
    }

    public static byte[] readCode(String name, InputStream fp, boolean testing) throws IOException {
        return imp.readCode(name, fp, testing, -1L);
    }

    public static byte[] readCode(String name, InputStream fp, boolean testing, long mtime) throws IOException {
        CodeData data = imp.readCodeData(name, fp, testing, mtime);
        if (data == null) {
            return null;
        }
        return data.getBytes();
    }

    public static CodeData readCodeData(String name, InputStream fp, boolean testing) throws IOException {
        return imp.readCodeData(name, fp, testing, -1L);
    }

    public static CodeData readCodeData(String name, InputStream fp, boolean testing, long mtime) throws IOException {
        long time;
        byte[] data = imp.readBytes(fp);
        AnnotationReader ar = new AnnotationReader(data);
        int api = ar.getVersion();
        if (api != 37) {
            if (testing) {
                return null;
            }
            String fmt = "compiled unit contains version %d code (%d required): %.200s";
            throw Py.ImportError(String.format(fmt, api, 37, name));
        }
        if (testing && mtime != -1L && mtime != (time = ar.getMTime())) {
            return null;
        }
        return new CodeData(data, mtime, ar.getFilename());
    }

    public static byte[] compileSource(String name, File file) {
        return imp.compileSource(name, file, null);
    }

    public static byte[] compileSource(String name, File file, String sourceFilename) {
        return imp.compileSource(name, file, sourceFilename, null);
    }

    public static byte[] compileSource(String name, File file, String sourceFilename, String compiledFilename) {
        if (sourceFilename == null) {
            sourceFilename = file.toString();
        }
        long mtime = file.lastModified();
        return imp.compileSource(name, imp.makeStream(file), sourceFilename, mtime);
    }

    public static String makeCompiledFilename(String filename) {
        return filename.substring(0, filename.length() - 3) + "$py.class";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String cacheCompiledSource(String sourceFilename, String compiledFilename, byte[] compiledSource) {
        if (compiledFilename == null) {
            if (sourceFilename == null || sourceFilename.equals(UNKNOWN_SOURCEFILE)) {
                return null;
            }
            compiledFilename = imp.makeCompiledFilename(sourceFilename);
        }
        FileOutputStream fop = null;
        try {
            SecurityManager man = System.getSecurityManager();
            if (man != null) {
                man.checkWrite(compiledFilename);
            }
            fop = new FileOutputStream(compiledFilename);
            fop.write(compiledSource);
            fop.close();
            String string2 = compiledFilename;
            return string2;
        }
        catch (IOException exc) {
            Py.writeDebug(IMPORT_LOG, "Unable to write to source cache file '" + compiledFilename + "' due to " + exc);
            String string3 = null;
            return string3;
        }
        catch (SecurityException exc) {
            Py.writeDebug(IMPORT_LOG, "Unable to write to source cache file '" + compiledFilename + "' due to " + exc);
            String string4 = null;
            return string4;
        }
        finally {
            if (fop != null) {
                try {
                    fop.close();
                }
                catch (IOException e) {
                    Py.writeDebug(IMPORT_LOG, "Unable to close source cache file '" + compiledFilename + "' due to " + e);
                }
            }
        }
    }

    public static byte[] compileSource(String name, InputStream fp, String filename) {
        return imp.compileSource(name, fp, filename, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compileSource(String name, InputStream fp, String filename, long mtime) {
        ByteArrayOutputStream ofp = new ByteArrayOutputStream();
        try {
            mod node;
            if (filename == null) {
                filename = UNKNOWN_SOURCEFILE;
            }
            try {
                node = ParserFacade.parse(fp, CompileMode.exec, filename, new CompilerFlags());
            }
            finally {
                fp.close();
            }
            Module.compile(node, ofp, name + "$py", filename, true, false, null, mtime);
            return ofp.toByteArray();
        }
        catch (Throwable t) {
            throw ParserFacade.fixParseError(null, t, filename);
        }
    }

    public static PyObject createFromSource(String name, InputStream fp, String filename) {
        return imp.createFromSource(name, fp, filename, null, -1L);
    }

    public static PyObject createFromSource(String name, InputStream fp, String filename, String outFilename) {
        return imp.createFromSource(name, fp, filename, outFilename, -1L);
    }

    public static PyObject createFromSource(String name, InputStream fp, String filename, String outFilename, long mtime) {
        byte[] bytes = imp.compileSource(name, fp, filename, mtime);
        if (!Py.getSystemState().dont_write_bytecode) {
            outFilename = imp.cacheCompiledSource(filename, outFilename, bytes);
        }
        Py.writeComment(IMPORT_LOG, "'" + name + "' as " + filename);
        PyCode code2 = BytecodeLoader.makeCode(name + "$py", bytes, filename);
        return imp.createFromCode(name, code2, filename);
    }

    public static PyObject createFromCode(String name, PyCode c) {
        return imp.createFromCode(name, c, null);
    }

    public static PyObject createFromCode(String name, PyCode c, String moduleLocation) {
        PyUnicode.checkEncoding(name);
        PyModule module = imp.addModule(name);
        PyBaseCode code2 = null;
        if (c instanceof PyBaseCode) {
            code2 = (PyBaseCode)c;
        }
        if (moduleLocation != null) {
            module.__setattr__("__file__", (PyObject)new PyString(moduleLocation));
        } else if (module.__findattr__("__file__") == null) {
            Py.writeDebug(IMPORT_LOG, String.format("Warning: %s __file__ is unknown", name));
        }
        ReentrantLock importLock = Py.getSystemState().getImportLock();
        importLock.lock();
        try {
            PyFrame f = new PyFrame(code2, module.__dict__, module.__dict__, null);
            code2.call(Py.getThreadState(), f);
            PyModule pyModule = module;
            return pyModule;
        }
        catch (RuntimeException t) {
            imp.removeModule(name);
            throw t;
        }
        finally {
            importLock.unlock();
        }
    }

    static PyObject createFromClass(String name, Class<?> c) {
        if (PyRunnable.class.isAssignableFrom(c)) {
            try {
                if (ContainsPyBytecode.class.isAssignableFrom(c)) {
                    try {
                        BytecodeLoader.fixPyBytecode(c);
                    }
                    catch (NoSuchFieldException e) {
                        throw Py.JavaError(e);
                    }
                    catch (IOException e) {
                        throw Py.JavaError(e);
                    }
                    catch (ClassNotFoundException e) {
                        throw Py.JavaError(e);
                    }
                }
                return imp.createFromCode(name, ((PyRunnable)c.newInstance()).getMain());
            }
            catch (InstantiationException e) {
                throw Py.JavaError(e);
            }
            catch (IllegalAccessException e) {
                throw Py.JavaError(e);
            }
        }
        return PyType.fromClass(c, false);
    }

    public static PyObject getImporter(PyObject p) {
        PySystemState sys = Py.getSystemState();
        return imp.getPathImporter(sys.path_importer_cache, sys.path_hooks, p);
    }

    static PyObject getPathImporter(PyObject cache, PyList hooks, PyObject p) {
        PyObject importer2;
        block9: {
            PyObject hook;
            importer2 = cache.__finditem__(p);
            if (importer2 != null) {
                return importer2;
            }
            PyObject iter = hooks.__iter__();
            while ((hook = iter.__iternext__()) != null) {
                try {
                    importer2 = hook.__call__(p);
                    break;
                }
                catch (PyException e) {
                    if (e.match(Py.ImportError)) continue;
                    throw e;
                }
            }
            if (importer2 == null) {
                try {
                    importer2 = new PyNullImporter(p);
                }
                catch (PyException e) {
                    if (e.match(Py.ImportError)) break block9;
                    throw e;
                }
            }
        }
        if (importer2 != null) {
            cache.__setitem__(p, importer2);
        } else {
            importer2 = Py.None;
        }
        return importer2;
    }

    static PyObject find_module(String name, String moduleName, PyList path) {
        PyObject loader2 = Py.None;
        PySystemState sys = Py.getSystemState();
        PyList metaPath = sys.meta_path;
        for (PyObject importer2 : metaPath.asIterable()) {
            PyObject findModule = importer2.__getattr__("find_module");
            PyObject[] pyObjectArray = new PyObject[2];
            pyObjectArray[0] = new PyString(moduleName);
            PyObject pyObject = pyObjectArray[1] = path == null ? Py.None : path;
            loader2 = findModule.__call__(pyObjectArray);
            if (loader2 == Py.None) continue;
            return imp.loadFromLoader(loader2, moduleName);
        }
        PyObject ret = imp.loadBuiltin(moduleName);
        if (ret != null) {
            return ret;
        }
        path = path == null ? sys.path : path;
        for (int i = 0; i < path.__len__(); ++i) {
            PyObject findModule;
            PyObject p = path.__getitem__(i);
            PyObject importer3 = imp.getPathImporter(sys.path_importer_cache, sys.path_hooks, p);
            if (importer3 != Py.None && (loader2 = (findModule = importer3.__getattr__("find_module")).__call__(new PyObject[]{new PyString(moduleName)})) != Py.None) {
                return imp.loadFromLoader(loader2, moduleName);
            }
            if (!(p instanceof PyUnicode)) {
                p = p.__str__();
            }
            if ((ret = imp.loadFromSource(sys, name, moduleName, p.toString())) == null) continue;
            return ret;
        }
        return ret;
    }

    private static PyObject loadBuiltin(String name) {
        Class<?> c;
        if (name == "sys") {
            Py.writeComment(IMPORT_LOG, "'" + name + "' as sys in builtin modules");
            return Py.java2py(Py.getSystemState());
        }
        if (name == "__builtin__") {
            Py.writeComment(IMPORT_LOG, "'" + name + "' as __builtin__ in builtin modules");
            return new PyModule("__builtin__", Py.getSystemState().builtins);
        }
        String mod2 = PySystemState.getBuiltin(name);
        if (mod2 != null && (c = Py.findClassEx(mod2, "builtin modules")) != null) {
            Py.writeComment(IMPORT_LOG, "'" + name + "' as " + mod2 + " in builtin modules");
            try {
                if (PyObject.class.isAssignableFrom(c)) {
                    return PyType.fromClass(c);
                }
                return imp.createFromClass(name, c);
            }
            catch (NoClassDefFoundError e) {
                throw Py.ImportError("Cannot import " + name + ", missing class " + c.getName());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PyObject loadFromLoader(PyObject importer2, String name) {
        PyUnicode.checkEncoding(name);
        PyObject load_module = importer2.__getattr__("load_module");
        ReentrantLock importLock = Py.getSystemState().getImportLock();
        importLock.lock();
        try {
            PyObject pyObject = load_module.__call__(new PyObject[]{new PyString(name)});
            return pyObject;
        }
        finally {
            importLock.unlock();
        }
    }

    public static PyObject loadFromCompiled(String name, InputStream stream, String sourceName, String compiledName) {
        return imp.createFromPyClass(name, stream, false, sourceName, compiledName);
    }

    static PyObject loadFromSource(PySystemState sys, String name, String modName, String entry) {
        String dirName = sys.getPath(entry);
        String sourceName = "__init__.py";
        String compiledName = imp.makeCompiledFilename(sourceName);
        String displayDirName = entry.equals("") ? null : entry.toString();
        String displaySourceName = new File(new File(displayDirName, name), sourceName).getPath();
        String displayCompiledName = new File(new File(displayDirName, name), compiledName).getPath();
        File dir = new File(dirName, name);
        File sourceFile = new File(dir, sourceName);
        File compiledFile = new File(dir, compiledName);
        boolean pkg = false;
        try {
            if (dir.isDirectory()) {
                if (imp.caseok(dir, name) && (sourceFile.isFile() || compiledFile.isFile())) {
                    pkg = true;
                } else {
                    Py.warning(Py.ImportWarning, String.format("Not importing directory '%s': missing __init__.py", dirName));
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (!pkg) {
            Py.writeDebug(IMPORT_LOG, "trying source " + dir.getPath());
            sourceName = name + ".py";
            compiledName = imp.makeCompiledFilename(sourceName);
            displaySourceName = new File(displayDirName, sourceName).getPath();
            displayCompiledName = new File(displayDirName, compiledName).getPath();
            sourceFile = new File(dirName, sourceName);
            compiledFile = new File(dirName, compiledName);
        } else {
            PyModule m = imp.addModule(modName);
            PyString filename = new PyString(new File(displayDirName, name).getPath());
            m.__dict__.__setitem__("__path__", (PyObject)new PyList(new PyObject[]{filename}));
        }
        try {
            if (sourceFile.isFile() && imp.caseok(sourceFile, sourceName)) {
                long pyTime = sourceFile.lastModified();
                if (compiledFile.isFile() && imp.caseok(compiledFile, compiledName)) {
                    PyObject ret;
                    Py.writeDebug(IMPORT_LOG, "trying precompiled " + compiledFile.getPath());
                    long classTime = compiledFile.lastModified();
                    if (classTime >= pyTime && (ret = imp.createFromPyClass(modName, imp.makeStream(compiledFile), true, displaySourceName, displayCompiledName, pyTime)) != null) {
                        return ret;
                    }
                    return imp.createFromSource(modName, imp.makeStream(sourceFile), displaySourceName, compiledFile.getPath(), pyTime);
                }
                return imp.createFromSource(modName, imp.makeStream(sourceFile), displaySourceName, compiledFile.getPath(), pyTime);
            }
            Py.writeDebug(IMPORT_LOG, "trying precompiled with no source " + compiledFile.getPath());
            if (compiledFile.isFile() && imp.caseok(compiledFile, compiledName)) {
                return imp.createFromPyClass(modName, imp.makeStream(compiledFile), false, displaySourceName, displayCompiledName, -1L, CodeImport.compiled_only);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    public static boolean caseok(File file, String filename) {
        if (Options.caseok || !PlatformUtil.isCaseInsensitive()) {
            return true;
        }
        try {
            File canFile = new File(file.getCanonicalPath());
            boolean match = filename.regionMatches(0, canFile.getName(), 0, filename.length());
            if (!match) {
                String[] children;
                File parent = file.getParentFile();
                for (String c : children = parent.list()) {
                    if (!c.equals(filename)) continue;
                    return true;
                }
            }
            return match;
        }
        catch (IOException exc) {
            return false;
        }
    }

    public static PyObject load(String name) {
        PyUnicode.checkEncoding(name);
        ReentrantLock importLock = Py.getSystemState().getImportLock();
        importLock.lock();
        try {
            PyObject pyObject = imp.import_first(name, new StringBuilder());
            return pyObject;
        }
        finally {
            importLock.unlock();
        }
    }

    private static String get_parent(PyObject dict, int level) {
        int dot;
        String modname;
        int orig_level = level;
        if (dict == null && level == -1 || level == 0) {
            return null;
        }
        PyObject tmp = dict.__finditem__("__package__");
        if (tmp != null && tmp != Py.None) {
            if (!Py.isInstance(tmp, PyString.TYPE)) {
                throw Py.ValueError("__package__ set to non-string");
            }
            modname = ((PyString)tmp).getString();
        } else {
            tmp = dict.__finditem__("__name__");
            if (tmp == null) {
                return null;
            }
            modname = tmp.toString();
            tmp = dict.__finditem__("__path__");
            if (tmp instanceof PyList) {
                dict.__setitem__("__package__", (PyObject)new PyString(modname));
            } else {
                dot = modname.lastIndexOf(46);
                if (dot == -1) {
                    if (level <= -1) {
                        dict.__setitem__("__package__", Py.None);
                        return null;
                    }
                    throw Py.ValueError("Attempted relative import in non-package");
                }
                modname = modname.substring(0, dot);
                dict.__setitem__("__package__", (PyObject)new PyString(modname));
            }
        }
        while (level-- > 1) {
            dot = modname.lastIndexOf(46);
            if (dot == -1) {
                throw Py.ValueError("Attempted relative import beyond toplevel package");
            }
            modname = modname.substring(0, dot);
        }
        if (Py.getSystemState().modules.__finditem__(modname) == null) {
            if (orig_level < 1) {
                if (modname.length() > 0) {
                    Py.warning(Py.RuntimeWarning, String.format("Parent module '%.200s' not found while handling absolute import", modname));
                }
            } else {
                throw Py.SystemError(String.format("Parent module '%.200s' not loaded, cannot perform relative import", modname));
            }
        }
        return modname.intern();
    }

    private static PyObject import_next(PyObject mod2, StringBuilder parentNameBuffer, String name, String outerFullName, PyObject fromlist) {
        if (parentNameBuffer.length() > 0 && name != null && name.length() > 0) {
            parentNameBuffer.append('.');
        }
        parentNameBuffer.append(name);
        String fullName = parentNameBuffer.toString().intern();
        PyObject modules = Py.getSystemState().modules;
        PyObject ret = modules.__finditem__(fullName);
        if (ret != null) {
            return ret;
        }
        ret = mod2 == null ? imp.find_module(fullName, name, null) : mod2.impAttr(name.intern());
        if (ret == null || ret == Py.None) {
            if (JavaImportHelper.tryAddPackage(outerFullName, fromlist)) {
                ret = modules.__finditem__(fullName);
            }
            return ret;
        }
        if (modules.__finditem__(fullName) == null) {
            modules.__setitem__(fullName, ret);
        } else {
            ret = modules.__finditem__(fullName);
        }
        return ret;
    }

    private static PyObject import_first(String name, StringBuilder parentNameBuffer) {
        PyObject ret = imp.import_next(null, parentNameBuffer, name, null, null);
        if (ret == null || ret == Py.None) {
            throw Py.ImportError("No module named " + name);
        }
        return ret;
    }

    private static PyObject import_first(String name, StringBuilder parentNameBuffer, String fullName, PyObject fromlist) {
        PyObject ret = imp.import_next(null, parentNameBuffer, name, fullName, fromlist);
        if ((ret == null || ret == Py.None) && JavaImportHelper.tryAddPackage(fullName, fromlist)) {
            ret = imp.import_next(null, parentNameBuffer, name, fullName, fromlist);
        }
        if (ret == null || ret == Py.None) {
            throw Py.ImportError("No module named " + name);
        }
        return ret;
    }

    private static PyObject import_logic(PyObject mod2, StringBuilder parentNameBuffer, String dottedName, String fullName, PyObject fromlist) {
        int dot = 0;
        int last_dot = 0;
        do {
            String name = (dot = dottedName.indexOf(46, last_dot)) == -1 ? dottedName.substring(last_dot) : dottedName.substring(last_dot, dot);
            PyJavaPackage jpkg = null;
            if (mod2 instanceof PyJavaPackage) {
                jpkg = (PyJavaPackage)mod2;
            }
            mod2 = imp.import_next(mod2, parentNameBuffer, name, fullName, fromlist);
            if (jpkg != null && (mod2 == null || mod2 == Py.None)) {
                mod2 = imp.import_next(jpkg, parentNameBuffer, name, fullName, fromlist);
            }
            if (mod2 == null || mod2 == Py.None) {
                throw Py.ImportError("No module named " + name);
            }
            last_dot = dot + 1;
        } while (dot != -1);
        return mod2;
    }

    private static PyObject import_module_level(String name, boolean top, PyObject modDict, PyObject fromlist, int level) {
        int dot;
        String firstName;
        StringBuilder parentNameBuffer;
        PyObject topMod;
        if (name.length() == 0) {
            if (level == 0 || modDict == null) {
                throw Py.ValueError("Empty module name");
            }
            PyObject moduleName = modDict.__findattr__("__name__");
            if (moduleName != null && moduleName.toString().equals("__name__")) {
                throw Py.ValueError("Attempted relative import in non-package");
            }
        }
        if (name.indexOf(File.separatorChar) != -1) {
            throw Py.ImportError("Import by filename is not supported.");
        }
        PyObject modules = Py.getSystemState().modules;
        PyObject pkgMod = null;
        String pkgName = null;
        if (modDict != null && modDict.isMappingType() && (pkgMod = modules.__finditem__(pkgName = imp.get_parent(modDict, level))) != null && !(pkgMod instanceof PyModule)) {
            pkgMod = null;
        }
        if ((topMod = imp.import_next(pkgMod, parentNameBuffer = new StringBuilder(pkgMod != null ? pkgName : ""), firstName = (dot = name.indexOf(46)) == -1 ? name : name.substring(0, dot), name, fromlist)) == Py.None || topMod == null) {
            parentNameBuffer = new StringBuilder("");
            topMod = level > 0 ? imp.import_first(pkgName + "." + firstName, parentNameBuffer, name, fromlist) : imp.import_first(firstName, parentNameBuffer, name, fromlist);
        }
        PyObject mod2 = topMod;
        if (dot != -1) {
            mod2 = imp.import_logic(topMod, parentNameBuffer, name.substring(dot + 1), name, fromlist);
        }
        if (top) {
            return topMod;
        }
        if (fromlist != null && fromlist != Py.None) {
            imp.ensureFromList(mod2, fromlist, name);
        }
        return mod2;
    }

    private static void ensureFromList(PyObject mod2, PyObject fromlist, String name) {
        imp.ensureFromList(mod2, fromlist, name, false);
    }

    private static void ensureFromList(PyObject mod2, PyObject fromlist, String name, boolean recursive) {
        if (name.length() == 0) {
            name = mod2.__findattr__("__name__").toString();
        }
        StringBuilder modNameBuffer = new StringBuilder(name);
        for (PyObject item : fromlist.asIterable()) {
            if (!Py.isInstance(item, PyBaseString.TYPE)) {
                throw Py.TypeError("Item in ``from list'' not a string");
            }
            if (item.toString().equals("*")) {
                if (recursive) continue;
                PyObject all = mod2.__findattr__("__all__");
                if (all != null) {
                    imp.ensureFromList(mod2, all, name, true);
                }
            }
            if (mod2.__findattr__((PyString)item) != null) continue;
            String fullName = modNameBuffer.toString() + "." + item.toString();
            imp.import_next(mod2, modNameBuffer, item.toString(), fullName, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PyObject importName(String name, boolean top) {
        PyUnicode.checkEncoding(name);
        ReentrantLock importLock = Py.getSystemState().getImportLock();
        importLock.lock();
        try {
            PyObject pyObject = imp.import_module_level(name, top, null, null, -1);
            return pyObject;
        }
        finally {
            importLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PyObject importName(String name, boolean top, PyObject modDict, PyObject fromlist, int level) {
        PyUnicode.checkEncoding(name);
        ReentrantLock importLock = Py.getSystemState().getImportLock();
        importLock.lock();
        try {
            PyObject pyObject = imp.import_module_level(name, top, modDict, fromlist, level);
            return pyObject;
        }
        finally {
            importLock.unlock();
        }
    }

    @Deprecated
    public static PyObject importOne(String mod2, PyFrame frame) {
        return imp.importOne(mod2, frame, -1);
    }

    public static PyObject importOne(String mod2, PyFrame frame, int level) {
        PyObject module = __builtin__.__import__(mod2, frame.f_globals, frame.getLocals(), Py.None, level);
        return module;
    }

    @Deprecated
    public static PyObject importOneAs(String mod2, PyFrame frame) {
        return imp.importOneAs(mod2, frame, -1);
    }

    public static PyObject importOneAs(String mod2, PyFrame frame, int level) {
        PyObject module = __builtin__.__import__(mod2, frame.f_globals, frame.getLocals(), Py.None, level);
        int dot = mod2.indexOf(46);
        while (dot != -1) {
            int dot2 = mod2.indexOf(46, dot + 1);
            String name = dot2 == -1 ? mod2.substring(dot + 1) : mod2.substring(dot + 1, dot2);
            module = module.__getattr__(name);
            dot = dot2;
        }
        return module;
    }

    @Deprecated
    public static PyObject[] importFrom(String mod2, String[] names, PyFrame frame) {
        return imp.importFromAs(mod2, names, null, frame, -1);
    }

    public static PyObject[] importFrom(String mod2, String[] names, PyFrame frame, int level) {
        return imp.importFromAs(mod2, names, null, frame, level);
    }

    @Deprecated
    public static PyObject[] importFromAs(String mod2, String[] names, PyFrame frame) {
        return imp.importFromAs(mod2, names, null, frame, -1);
    }

    public static PyObject[] importFromAs(String mod2, String[] names, String[] asnames, PyFrame frame, int level) {
        PyObject[] pyNames = new PyObject[names.length];
        for (int i = 0; i < names.length; ++i) {
            pyNames[i] = Py.newString(names[i]);
        }
        PyObject module = __builtin__.__import__(mod2, frame.f_globals, frame.getLocals(), new PyTuple(pyNames), level);
        PyObject[] submods = new PyObject[names.length];
        for (int i = 0; i < names.length; ++i) {
            PyObject submod = module.__findattr__(names[i]);
            if (submod == null) {
                submod = module.impAttr(names[i]);
            }
            if (submod == null) {
                throw Py.ImportError("cannot import name " + names[i]);
            }
            submods[i] = submod;
        }
        return submods;
    }

    public static void importAll(String mod2, PyFrame frame, int level) {
        PyObject module = __builtin__.__import__(mod2, frame.f_globals, frame.getLocals(), all, level);
        imp.importAll(module, frame);
    }

    @Deprecated
    public static void importAll(String mod2, PyFrame frame) {
        imp.importAll(mod2, frame, -1);
    }

    public static void importAll(PyObject module, PyFrame frame) {
        PyObject names;
        boolean filter = true;
        if (module instanceof PyJavaPackage) {
            names = ((PyJavaPackage)module).fillDir();
        } else {
            PyObject __all__ = module.__findattr__("__all__");
            if (__all__ != null) {
                names = __all__;
                filter = false;
            } else {
                names = module.__dir__();
            }
        }
        imp.loadNames(names, module, frame.getLocals(), filter);
    }

    private static void loadNames(PyObject names, PyObject module, PyObject locals, boolean filter) {
        for (PyObject name : names.asIterable()) {
            String sname = ((PyString)name).internedString();
            if (filter && sname.startsWith("_")) continue;
            try {
                PyObject nameObj;
                PyObject value = module.__findattr__(sname);
                if (value == null && (nameObj = module.__findattr__("__name__")) != null) {
                    String submodName = nameObj.__str__().toString() + '.' + sname;
                    value = __builtin__.__import__(submodName, null, null, nonEmptyFromlist);
                }
                locals.__setitem__(sname, value);
            }
            catch (Exception exc) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PyObject reload(PyModule m) {
        PySystemState sys = Py.getSystemState();
        PyObject modules = sys.modules;
        Map<String, PyModule> modules_reloading = sys.modules_reloading;
        ReentrantLock importLock = Py.getSystemState().getImportLock();
        importLock.lock();
        try {
            PyObject pyObject = imp._reload(m, modules, modules_reloading);
            return pyObject;
        }
        finally {
            modules_reloading.clear();
            importLock.unlock();
        }
    }

    private static PyObject _reload(PyModule m, PyObject modules, Map<String, PyModule> modules_reloading) {
        String name = m.__getattr__("__name__").toString().intern();
        PyModule nm = (PyModule)modules.__finditem__(name);
        if (nm == null || !nm.__getattr__("__name__").toString().equals(name)) {
            throw Py.ImportError("reload(): module " + name + " not in sys.modules");
        }
        PyModule existing_module = modules_reloading.get(name);
        if (existing_module != null) {
            return existing_module;
        }
        modules_reloading.put(name, nm);
        PyList path = Py.getSystemState().path;
        String modName = name;
        int dot = name.lastIndexOf(46);
        if (dot != -1) {
            String iname = name.substring(0, dot).intern();
            PyObject pkg = modules.__finditem__(iname);
            if (pkg == null) {
                throw Py.ImportError("reload(): parent not in sys.modules");
            }
            path = (PyList)pkg.__getattr__("__path__");
            name = name.substring(dot + 1, name.length()).intern();
        }
        nm.__setattr__("__name__", (PyObject)new PyString(modName));
        try {
            PyObject ret = imp.find_module(name, modName, path);
            modules.__setitem__(modName, ret);
            return ret;
        }
        catch (RuntimeException t) {
            modules.__setitem__(modName, (PyObject)nm);
            throw t;
        }
    }

    public static int getAPIVersion() {
        return 37;
    }

    public static enum CodeImport {
        source,
        compiled_only;

    }

    public static class CodeData {
        private final byte[] bytes;
        private final long mtime;
        private final String filename;

        public CodeData(byte[] bytes, long mtime, String filename) {
            this.bytes = bytes;
            this.mtime = mtime;
            this.filename = filename;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public long getMTime() {
            return this.mtime;
        }

        public String getFilename() {
            return this.filename;
        }
    }
}

