/*
 * Decompiled with CFR 0.152.
 */
package org.python.netty.util.concurrent;

import org.python.netty.util.concurrent.Future;
import org.python.netty.util.concurrent.GenericFutureListener;
import org.python.netty.util.concurrent.Promise;
import org.python.netty.util.internal.ObjectUtil;

public final class PromiseCombiner {
    private int expectedCount;
    private int doneCount;
    private boolean doneAdding;
    private Promise<Void> aggregatePromise;
    private Throwable cause;
    private final GenericFutureListener<Future<?>> listener = new GenericFutureListener<Future<?>>(){

        @Override
        public void operationComplete(Future<?> future2) throws Exception {
            ++PromiseCombiner.this.doneCount;
            if (!future2.isSuccess() && PromiseCombiner.this.cause == null) {
                PromiseCombiner.this.cause = future2.cause();
            }
            if (PromiseCombiner.this.doneCount == PromiseCombiner.this.expectedCount && PromiseCombiner.this.doneAdding) {
                PromiseCombiner.this.tryPromise();
            }
        }
    };

    public void add(Promise promise) {
        this.checkAddAllowed();
        ++this.expectedCount;
        promise.addListener(this.listener);
    }

    public void addAll(Promise ... promises) {
        this.checkAddAllowed();
        this.expectedCount += promises.length;
        for (Promise promise : promises) {
            promise.addListener(this.listener);
        }
    }

    public void finish(Promise<Void> aggregatePromise) {
        if (this.doneAdding) {
            throw new IllegalStateException("Already finished");
        }
        this.doneAdding = true;
        this.aggregatePromise = ObjectUtil.checkNotNull(aggregatePromise, "aggregatePromise");
        if (this.doneCount == this.expectedCount) {
            this.tryPromise();
        }
    }

    private boolean tryPromise() {
        return this.cause == null ? this.aggregatePromise.trySuccess(null) : this.aggregatePromise.tryFailure(this.cause);
    }

    private void checkAddAllowed() {
        if (this.doneAdding) {
            throw new IllegalStateException("Adding promises is not allowed after finished adding");
        }
    }
}

