/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Set;
import org.python.compiler.ClassConstants;
import org.python.compiler.ClassFile;
import org.python.compiler.Code;
import org.python.compiler.CodeCompiler;
import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.core.PyMethod;
import org.python.core.PyObject;
import org.python.core.PyProxy;
import org.python.core.PyReflectedFunction;
import org.python.objectweb.asm.Label;
import org.python.objectweb.asm.Opcodes;
import org.python.util.Generic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyMaker
implements ClassConstants,
Opcodes {
    public static final int tBoolean = 0;
    public static final int tByte = 1;
    public static final int tShort = 2;
    public static final int tInteger = 3;
    public static final int tLong = 4;
    public static final int tFloat = 5;
    public static final int tDouble = 6;
    public static final int tCharacter = 7;
    public static final int tVoid = 8;
    public static final int tOther = 9;
    public static final int tNone = 10;
    public static Map<Class<?>, Integer> types = ProxyMaker.fillTypes();
    Class<?> superclass;
    Class<?>[] interfaces;
    Set<String> names;
    Set<String> supernames;
    public ClassFile classfile;
    public String myClass;

    public static Map<Class<?>, Integer> fillTypes() {
        Map<Class<?>, Integer> typeMap = Generic.map();
        typeMap.put(Boolean.TYPE, 0);
        typeMap.put(Byte.TYPE, 1);
        typeMap.put(Short.TYPE, 2);
        typeMap.put(Integer.TYPE, 3);
        typeMap.put(Long.TYPE, 4);
        typeMap.put(Float.TYPE, 5);
        typeMap.put(Double.TYPE, 6);
        typeMap.put(Character.TYPE, 7);
        typeMap.put(Void.TYPE, 8);
        return typeMap;
    }

    public static int getType(Class<?> c) {
        if (c == null) {
            return 10;
        }
        Integer i = types.get(c);
        if (i == null) {
            return 9;
        }
        return i;
    }

    public static PyObject findPython(PyProxy proxy, String name) {
        PyObject ret;
        PyObject o = proxy._getPyInstance();
        if (o == null) {
            proxy.__initProxy__(new Object[0]);
            o = proxy._getPyInstance();
        }
        if ((ret = o.__findattr__(name)) instanceof PyMethod) {
            PyMethod meth = (PyMethod)ret;
            if (meth.im_func instanceof PyReflectedFunction) {
                PyReflectedFunction func = (PyReflectedFunction)meth.im_func;
                if (func.nargs > 0 && proxy.getClass() == func.argslist[0].declaringClass) {
                    return null;
                }
            }
        }
        Py.setSystemState(proxy._getPySystemState());
        return ret;
    }

    @Deprecated
    public ProxyMaker(String superclassName, Class<?> superclass) {
        Class[] classArray;
        String string2 = "org.python.proxies." + superclassName;
        Class clazz = superclass.isInterface() ? Object.class : superclass;
        if (superclass.isInterface()) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = superclass;
        } else {
            classArray = new Class[]{};
        }
        this(string2, clazz, classArray);
    }

    public ProxyMaker(String proxyClassName, Class<?> superclass, Class<?> ... interfaces) {
        this.supernames = Generic.set();
        this.myClass = proxyClassName;
        if (superclass == null) {
            superclass = Object.class;
        }
        if (superclass.isInterface()) {
            throw new IllegalArgumentException("Given an interface,  " + superclass.getName() + ", for a proxy superclass");
        }
        this.superclass = superclass;
        if (interfaces == null) {
            interfaces = new Class[]{};
        }
        for (Class<?> interfac : interfaces) {
            if (interfac.isInterface()) continue;
            throw new IllegalArgumentException("All classes in the interfaces array must be interfaces, unlike " + interfac.getName());
        }
        this.interfaces = interfaces;
    }

    public static String mapClass(Class<?> c) {
        String name = c.getName();
        int index = name.indexOf(".");
        if (index == -1) {
            return name;
        }
        StringBuffer buf = new StringBuffer(name.length());
        int last_index = 0;
        while (index != -1) {
            buf.append(name.substring(last_index, index));
            buf.append("/");
            last_index = index + 1;
            index = name.indexOf(".", last_index);
        }
        buf.append(name.substring(last_index, name.length()));
        return buf.toString();
    }

    public static String mapType(Class<?> type) {
        if (type.isArray()) {
            return "[" + ProxyMaker.mapType(type.getComponentType());
        }
        switch (ProxyMaker.getType(type)) {
            case 1: {
                return "B";
            }
            case 7: {
                return "C";
            }
            case 6: {
                return "D";
            }
            case 5: {
                return "F";
            }
            case 3: {
                return "I";
            }
            case 4: {
                return "J";
            }
            case 2: {
                return "S";
            }
            case 0: {
                return "Z";
            }
            case 8: {
                return "V";
            }
        }
        return "L" + ProxyMaker.mapClass(type) + ";";
    }

    public static String makeSig(Class<?> ret, Class<?> ... sig) {
        String[] mapped = new String[sig.length];
        for (int i = 0; i < mapped.length; ++i) {
            mapped[i] = ProxyMaker.mapType(sig[i]);
        }
        return ProxyMaker.makeSig(ProxyMaker.mapType(ret), mapped);
    }

    public static String makeSig(String returnType, String ... parameterTypes) {
        StringBuilder buf = new StringBuilder("(");
        for (String param : parameterTypes) {
            buf.append(param);
        }
        return buf.append(')').append(returnType).toString();
    }

    public void doConstants() throws Exception {
        Code code2 = this.classfile.addMethod("<clinit>", ProxyMaker.makeSig("V", new String[0]), 8);
        code2.return_();
    }

    public static void doReturn(Code code2, Class<?> type) throws Exception {
        switch (ProxyMaker.getType(type)) {
            case 10: {
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                code2.ireturn();
                break;
            }
            case 4: {
                code2.lreturn();
                break;
            }
            case 5: {
                code2.freturn();
                break;
            }
            case 6: {
                code2.dreturn();
                break;
            }
            case 8: {
                code2.return_();
                break;
            }
            default: {
                code2.areturn();
            }
        }
    }

    public static void doNullReturn(Code code2, Class<?> type) throws Exception {
        switch (ProxyMaker.getType(type)) {
            case 10: {
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                code2.iconst_0();
                code2.ireturn();
                break;
            }
            case 4: {
                code2.lconst_0();
                code2.lreturn();
                break;
            }
            case 5: {
                code2.fconst_0();
                code2.freturn();
                break;
            }
            case 6: {
                code2.dconst_0();
                code2.dreturn();
                break;
            }
            case 8: {
                code2.return_();
                break;
            }
            default: {
                code2.aconst_null();
                code2.areturn();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void callSuper(Code code2, String name, String superclass, Class<?>[] parameters, Class<?> ret, String sig) throws Exception {
        void local_index;
        code2.aload(0);
        boolean bl = false;
        int i = 1;
        while (local_index < parameters.length) {
            switch (ProxyMaker.getType(parameters[local_index])) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 7: {
                    code2.iload(i);
                    ++i;
                    break;
                }
                case 4: {
                    code2.lload(i);
                    i += 2;
                    break;
                }
                case 5: {
                    code2.fload(i);
                    ++i;
                    break;
                }
                case 6: {
                    code2.dload(i);
                    i += 2;
                    break;
                }
                default: {
                    code2.aload(i);
                    ++i;
                }
            }
            ++local_index;
        }
        code2.invokespecial(superclass, name, sig);
        ProxyMaker.doReturn(code2, ret);
    }

    public void doJavaCall(Code code2, String name, String type, String jcallName) throws Exception {
        code2.invokevirtual("org/python/core/PyObject", jcallName, ProxyMaker.makeSig("Lorg/python/core/PyObject;", "[Ljava/lang/Object;"));
        code2.invokestatic("org/python/core/Py", "py2" + name, ProxyMaker.makeSig(type, "Lorg/python/core/PyObject;"));
    }

    /*
     * WARNING - void declaration
     */
    public void getArgs(Code code2, Class<?>[] parameters) throws Exception {
        if (parameters.length == 0) {
            code2.getstatic("org/python/core/Py", "EmptyObjects", "[Lorg/python/core/PyObject;");
        } else {
            void local_index;
            code2.iconst(parameters.length);
            code2.anewarray("java/lang/Object");
            int array = code2.getLocal("[org/python/core/PyObject");
            code2.astore(array);
            boolean bl = false;
            int i = 1;
            while (local_index < parameters.length) {
                code2.aload(array);
                code2.iconst((int)local_index);
                switch (ProxyMaker.getType(parameters[local_index])) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        code2.iload(i);
                        ++i;
                        code2.invokestatic("org/python/core/Py", "newInteger", "(I)Lorg/python/core/PyInteger;");
                        break;
                    }
                    case 4: {
                        code2.lload(i);
                        i += 2;
                        code2.invokestatic("org/python/core/Py", "newInteger", "(J)Lorg/python/core/PyObject;");
                        break;
                    }
                    case 5: {
                        code2.fload(i);
                        ++i;
                        code2.invokestatic("org/python/core/Py", "newFloat", "(F)Lorg/python/core/PyFloat;");
                        break;
                    }
                    case 6: {
                        code2.dload(i);
                        i += 2;
                        code2.invokestatic("org/python/core/Py", "newFloat", "(D)Lorg/python/core/PyFloat;");
                        break;
                    }
                    case 7: {
                        code2.iload(i);
                        ++i;
                        code2.invokestatic("org/python/core/Py", "newString", "(C)Lorg/python/core/PyString;");
                        break;
                    }
                    default: {
                        code2.aload(i);
                        ++i;
                    }
                }
                code2.aastore();
                ++local_index;
            }
            code2.aload(array);
        }
    }

    public void callMethod(Code code2, String name, Class<?>[] parameters, Class<?> ret, Class<?>[] exceptions2) throws Exception {
        Label start = null;
        Label end = null;
        String jcallName = "_jcall";
        int instLocal = 0;
        if (exceptions2.length > 0) {
            start = new Label();
            end = new Label();
            jcallName = "_jcallexc";
            instLocal = code2.getLocal("org/python/core/PyObject");
            code2.astore(instLocal);
            code2.label(start);
            code2.aload(instLocal);
        }
        this.getArgs(code2, parameters);
        switch (ProxyMaker.getType(ret)) {
            case 7: {
                this.doJavaCall(code2, "char", "C", jcallName);
                break;
            }
            case 0: {
                this.doJavaCall(code2, "boolean", "Z", jcallName);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                this.doJavaCall(code2, "int", "I", jcallName);
                break;
            }
            case 4: {
                this.doJavaCall(code2, "long", "J", jcallName);
                break;
            }
            case 5: {
                this.doJavaCall(code2, "float", "F", jcallName);
                break;
            }
            case 6: {
                this.doJavaCall(code2, "double", "D", jcallName);
                break;
            }
            case 8: {
                this.doJavaCall(code2, "void", "V", jcallName);
                break;
            }
            default: {
                code2.invokevirtual("org/python/core/PyObject", jcallName, ProxyMaker.makeSig("Lorg/python/core/PyObject;", "[Ljava/lang/Object;"));
                code2.ldc(ret.getName());
                code2.invokestatic("java/lang/Class", "forName", ProxyMaker.makeSig("Ljava/lang/Class;", "Ljava/lang/String;"));
                code2.invokestatic("org/python/core/Py", "tojava", ProxyMaker.makeSig("Ljava/lang/Object;", "Lorg/python/core/PyObject;", "Ljava/lang/Class;"));
                code2.checkcast(ProxyMaker.mapClass(ret));
            }
        }
        if (end != null) {
            code2.label(end);
        }
        ProxyMaker.doReturn(code2, ret);
        if (exceptions2.length > 0) {
            boolean throwableFound = false;
            Label handlerStart = null;
            for (Class<?> exception : exceptions2) {
                handlerStart = new Label();
                code2.label(handlerStart);
                int excLocal = code2.getLocal("java/lang/Throwable");
                code2.astore(excLocal);
                code2.aload(excLocal);
                code2.athrow();
                code2.visitTryCatchBlock(start, end, handlerStart, ProxyMaker.mapClass(exception));
                ProxyMaker.doNullReturn(code2, ret);
                code2.freeLocal(excLocal);
                if (exception != Throwable.class) continue;
                throwableFound = true;
            }
            if (!throwableFound) {
                handlerStart = new Label();
                code2.label(handlerStart);
                int excLocal = code2.getLocal("java/lang/Throwable");
                code2.astore(excLocal);
                code2.aload(instLocal);
                code2.aload(excLocal);
                code2.invokevirtual("org/python/core/PyObject", "_jthrow", ProxyMaker.makeSig("V", "Ljava/lang/Throwable;"));
                code2.visitTryCatchBlock(start, end, handlerStart, "java/lang/Throwable");
                code2.freeLocal(excLocal);
                ProxyMaker.doNullReturn(code2, ret);
            }
            code2.freeLocal(instLocal);
        }
    }

    public void addMethod(Method method, int access) throws Exception {
        boolean isAbstract = false;
        if (Modifier.isAbstract(access)) {
            access &= 0xFFFFFBFF;
            isAbstract = true;
        }
        Class<?>[] parameters = method.getParameterTypes();
        Class<?> ret = method.getReturnType();
        String sig = ProxyMaker.makeSig(ret, parameters);
        String name = method.getName();
        this.names.add(name);
        Code code2 = this.classfile.addMethod(name, sig, access);
        code2.aload(0);
        code2.ldc(name);
        if (!isAbstract) {
            int tmp = code2.getLocal("org/python/core/PyObject");
            code2.invokestatic("org/python/compiler/ProxyMaker", "findPython", ProxyMaker.makeSig("Lorg/python/core/PyObject;", "Lorg/python/core/PyProxy;", "Ljava/lang/String;"));
            code2.astore(tmp);
            code2.aload(tmp);
            Label callPython = new Label();
            code2.ifnonnull(callPython);
            String superClass = ProxyMaker.mapClass(method.getDeclaringClass());
            this.callSuper(code2, name, superClass, parameters, ret, sig);
            code2.label(callPython);
            code2.aload(tmp);
            this.callMethod(code2, name, parameters, ret, method.getExceptionTypes());
            this.addSuperMethod("super__" + name, name, superClass, parameters, ret, sig, access);
        } else {
            code2.invokestatic("org/python/compiler/ProxyMaker", "findPython", ProxyMaker.makeSig("Lorg/python/core/PyObject;", "Lorg/python/core/PyProxy;", "Ljava/lang/String;"));
            code2.dup();
            Label returnNull = new Label();
            code2.ifnull(returnNull);
            this.callMethod(code2, name, parameters, ret, method.getExceptionTypes());
            code2.label(returnNull);
            code2.pop();
            ProxyMaker.doNullReturn(code2, ret);
        }
    }

    private String methodString(Method m) {
        Class<?>[] params;
        StringBuffer buf = new StringBuffer(m.getName());
        buf.append(":");
        for (Class<?> param : params = m.getParameterTypes()) {
            buf.append(param.getName());
            buf.append(",");
        }
        return buf.toString();
    }

    protected void addMethods(Class<?> c, Set<String> t) throws Exception {
        Method[] methods;
        for (Method method : methods = c.getDeclaredMethods()) {
            int access;
            if (!t.add(this.methodString(method)) || Modifier.isStatic(access = method.getModifiers()) || Modifier.isPrivate(access)) continue;
            if (Modifier.isNative(access)) {
                access &= 0xFFFFFEFF;
            }
            if (Modifier.isProtected(access)) {
                if (Modifier.isFinal(access = access & 0xFFFFFFFB | 1)) {
                    this.addSuperMethod(method, access);
                    continue;
                }
            } else if (Modifier.isFinal(access) || !Modifier.isPublic(access)) continue;
            this.addMethod(method, access);
        }
        Class<?> sc = c.getSuperclass();
        if (sc != null) {
            this.addMethods(sc, t);
        }
        for (Class<?> iface : c.getInterfaces()) {
            this.addMethods(iface, t);
        }
    }

    public void addConstructor(String name, Class<?>[] parameters, Class<?> ret, String sig, int access) throws Exception {
        Code code2 = this.classfile.addMethod("<init>", sig, access);
        this.callSuper(code2, "<init>", name, parameters, Void.TYPE, sig);
    }

    public void addConstructors(Class<?> c) throws Exception {
        Constructor<?>[] constructors = c.getDeclaredConstructors();
        String name = ProxyMaker.mapClass(c);
        for (Constructor<?> constructor : constructors) {
            int access = constructor.getModifiers();
            if (Modifier.isPrivate(access)) continue;
            if (Modifier.isNative(access)) {
                access &= 0xFFFFFEFF;
            }
            if (Modifier.isProtected(access)) {
                access = access & 0xFFFFFFFB | 1;
            }
            Class<?>[] parameters = constructor.getParameterTypes();
            this.addConstructor(name, parameters, Void.TYPE, ProxyMaker.makeSig(Void.TYPE, parameters), access);
        }
    }

    public void addSuperMethod(Method method, int access) throws Exception {
        String superName;
        Class<?>[] parameters = method.getParameterTypes();
        Class<?> ret = method.getReturnType();
        String superClass = ProxyMaker.mapClass(method.getDeclaringClass());
        String methodName = superName = method.getName();
        if (Modifier.isFinal(access)) {
            methodName = "super__" + superName;
            access &= 0xFFFFFFEF;
        }
        this.addSuperMethod(methodName, superName, superClass, parameters, ret, ProxyMaker.makeSig(ret, parameters), access);
    }

    public void addSuperMethod(String methodName, String superName, String declClass, Class<?>[] parameters, Class<?> ret, String sig, int access) throws Exception {
        if (methodName.startsWith("super__")) {
            try {
                this.superclass.getMethod(methodName, parameters);
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException e) {
                return;
            }
        }
        this.supernames.add(methodName);
        Code code2 = this.classfile.addMethod(methodName, sig, access);
        this.callSuper(code2, superName, declClass, parameters, ret, sig);
    }

    public void addProxy() throws Exception {
        this.classfile.addField("__proxy", "Lorg/python/core/PyObject;", 4);
        Code code2 = this.classfile.addMethod("_setPyInstance", ProxyMaker.makeSig("V", "Lorg/python/core/PyObject;"), 1);
        code2.aload(0);
        code2.aload(1);
        code2.putfield(this.classfile.name, "__proxy", "Lorg/python/core/PyObject;");
        code2.return_();
        code2 = this.classfile.addMethod("_getPyInstance", ProxyMaker.makeSig("Lorg/python/core/PyObject;", new String[0]), 1);
        code2.aload(0);
        code2.getfield(this.classfile.name, "__proxy", "Lorg/python/core/PyObject;");
        code2.areturn();
        String pySys = "Lorg/python/core/PySystemState;";
        this.classfile.addField("__systemState", pySys, 132);
        code2 = this.classfile.addMethod("_setPySystemState", ProxyMaker.makeSig("V", pySys), 1);
        code2.aload(0);
        code2.aload(1);
        code2.putfield(this.classfile.name, "__systemState", pySys);
        code2.return_();
        code2 = this.classfile.addMethod("_getPySystemState", ProxyMaker.makeSig(pySys, new String[0]), 1);
        code2.aload(0);
        code2.getfield(this.classfile.name, "__systemState", pySys);
        code2.areturn();
    }

    public void addClassDictInit() throws Exception {
        this.classfile.addInterface(ProxyMaker.mapClass(ClassDictInit.class));
        Code code2 = this.classfile.addMethod("classDictInit", ProxyMaker.makeSig("V", "Lorg/python/core/PyObject;"), 9);
        code2.aload(0);
        code2.ldc("__supernames__");
        int strArray = CodeCompiler.makeStrings(code2, this.supernames);
        code2.aload(strArray);
        code2.freeLocal(strArray);
        code2.invokestatic("org/python/core/Py", "java2py", ProxyMaker.makeSig("Lorg/python/core/PyObject;", "Ljava/lang/Object;"));
        code2.invokevirtual("org/python/core/PyObject", "__setitem__", ProxyMaker.makeSig("V", "Ljava/lang/String;", "Lorg/python/core/PyObject;"));
        code2.return_();
    }

    public void build(OutputStream out) throws Exception {
        this.build();
        this.classfile.write(out);
    }

    public void build() throws Exception {
        this.names = Generic.set();
        int access = this.superclass.getModifiers();
        if ((access & 0x10) != 0) {
            throw new InstantiationException("can't subclass final class");
        }
        access = 33;
        this.classfile = new ClassFile(this.myClass, ProxyMaker.mapClass(this.superclass), access);
        this.addProxy();
        this.addConstructors(this.superclass);
        this.classfile.addInterface("org/python/core/PyProxy");
        Set<String> seenmethods = Generic.set();
        this.addMethods(this.superclass, seenmethods);
        for (Class<?> iface : this.interfaces) {
            if (iface.isAssignableFrom(this.superclass)) {
                Py.writeWarning("compiler", "discarding redundant interface: " + iface.getName());
                continue;
            }
            this.classfile.addInterface(ProxyMaker.mapClass(iface));
            this.addMethods(iface, seenmethods);
        }
        this.doConstants();
        this.addClassDictInit();
    }
}

