/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.security.AccessControlException;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.python.Version;
import org.python.core.ClassDictInit;
import org.python.core.ClasspathPyImporter;
import org.python.core.JavaImporter;
import org.python.core.JythonInitializer;
import org.python.core.Options;
import org.python.core.Py;
import org.python.core.PyAttributeDeleted;
import org.python.core.PyBoolean;
import org.python.core.PyDictionary;
import org.python.core.PyEllipsis;
import org.python.core.PyException;
import org.python.core.PyFile;
import org.python.core.PyFrame;
import org.python.core.PyFrozenSet;
import org.python.core.PyIgnoreMethodTag;
import org.python.core.PyInteger;
import org.python.core.PyJavaPackage;
import org.python.core.PyList;
import org.python.core.PyMethod;
import org.python.core.PyModule;
import org.python.core.PyNone;
import org.python.core.PyNotImplemented;
import org.python.core.PyObject;
import org.python.core.PyReflectedFunction;
import org.python.core.PySingleton;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PySyntaxError;
import org.python.core.PySystemStateFunctions;
import org.python.core.PyTraceback;
import org.python.core.PyTuple;
import org.python.core.PythonTraceFunction;
import org.python.core.Shadow;
import org.python.core.StderrWrapper;
import org.python.core.StdoutWrapper;
import org.python.core.ThreadState;
import org.python.core.__builtin__;
import org.python.core.adapter.ClassicPyObjectAdapter;
import org.python.core.adapter.ExtensiblePyObjectAdapter;
import org.python.core.codecs;
import org.python.core.packagecache.PackageManager;
import org.python.core.packagecache.SysPackageManager;
import org.python.modules.Setup;
import org.python.modules.zipimport.zipimporter;
import org.python.posix.util.Platform;
import org.python.util.Generic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PySystemState
extends PyObject
implements ClassDictInit {
    public static final String PYTHON_CACHEDIR = "python.cachedir";
    public static final String PYTHON_CACHEDIR_SKIP = "python.cachedir.skip";
    public static final String PYTHON_CONSOLE_ENCODING = "python.console.encoding";
    protected static final String CACHEDIR_DEFAULT_NAME = "cachedir";
    public static final String JYTHON_JAR = "jython.jar";
    public static final String JYTHON_DEV_JAR = "jython-dev.jar";
    private static final String JAR_URL_PREFIX = "jar:file:";
    private static final String JAR_SEPARATOR = "!";
    private static final String VFSZIP_PREFIX = "vfszip:";
    public static final PyString version = new PyString(Version.getVersion());
    public static final int hexversion = Version.PY_MAJOR_VERSION << 24 | Version.PY_MINOR_VERSION << 16 | Version.PY_MICRO_VERSION << 8 | Version.PY_RELEASE_LEVEL << 4 | Version.PY_RELEASE_SERIAL << 0;
    public static PyTuple version_info;
    public static final int maxunicode = 0x10FFFF;
    public static PyTuple subversion;
    public static final PyObject copyright;
    private static Map<String, String> builtinNames;
    public static PyTuple builtin_module_names;
    public static PackageManager packageManager;
    private static File cachedir;
    private static PyList defaultPath;
    private static PyList defaultArgv;
    private static PyObject defaultExecutable;
    public static Properties registry;
    public static PyObject prefix;
    public static PyObject exec_prefix;
    public static final PyString byteorder;
    public static final int maxint = Integer.MAX_VALUE;
    public static final int minint = Integer.MIN_VALUE;
    private static boolean initialized;
    public PyList argv = new PyList();
    public PyObject modules;
    public PyList path;
    public static PyList warnoptions;
    public static PyObject builtins;
    public static PyObject platform;
    public PyList meta_path;
    public PyList path_hooks;
    public PyObject path_importer_cache;
    public PyObject ps1 = new PyString(">>> ");
    public PyObject ps2 = new PyString("... ");
    public PyObject executable;
    private String currentWorkingDir;
    private ClassLoader classLoader = null;
    public PyObject stdout;
    public PyObject stderr;
    public PyObject stdin;
    public PyObject __stdout__;
    public PyObject __stderr__;
    public PyObject __stdin__;
    public PyObject __displayhook__;
    public PyObject __excepthook__;
    public PyObject last_value = Py.None;
    public PyObject last_type = Py.None;
    public PyObject last_traceback = Py.None;
    public PyObject __name__ = new PyString("sys");
    public PyObject __dict__;
    private int recursionlimit = 1000;
    public boolean _systemRestart = false;
    private final PySystemStateCloser closer;
    private static final ReferenceQueue<PySystemState> systemStateQueue;
    private static final ConcurrentMap<WeakReference<PySystemState>, PySystemStateCloser> sysClosers;
    private Shadow shadowing;
    private static final String INITIALIZER_SERVICE = "META-INF/services/org.python.core.JythonInitializer";

    public PySystemState() {
        PySystemState.initialize();
        this.closer = new PySystemStateCloser(this);
        this.modules = new PyStringMap();
        this.argv = (PyList)defaultArgv.repeat(1);
        this.path = (PyList)defaultPath.repeat(1);
        this.path.append(Py.newString("__classpath__"));
        this.path.append(Py.newString("__pyclasspath__/"));
        this.executable = defaultExecutable;
        this.meta_path = new PyList();
        this.path_hooks = new PyList();
        this.path_hooks.append(new JavaImporter());
        this.path_hooks.append(zipimporter.TYPE);
        this.path_hooks.append(ClasspathPyImporter.TYPE);
        this.path_importer_cache = new PyDictionary();
        this.currentWorkingDir = new File("").getAbsolutePath();
        String mode = Options.unbuffered ? "b" : "";
        int buffering = Options.unbuffered ? 0 : 1;
        this.stdin = this.__stdin__ = new PyFile(System.in, "<stdin>", "r" + mode, buffering, false);
        this.stdout = this.__stdout__ = new PyFile(System.out, "<stdout>", "w" + mode, buffering, false);
        this.stderr = this.__stderr__ = new PyFile(System.err, "<stderr>", "w" + mode, 0, false);
        this.initEncoding();
        this.__displayhook__ = new PySystemStateFunctions("displayhook", 10, 1, 1);
        this.__excepthook__ = new PySystemStateFunctions("excepthook", 30, 3, 3);
        if (builtins == null) {
            builtins = PySystemState.getDefaultBuiltins();
        }
        this.modules.__setitem__("__builtin__", (PyObject)new PyModule("__builtin__", PySystemState.getDefaultBuiltins()));
        this.__dict__ = new PyStringMap();
        this.__dict__.invoke("update", this.getType().fastGetDict());
        this.__dict__.__setitem__("displayhook", this.__displayhook__);
        this.__dict__.__setitem__("excepthook", this.__excepthook__);
    }

    public static void classDictInit(PyObject dict) {
        dict.__setitem__("trace", null);
        dict.__setitem__("profile", null);
    }

    void reload() throws PyIgnoreMethodTag {
        this.__dict__.invoke("update", this.getType().fastGetDict());
    }

    private static void checkReadOnly(String name) {
        if (name == "__dict__" || name == "__class__" || name == "registry" || name == "exec_prefix" || name == "packageManager") {
            throw Py.TypeError("readonly attribute");
        }
    }

    private static void checkMustExist(String name) {
        if (name == "__dict__" || name == "__class__" || name == "registry" || name == "exec_prefix" || name == "platform" || name == "packageManager" || name == "builtins" || name == "warnoptions") {
            throw Py.TypeError("readonly attribute");
        }
    }

    private void initEncoding() {
        String encoding = registry.getProperty(PYTHON_CONSOLE_ENCODING);
        if (encoding == null) {
            return;
        }
        for (PyFile stdStream : new PyFile[]{(PyFile)this.stdin, (PyFile)this.stdout, (PyFile)this.stderr}) {
            if (!stdStream.isatty()) continue;
            stdStream.encoding = encoding;
        }
    }

    public synchronized void shadow() {
        if (this.shadowing == null) {
            this.shadowing = new Shadow();
        }
    }

    public static PyObject getDefaultBuiltins() {
        return DefaultBuiltinsHolder.builtins;
    }

    public synchronized PyObject getBuiltins() {
        if (this.shadowing == null) {
            return PySystemState.getDefaultBuiltins();
        }
        return this.shadowing.builtins;
    }

    public synchronized void setBuiltins(PyObject value) {
        if (this.shadowing == null) {
            builtins = value;
        } else {
            this.shadowing.builtins = value;
        }
        this.modules.__setitem__("__builtin__", (PyObject)new PyModule("__builtin__", value));
    }

    public synchronized PyObject getWarnoptions() {
        if (this.shadowing == null) {
            return warnoptions;
        }
        return this.shadowing.warnoptions;
    }

    public synchronized void setWarnoptions(PyObject value) {
        if (this.shadowing == null) {
            warnoptions = new PyList(value);
        } else {
            this.shadowing.warnoptions = new PyList(value);
        }
    }

    public synchronized PyObject getPlatform() {
        if (this.shadowing == null) {
            return platform;
        }
        return this.shadowing.platform;
    }

    public synchronized void setPlatform(PyObject value) {
        if (this.shadowing == null) {
            platform = value;
        } else {
            this.shadowing.platform = value;
        }
    }

    @Override
    public PyObject __findattr_ex__(String name) {
        if (name == "exc_value") {
            PyException exc = Py.getThreadState().exception;
            if (exc == null) {
                return null;
            }
            return exc.value;
        }
        if (name == "exc_type") {
            PyException exc = Py.getThreadState().exception;
            if (exc == null) {
                return null;
            }
            return exc.type;
        }
        if (name == "exc_traceback") {
            PyException exc = Py.getThreadState().exception;
            if (exc == null) {
                return null;
            }
            return exc.traceback;
        }
        if (name == "warnoptions") {
            return this.getWarnoptions();
        }
        if (name == "builtins") {
            return this.getBuiltins();
        }
        if (name == "platform") {
            return this.getPlatform();
        }
        PyObject ret = super.__findattr_ex__(name);
        if (ret != null) {
            if (ret instanceof PyMethod) {
                if (this.__dict__.__finditem__(name) instanceof PyReflectedFunction) {
                    return ret;
                }
            } else {
                if (ret == PyAttributeDeleted.INSTANCE) {
                    return null;
                }
                return ret;
            }
        }
        return this.__dict__.__finditem__(name);
    }

    @Override
    public void __setattr__(String name, PyObject value) {
        PySystemState.checkReadOnly(name);
        if (name == "builtins") {
            this.shadow();
            this.setBuiltins(value);
        } else if (name == "warnoptions") {
            this.shadow();
            this.setWarnoptions(value);
        } else if (name == "platform") {
            this.shadow();
            this.setPlatform(value);
        } else {
            PyObject ret = this.getType().lookup(name);
            if (ret != null && ret._doset(this, value)) {
                return;
            }
            this.__dict__.__setitem__(name, value);
        }
    }

    @Override
    public void __delattr__(String name) {
        block3: {
            PySystemState.checkMustExist(name);
            PyObject ret = this.getType().lookup(name);
            if (ret != null) {
                ret._doset(this, PyAttributeDeleted.INSTANCE);
            }
            try {
                this.__dict__.__delitem__(name);
            }
            catch (PyException pye) {
                if (ret != null) break block3;
                throw Py.AttributeError(name);
            }
        }
    }

    @Override
    public void __rawdir__(PyDictionary accum) {
        accum.update(this.__dict__);
    }

    @Override
    public String toString() {
        return "<module '" + this.__name__ + "' (built-in)>";
    }

    public int getrecursionlimit() {
        return this.recursionlimit;
    }

    public void setrecursionlimit(int recursionlimit) {
        if (recursionlimit <= 0) {
            throw Py.ValueError("Recursion limit must be positive");
        }
        this.recursionlimit = recursionlimit;
    }

    public void settrace(PyObject tracefunc) {
        ThreadState ts = Py.getThreadState();
        ts.tracefunc = tracefunc == Py.None ? null : new PythonTraceFunction(tracefunc);
    }

    public void setprofile(PyObject profilefunc) {
        ThreadState ts = Py.getThreadState();
        ts.profilefunc = profilefunc == Py.None ? null : new PythonTraceFunction(profilefunc);
    }

    public PyString getdefaultencoding() {
        return new PyString(codecs.getDefaultEncoding());
    }

    public void setdefaultencoding(String encoding) {
        codecs.setDefaultEncoding(encoding);
    }

    public PyObject getfilesystemencoding() {
        return Py.None;
    }

    public void setCurrentWorkingDir(String path) {
        this.currentWorkingDir = path;
    }

    public String getCurrentWorkingDir() {
        return this.currentWorkingDir;
    }

    public String getPath(String path) {
        return PySystemState.getPath(this, path);
    }

    public static String getPathLazy(String path) {
        return PySystemState.getPath(null, path);
    }

    private static String getPath(PySystemState sys, String path) {
        if (path == null) {
            return path;
        }
        File file = new File(path);
        if (!(file.isAbsolute() || Platform.IS_WINDOWS && (path.startsWith("\\") || path.startsWith("/")))) {
            if (sys == null) {
                sys = Py.getSystemState();
            }
            file = new File(sys.getCurrentWorkingDir(), path);
        }
        return file.getPath();
    }

    public void callExitFunc() throws PyIgnoreMethodTag {
        PyObject exitfunc = this.__findattr__("exitfunc");
        if (exitfunc != null) {
            try {
                exitfunc.__call__();
            }
            catch (PyException exc) {
                if (!exc.match(Py.SystemExit)) {
                    Py.println(this.stderr, Py.newString("Error in sys.exitfunc:"));
                }
                Py.printException(exc);
            }
        }
        Py.flushLine();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private static String findRoot(Properties preProperties, Properties postProperties, String jarFileName) {
        String classpath;
        String root = null;
        try {
            if (postProperties != null) {
                root = postProperties.getProperty("python.home");
            }
            if (root == null) {
                root = preProperties.getProperty("python.home");
            }
            if (root == null) {
                root = preProperties.getProperty("install.root");
            }
            PySystemState.determinePlatform(preProperties);
        }
        catch (Exception exc) {
            return null;
        }
        if (root == null && (classpath = preProperties.getProperty("java.class.path")) != null) {
            String lowerCaseClasspath = classpath.toLowerCase();
            int jarIndex = lowerCaseClasspath.indexOf(JYTHON_JAR);
            if (jarIndex < 0) {
                jarIndex = lowerCaseClasspath.indexOf(JYTHON_DEV_JAR);
            }
            if (jarIndex >= 0) {
                int start = classpath.lastIndexOf(File.pathSeparator, jarIndex) + 1;
                root = classpath.substring(start, jarIndex);
            } else if (jarFileName != null) {
                root = new File(jarFileName).getParent();
            }
        }
        if (root == null) {
            return null;
        }
        File rootFile = new File(root);
        try {
            return rootFile.getCanonicalPath();
        }
        catch (IOException ioe) {
            return rootFile.getAbsolutePath();
        }
    }

    public static void determinePlatform(Properties props) {
        String lversion;
        String version = props.getProperty("java.version");
        if (version == null) {
            version = "???";
        }
        if ((lversion = version.toLowerCase()).startsWith("java")) {
            version = version.substring(4, version.length());
        }
        if (lversion.startsWith("jdk") || lversion.startsWith("jre")) {
            version = version.substring(3, version.length());
        }
        if (version.equals("12")) {
            version = "1.2";
        }
        platform = new PyString("java" + version);
    }

    private static void initRegistry(Properties preProperties, Properties postProperties, boolean standalone, String jarFileName) {
        String encoding;
        String prefix;
        if (registry != null) {
            Py.writeError("systemState", "trying to reinitialize registry");
            return;
        }
        registry = preProperties;
        String exec_prefix = prefix = PySystemState.findRoot(preProperties, postProperties, jarFileName);
        if (prefix != null) {
            if (prefix.length() == 0) {
                exec_prefix = ".";
                prefix = ".";
            }
            try {
                File homeFile = new File(registry.getProperty("user.home"), ".jython");
                PySystemState.addRegistryFile(homeFile);
                PySystemState.addRegistryFile(new File(prefix, "registry"));
            }
            catch (Exception homeFile) {
                // empty catch block
            }
        }
        if (prefix != null) {
            PySystemState.prefix = Py.newString(prefix);
        }
        if (exec_prefix != null) {
            PySystemState.exec_prefix = Py.newString(exec_prefix);
        }
        try {
            String jythonpath = System.getenv("JYTHONPATH");
            if (jythonpath != null) {
                registry.setProperty("python.path", jythonpath);
            }
        }
        catch (SecurityException jythonpath) {
            // empty catch block
        }
        registry.putAll((Map<?, ?>)postProperties);
        if (standalone && !registry.containsKey(PYTHON_CACHEDIR_SKIP)) {
            registry.put(PYTHON_CACHEDIR_SKIP, "true");
        }
        if (!registry.containsKey(PYTHON_CONSOLE_ENCODING) && (encoding = PySystemState.getPlatformEncoding()) != null) {
            registry.put(PYTHON_CONSOLE_ENCODING, encoding);
        }
        Options.setFromRegistry();
    }

    private static String getPlatformEncoding() {
        String encoding = PySystemState.getConsoleEncoding();
        if (encoding == null) {
            try {
                encoding = System.getProperty("file.encoding");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return encoding;
    }

    private static String getConsoleEncoding() {
        String encoding = null;
        try {
            Class<?> consoleClass = Class.forName("java.io.Console");
            Method encodingMethod = consoleClass.getDeclaredMethod("encoding", new Class[0]);
            encodingMethod.setAccessible(true);
            encoding = (String)encodingMethod.invoke(consoleClass, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addRegistryFile(File file) {
        if (file.exists()) {
            if (!file.isDirectory()) {
                Properties fileProperties = new Properties();
                try {
                    FileInputStream fp = new FileInputStream(file);
                    try {
                        fileProperties.load(fp);
                        for (Map.Entry<Object, Object> kv : fileProperties.entrySet()) {
                            Object key = kv.getKey();
                            if (registry.containsKey(key)) continue;
                            registry.put(key, kv.getValue());
                        }
                    }
                    finally {
                        fp.close();
                    }
                }
                catch (IOException e) {
                    System.err.println("couldn't open registry file: " + file.toString());
                }
            } else {
                System.err.println("warning: " + file.toString() + " is a directory, not a file");
            }
        }
    }

    public static Properties getBaseProperties() {
        try {
            return System.getProperties();
        }
        catch (AccessControlException ace) {
            return new Properties();
        }
    }

    public static synchronized void initialize() {
        PySystemState.initialize(null, null);
    }

    public static synchronized void initialize(Properties preProperties, Properties postProperties) {
        PySystemState.initialize(preProperties, postProperties, new String[]{""});
    }

    public static synchronized void initialize(Properties preProperties, Properties postProperties, String[] argv) {
        PySystemState.initialize(preProperties, postProperties, argv, null);
    }

    public static synchronized void initialize(Properties preProperties, Properties postProperties, String[] argv, ClassLoader classLoader) {
        PySystemState.initialize(preProperties, postProperties, argv, classLoader, new ClassicPyObjectAdapter());
    }

    public static synchronized void initialize(Properties preProperties, Properties postProperties, String[] argv, ClassLoader classLoader, ExtensiblePyObjectAdapter adapter) {
        if (initialized) {
            return;
        }
        if (preProperties == null) {
            preProperties = PySystemState.getBaseProperties();
        }
        if (postProperties == null) {
            postProperties = new Properties();
        }
        try {
            ClassLoader sysStateLoader;
            ClassLoader context = Thread.currentThread().getContextClassLoader();
            if (context != null) {
                if (PySystemState.initialize(preProperties, postProperties, argv, classLoader, adapter, context)) {
                    return;
                }
            } else {
                Py.writeDebug("initializer", "Context class loader null, skipping");
            }
            if ((sysStateLoader = PySystemState.class.getClassLoader()) != null) {
                if (PySystemState.initialize(preProperties, postProperties, argv, classLoader, adapter, sysStateLoader)) {
                    return;
                }
            } else {
                Py.writeDebug("initializer", "PySystemState.class class loader null, skipping");
            }
        }
        catch (UnsupportedCharsetException e) {
            Py.writeWarning("initializer", "Unable to load the UTF-8 charset to read an initializer definition");
            e.printStackTrace(System.err);
        }
        catch (SecurityException e) {
        }
        catch (Exception e) {
            Py.writeWarning("initializer", "Unexpected exception thrown while trying to use initializer service");
            e.printStackTrace(System.err);
        }
        PySystemState.doInitialize(preProperties, postProperties, argv, classLoader, adapter);
    }

    private static boolean initialize(Properties pre, Properties post, String[] argv, ClassLoader sysClassLoader, ExtensiblePyObjectAdapter adapter, ClassLoader initializerClassLoader) {
        Class<?> initializer;
        String className;
        InputStream in = initializerClassLoader.getResourceAsStream(INITIALIZER_SERVICE);
        if (in == null) {
            Py.writeDebug("initializer", "'META-INF/services/org.python.core.JythonInitializer' not found on " + initializerClassLoader);
            return false;
        }
        BufferedReader r = new BufferedReader(new InputStreamReader(in, Charset.forName("UTF-8")));
        try {
            className = r.readLine();
        }
        catch (IOException e) {
            Py.writeWarning("initializer", "Failed reading 'META-INF/services/org.python.core.JythonInitializer' from " + initializerClassLoader);
            e.printStackTrace(System.err);
            return false;
        }
        try {
            initializer = initializerClassLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            Py.writeWarning("initializer", "Specified initializer class '" + className + "' not found, continuing");
            return false;
        }
        try {
            ((JythonInitializer)initializer.newInstance()).initialize(pre, post, argv, sysClassLoader, adapter);
        }
        catch (Exception e) {
            Py.writeWarning("initializer", "Failed initializing with class '" + className + "', continuing");
            e.printStackTrace(System.err);
            return false;
        }
        if (!initialized) {
            Py.writeWarning("initializer", "Initializer '" + className + "' failed to call doInitialize, using default initialization");
        }
        return initialized;
    }

    public static synchronized PySystemState doInitialize(Properties preProperties, Properties postProperties, String[] argv, ClassLoader classLoader, ExtensiblePyObjectAdapter adapter) {
        if (initialized) {
            return Py.defaultSystemState;
        }
        initialized = true;
        Py.setAdapter(adapter);
        boolean standalone = false;
        String jarFileName = PySystemState.getJarFileName();
        if (jarFileName != null) {
            standalone = PySystemState.isStandalone(jarFileName);
        }
        PySystemState.initRegistry(preProperties, postProperties, standalone, jarFileName);
        PySystemState.initBuiltins(registry);
        PySystemState.initStaticFields();
        defaultPath = PySystemState.initPath(registry, standalone, jarFileName);
        defaultArgv = PySystemState.initArgv(argv);
        defaultExecutable = PySystemState.initExecutable(registry);
        PySystemState.initPackages(registry);
        Py.defaultSystemState = new PySystemState();
        Py.setSystemState(Py.defaultSystemState);
        if (classLoader != null) {
            Py.defaultSystemState.setClassLoader(classLoader);
        }
        Py.initClassExceptions(PySystemState.getDefaultBuiltins());
        Py.defaultSystemState.initEncoding();
        new PySyntaxError("", 1, 1, "", "");
        return Py.defaultSystemState;
    }

    private static void initStaticFields() {
        String s;
        Py.None = new PyNone();
        Py.NotImplemented = new PyNotImplemented();
        Py.NoKeywords = new String[0];
        Py.EmptyObjects = new PyObject[0];
        Py.EmptyTuple = new PyTuple(Py.EmptyObjects);
        Py.EmptyFrozenSet = new PyFrozenSet();
        Py.NoConversion = new PySingleton("Error");
        Py.Ellipsis = new PyEllipsis();
        Py.Zero = new PyInteger(0);
        Py.One = new PyInteger(1);
        Py.False = new PyBoolean(false);
        Py.True = new PyBoolean(true);
        Py.EmptyString = new PyString("");
        Py.Newline = new PyString("\n");
        Py.Space = new PyString(" ");
        Py.stderr = new StderrWrapper();
        Py.stdout = new StdoutWrapper();
        if (Version.PY_RELEASE_LEVEL == 10) {
            s = "alpha";
        } else if (Version.PY_RELEASE_LEVEL == 11) {
            s = "beta";
        } else if (Version.PY_RELEASE_LEVEL == 12) {
            s = "candidate";
        } else if (Version.PY_RELEASE_LEVEL == 15) {
            s = "final";
        } else if (Version.PY_RELEASE_LEVEL == 170) {
            s = "snapshot";
        } else {
            throw new RuntimeException("Illegal value for PY_RELEASE_LEVEL: " + Version.PY_RELEASE_LEVEL);
        }
        version_info = new PyTuple(Py.newInteger(Version.PY_MAJOR_VERSION), Py.newInteger(Version.PY_MINOR_VERSION), Py.newInteger(Version.PY_MICRO_VERSION), Py.newString(s), Py.newInteger(Version.PY_RELEASE_SERIAL));
        subversion = new PyTuple(Py.newString("Jython"), Py.newString(Version.BRANCH), Py.newString(Version.SVN_REVISION));
    }

    public static boolean isPackageCacheEnabled() {
        return cachedir != null;
    }

    private static void initCacheDirectory(Properties props) {
        String skip = props.getProperty(PYTHON_CACHEDIR_SKIP, "false");
        if (skip.equalsIgnoreCase("true")) {
            cachedir = null;
            return;
        }
        cachedir = new File(props.getProperty(PYTHON_CACHEDIR, CACHEDIR_DEFAULT_NAME));
        if (!cachedir.isAbsolute()) {
            cachedir = new File(prefix == null ? null : prefix.toString(), cachedir.getPath());
        }
    }

    private static void initPackages(Properties props) {
        PySystemState.initCacheDirectory(props);
        File pkgdir = cachedir != null ? new File(cachedir, "packages") : null;
        packageManager = new SysPackageManager(pkgdir, props);
    }

    private static PyList initArgv(String[] args) {
        PyList argv = new PyList();
        if (args != null) {
            for (String arg : args) {
                argv.append(new PyString(arg));
            }
        }
        return argv;
    }

    private static PyObject initExecutable(Properties props) {
        String executable = props.getProperty("python.executable");
        if (executable == null) {
            return Py.None;
        }
        File executableFile = new File(executable);
        try {
            executableFile = executableFile.getCanonicalFile();
        }
        catch (IOException ioe) {
            executableFile = executableFile.getAbsoluteFile();
        }
        if (!executableFile.isFile()) {
            return Py.None;
        }
        return new PyString(executableFile.getPath());
    }

    private static void addBuiltin(String name) {
        String colon;
        String modname;
        int n = name.indexOf(58);
        if (n != -1) {
            modname = name.substring(0, n).trim();
            colon = name.substring(n + 1, name.length()).trim();
            if (colon.equals("null")) {
                colon = null;
            }
        } else {
            modname = name.trim();
            colon = "org.python.modules." + modname;
        }
        if (colon != null) {
            builtinNames.put(modname, colon);
        } else {
            builtinNames.remove(modname);
        }
    }

    private static void initBuiltins(Properties props) {
        builtinNames = Generic.map();
        builtinNames.put("__builtin__", "");
        builtinNames.put("sys", "");
        for (String builtinModule : Setup.builtinModules) {
            PySystemState.addBuiltin(builtinModule);
        }
        String builtinprop = props.getProperty("python.modules.builtin", "");
        StringTokenizer tok = new StringTokenizer(builtinprop, ",");
        while (tok.hasMoreTokens()) {
            PySystemState.addBuiltin(tok.nextToken());
        }
        int n = builtinNames.size();
        PyObject[] built_mod = new PyObject[n];
        int i = 0;
        for (String key : builtinNames.keySet()) {
            built_mod[i++] = Py.newString(key);
        }
        builtin_module_names = new PyTuple(built_mod);
    }

    public static String getBuiltin(String name) {
        return builtinNames.get(name);
    }

    private static PyList initPath(Properties props, boolean standalone, String jarFileName) {
        PyList path = new PyList();
        PySystemState.addPaths(path, props.getProperty("python.path", ""));
        if (prefix != null) {
            String libpath = new File(prefix.toString(), "Lib").toString();
            path.append(new PyString(libpath));
        }
        if (standalone) {
            PySystemState.addPaths(path, jarFileName + "/Lib");
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isStandalone(String jarFileName) {
        boolean standalone = false;
        if (jarFileName != null) {
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(jarFileName);
                JarEntry jarEntry = jarFile.getJarEntry("Lib/os.py");
                standalone = jarEntry != null;
            }
            catch (IOException iOException) {
            }
            finally {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return standalone;
    }

    private static String getJarFileName() {
        Class<PySystemState> thisClass = PySystemState.class;
        String fullClassName = thisClass.getName();
        String className = fullClassName.substring(fullClassName.lastIndexOf(".") + 1);
        URL url = thisClass.getResource(className + ".class");
        return PySystemState.getJarFileNameFromURL(url);
    }

    protected static String getJarFileNameFromURL(URL url) {
        String jarFileName = null;
        if (url != null) {
            try {
                String path;
                int jarIndex;
                String plus = "\\+";
                String escapedPlus = "__ppluss__";
                String rawUrl = url.toString();
                rawUrl = rawUrl.replaceAll("\\+", "__ppluss__");
                String urlString = URLDecoder.decode(rawUrl, "UTF-8");
                urlString = urlString.replaceAll("__ppluss__", "\\+");
                int jarSeparatorIndex = urlString.lastIndexOf(JAR_SEPARATOR);
                if (urlString.startsWith(JAR_URL_PREFIX) && jarSeparatorIndex > 0) {
                    jarFileName = urlString.substring(JAR_URL_PREFIX.length(), jarSeparatorIndex);
                } else if (urlString.startsWith(VFSZIP_PREFIX) && (jarIndex = urlString.indexOf(".jar/".concat(path = PySystemState.class.getName().replace('.', '/')))) > 0) {
                    jarIndex += 4;
                    int start = VFSZIP_PREFIX.length();
                    if (Platform.IS_WINDOWS) {
                        ++start;
                    }
                    jarFileName = urlString.substring(start, jarIndex);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return jarFileName;
    }

    private static void addPaths(PyList path, String pypath) {
        StringTokenizer tok = new StringTokenizer(pypath, File.pathSeparator);
        while (tok.hasMoreTokens()) {
            path.append(new PyString(tok.nextToken().trim()));
        }
    }

    public static PyJavaPackage add_package(String n) {
        return PySystemState.add_package(n, null);
    }

    public static PyJavaPackage add_package(String n, String contents) {
        return packageManager.makeJavaPackage(n, contents, null);
    }

    public static void add_classdir(String directoryPath) {
        packageManager.addDirectory(new File(directoryPath));
    }

    public static void add_extdir(String directoryPath) {
        packageManager.addJarDir(directoryPath, false);
    }

    public static void add_extdir(String directoryPath, boolean cache) {
        packageManager.addJarDir(directoryPath, cache);
    }

    static void displayhook(PyObject o) {
        if (o == Py.None) {
            return;
        }
        PyObject currentBuiltins = Py.getSystemState().getBuiltins();
        currentBuiltins.__setitem__("_", Py.None);
        Py.stdout.println(o.__repr__());
        currentBuiltins.__setitem__("_", o);
    }

    static void excepthook(PyObject type, PyObject val, PyObject tb) {
        Py.displayException(type, val, tb, null);
    }

    public static void exit(PyObject status) {
        throw new PyException(Py.SystemExit, status);
    }

    public static void exit() {
        PySystemState.exit(Py.None);
    }

    public static PyTuple exc_info() {
        PyException exc = Py.getThreadState().exception;
        if (exc == null) {
            return new PyTuple(Py.None, Py.None, Py.None);
        }
        PyTraceback tb = exc.traceback;
        PyObject value = exc.value;
        return new PyTuple(exc.type, value == null ? Py.None : value, tb == null ? Py.None : tb);
    }

    public static void exc_clear() {
        Py.getThreadState().exception = null;
    }

    public static PyFrame _getframe() {
        return PySystemState._getframe(-1);
    }

    public static PyFrame _getframe(int depth) {
        PyFrame f = Py.getFrame();
        while (depth > 0 && f != null) {
            f = f.f_back;
            --depth;
        }
        if (f == null) {
            throw Py.ValueError("call stack is not deep enough");
        }
        return f;
    }

    public void registerCloser(Callable<Void> resourceCloser) {
        this.closer.registerCloser(resourceCloser);
    }

    public boolean unregisterCloser(Callable<Void> resourceCloser) {
        return this.closer.unregisterCloser(resourceCloser);
    }

    public void cleanup() {
        this.closer.cleanup();
    }

    static {
        copyright = Py.newString("Copyright (c) 2000-2009 Jython Developers.\nAll rights reserved.\n\nCopyright (c) 2000 BeOpen.com.\nAll Rights Reserved.\n\nCopyright (c) 2000 The Apache Software Foundation.\nAll rights reserved.\n\nCopyright (c) 1995-2000 Corporation for National Research Initiatives.\nAll Rights Reserved.\n\nCopyright (c) 1991-1995 Stichting Mathematisch Centrum, Amsterdam.\nAll Rights Reserved.");
        builtin_module_names = null;
        exec_prefix = Py.EmptyString;
        byteorder = new PyString("big");
        initialized = false;
        warnoptions = new PyList();
        platform = new PyString("java");
        systemStateQueue = new ReferenceQueue();
        sysClosers = Generic.concurrentMap();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PySystemStateCloser {
        private final Set<Callable<Void>> resourceClosers = new LinkedHashSet<Callable<Void>>();
        private volatile boolean isCleanup = false;
        private final Thread shutdownHook = this.initShutdownCloser();

        private PySystemStateCloser(PySystemState sys) {
            WeakReference<PySystemState> ref = new WeakReference<PySystemState>(sys, systemStateQueue);
            sysClosers.put(ref, this);
            PySystemStateCloser.cleanupOtherClosers();
        }

        private static void cleanupOtherClosers() {
            Reference ref;
            while ((ref = systemStateQueue.poll()) != null) {
                PySystemStateCloser closer = (PySystemStateCloser)sysClosers.get(ref);
                closer.cleanup();
            }
        }

        private synchronized void registerCloser(Callable<Void> closer) {
            if (!this.isCleanup) {
                this.resourceClosers.add(closer);
            }
        }

        private synchronized boolean unregisterCloser(Callable<Void> closer) {
            return this.resourceClosers.remove(closer);
        }

        private synchronized void cleanup() {
            if (this.isCleanup) {
                return;
            }
            this.isCleanup = true;
            if (this.shutdownHook != null) {
                try {
                    Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            for (Callable<Void> callable : this.resourceClosers) {
                try {
                    callable.call();
                }
                catch (Exception exception) {}
            }
            this.resourceClosers.clear();
        }

        private Thread initShutdownCloser() {
            try {
                ShutdownCloser shutdownHook = new ShutdownCloser();
                Runtime.getRuntime().addShutdownHook(shutdownHook);
                return shutdownHook;
            }
            catch (SecurityException se) {
                Py.writeDebug("PySystemState", "Can't register cleanup closer hook");
                return null;
            }
        }

        private class ShutdownCloser
        extends Thread {
            private ShutdownCloser() {
                super("Jython Shutdown Closer");
            }

            public synchronized void run() {
                if (PySystemStateCloser.this.resourceClosers == null) {
                    return;
                }
                for (Callable callable : PySystemStateCloser.this.resourceClosers) {
                    try {
                        callable.call();
                    }
                    catch (Exception exception) {}
                }
                PySystemStateCloser.this.resourceClosers.clear();
            }
        }
    }

    private static class DefaultBuiltinsHolder {
        static final PyObject builtins = DefaultBuiltinsHolder.fillin();

        private DefaultBuiltinsHolder() {
        }

        static PyObject fillin() {
            PyStringMap temp = new PyStringMap();
            __builtin__.fillWithBuiltins(temp);
            return temp;
        }
    }
}

