/*
 * Decompiled with CFR 0.152.
 */
package org.opengauss.replication;

import java.sql.SQLException;
import java.sql.Statement;
import org.opengauss.core.BaseConnection;
import org.opengauss.replication.PGReplicationConnection;
import org.opengauss.replication.fluent.ChainedCreateReplicationSlotBuilder;
import org.opengauss.replication.fluent.ChainedStreamBuilder;
import org.opengauss.replication.fluent.ReplicationCreateSlotBuilder;
import org.opengauss.replication.fluent.ReplicationStreamBuilder;

public class PGReplicationConnectionImpl
implements PGReplicationConnection {
    private BaseConnection connection;

    public PGReplicationConnectionImpl(BaseConnection connection) {
        this.connection = connection;
    }

    @Override
    public ChainedStreamBuilder replicationStream() {
        return new ReplicationStreamBuilder(this.connection);
    }

    @Override
    public ChainedCreateReplicationSlotBuilder createReplicationSlot() {
        return new ReplicationCreateSlotBuilder(this.connection);
    }

    @Override
    public void dropReplicationSlot(String slotName) throws SQLException {
        if (slotName == null || slotName.isEmpty()) {
            throw new IllegalArgumentException("Replication slot name can't be null or empty");
        }
        try (Statement statement = this.connection.createStatement();){
            statement.execute("DROP_REPLICATION_SLOT " + slotName);
        }
    }
}

