/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.shade.org.bouncycastle.pqc.jcajce.provider.qtesla;

import com.huawei.shade.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.huawei.shade.org.bouncycastle.crypto.CryptoServicesRegistrar;
import com.huawei.shade.org.bouncycastle.pqc.crypto.qtesla.QTESLAKeyGenerationParameters;
import com.huawei.shade.org.bouncycastle.pqc.crypto.qtesla.QTESLAKeyPairGenerator;
import com.huawei.shade.org.bouncycastle.pqc.crypto.qtesla.QTESLAPrivateKeyParameters;
import com.huawei.shade.org.bouncycastle.pqc.crypto.qtesla.QTESLAPublicKeyParameters;
import com.huawei.shade.org.bouncycastle.pqc.crypto.qtesla.QTESLASecurityCategory;
import com.huawei.shade.org.bouncycastle.pqc.jcajce.provider.qtesla.BCqTESLAPrivateKey;
import com.huawei.shade.org.bouncycastle.pqc.jcajce.provider.qtesla.BCqTESLAPublicKey;
import com.huawei.shade.org.bouncycastle.pqc.jcajce.spec.QTESLAParameterSpec;
import com.huawei.shade.org.bouncycastle.util.Integers;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;

public class KeyPairGeneratorSpi
extends KeyPairGenerator {
    private static final Map catLookup = new HashMap();
    private QTESLAKeyGenerationParameters param;
    private QTESLAKeyPairGenerator engine = new QTESLAKeyPairGenerator();
    private SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
    private boolean initialised = false;

    public KeyPairGeneratorSpi() {
        super("qTESLA");
    }

    public void initialize(int n, SecureRandom secureRandom) {
        throw new IllegalArgumentException("use AlgorithmParameterSpec");
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof QTESLAParameterSpec)) {
            throw new InvalidAlgorithmParameterException("parameter object not a QTESLAParameterSpec");
        }
        QTESLAParameterSpec qTESLAParameterSpec = (QTESLAParameterSpec)algorithmParameterSpec;
        this.param = new QTESLAKeyGenerationParameters((Integer)catLookup.get(qTESLAParameterSpec.getSecurityCategory()), secureRandom);
        this.engine.init(this.param);
        this.initialised = true;
    }

    public KeyPair generateKeyPair() {
        if (!this.initialised) {
            this.param = new QTESLAKeyGenerationParameters(6, this.random);
            this.engine.init(this.param);
            this.initialised = true;
        }
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.engine.generateKeyPair();
        QTESLAPublicKeyParameters qTESLAPublicKeyParameters = (QTESLAPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        QTESLAPrivateKeyParameters qTESLAPrivateKeyParameters = (QTESLAPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        return new KeyPair(new BCqTESLAPublicKey(qTESLAPublicKeyParameters), new BCqTESLAPrivateKey(qTESLAPrivateKeyParameters));
    }

    static {
        catLookup.put(QTESLASecurityCategory.getName(5), Integers.valueOf(5));
        catLookup.put(QTESLASecurityCategory.getName(6), Integers.valueOf(6));
    }
}

