/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.shade.org.bouncycastle.asn1.x509;

import com.huawei.shade.org.bouncycastle.asn1.ASN1EncodableVector;
import com.huawei.shade.org.bouncycastle.asn1.ASN1Integer;
import com.huawei.shade.org.bouncycastle.asn1.ASN1Object;
import com.huawei.shade.org.bouncycastle.asn1.ASN1Primitive;
import com.huawei.shade.org.bouncycastle.asn1.ASN1Sequence;
import com.huawei.shade.org.bouncycastle.asn1.ASN1TaggedObject;
import com.huawei.shade.org.bouncycastle.asn1.DERSequence;
import java.math.BigInteger;
import java.util.Enumeration;

public class DSAParameter
extends ASN1Object {
    ASN1Integer p;
    ASN1Integer q;
    ASN1Integer g;

    public static DSAParameter getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DSAParameter.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static DSAParameter getInstance(Object object) {
        if (object instanceof DSAParameter) {
            return (DSAParameter)object;
        }
        if (object != null) {
            return new DSAParameter(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public DSAParameter(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        this.p = new ASN1Integer(bigInteger);
        this.q = new ASN1Integer(bigInteger2);
        this.g = new ASN1Integer(bigInteger3);
    }

    private DSAParameter(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() != 3) {
            throw new IllegalArgumentException("Bad sequence size: " + aSN1Sequence.size());
        }
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.p = ASN1Integer.getInstance(enumeration.nextElement());
        this.q = ASN1Integer.getInstance(enumeration.nextElement());
        this.g = ASN1Integer.getInstance(enumeration.nextElement());
    }

    public BigInteger getP() {
        return this.p.getPositiveValue();
    }

    public BigInteger getQ() {
        return this.q.getPositiveValue();
    }

    public BigInteger getG() {
        return this.g.getPositiveValue();
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(3);
        aSN1EncodableVector.add(this.p);
        aSN1EncodableVector.add(this.q);
        aSN1EncodableVector.add(this.g);
        return new DERSequence(aSN1EncodableVector);
    }
}

