/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql;

import com.huawei.shade.com.alibaba.fastjson.JSONObject;
import com.huawei.shade.com.cloud.apigateway.sdk.utils.Client;
import com.huawei.shade.com.cloud.apigateway.sdk.utils.Request;
import com.huawei.shade.com.cloud.sdk.http.HttpMethodName;
import com.huawei.shade.org.apache.http.client.methods.CloseableHttpResponse;
import com.huawei.shade.org.apache.http.client.methods.HttpRequestBase;
import com.huawei.shade.org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import com.huawei.shade.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import com.huawei.shade.org.apache.http.conn.ssl.SSLContexts;
import com.huawei.shade.org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import com.huawei.shade.org.apache.http.conn.ssl.X509HostnameVerifier;
import com.huawei.shade.org.apache.http.impl.client.CloseableHttpClient;
import com.huawei.shade.org.apache.http.impl.client.HttpClients;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import org.postgresql.PGProperty;
import org.postgresql.QueryCNListUtils;
import org.postgresql.hostchooser.MultiHostChooser;
import org.postgresql.jdbc.PgConnection;
import org.postgresql.log.Log;
import org.postgresql.log.Logger;
import org.postgresql.util.ExpressionProperties;
import org.postgresql.util.GT;
import org.postgresql.util.HostSpec;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.SharedTimer;
import org.postgresql.util.URLCoder;
import org.postgresql.util.WriterHandler;

public class Driver
implements java.sql.Driver {
    private static Driver registeredDriver;
    private static final java.util.logging.Logger PARENT_LOGGER;
    private static Log LOGGER;
    private static SharedTimer sharedTimer;
    private static final String DEFAULT_PORT = "5431";
    private static CloseableHttpClient client;
    private static final String gsVersion = "compiled at 2020-12-31-20:48:13 build 4f82f62";
    public static AtomicBoolean isLogFileCreated;
    private Properties defaultProperties;
    private static String loggerHandlerFile;

    private synchronized Properties getDefaultProperties() throws IOException {
        if (this.defaultProperties != null) {
            return this.defaultProperties;
        }
        try {
            this.defaultProperties = AccessController.doPrivileged(new PrivilegedExceptionAction<Properties>(){

                @Override
                public Properties run() throws IOException {
                    return Driver.this.loadDefaultProperties();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
        return this.defaultProperties;
    }

    private Properties loadDefaultProperties() throws IOException {
        Properties merged = new Properties();
        try {
            PGProperty.USER.set(merged, System.getProperty("user.name"));
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        ClassLoader cl = this.getClass().getClassLoader();
        if (cl == null) {
            LOGGER.debug("Can't find our classloader for the Driver; attempt to use the system class loader");
            cl = ClassLoader.getSystemClassLoader();
        }
        if (cl == null) {
            LOGGER.warn("Can't find a classloader for the Driver; not loading driver configuration from org/postgresql/driverconfig.properties");
            return merged;
        }
        LOGGER.debug("Loading driver configuration via classloader " + cl);
        ArrayList<URL> urls = new ArrayList<URL>();
        Enumeration<URL> urlEnum = cl.getResources("org/postgresql/driverconfig.properties");
        while (urlEnum.hasMoreElements()) {
            urls.add(urlEnum.nextElement());
        }
        for (int i = urls.size() - 1; i >= 0; --i) {
            URL url = (URL)urls.get(i);
            LOGGER.debug("Loading driver configuration from: " + url);
            InputStream is = url.openStream();
            merged.load(is);
            is.close();
        }
        return merged;
    }

    public static Properties GetProps(Properties defaults, Properties info) throws PSQLException {
        Properties newProps = new Properties(defaults);
        if (info != null) {
            Set<String> e = info.stringPropertyNames();
            for (String propName : e) {
                String propValue = info.getProperty(propName);
                if (propValue == null) {
                    throw new PSQLException(GT.tr("Properties for the driver contains a non-string value for the key ", new Object[0]) + propName, PSQLState.UNEXPECTED_ERROR);
                }
                newProps.setProperty(propName, propValue);
            }
        }
        return newProps;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        Properties defaults;
        if (!url.startsWith("jdbc:postgresql:") && !url.startsWith("jdbc:dws:iam:")) {
            return null;
        }
        try {
            defaults = this.getDefaultProperties();
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("Error loading default settings from driverconfig.properties", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)ioe);
        }
        Properties props = Driver.GetProps(defaults, info);
        props = Driver.parseURL(url, props);
        if (props == null) {
            return null;
        }
        Logger.setLoggerName(props.getProperty("logger"));
        if (Logger.isUsingJDKLogger()) {
            this.setupLoggerFromProperties(props);
        } else {
            LOGGER = Logger.getLogger("org.postgresql.Driver");
        }
        if (MultiHostChooser.isUsingAutoLoadBalance(props)) {
            if (!MultiHostChooser.isVaildPriorityLoadBalance(props)) {
                return null;
            }
            QueryCNListUtils.refreshProperties(props);
        }
        try {
            LOGGER.debug("Connecting with URL: " + url);
            long timeout = Driver.timeout(props);
            if (timeout <= 0L) {
                Connection con = Driver.makeConnection(url, props);
                return con;
            }
            ConnectThread ct = new ConnectThread(url, props);
            Thread thread = new Thread((Runnable)ct, "PostgreSQL JDBC driver connection thread");
            thread.setDaemon(true);
            thread.start();
            return ct.getResult(timeout);
        }
        catch (PSQLException ex1) {
            LOGGER.debug("Connection error: ", ex1);
            throw ex1;
        }
        catch (AccessControlException ace) {
            throw new PSQLException(GT.tr("Your security policy has prevented the connection from being attempted.  You probably need to grant the connect java.net.SocketPermission to the database server host and port that you wish to connect to.", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)ace);
        }
        catch (Exception ex2) {
            LOGGER.debug("Unexpected connection error: ", ex2);
            throw new PSQLException(GT.tr("Something unusual has occured to cause the driver to fail. Please report this exception.", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)ex2);
        }
    }

    private Boolean initLoggerProperties(String driverLogLevel) {
        if (driverLogLevel == null) {
            return false;
        }
        if (!"OFF".equalsIgnoreCase(driverLogLevel) && !isLogFileCreated.compareAndSet(false, true)) {
            return false;
        }
        if ("OFF".equalsIgnoreCase(driverLogLevel)) {
            PARENT_LOGGER.setLevel(Level.OFF);
            return false;
        }
        if ("DEBUG".equalsIgnoreCase(driverLogLevel)) {
            PARENT_LOGGER.setLevel(Level.FINE);
        } else if ("TRACE".equalsIgnoreCase(driverLogLevel)) {
            PARENT_LOGGER.setLevel(Level.FINEST);
        } else if ("INFO".equalsIgnoreCase(driverLogLevel)) {
            PARENT_LOGGER.setLevel(Level.INFO);
        } else {
            PARENT_LOGGER.setLevel(Level.OFF);
        }
        return true;
    }

    private void setupLoggerFromProperties(Properties props) {
        String driverLogLevel = PGProperty.LOGGER_LEVEL.get(props);
        if (!this.initLoggerProperties(driverLogLevel).booleanValue()) {
            return;
        }
        ExpressionProperties exprProps = new ExpressionProperties(props, System.getProperties());
        String driverLogFile = PGProperty.LOGGER_FILE.get(exprProps);
        if (driverLogFile != null && driverLogFile.equals(loggerHandlerFile)) {
            return;
        }
        for (Handler handlers : PARENT_LOGGER.getHandlers()) {
            handlers.close();
            PARENT_LOGGER.removeHandler(handlers);
            loggerHandlerFile = null;
        }
        Handler handler = null;
        if (driverLogFile != null) {
            try {
                handler = new FileHandler(driverLogFile);
                loggerHandlerFile = driverLogFile;
            }
            catch (Exception ex) {
                System.err.println("Cannot enable FileHandler, fallback to ConsoleHandler.");
            }
        }
        SimpleFormatter formatter = new SimpleFormatter();
        if (handler == null) {
            handler = DriverManager.getLogWriter() != null ? new WriterHandler(DriverManager.getLogWriter()) : (DriverManager.getLogStream() != null ? new StreamHandler(DriverManager.getLogStream(), formatter) : new StreamHandler(System.err, formatter));
        } else {
            handler.setFormatter(formatter);
        }
        handler.setLevel(PARENT_LOGGER.getLevel());
        PARENT_LOGGER.setUseParentHandlers(false);
        PARENT_LOGGER.addHandler(handler);
    }

    private static Connection makeConnection(String url, Properties props) throws SQLException {
        PgConnection pgConnection = new PgConnection(Driver.hostSpecs(props), Driver.user(props), Driver.database(props), props, url);
        return pgConnection;
    }

    @Override
    public boolean acceptsURL(String url) throws PSQLException {
        return Driver.parseURL(url, null) != null;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws PSQLException {
        Properties copy = new Properties(info);
        Properties parse = Driver.parseURL(url, copy);
        if (parse != null) {
            copy = parse;
        }
        PGProperty[] knownProperties = PGProperty.values();
        DriverPropertyInfo[] props = new DriverPropertyInfo[knownProperties.length];
        for (int i = 0; i < props.length; ++i) {
            props[i] = knownProperties[i].toDriverPropertyInfo(copy);
        }
        return props;
    }

    @Override
    public int getMajorVersion() {
        return 42;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Deprecated
    public static String getVersion() {
        return "PostgreSQL JDBC Driver /*$mvn.project.property.parsedversion.osgiversion$*/";
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    public static String parseIPValid(String address) {
        if (address == "" || address == null) {
            return address;
        }
        String regex = "^(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|[1-9])\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)$";
        Pattern pattern = Pattern.compile(regex);
        if (!pattern.matcher(address).matches()) {
            LOGGER.debug("JDBC URL invalid ip address: " + address);
        }
        return address;
    }

    public static Properties parseURL(String url, Properties defaults) throws PSQLException {
        Properties urlProps = new Properties(defaults);
        String l_urlServer = url;
        String l_urlArgs = "";
        int l_qPos = url.indexOf(63);
        if (l_qPos != -1) {
            l_urlServer = url.substring(0, l_qPos);
            l_urlArgs = url.substring(l_qPos + 1);
        }
        if (!l_urlServer.startsWith("jdbc:postgresql:") && !l_urlServer.startsWith("jdbc:dws:iam:")) {
            LOGGER.debug("JDBC URL must start with \"jdbc:postgresql:\" or \"jdbc:dws:iam:\" but was: " + url);
            return null;
        }
        if (l_urlServer.startsWith("jdbc:postgresql:")) {
            String[] args;
            if ((l_urlServer = l_urlServer.substring("jdbc:postgresql:".length())).startsWith("//")) {
                int slash = (l_urlServer = l_urlServer.substring(2)).indexOf(47);
                if (slash == -1) {
                    LOGGER.warn("JDBC URL must contain a / at the end of the host or port: " + url);
                    return null;
                }
                urlProps.setProperty("PGDBNAME", URLCoder.decode(l_urlServer.substring(slash + 1)));
                String[] addresses = l_urlServer.substring(0, slash).split(",");
                StringBuilder hosts = new StringBuilder();
                StringBuilder ports = new StringBuilder();
                for (String address : addresses) {
                    int portIdx = address.lastIndexOf(58);
                    if (portIdx != -1 && address.lastIndexOf(93) < portIdx) {
                        String portStr = address.substring(portIdx + 1);
                        try {
                            int port = Integer.parseInt(portStr);
                            if (port < 1 || port > 65535) {
                                LOGGER.warn("JDBC URL port: " + portStr + " not valid (1:65535) ");
                                return null;
                            }
                        }
                        catch (NumberFormatException ignore) {
                            LOGGER.warn("JDBC URL invalid port number: " + portStr);
                            return null;
                        }
                        ports.append(portStr);
                        hosts.append(Driver.parseIPValid((String)address.subSequence(0, portIdx)));
                    } else {
                        ports.append(DEFAULT_PORT);
                        hosts.append(Driver.parseIPValid(address));
                    }
                    ports.append(',');
                    hosts.append(',');
                }
                ports.setLength(ports.length() - 1);
                hosts.setLength(hosts.length() - 1);
                urlProps.setProperty("PGHOST", hosts.toString());
                urlProps.setProperty("PGPORT", ports.toString());
                urlProps.setProperty("PGHOSTURL", hosts.toString());
                urlProps.setProperty("PGPORTURL", ports.toString());
            } else {
                if (defaults == null || !defaults.containsKey("PGPORT")) {
                    urlProps.setProperty("PGPORT", DEFAULT_PORT);
                }
                if (defaults == null || !defaults.containsKey("PGHOST")) {
                    urlProps.setProperty("PGHOST", "localhost");
                }
                if (defaults == null || !defaults.containsKey("PGDBNAME")) {
                    urlProps.setProperty("PGDBNAME", URLCoder.decode(l_urlServer));
                }
            }
            for (String token : args = l_urlArgs.split("&")) {
                if (token.isEmpty()) continue;
                int l_pos = token.indexOf(61);
                if (l_pos == -1) {
                    urlProps.setProperty(token, "");
                    continue;
                }
                urlProps.setProperty(token.substring(0, l_pos), URLCoder.decode(token.substring(l_pos + 1)));
            }
            return urlProps;
        }
        StringBuffer tmp = new StringBuffer();
        l_urlServer = l_urlServer.substring("jdbc:dws:iam:".length());
        String ClusterIdentifier = "";
        String region = "";
        String DbUser = "";
        String AutoCreate = "";
        String AccessKeyID = "";
        String SecretAccessKey = "";
        if (l_urlServer.startsWith("//")) {
            int slash = (l_urlServer = l_urlServer.substring(2)).indexOf(47);
            if (slash == -1) {
                return null;
            }
            urlProps.setProperty("PGDBNAME", l_urlServer.substring(slash + 1));
            String serverurl = l_urlServer.substring(0, slash);
            String[] clusterurl = serverurl.split(":");
            if (clusterurl.length != 2) {
                return null;
            }
            ClusterIdentifier = clusterurl[0];
            region = clusterurl[1];
        }
        String[] args = l_urlArgs.split("&");
        for (int i = 0; i < args.length; ++i) {
            String token = args[i];
            if (token.length() == 0) continue;
            int l_pos = token.indexOf(61);
            if (l_pos == -1) {
                urlProps.setProperty(token, "");
                continue;
            }
            if (token.substring(0, l_pos).equals("AccessKeyID")) {
                AccessKeyID = token.substring(l_pos + 1);
                continue;
            }
            if (token.substring(0, l_pos).equals("SecretAccessKey")) {
                SecretAccessKey = token.substring(l_pos + 1);
                continue;
            }
            if (token.substring(0, l_pos).equals("DbUser")) {
                DbUser = token.substring(l_pos + 1);
                continue;
            }
            if (token.substring(0, l_pos).equals("AutoCreate")) {
                AutoCreate = token.substring(l_pos + 1);
                continue;
            }
            tmp.append("&" + token.substring(0, l_pos) + "=" + token.substring(l_pos + 1));
        }
        StringBuffer jdbcUrl = new StringBuffer();
        if (region.equals("") || ClusterIdentifier.equals("") || DbUser.equals("") || AccessKeyID.equals("") || SecretAccessKey.equals("")) {
            throw new PSQLException(GT.tr("Please confirm that all the parameters needed is added to the url.", new Object[0]), PSQLState.CONNECTION_REJECTED);
        }
        InputStream in = null;
        Properties props = new Properties();
        String domainName = "";
        try {
            File f = new File(Driver.class.getClassLoader().getResource("").getPath());
            String filePath = f.getParent() + File.separator + "config" + File.separator + "jdbcconfig.properties";
            in = new BufferedInputStream(new FileInputStream(filePath));
            props = new Properties();
            props.load(in);
            domainName = props.getProperty(region);
            in.close();
        }
        catch (Exception e) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {
                    LOGGER.warn(ioe.getMessage());
                }
            }
            try {
                props = new Properties();
                in = Driver.class.getResourceAsStream("/org/postgresql/jdbcconfig.properties");
                props.load(in);
                domainName = props.getProperty(region);
                in.close();
            }
            catch (Exception e1) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ioe) {
                        LOGGER.warn(ioe.getMessage());
                    }
                }
                throw new PSQLException(GT.tr("Parse jdbcconfig.properties failed.", new Object[0]), PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)e1);
            }
        }
        if (domainName == null || domainName.equals("")) {
            throw new PSQLException(GT.tr("Unrecognized region name.", new Object[0]), PSQLState.CONNECTION_REJECTED);
        }
        jdbcUrl.append("https://" + domainName + "/credentials?");
        jdbcUrl.append("clusterName=" + ClusterIdentifier);
        jdbcUrl.append("&dbUser=" + DbUser);
        if (!AutoCreate.equals("")) {
            jdbcUrl.append("&autoCreate=" + AutoCreate);
        }
        jdbcUrl.append(tmp.toString());
        String jsonstr = "";
        jsonstr = Driver.getReturn(AccessKeyID, SecretAccessKey, jdbcUrl.toString(), region);
        try {
            JSONObject jsonObj = JSONObject.parseObject(jsonstr);
            if (jsonObj.get("cluster_credentials") != null) {
                jsonstr = jsonObj.get("cluster_credentials").toString();
                if ((jsonObj = JSONObject.parseObject(jsonstr)).get("db_user") != null) {
                    urlProps.setProperty("user", jsonObj.get("db_user").toString());
                }
                if (jsonObj.get("db_endpoint") != null) {
                    urlProps.setProperty("PGHOST", jsonObj.get("db_endpoint").toString());
                }
                if (jsonObj.get("db_port") != null) {
                    urlProps.setProperty("PGPORT", jsonObj.get("db_port").toString());
                }
                if (jsonObj.get("db_password") != null) {
                    urlProps.setProperty("password", jsonObj.get("db_password").toString());
                }
            } else {
                if (jsonObj.get("externalMessage") != null) {
                    throw new PSQLException(GT.tr(jsonObj.get("externalMessage").toString(), new Object[0]), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
                }
                throw new PSQLException(GT.tr("The format of Token is not as expected.", new Object[0]), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
            }
            urlProps.setProperty("PGHOSTURL", urlProps.getProperty("PGHOST"));
            urlProps.setProperty("PGPORTURL", urlProps.getProperty("PGPORT"));
        }
        catch (Exception e) {
            throw new PSQLException(GT.tr("Parse the token failed.", new Object[0]), PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)e);
        }
        if (urlProps.getProperty("ssl") == null && urlProps.getProperty("sslmode") == null) {
            urlProps.setProperty("sslmode", "require");
        }
        return urlProps;
    }

    private static Request getRequest(URL url, String ak, String sk) throws Exception {
        Request request = new Request();
        request.setUrl(url.toString());
        request.setKey(ak);
        request.setSecret(sk);
        return request;
    }

    private static String getReturn(String ak, String sk, String requestUrl, String region) throws PSQLException {
        try {
            URL url = new URL(requestUrl);
            HttpMethodName httpMethod = HttpMethodName.GET;
            Request request = Driver.getRequest(url, ak, sk);
            request.setMethod(httpMethod.toString());
            request.addHeader("X-Language", "en-us");
            request.addHeader("Content-Type", "application/json");
            request.addHeader("Accept", "application/json");
            HttpRequestBase signedRequest = Client.sign(request);
            CloseableHttpResponse response = null;
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, new TrustSelfSignedStrategy()).useTLS().build();
            SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (X509HostnameVerifier)new AllowAllHostnameVerifier());
            client = HttpClients.custom().setSSLSocketFactory(sslSocketFactory).build();
            response = client.execute(signedRequest);
            String string = Driver.convertStreamToString(response.getEntity().getContent());
            return string;
        }
        catch (Exception e) {
            throw new PSQLException(GT.tr("Get the token failed.", new Object[0]), PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)e);
        }
        finally {
            try {
                if (client != null) {
                    client.close();
                }
            }
            catch (IOException e) {
                LOGGER.warn("Catch IOException, client close failed.");
            }
        }
    }

    private static String convertStreamToString(InputStream is) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
        }
        catch (IOException ioEX) {
            throw ioEX;
        }
        finally {
            is.close();
        }
        return sb.toString();
    }

    public static HostSpec[] GetHostSpecs(Properties props) {
        return Driver.hostSpecs(props);
    }

    public static HostSpec[] getURLHostSpecs(Properties props) {
        return Driver.urlHostSpecs(props);
    }

    public static String GetUser(Properties props) {
        return Driver.user(props);
    }

    public static String GetDatabase(Properties props) {
        return Driver.database(props);
    }

    private static HostSpec[] urlHostSpecs(Properties props) {
        String[] ports = props.getProperty("PGPORTURL").split(",");
        String[] hosts = props.getProperty("PGHOSTURL").split(",", ports.length);
        HostSpec[] hostSpecs = new HostSpec[hosts.length];
        for (int i = 0; i < hostSpecs.length; ++i) {
            hostSpecs[i] = new HostSpec(hosts[i], Integer.parseInt(ports[i]));
        }
        return hostSpecs;
    }

    private static HostSpec[] hostSpecs(Properties props) {
        String[] ports = props.getProperty("PGPORT").split(",");
        String[] hosts = props.getProperty("PGHOST").split(",", ports.length);
        HostSpec[] hostSpecs = new HostSpec[hosts.length];
        for (int i = 0; i < hostSpecs.length; ++i) {
            hostSpecs[i] = new HostSpec(hosts[i], Integer.parseInt(ports[i]));
        }
        return hostSpecs;
    }

    private static String user(Properties props) {
        return props.getProperty("user", "");
    }

    private static String database(Properties props) {
        return props.getProperty("PGDBNAME", "");
    }

    private static long timeout(Properties props) {
        String timeout = PGProperty.LOGIN_TIMEOUT.get(props);
        if (timeout != null) {
            try {
                return (long)(Float.parseFloat(timeout) * 1000.0f);
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Couldn't parse loginTimeout value: " + timeout);
            }
        }
        return (long)DriverManager.getLoginTimeout() * 1000L;
    }

    public static SQLFeatureNotSupportedException notImplemented(Class<?> callClass, String functionName) {
        return new SQLFeatureNotSupportedException(GT.tr("Method {0} is not yet implemented.", callClass.getName() + "." + functionName), PSQLState.NOT_IMPLEMENTED.getState());
    }

    @Override
    public java.util.logging.Logger getParentLogger() {
        if (Logger.isUsingJDKLogger()) {
            return PARENT_LOGGER;
        }
        return null;
    }

    public static SharedTimer getSharedTimer() {
        return sharedTimer;
    }

    public static void register() throws SQLException {
        if (Driver.isRegistered()) {
            throw new IllegalStateException("Driver is already registered. It can only be registered once.");
        }
        registeredDriver = new Driver();
        DriverManager.registerDriver(registeredDriver);
        isLogFileCreated = new AtomicBoolean(false);
    }

    public static void deregister() throws SQLException {
        if (!Driver.isRegistered()) {
            throw new IllegalStateException("Driver is not registered (or it has not been registered using Driver.register() method)");
        }
        DriverManager.deregisterDriver(registeredDriver);
        registeredDriver = null;
    }

    public static boolean isRegistered() {
        return registeredDriver != null;
    }

    public static String getGSVersion() {
        return gsVersion;
    }

    static {
        PARENT_LOGGER = java.util.logging.Logger.getLogger("org.postgresql");
        LOGGER = Logger.getLogger("org.postgresql.Driver");
        sharedTimer = new SharedTimer();
        client = null;
        try {
            Driver.register();
        }
        catch (SQLException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static class ConnectThread
    implements Runnable {
        private final String url;
        private final Properties props;
        private Connection result;
        private Throwable resultException;
        private boolean abandoned;

        ConnectThread(String url, Properties props) {
            this.url = url;
            this.props = props;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Throwable error;
            Connection conn;
            try {
                conn = Driver.makeConnection(this.url, this.props);
                error = null;
            }
            catch (Throwable t) {
                conn = null;
                error = t;
            }
            ConnectThread connectThread = this;
            synchronized (connectThread) {
                if (this.abandoned) {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                } else {
                    this.result = conn;
                    this.resultException = error;
                    this.notify();
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Connection getResult(long timeout) throws SQLException {
            long expiry = System.currentTimeMillis() + timeout;
            ConnectThread connectThread = this;
            synchronized (connectThread) {
                while (this.result == null) {
                    if (this.resultException != null) {
                        if (this.resultException instanceof SQLException) {
                            this.resultException.fillInStackTrace();
                            throw (SQLException)this.resultException;
                        }
                        throw new PSQLException(GT.tr("Something unusual has occured to cause the driver to fail. Please report this exception.", new Object[0]), PSQLState.UNEXPECTED_ERROR, this.resultException);
                    }
                    long delay = expiry - System.currentTimeMillis();
                    if (delay <= 0L) {
                        this.abandoned = true;
                        throw new PSQLException(GT.tr("Connection attempt timed out.", new Object[0]), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
                    }
                    try {
                        this.wait(delay);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        this.abandoned = true;
                        throw new RuntimeException(GT.tr("Interrupted while attempting to connect.", new Object[0]));
                    }
                }
                return this.result;
            }
        }
    }
}

