/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.kitesdk.data.DatasetIOException;
import org.kitesdk.data.spi.Constraints;
import org.kitesdk.shaded.com.google.common.base.Joiner;

public class SignalManager {
    private final Path signalDirectory;
    private final FileSystem rootFileSystem;
    private static final String UNBOUNDED_CONSTRAINT = "unbounded";

    public SignalManager(FileSystem fileSystem, Path signalDirectory) {
        this.signalDirectory = signalDirectory;
        this.rootFileSystem = fileSystem;
    }

    public void signalReady(Constraints viewConstraints) {
        try {
            this.rootFileSystem.mkdirs(this.signalDirectory);
        }
        catch (IOException e) {
            throw new DatasetIOException("Unable to create signal manager directory: " + this.signalDirectory, e);
        }
        String normalizedConstraints = SignalManager.getNormalizedConstraints(viewConstraints);
        Path signalPath = new Path(this.signalDirectory, normalizedConstraints);
        try {
            FSDataOutputStream os = this.rootFileSystem.create(signalPath, true);
            os.close();
        }
        catch (IOException e) {
            throw new DatasetIOException("Could not access signal path: " + signalPath, e);
        }
    }

    public long getReadyTimestamp(Constraints viewConstraints) {
        String normalizedConstraints = SignalManager.getNormalizedConstraints(viewConstraints);
        Path signalPath = new Path(this.signalDirectory, normalizedConstraints);
        try {
            try {
                FileStatus signalStatus = this.rootFileSystem.getFileStatus(signalPath);
                return signalStatus.getModificationTime();
            }
            catch (FileNotFoundException signalStatus) {
                return -1L;
            }
        }
        catch (IOException e) {
            throw new DatasetIOException("Could not access signal path: " + signalPath, e);
        }
    }

    public static String getNormalizedConstraints(Constraints constraints) {
        if (constraints.isUnbounded()) {
            return UNBOUNDED_CONSTRAINT;
        }
        Map<String, String> orderedConstraints = constraints.toNormalizedQueryMap();
        ArrayList<String> parts = new ArrayList<String>();
        for (Map.Entry<String, String> entry : orderedConstraints.entrySet()) {
            StringBuilder builder = new StringBuilder();
            String key = entry.getKey();
            String value = entry.getValue();
            builder.append(key);
            builder.append("=");
            if (value != null) {
                builder.append(value);
            }
            parts.add(builder.toString());
        }
        return Joiner.on('&').join(parts);
    }
}

