/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.hbase.tool;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.util.Bytes;
import org.kitesdk.data.DatasetException;
import org.kitesdk.data.ValidationException;
import org.kitesdk.data.hbase.avro.AvroEntitySchema;
import org.kitesdk.data.hbase.avro.AvroKeyEntitySchemaParser;
import org.kitesdk.data.hbase.avro.AvroKeySchema;
import org.kitesdk.data.hbase.avro.AvroUtils;
import org.kitesdk.data.hbase.impl.Constants;
import org.kitesdk.data.hbase.impl.KeySchema;
import org.kitesdk.data.hbase.impl.SchemaManager;
import org.kitesdk.shaded.com.google.common.collect.ArrayListMultimap;
import org.kitesdk.shaded.com.google.common.collect.ImmutableList;
import org.kitesdk.shaded.com.google.common.collect.Lists;
import org.kitesdk.shaded.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaTool {
    private static final int MAX_SECOND_WAIT_FOR_TABLE_CREATION = 600;
    private static final Logger LOG = LoggerFactory.getLogger(SchemaTool.class);
    private static final String CLASSPATH_PREFIX = "classpath:";
    private static final AvroKeyEntitySchemaParser parser = new AvroKeyEntitySchemaParser();
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final JsonFactory factory = mapper.getJsonFactory();
    private final SchemaManager schemaManager;
    private final HBaseAdmin hbaseAdmin;

    public SchemaTool(HBaseAdmin hbaseAdmin, SchemaManager entityManager) {
        this.hbaseAdmin = hbaseAdmin;
        this.schemaManager = entityManager;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createOrMigrateSchemaDirectory(String schemaDirectory, boolean createTableAndFamilies) throws InterruptedException {
        List<String> schemaStrings;
        block14: {
            if (schemaDirectory.startsWith(CLASSPATH_PREFIX)) {
                URL dirURL = this.getClass().getClassLoader().getResource(schemaDirectory.substring(CLASSPATH_PREFIX.length()));
                if (dirURL != null && dirURL.getProtocol().equals("file")) {
                    try {
                        schemaStrings = this.getSchemaStringsFromDir(new File(dirURL.toURI()));
                    }
                    catch (URISyntaxException e) {
                        throw new DatasetException(e);
                    }
                }
                if (dirURL != null && dirURL.getProtocol().equals("jar")) {
                    String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
                    schemaStrings = this.getSchemaStringsFromJar(jarPath, schemaDirectory.substring(CLASSPATH_PREFIX.length()));
                    break block14;
                } else {
                    String msg = "Could not find classpath resource: " + schemaDirectory;
                    LOG.error(msg);
                    throw new DatasetException(msg);
                }
            }
            schemaStrings = this.getSchemaStringsFromDir(new File(schemaDirectory));
        }
        HashMap tableEntitySchemaMap = new HashMap();
        Iterator<Object> msg = schemaStrings.iterator();
        block2: while (true) {
            if (!msg.hasNext()) {
                for (Map.Entry entry : tableEntitySchemaMap.entrySet()) {
                    String table = (String)entry.getKey();
                    List entitySchemas = (List)entry.getValue();
                    if (entitySchemas.size() != 0) continue;
                    String msg2 = "Table requested, but no entity schemas for Table: " + table;
                    LOG.error(msg2);
                    throw new ValidationException(msg2);
                }
                ArrayList<HTableDescriptor> tableDescriptors = Lists.newArrayList();
                for (Map.Entry entry : tableEntitySchemaMap.entrySet()) {
                    String table = (String)entry.getKey();
                    for (String entitySchemaString : (List)entry.getValue()) {
                        boolean migrationRequired = this.prepareManagedSchema(table, entitySchemaString);
                        if (!migrationRequired) continue;
                        tableDescriptors.add(this.prepareTableDescriptor(table, entitySchemaString));
                    }
                }
                if (createTableAndFamilies) {
                    this.createTables(tableDescriptors);
                }
                return;
            }
            String string = msg.next();
            List<String> tables = this.getTablesFromSchemaString(string);
            Iterator<String> iterator = tables.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block2;
                String table = iterator.next();
                if (tableEntitySchemaMap.containsKey(table)) {
                    ((List)tableEntitySchemaMap.get(table)).add(string);
                    continue;
                }
                ArrayList<String> entityList = new ArrayList<String>();
                entityList.add(string);
                tableEntitySchemaMap.put(table, entityList);
            }
            break;
        }
    }

    public void createOrMigrateSchemaFile(String tableName, String entitySchemaFilePath, boolean createTableAndFamilies) throws InterruptedException {
        this.createOrMigrateSchemaFile(tableName, new File(entitySchemaFilePath), createTableAndFamilies);
    }

    public void createOrMigrateSchemaFile(String tableName, File entitySchemaFile, boolean createTableAndFamilies) throws InterruptedException {
        this.createOrMigrateSchema(tableName, this.getSchemaStringFromFile(entitySchemaFile), createTableAndFamilies);
    }

    public void createOrMigrateSchema(String tableName, String entitySchemaString, boolean createTableAndFamilies) throws InterruptedException {
        boolean migrationRequired = this.prepareManagedSchema(tableName, entitySchemaString);
        if (migrationRequired && createTableAndFamilies) {
            try {
                HTableDescriptor descriptor = this.prepareTableDescriptor(tableName, entitySchemaString);
                if (this.hbaseAdmin.isTableAvailable(tableName)) {
                    this.modifyTable(tableName, descriptor);
                } else {
                    this.createTable(descriptor);
                }
            }
            catch (IOException e) {
                throw new DatasetException(e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean prepareManagedSchema(String tableName, String entitySchemaString) {
        String entityName = this.getEntityNameFromSchemaString(entitySchemaString);
        AvroEntitySchema entitySchema = parser.parseEntitySchema(entitySchemaString);
        AvroKeySchema keySchema = parser.parseKeySchema(entitySchemaString);
        if (!this.schemaManager.hasManagedSchema(tableName, entityName)) {
            LOG.info("Creating Schema: (" + tableName + ", " + entityName + ")");
            parser.parseEntitySchema(entitySchemaString).getColumnMappingDescriptor().getRequiredColumnFamilies();
            this.schemaManager.createSchema(tableName, entityName, entitySchemaString, "org.kitesdk.data.hbase.avro.AvroKeyEntitySchemaParser", "org.kitesdk.data.hbase.avro.AvroKeySerDe", "org.kitesdk.data.hbase.avro.AvroEntitySerDe");
            return true;
        }
        KeySchema currentKeySchema = this.schemaManager.getKeySchema(tableName, entityName);
        if (!keySchema.equals(currentKeySchema)) {
            String msg = "Migrating schema with different keys. Current: " + currentKeySchema.getRawSchema() + " New: " + keySchema.getRawSchema();
            LOG.error(msg);
            throw new ValidationException(msg);
        }
        if (!this.schemaManager.hasSchemaVersion(tableName, entityName, entitySchema)) {
            LOG.info("Migrating Schema: (" + tableName + ", " + entityName + ")");
            this.schemaManager.migrateSchema(tableName, entityName, entitySchemaString);
            return true;
        }
        LOG.info("Schema hasn't changed, not migrating: (" + tableName + ", " + entityName + ")");
        return false;
    }

    private HTableDescriptor prepareTableDescriptor(String tableName, String entitySchemaString) {
        HTableDescriptor descriptor = new HTableDescriptor(Bytes.toBytes((String)tableName));
        AvroEntitySchema entitySchema = parser.parseEntitySchema(entitySchemaString);
        Set<String> familiesToAdd = entitySchema.getColumnMappingDescriptor().getRequiredColumnFamilies();
        familiesToAdd.add(new String(Constants.SYS_COL_FAMILY));
        familiesToAdd.add(new String(Constants.OBSERVABLE_COL_FAMILY));
        for (String familyToAdd : familiesToAdd) {
            if (descriptor.hasFamily(familyToAdd.getBytes())) continue;
            descriptor.addFamily(new HColumnDescriptor(familyToAdd));
        }
        return descriptor;
    }

    private void createTables(Collection<HTableDescriptor> tableDescriptors) throws InterruptedException {
        try {
            HashSet<String> tablesCreated = Sets.newHashSet();
            ArrayListMultimap<String, HTableDescriptor> pendingTableUpdates = ArrayListMultimap.create();
            for (HTableDescriptor tableDescriptor : tableDescriptors) {
                String tableName = Bytes.toString((byte[])tableDescriptor.getName());
                if (tablesCreated.contains(tableName)) {
                    pendingTableUpdates.put(tableName, tableDescriptor);
                    continue;
                }
                LOG.info("Creating table " + tableName);
                this.hbaseAdmin.createTableAsync(tableDescriptor, (byte[][])new byte[0][]);
                tablesCreated.add(tableName);
            }
            for (int waitCount = 0; waitCount < 600; ++waitCount) {
                Iterator iterator = tablesCreated.iterator();
                while (iterator.hasNext()) {
                    String table = (String)iterator.next();
                    if (!this.hbaseAdmin.isTableAvailable(table)) continue;
                    if (pendingTableUpdates.containsKey(table)) {
                        for (HTableDescriptor tableDescriptor : pendingTableUpdates.get(table)) {
                            this.modifyTable(table, tableDescriptor);
                        }
                    }
                    iterator.remove();
                }
                if (!tablesCreated.isEmpty()) {
                    Thread.sleep(1000L);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new DatasetException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifyTable(String tableName, HTableDescriptor newDescriptor) {
        block7: {
            LOG.info("Modifying table " + tableName);
            HColumnDescriptor[] newFamilies = newDescriptor.getColumnFamilies();
            try {
                ArrayList<HColumnDescriptor> columnsToAdd = Lists.newArrayList();
                HTableDescriptor currentFamilies = this.hbaseAdmin.getTableDescriptor(Bytes.toBytes((String)tableName));
                for (HColumnDescriptor newFamily : newFamilies) {
                    if (currentFamilies.hasFamily(newFamily.getName())) continue;
                    columnsToAdd.add(new HColumnDescriptor(newFamily.getName()));
                }
                if (columnsToAdd.isEmpty()) break block7;
                this.hbaseAdmin.disableTable(tableName);
                try {
                    for (HColumnDescriptor columnToAdd : columnsToAdd) {
                        this.hbaseAdmin.addColumn(tableName, columnToAdd);
                    }
                }
                finally {
                    this.hbaseAdmin.enableTable(tableName);
                }
            }
            catch (IOException e) {
                throw new DatasetException(e);
            }
        }
    }

    private void createTable(HTableDescriptor tableDescriptor) throws InterruptedException {
        this.createTables(ImmutableList.of(tableDescriptor));
    }

    private String getSchemaStringFromFile(File schemaFile) {
        String schemaString;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(schemaFile);
            schemaString = AvroUtils.inputStreamToString(fis);
        }
        catch (IOException e) {
            throw new DatasetException(e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return schemaString;
    }

    private List<String> getTablesFromSchemaString(String schema) {
        try {
            JsonParser jp = factory.createJsonParser(schema);
            JsonNode node = (JsonNode)mapper.readTree(jp);
            if (node.get("tables") == null) {
                return new ArrayList<String>();
            }
            ArrayList<String> result = new ArrayList<String>(node.get("tables").size());
            Iterator<JsonNode> it = node.get("tables").elements();
            while (it.hasNext()) {
                result.add(it.next().textValue());
            }
            return result;
        }
        catch (JsonParseException e) {
            throw new ValidationException(e);
        }
        catch (IOException e) {
            throw new ValidationException(e);
        }
    }

    private String getEntityNameFromSchemaString(String schema) {
        try {
            JsonParser jp = factory.createJsonParser(schema);
            JsonNode node = (JsonNode)mapper.readTree(jp);
            if (node.get("name") == null) {
                return null;
            }
            return node.get("name").textValue();
        }
        catch (JsonParseException e) {
            throw new ValidationException(e);
        }
        catch (IOException e) {
            throw new ValidationException(e);
        }
    }

    private List<String> getSchemaStringsFromDir(File dir) {
        ArrayList<String> schemaStrings = new ArrayList<String>();
        Collection schemaFiles = FileUtils.listFiles((File)dir, (IOFileFilter)new SuffixFileFilter(".avsc"), (IOFileFilter)TrueFileFilter.INSTANCE);
        for (File schemaFile : schemaFiles) {
            schemaStrings.add(this.getSchemaStringFromFile(schemaFile));
        }
        return schemaStrings;
    }

    private List<String> getSchemaStringsFromJar(String jarPath, String directoryPath) {
        JarFile jar;
        LOG.info("Getting schema strings in: " + directoryPath + ", from jar: " + jarPath);
        try {
            jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new DatasetException(e);
        }
        catch (IOException e) {
            throw new DatasetException(e);
        }
        Enumeration<JarEntry> entries = jar.entries();
        ArrayList<String> schemaStrings = new ArrayList<String>();
        while (entries.hasMoreElements()) {
            InputStream inputStream;
            JarEntry jarEntry = entries.nextElement();
            if (!jarEntry.getName().startsWith(directoryPath) || !jarEntry.getName().endsWith(".avsc")) continue;
            LOG.info("Found schema: " + jarEntry.getName());
            try {
                inputStream = jar.getInputStream(jarEntry);
            }
            catch (IOException e) {
                throw new DatasetException(e);
            }
            String schemaString = AvroUtils.inputStreamToString(inputStream);
            schemaStrings.add(schemaString);
        }
        return schemaStrings;
    }
}

