/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.hbase.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hbase.client.HTablePool;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Result;
import org.kitesdk.data.ColumnMapping;
import org.kitesdk.data.DatasetException;
import org.kitesdk.data.FieldMapping;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.hbase.impl.BaseDao;
import org.kitesdk.data.hbase.impl.CompositeDao;
import org.kitesdk.data.hbase.impl.Dao;
import org.kitesdk.data.hbase.impl.EntityBatch;
import org.kitesdk.data.hbase.impl.EntityMapper;
import org.kitesdk.data.hbase.impl.EntityScanner;
import org.kitesdk.data.hbase.impl.EntitySchema;
import org.kitesdk.data.hbase.impl.EntitySerDe;
import org.kitesdk.data.hbase.impl.HBaseUtils;
import org.kitesdk.data.hbase.impl.KeySchema;
import org.kitesdk.data.hbase.impl.KeySerDe;
import org.kitesdk.data.hbase.impl.PutAction;
import org.kitesdk.data.spi.PartitionKey;

public abstract class CompositeBaseDao<E, S>
implements CompositeDao<E, S> {
    private final BaseDao<E> baseDao;

    public CompositeBaseDao(HTablePool tablePool, String tableName, List<EntityMapper<S>> entityMappers) {
        this.baseDao = new BaseDao(tablePool, tableName, new CompositeEntityMapper(entityMappers));
    }

    @Override
    public E get(PartitionKey key) {
        return this.baseDao.get(key);
    }

    @Override
    public boolean put(E entity) {
        return this.baseDao.put(entity);
    }

    @Override
    public long increment(PartitionKey key, String fieldName, long amount) {
        throw new UnsupportedOperationException("We don't currently support increment on CompositeDaos");
    }

    @Override
    public void delete(PartitionKey key) {
        this.baseDao.delete(key);
    }

    @Override
    public boolean delete(E entity) {
        return this.baseDao.delete(entity);
    }

    @Override
    public EntityScanner<E> getScanner() {
        return this.baseDao.getScanner();
    }

    @Override
    public EntityScanner<E> getScanner(PartitionKey startKey, PartitionKey stopKey) {
        return this.baseDao.getScanner(startKey, stopKey);
    }

    @Override
    public EntityScanner<E> getScanner(PartitionKey startKey, boolean startInclusive, PartitionKey stopKey, boolean stopInclusive) {
        return this.baseDao.getScanner(startKey, startInclusive, stopKey, stopInclusive);
    }

    @Override
    public KeySchema getKeySchema() {
        return this.baseDao.getKeySchema();
    }

    @Override
    public EntitySchema getEntitySchema() {
        return this.baseDao.getEntitySchema();
    }

    @Override
    public EntityBatch<E> newBatch(long writeBufferSize) {
        return this.baseDao.newBatch(writeBufferSize);
    }

    @Override
    public EntityBatch<E> newBatch() {
        return this.baseDao.newBatch();
    }

    @Override
    public PartitionStrategy getPartitionStrategy() {
        return this.baseDao.getPartitionStrategy();
    }

    public Dao<E> getDao() {
        return this.baseDao;
    }

    private class CompositeEntityMapper
    implements EntityMapper<E> {
        private final List<EntityMapper<S>> entityMappers;

        public CompositeEntityMapper(List<EntityMapper<S>> entityMappers) {
            if (entityMappers.size() == 0) {
                throw new IllegalArgumentException("Must provide more than one entity mapper to CompositeEntityMapper");
            }
            this.entityMappers = entityMappers;
        }

        @Override
        public E mapToEntity(Result result) {
            ArrayList entityList = new ArrayList();
            for (EntityMapper entityMapper : this.entityMappers) {
                Object entity = entityMapper.mapToEntity(result);
                entityList.add(entity);
            }
            return CompositeBaseDao.this.compose(entityList);
        }

        @Override
        public PartitionKey mapToKey(E entity) {
            return this.entityMappers.get(0).mapToKey(CompositeBaseDao.this.decompose(entity).get(0));
        }

        @Override
        public PutAction mapFromEntity(E entity) {
            ArrayList<PutAction> puts = new ArrayList<PutAction>();
            List subEntities = CompositeBaseDao.this.decompose(entity);
            byte[] keyBytes = null;
            for (int i = 0; i < this.entityMappers.size(); ++i) {
                Object subEntity = subEntities.get(i);
                if (subEntity == null) continue;
                PutAction put = this.entityMappers.get(i).mapFromEntity(subEntity);
                if (keyBytes == null) {
                    keyBytes = put.getPut().getRow();
                } else if (!Arrays.equals(keyBytes, put.getPut().getRow())) {
                    throw new DatasetException("Composite entity keys didn't serialize to the same row bytes.");
                }
                puts.add(this.entityMappers.get(i).mapFromEntity(subEntity));
            }
            return HBaseUtils.mergePutActions(keyBytes, puts);
        }

        @Override
        public Increment mapToIncrement(PartitionKey key, String fieldName, long amount) {
            throw new UnsupportedOperationException("We don't currently support increment on CompositeDaos");
        }

        @Override
        public long mapFromIncrementResult(Result result, String fieldName) {
            throw new UnsupportedOperationException("We don't currently support increment on CompositeDaos");
        }

        @Override
        public Set<String> getRequiredColumns() {
            HashSet<String> requiredColumnsSet = new HashSet<String>();
            for (EntityMapper entityMapper : this.entityMappers) {
                requiredColumnsSet.addAll(entityMapper.getRequiredColumns());
            }
            return requiredColumnsSet;
        }

        @Override
        public Set<String> getRequiredColumnFamilies() {
            HashSet<String> requiredColumnFamiliesSet = new HashSet<String>();
            for (EntityMapper entityMapper : this.entityMappers) {
                requiredColumnFamiliesSet.addAll(entityMapper.getRequiredColumnFamilies());
            }
            return requiredColumnFamiliesSet;
        }

        @Override
        public KeySchema getKeySchema() {
            return this.entityMappers.get(0).getKeySchema();
        }

        @Override
        public EntitySchema getEntitySchema() {
            ArrayList<FieldMapping> fieldMappings = new ArrayList<FieldMapping>();
            for (EntityMapper entityMapper : this.entityMappers) {
                fieldMappings.addAll(entityMapper.getEntitySchema().getColumnMappingDescriptor().getFieldMappings());
            }
            ColumnMapping mappingDescriptor = new ColumnMapping.Builder().fieldMappings(fieldMappings).build();
            return new EntitySchema(null, null, mappingDescriptor);
        }

        @Override
        public KeySerDe getKeySerDe() {
            return this.entityMappers.get(0).getKeySerDe();
        }

        @Override
        public EntitySerDe<E> getEntitySerDe() {
            return this.entityMappers.get(0).getEntitySerDe();
        }
    }
}

