/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.hbase.avro.io;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.avro.io.Decoder;
import org.apache.avro.util.Utf8;

public class MemcmpDecoder
extends Decoder {
    private InputStream in;

    public MemcmpDecoder(InputStream in) {
        this.in = in;
    }

    @Override
    public void readNull() throws IOException {
    }

    @Override
    public boolean readBoolean() throws IOException {
        int byteRead = this.in.read();
        if (byteRead == -1) {
            throw new EOFException();
        }
        return byteRead > 0;
    }

    @Override
    public int readInt() throws IOException {
        byte[] intBytes = new byte[4];
        int i = this.in.read(intBytes);
        if (i < 4) {
            throw new EOFException();
        }
        intBytes[0] = (byte)(intBytes[0] ^ 0x80);
        int value = 0;
        for (int j = 0; j < intBytes.length; ++j) {
            value = (value << 8) + (intBytes[j] & 0xFF);
        }
        return value;
    }

    @Override
    public long readLong() throws IOException {
        byte[] longBytes = new byte[8];
        int i = this.in.read(longBytes);
        if (i < 8) {
            throw new EOFException();
        }
        longBytes[0] = (byte)(longBytes[0] ^ 0x80);
        long value = 0L;
        for (int j = 0; j < longBytes.length; ++j) {
            value = (value << 8) + (long)(longBytes[j] & 0xFF);
        }
        return value;
    }

    @Override
    public float readFloat() throws IOException {
        int floatAsInt = this.readInt();
        if (floatAsInt >>> 31 > 0) {
            floatAsInt ^= Integer.MAX_VALUE;
        }
        return Float.intBitsToFloat(floatAsInt);
    }

    @Override
    public double readDouble() throws IOException {
        long doubleAsLong = this.readLong();
        if (doubleAsLong >>> 63 > 0L) {
            doubleAsLong ^= Long.MAX_VALUE;
        }
        return Double.longBitsToDouble(doubleAsLong);
    }

    @Override
    public Utf8 readString(Utf8 old) throws IOException {
        ByteBuffer stringBytes = this.readBytes(null);
        return new Utf8(stringBytes.array());
    }

    @Override
    public String readString() throws IOException {
        return this.readString(null).toString();
    }

    @Override
    public void skipString() throws IOException {
        this.readString(null);
    }

    @Override
    public ByteBuffer readBytes(ByteBuffer old) throws IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        while (true) {
            int byteRead;
            if ((byteRead = this.in.read()) < 0) {
                throw new EOFException();
            }
            if (byteRead == 0) {
                int secondByteRead = this.in.read();
                if (byteRead < 0) {
                    throw new EOFException();
                }
                if (secondByteRead == 0) break;
                if (secondByteRead == 1) {
                    bytesOut.write(0);
                    continue;
                }
                String msg = "Illegal encoding. 0 byte cannot be followed by anything other than 0 or 1. It was followed by " + Integer.toString(byteRead);
                throw new IOException(msg);
            }
            bytesOut.write(byteRead);
        }
        return ByteBuffer.wrap(bytesOut.toByteArray());
    }

    @Override
    public void skipBytes() throws IOException {
        this.readBytes(null);
    }

    @Override
    public void readFixed(byte[] bytes, int start, int length) throws IOException {
        int i = this.in.read(bytes, start, length);
        if (i < length) {
            throw new EOFException();
        }
    }

    @Override
    public void skipFixed(int length) throws IOException {
        this.in.skip(length);
    }

    @Override
    public int readEnum() throws IOException {
        return this.readInt();
    }

    @Override
    public long readArrayStart() throws IOException {
        return this.readByte();
    }

    @Override
    public long arrayNext() throws IOException {
        return this.readByte();
    }

    @Override
    public long skipArray() throws IOException {
        return this.readByte();
    }

    @Override
    public long readMapStart() throws IOException {
        throw new IOException("MemcmpDecoder does not support reading Map types.");
    }

    @Override
    public long mapNext() throws IOException {
        throw new IOException("MemcmpDecoder does not support reading Map types.");
    }

    @Override
    public long skipMap() throws IOException {
        throw new IOException("MemcmpDecoder does not support reading Map types.");
    }

    @Override
    public int readIndex() throws IOException {
        return this.readInt();
    }

    private byte readByte() throws IOException {
        int byteRead = this.in.read();
        if (byteRead == -1) {
            throw new EOFException();
        }
        return (byte)byteRead;
    }
}

