/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.hbase.avro.io;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.util.Utf8;
import org.apache.hadoop.hbase.util.Bytes;

public class ColumnDecoder
extends Decoder {
    private final BinaryDecoder wrappedDecoder;
    private final InputStream in;
    private final DataInputStream dataIn;

    public ColumnDecoder(InputStream in) {
        this.in = in;
        this.wrappedDecoder = new DecoderFactory().binaryDecoder(in, null);
        this.dataIn = new DataInputStream(in);
    }

    @Override
    public void readNull() throws IOException {
        this.wrappedDecoder.readNull();
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.wrappedDecoder.readBoolean();
    }

    @Override
    public int readInt() throws IOException {
        byte[] b = new byte[4];
        this.dataIn.readFully(b);
        return Bytes.toInt((byte[])b);
    }

    @Override
    public long readLong() throws IOException {
        byte[] b = new byte[8];
        this.dataIn.readFully(b);
        return Bytes.toLong((byte[])b);
    }

    @Override
    public float readFloat() throws IOException {
        return this.wrappedDecoder.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.wrappedDecoder.readDouble();
    }

    @Override
    public Utf8 readString(Utf8 old) throws IOException {
        int bytesAvailable = this.in.available();
        byte[] bytes = new byte[bytesAvailable];
        this.in.read(bytes);
        return new Utf8(bytes);
    }

    @Override
    public String readString() throws IOException {
        return this.readString(null).toString();
    }

    @Override
    public void skipString() throws IOException {
        int bytesAvailable = this.in.available();
        this.in.skip(bytesAvailable);
    }

    @Override
    public ByteBuffer readBytes(ByteBuffer old) throws IOException {
        return this.wrappedDecoder.readBytes(old);
    }

    @Override
    public void skipBytes() throws IOException {
        this.wrappedDecoder.skipBytes();
    }

    @Override
    public void readFixed(byte[] bytes, int start, int length) throws IOException {
        this.wrappedDecoder.readFixed(bytes, start, length);
    }

    @Override
    public void skipFixed(int length) throws IOException {
        this.wrappedDecoder.skipFixed(length);
    }

    @Override
    public int readEnum() throws IOException {
        return this.wrappedDecoder.readEnum();
    }

    @Override
    public long readArrayStart() throws IOException {
        return this.wrappedDecoder.readArrayStart();
    }

    @Override
    public long arrayNext() throws IOException {
        return this.wrappedDecoder.arrayNext();
    }

    @Override
    public long skipArray() throws IOException {
        return this.wrappedDecoder.skipArray();
    }

    @Override
    public long readMapStart() throws IOException {
        return this.wrappedDecoder.readMapStart();
    }

    @Override
    public long mapNext() throws IOException {
        return this.wrappedDecoder.mapNext();
    }

    @Override
    public long skipMap() throws IOException {
        return this.wrappedDecoder.skipMap();
    }

    @Override
    public int readIndex() throws IOException {
        return this.wrappedDecoder.readIndex();
    }
}

