/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.hbase.avro;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.kitesdk.data.DatasetException;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.hbase.avro.AvroUtils;
import org.kitesdk.data.hbase.avro.io.MemcmpDecoder;
import org.kitesdk.data.hbase.avro.io.MemcmpEncoder;
import org.kitesdk.data.hbase.impl.KeySerDe;
import org.kitesdk.data.spi.PartitionKey;

public class AvroKeySerDe
implements KeySerDe {
    private final Schema schema;
    private final Schema[] partialSchemas;
    private final PartitionStrategy partitionStrategy;

    public AvroKeySerDe(Schema schema, PartitionStrategy partitionStrategy) {
        this.schema = schema;
        int fieldSize = schema.getFields().size();
        this.partialSchemas = new Schema[fieldSize];
        for (int i = 0; i < fieldSize && i != fieldSize - 1; ++i) {
            ArrayList<Schema.Field> partialFieldList = new ArrayList<Schema.Field>();
            for (Schema.Field field : schema.getFields().subList(0, i + 1)) {
                partialFieldList.add(AvroUtils.cloneField(field));
            }
            this.partialSchemas[i] = Schema.createRecord(partialFieldList);
        }
        this.partitionStrategy = partitionStrategy;
    }

    @Override
    public byte[] serialize(PartitionKey key) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        MemcmpEncoder encoder = new MemcmpEncoder(outputStream);
        Schema schemaToUse = key.getLength() == this.schema.getFields().size() ? this.schema : this.partialSchemas[key.getLength() - 1];
        GenericDatumWriter datumWriter = new GenericDatumWriter(schemaToUse);
        GenericData.Record record = new GenericData.Record(schemaToUse);
        for (int i = 0; i < key.getLength(); ++i) {
            Object keyPart = key.get(i);
            if (keyPart == null) {
                Schema fieldSchema = schemaToUse.getFields().get(i).schema();
                if (fieldSchema.getType() != Schema.Type.NULL && fieldSchema.getType() != Schema.Type.UNION) {
                    throw new DatasetException("Null key field only supported in null type or union type that has a null type.");
                }
                if (fieldSchema.getType() == Schema.Type.UNION) {
                    boolean foundNullInUnion = false;
                    for (Schema unionSchema : fieldSchema.getTypes()) {
                        if (unionSchema.getType() != Schema.Type.NULL) continue;
                        foundNullInUnion = true;
                    }
                    if (!foundNullInUnion) {
                        throw new DatasetException("Null key field only supported in union type that has a null type.");
                    }
                }
            }
            record.put(i, keyPart);
        }
        AvroUtils.writeAvroEntity(record, encoder, datumWriter);
        return outputStream.toByteArray();
    }

    @Override
    public PartitionKey deserialize(byte[] keyBytes) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(keyBytes);
        MemcmpDecoder decoder = new MemcmpDecoder(inputStream);
        GenericDatumReader datumReader = new GenericDatumReader(this.schema);
        GenericRecord genericRecord = (GenericRecord)AvroUtils.readAvroEntity(decoder, datumReader);
        Object[] keyParts = new Object[genericRecord.getSchema().getFields().size()];
        for (int i = 0; i < genericRecord.getSchema().getFields().size(); ++i) {
            keyParts[i] = genericRecord.get(i);
        }
        return new PartitionKey(keyParts);
    }

    @Override
    public byte[] serialize(Object ... keyPartValues) {
        return this.serialize(new PartitionKey(keyPartValues));
    }
}

