/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.hbase.avro;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.util.Utf8;
import org.kitesdk.data.FieldMapping;
import org.kitesdk.data.ValidationException;
import org.kitesdk.data.hbase.avro.AvroEntitySchema;
import org.kitesdk.data.hbase.avro.AvroUtils;
import org.kitesdk.data.hbase.avro.io.ColumnDecoder;
import org.kitesdk.data.hbase.avro.io.ColumnEncoder;
import org.kitesdk.data.hbase.impl.EntityComposer;
import org.kitesdk.data.hbase.impl.EntitySerDe;

public class AvroEntitySerDe<E extends IndexedRecord>
extends EntitySerDe<E> {
    private final boolean specific;
    private final AvroEntitySchema avroSchema;
    private final Map<String, DatumReader<Object>> fieldDatumReaders = new HashMap<String, DatumReader<Object>>();
    private final Map<String, DatumWriter<Object>> fieldDatumWriters = new HashMap<String, DatumWriter<Object>>();
    private final Map<String, Map<String, DatumReader<Object>>> kacRecordDatumReaders = new HashMap<String, Map<String, DatumReader<Object>>>();
    private final Map<String, Map<String, DatumWriter<Object>>> kacRecordDatumWriters = new HashMap<String, Map<String, DatumWriter<Object>>>();
    private final Map<String, Object> defaultValueMap;

    public AvroEntitySerDe(EntityComposer<E> entityComposer, AvroEntitySchema avroSchema, AvroEntitySchema writtenAvroSchema, boolean specific) {
        super(entityComposer);
        this.specific = specific;
        this.avroSchema = avroSchema;
        this.defaultValueMap = AvroUtils.getDefaultValueMap(avroSchema.getAvroSchema());
        for (FieldMapping fieldMapping : avroSchema.getColumnMappingDescriptor().getFieldMappings()) {
            String fieldName = fieldMapping.getFieldName();
            Schema fieldSchema = avroSchema.getAvroSchema().getField(fieldName).schema();
            Schema.Field writtenField = writtenAvroSchema.getAvroSchema().getField(fieldName);
            if (writtenField == null) continue;
            Schema writtenFieldSchema = writtenField.schema();
            if (fieldMapping.getMappingType() == FieldMapping.MappingType.COLUMN || fieldMapping.getMappingType() == FieldMapping.MappingType.COUNTER) {
                this.initColumnDatumMaps(fieldName, fieldSchema, writtenFieldSchema);
                continue;
            }
            if (fieldMapping.getMappingType() != FieldMapping.MappingType.KEY_AS_COLUMN) continue;
            if (fieldSchema.getType() == Schema.Type.RECORD) {
                this.initKACRecordDatumMaps(fieldName, fieldSchema, writtenFieldSchema);
                continue;
            }
            if (fieldSchema.getType() == Schema.Type.MAP) {
                this.initColumnDatumMaps(fieldName, fieldSchema.getValueType(), writtenFieldSchema.getValueType());
                continue;
            }
            throw new ValidationException("Unsupported type for keyAsColumn: " + (Object)((Object)fieldSchema.getType()));
        }
    }

    @Override
    public byte[] serializeColumnValueToBytes(String fieldName, Object columnValue) {
        Schema.Field field = this.avroSchema.getAvroSchema().getField(fieldName);
        DatumWriter<Object> datumWriter = this.fieldDatumWriters.get(fieldName);
        if (field == null) {
            throw new ValidationException("Invalid field name " + fieldName + " for schema " + this.avroSchema.toString());
        }
        if (datumWriter == null) {
            throw new ValidationException("No datum writer for field name: " + fieldName);
        }
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        Encoder encoder = this.getColumnEncoder(field.schema(), byteOut);
        AvroUtils.writeAvroEntity(columnValue, encoder, this.fieldDatumWriters.get(fieldName));
        return byteOut.toByteArray();
    }

    @Override
    public byte[] serializeKeyAsColumnValueToBytes(String fieldName, CharSequence columnKey, Object columnValue) {
        Schema.Field field = this.avroSchema.getAvroSchema().getField(fieldName);
        if (field == null) {
            throw new ValidationException("Invalid field name " + fieldName + " for schema " + this.avroSchema.toString());
        }
        Schema.Type schemaType = field.schema().getType();
        if (schemaType == Schema.Type.MAP) {
            DatumWriter<Object> datumWriter = this.fieldDatumWriters.get(fieldName);
            if (datumWriter == null) {
                throw new ValidationException("No datum writer for field name: " + fieldName);
            }
            return AvroUtils.writeAvroEntity(columnValue, datumWriter);
        }
        if (schemaType == Schema.Type.RECORD) {
            if (!this.kacRecordDatumWriters.containsKey(fieldName)) {
                throw new ValidationException("Invalid field name " + fieldName + " for schema " + this.avroSchema.toString());
            }
            if (!this.kacRecordDatumWriters.get(fieldName).containsKey(columnKey.toString())) {
                throw new ValidationException("Invalid key in record: " + fieldName + "." + columnKey);
            }
            DatumWriter<Object> datumWriter = this.kacRecordDatumWriters.get(fieldName).get(columnKey.toString());
            return AvroUtils.writeAvroEntity(columnValue, datumWriter);
        }
        throw new ValidationException("Unsupported type for keyAsColumn: " + (Object)((Object)schemaType));
    }

    @Override
    public byte[] serializeKeyAsColumnKeyToBytes(String fieldName, CharSequence columnKey) {
        if (columnKey.getClass().isAssignableFrom(String.class)) {
            return ((String)columnKey).getBytes();
        }
        if (columnKey.getClass().isAssignableFrom(Utf8.class)) {
            return ((Utf8)columnKey).getBytes();
        }
        return columnKey.toString().getBytes();
    }

    @Override
    public Object deserializeColumnValueFromBytes(String fieldName, byte[] bytes) {
        Schema.Field field = this.avroSchema.getAvroSchema().getField(fieldName);
        DatumReader<Object> datumReader = this.fieldDatumReaders.get(fieldName);
        if (field == null) {
            throw new ValidationException("Invalid field name " + fieldName + " for schema " + this.avroSchema.toString());
        }
        if (datumReader == null) {
            throw new ValidationException("No datum reader for field name: " + fieldName);
        }
        ByteArrayInputStream byteIn = new ByteArrayInputStream(bytes);
        Decoder decoder = this.getColumnDecoder(field.schema(), byteIn);
        return AvroUtils.readAvroEntity(decoder, datumReader);
    }

    @Override
    public Object deserializeKeyAsColumnValueFromBytes(String fieldName, byte[] columnKeyBytes, byte[] columnValueBytes) {
        Schema.Field field = this.avroSchema.getAvroSchema().getField(fieldName);
        if (field == null) {
            throw new ValidationException("Invalid field name " + fieldName + " for schema " + this.avroSchema.toString());
        }
        Schema.Type schemaType = field.schema().getType();
        if (schemaType == Schema.Type.MAP) {
            DatumReader<Object> datumReader = this.fieldDatumReaders.get(fieldName);
            if (datumReader == null) {
                throw new ValidationException("No datum reader for field name: " + fieldName);
            }
            return AvroUtils.readAvroEntity(columnValueBytes, datumReader);
        }
        if (schemaType == Schema.Type.RECORD) {
            if (!this.kacRecordDatumReaders.containsKey(fieldName)) {
                throw new ValidationException("Invalid field name " + fieldName + " for schema " + this.avroSchema.toString());
            }
            String columnKey = new String(columnKeyBytes);
            if (!this.kacRecordDatumReaders.get(fieldName).containsKey(columnKey)) {
                throw new ValidationException("Invalid key in record: " + fieldName + "." + columnKey);
            }
            DatumReader<Object> datumReader = this.kacRecordDatumReaders.get(fieldName).get(columnKey);
            return AvroUtils.readAvroEntity(columnValueBytes, datumReader);
        }
        throw new ValidationException("Unsupported type for keyAsColumn: " + (Object)((Object)schemaType));
    }

    @Override
    public CharSequence deserializeKeyAsColumnKeyFromBytes(String fieldName, byte[] columnKeyBytes) {
        Schema.Field field = this.avroSchema.getAvroSchema().getField(fieldName);
        if (field == null) {
            throw new ValidationException("Invalid field name " + fieldName + " for schema " + this.avroSchema.toString());
        }
        Schema.Type schemaType = field.schema().getType();
        if (schemaType == Schema.Type.MAP) {
            String stringProp = field.schema().getProp("avro.java.string");
            if (stringProp != null && stringProp.equals("String")) {
                return new String(columnKeyBytes);
            }
            return new Utf8(columnKeyBytes);
        }
        if (schemaType == Schema.Type.RECORD) {
            return new String(columnKeyBytes);
        }
        throw new ValidationException("Unsupported type for keyAsColumn: " + (Object)((Object)schemaType));
    }

    @Override
    public Object getDefaultValue(String fieldName) {
        return this.defaultValueMap.get(fieldName);
    }

    private void initColumnDatumMaps(String fieldName, Schema fieldSchema, Schema writtenFieldSchema) {
        this.fieldDatumReaders.put(fieldName, this.buildDatumReader(fieldSchema, writtenFieldSchema));
        this.fieldDatumWriters.put(fieldName, this.buildDatumWriter(fieldSchema));
    }

    private void initKACRecordDatumMaps(String fieldName, Schema fieldSchema, Schema writtenFieldSchema) {
        HashMap<String, DatumReader<Object>> recordFieldReaderMap = new HashMap<String, DatumReader<Object>>();
        HashMap<String, DatumWriter<Object>> recordFieldWriterMap = new HashMap<String, DatumWriter<Object>>();
        this.kacRecordDatumReaders.put(fieldName, recordFieldReaderMap);
        this.kacRecordDatumWriters.put(fieldName, recordFieldWriterMap);
        for (Schema.Field recordField : fieldSchema.getFields()) {
            Schema.Field writtenRecordField = writtenFieldSchema.getField(recordField.name());
            if (writtenRecordField == null) continue;
            recordFieldReaderMap.put(recordField.name(), this.buildDatumReader(recordField.schema(), writtenRecordField.schema()));
            recordFieldWriterMap.put(recordField.name(), this.buildDatumWriter(recordField.schema()));
        }
    }

    private DatumReader<Object> buildDatumReader(Schema schema, Schema writtenSchema) {
        if (this.specific) {
            return new SpecificDatumReader<Object>(writtenSchema, schema);
        }
        return new GenericDatumReader<Object>(writtenSchema, schema);
    }

    private DatumWriter<Object> buildDatumWriter(Schema schema) {
        if (this.specific) {
            return new SpecificDatumWriter<Object>(schema);
        }
        return new GenericDatumWriter<Object>(schema);
    }

    private Decoder getColumnDecoder(Schema writtenFieldAvroSchema, InputStream in) {
        if (writtenFieldAvroSchema.getType() == Schema.Type.INT || writtenFieldAvroSchema.getType() == Schema.Type.LONG || writtenFieldAvroSchema.getType() == Schema.Type.STRING) {
            return new ColumnDecoder(in);
        }
        return DecoderFactory.get().binaryDecoder(in, null);
    }

    private Encoder getColumnEncoder(Schema fieldAvroSchema, OutputStream out) {
        if (fieldAvroSchema.getType() == Schema.Type.INT || fieldAvroSchema.getType() == Schema.Type.LONG || fieldAvroSchema.getType() == Schema.Type.STRING) {
            return new ColumnEncoder(out);
        }
        return EncoderFactory.get().binaryEncoder(out, null);
    }
}

