/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.avro.Schema;
import org.apache.avro.reflect.ReflectData;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.kitesdk.data.ColumnMapping;
import org.kitesdk.data.CompressionType;
import org.kitesdk.data.DatasetIOException;
import org.kitesdk.data.FieldMapping;
import org.kitesdk.data.Format;
import org.kitesdk.data.Formats;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.ValidationException;
import org.kitesdk.data.spi.ColumnMappingParser;
import org.kitesdk.data.spi.DefaultConfiguration;
import org.kitesdk.data.spi.FieldPartitioner;
import org.kitesdk.data.spi.HadoopFileSystemURLStreamHandler;
import org.kitesdk.data.spi.PartitionStrategyParser;
import org.kitesdk.data.spi.SchemaUtil;
import org.kitesdk.data.spi.Schemas;
import org.kitesdk.data.spi.partition.IdentityFieldPartitioner;
import org.kitesdk.data.spi.partition.ProvidedFieldPartitioner;
import org.kitesdk.shaded.com.google.common.base.Joiner;
import org.kitesdk.shaded.com.google.common.base.Objects;
import org.kitesdk.shaded.com.google.common.base.Preconditions;
import org.kitesdk.shaded.com.google.common.collect.ImmutableMap;
import org.kitesdk.shaded.com.google.common.collect.Maps;
import org.kitesdk.shaded.com.google.common.collect.Sets;
import org.kitesdk.shaded.com.google.common.io.Closeables;
import org.kitesdk.shaded.com.google.common.io.Resources;

@Immutable
public class DatasetDescriptor {
    private final Schema schema;
    private final URL schemaUrl;
    private final URI schemaUri;
    private final Format format;
    private final URI location;
    private final Map<String, String> properties;
    private final PartitionStrategy partitionStrategy;
    private final ColumnMapping columnMappings;
    private final CompressionType compressionType;

    public DatasetDescriptor(Schema schema, @Nullable URL schemaUrl, Format format, @Nullable URI location, @Nullable Map<String, String> properties, @Nullable PartitionStrategy partitionStrategy) {
        this(schema, schemaUrl, format, location, properties, partitionStrategy, null);
    }

    public DatasetDescriptor(Schema schema, @Nullable URL schemaUrl, Format format, @Nullable URI location, @Nullable Map<String, String> properties, @Nullable PartitionStrategy partitionStrategy, @Nullable ColumnMapping columnMapping) {
        this(schema, DatasetDescriptor.toURI(schemaUrl), format, location, properties, partitionStrategy, columnMapping, null);
    }

    public DatasetDescriptor(Schema schema, @Nullable URI schemaUri, Format format, @Nullable URI location, @Nullable Map<String, String> properties, @Nullable PartitionStrategy partitionStrategy, @Nullable ColumnMapping columnMapping, @Nullable CompressionType compressionType) {
        Preconditions.checkArgument(location == null || location.getScheme() != null, "Location URIs must be fully-qualified and have a FS scheme.");
        DatasetDescriptor.checkCompressionType(format, compressionType);
        this.schema = schema;
        this.schemaUri = schemaUri;
        this.schemaUrl = DatasetDescriptor.toURL(schemaUri);
        this.format = format;
        this.location = location;
        this.properties = properties != null ? ImmutableMap.copyOf(properties) : ImmutableMap.of();
        this.partitionStrategy = partitionStrategy;
        this.columnMappings = columnMapping;
        this.compressionType = compressionType == null ? this.format.getDefaultCompressionType() : compressionType;
    }

    public Schema getSchema() {
        return this.schema;
    }

    @Nullable
    public URL getSchemaUrl() {
        return this.schemaUrl;
    }

    public Format getFormat() {
        return this.format;
    }

    @Nullable
    public URI getLocation() {
        return this.location;
    }

    @Nullable
    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    public Collection<String> listProperties() {
        return this.properties.keySet();
    }

    public PartitionStrategy getPartitionStrategy() {
        Preconditions.checkState(this.isPartitioned(), "Attempt to retrieve the partition strategy on a non-partitioned descriptor:%s", this);
        return this.partitionStrategy;
    }

    public ColumnMapping getColumnMapping() {
        return this.columnMappings;
    }

    public CompressionType getCompressionType() {
        return this.compressionType;
    }

    public boolean isPartitioned() {
        return this.partitionStrategy != null;
    }

    public boolean isColumnMapped() {
        return this.columnMappings != null;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.schema, this.format, this.location, this.properties, this.partitionStrategy, this.columnMappings, this.compressionType});
    }

    @SuppressWarnings(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"}, justification="Default annotation is not correct for equals")
    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DatasetDescriptor other = (DatasetDescriptor)obj;
        return Objects.equal(this.schema, other.schema) && Objects.equal(this.format, other.format) && Objects.equal(this.location, other.location) && Objects.equal(this.properties, other.properties) && Objects.equal(this.partitionStrategy, other.partitionStrategy) && Objects.equal(this.columnMappings, other.columnMappings) && Objects.equal((Object)this.compressionType, (Object)other.compressionType);
    }

    public String toString() {
        Objects.ToStringHelper helper = Objects.toStringHelper(this).add("format", this.format).add("schema", this.schema).add("location", this.location).add("properties", this.properties).add("partitionStrategy", this.partitionStrategy).add("compressionType", (Object)this.compressionType);
        if (this.isColumnMapped()) {
            helper.add("columnMapping", this.columnMappings);
        }
        return helper.toString();
    }

    private static void checkCompressionType(Format format, @Nullable CompressionType compressionType) {
        if (compressionType == null) {
            return;
        }
        ValidationException.check(format.getSupportedCompressionTypes().contains((Object)compressionType), "Format %s doesn't support compression format %s", format.getName(), compressionType.getName());
    }

    private static void checkColumnMappings(Schema schema, @Nullable PartitionStrategy strategy, @Nullable ColumnMapping mappings) {
        if (mappings == null) {
            return;
        }
        ValidationException.check(schema.getType() == Schema.Type.RECORD, "Cannot map non-records: %s", schema);
        HashSet<String> keyMappedFields = Sets.newHashSet();
        for (FieldMapping fm : mappings.getFieldMappings()) {
            Schema fieldSchema = SchemaUtil.fieldSchema(schema, fm.getFieldName());
            ValidationException.check(SchemaUtil.isConsistentWithMappingType(fieldSchema.getType(), fm.getMappingType()), "Field type %s is not compatible with mapping %s", new Object[]{fieldSchema.getType(), fm});
            if (FieldMapping.MappingType.KEY != fm.getMappingType()) continue;
            keyMappedFields.add(fm.getFieldName());
        }
        if (strategy != null) {
            for (FieldPartitioner fp : strategy.getFieldPartitioners()) {
                if (!(fp instanceof IdentityFieldPartitioner)) continue;
                keyMappedFields.remove(fp.getSourceName());
            }
        }
        if (keyMappedFields.size() > 0) {
            throw new ValidationException("Fields are key-mapped without identity partitioners: " + Joiner.on(", ").join(keyMappedFields));
        }
    }

    private static PartitionStrategy buildPartitionStrategyForKeyMappings(Map<Integer, FieldMapping> keyMappings) {
        PartitionStrategy.Builder builder = new PartitionStrategy.Builder();
        for (Integer index : new TreeSet<Integer>(keyMappings.keySet())) {
            builder.identity(keyMappings.get(index).getFieldName());
        }
        return builder.build();
    }

    private static URI toURI(@Nullable URL url) {
        if (url == null) {
            return null;
        }
        return URI.create(url.toExternalForm());
    }

    private static URL toURL(@Nullable URI uri) {
        if (uri == null) {
            return null;
        }
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            try {
                return new URL(null, uri.toString(), new HadoopFileSystemURLStreamHandler());
            }
            catch (MalformedURLException _) {
                return null;
            }
        }
    }

    public static class Builder {
        private static final String RESOURCE_URI_SCHEME = "resource";
        private Configuration conf;
        private URI defaultFS;
        private Schema schema;
        private URI schemaUri;
        private Format format = Formats.AVRO;
        private URI location;
        private Map<String, String> properties = Maps.newHashMap();
        private PartitionStrategy partitionStrategy;
        private ColumnMapping columnMapping;
        private ColumnMapping copiedMapping;
        private CompressionType compressionType;

        public Builder() {
            this.conf = DefaultConfiguration.get();
            try {
                this.defaultFS = FileSystem.get((Configuration)this.conf).getUri();
            }
            catch (IOException e) {
                throw new DatasetIOException("Cannot get the default FS", e);
            }
        }

        public Builder(DatasetDescriptor descriptor) {
            this();
            this.schema = descriptor.schema;
            this.schemaUri = descriptor.schemaUri;
            this.format = descriptor.format;
            this.location = descriptor.location;
            this.copiedMapping = descriptor.columnMappings;
            this.compressionType = descriptor.compressionType;
            this.partitionStrategy = descriptor.partitionStrategy;
            this.properties.putAll(descriptor.properties);
        }

        public Builder schema(Schema schema) {
            Preconditions.checkNotNull(schema, "Schema cannot be null");
            this.schema = schema;
            return this;
        }

        public Builder schema(File file) throws IOException {
            this.schema = Schemas.fromAvsc(file);
            return this;
        }

        public Builder schema(InputStream in) throws IOException {
            this.schema = Schemas.fromAvsc(in);
            return this;
        }

        public Builder schemaUri(URI uri) throws IOException {
            this.schemaUri = this.qualifiedUri(uri);
            this.schema = Schemas.fromAvsc(this.conf, uri);
            return this;
        }

        public Builder schemaUri(String uri) throws IOException {
            return this.schemaUri(URI.create(uri));
        }

        public Builder schemaLiteral(String s) {
            this.schema = new Schema.Parser().parse(s);
            return this;
        }

        public <T> Builder schema(Class<T> type) {
            this.schema = ReflectData.get().getSchema(type);
            return this;
        }

        public Builder schemaFromAvroDataFile(File file) throws IOException {
            this.schema = Schemas.fromAvro(file);
            return this;
        }

        public Builder schemaFromAvroDataFile(InputStream in) throws IOException {
            this.schema = Schemas.fromAvro(in);
            return this;
        }

        public Builder schemaFromAvroDataFile(URI uri) throws IOException {
            this.schema = Schemas.fromAvro(this.conf, uri);
            return this;
        }

        public Builder format(Format format) {
            this.format = format;
            return this;
        }

        public Builder format(String formatName) {
            return this.format(Formats.fromString(formatName));
        }

        public Builder location(@Nullable URI uri) {
            Preconditions.checkArgument(uri == null || uri.getScheme() != null, "Location URIs must be fully-qualified and have a FS scheme.");
            this.location = uri;
            return this;
        }

        public Builder location(Path path) {
            return this.location(path.toString());
        }

        public Builder location(String uri) {
            return this.location(URI.create(uri));
        }

        public Builder property(String name, String value) {
            this.properties.put(name, value);
            return this;
        }

        public Builder partitionStrategy(@Nullable PartitionStrategy partitionStrategy) {
            this.partitionStrategy = partitionStrategy;
            return this;
        }

        public Builder partitionStrategy(File file) {
            this.partitionStrategy = PartitionStrategyParser.parse(file);
            return this;
        }

        public Builder partitionStrategy(InputStream in) {
            this.partitionStrategy = PartitionStrategyParser.parse(in);
            return this;
        }

        public Builder partitionStrategyLiteral(String literal) {
            this.partitionStrategy = PartitionStrategyParser.parse(literal);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Builder partitionStrategyUri(URI uri) throws IOException {
            InputStream in = null;
            boolean threw = true;
            try {
                in = this.open(uri);
                this.partitionStrategy(in);
                threw = false;
            }
            finally {
                Closeables.close(in, threw);
            }
            return this;
        }

        public Builder partitionStrategyUri(String uri) throws IOException {
            return this.partitionStrategyUri(URI.create(uri));
        }

        public Builder columnMapping(@Nullable ColumnMapping columnMappings) {
            this.columnMapping = columnMappings;
            return this;
        }

        public Builder columnMapping(File file) {
            this.columnMapping = ColumnMappingParser.parse(file);
            return this;
        }

        public Builder columnMapping(InputStream in) {
            this.columnMapping = ColumnMappingParser.parse(in);
            return this;
        }

        public Builder columnMappingLiteral(String literal) {
            this.columnMapping = ColumnMappingParser.parse(literal);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Builder columnMappingUri(URI uri) throws IOException {
            InputStream in = null;
            boolean threw = true;
            try {
                in = this.open(uri);
                this.columnMapping(in);
                threw = false;
            }
            finally {
                Closeables.close(in, threw);
            }
            return this;
        }

        public Builder columnMappingUri(String uri) throws IOException {
            return this.columnMappingUri(URI.create(uri));
        }

        public Builder compressionType(CompressionType compressionType) {
            this.compressionType = compressionType;
            return this;
        }

        public Builder compressionType(String compressionTypeName) {
            return this.compressionType(CompressionType.forName(compressionTypeName));
        }

        public DatasetDescriptor build() {
            ValidationException.check(this.schema != null, "Descriptor schema is required and cannot be null", new Object[0]);
            if (this.partitionStrategy == null && PartitionStrategyParser.hasEmbeddedStrategy(this.schema)) {
                this.partitionStrategy = PartitionStrategyParser.parseFromSchema(this.schema);
            }
            if (this.columnMapping == null) {
                if (ColumnMappingParser.hasEmbeddedColumnMapping(this.schema)) {
                    this.columnMapping = ColumnMappingParser.parseFromSchema(this.schema);
                } else if (ColumnMappingParser.hasEmbeddedFieldMappings(this.schema)) {
                    this.columnMapping = ColumnMappingParser.parseFromSchemaFields(this.schema);
                    if (this.partitionStrategy == null) {
                        this.partitionStrategy = DatasetDescriptor.buildPartitionStrategyForKeyMappings(ColumnMappingParser.parseKeyMappingsFromSchemaFields(this.schema));
                    }
                }
            }
            if (this.columnMapping == null && this.copiedMapping != null) {
                this.columnMapping = this.copiedMapping;
            }
            Builder.checkPartitionStrategy(this.schema, this.partitionStrategy);
            DatasetDescriptor.checkColumnMappings(this.schema, this.partitionStrategy, this.columnMapping);
            return new DatasetDescriptor(this.schema, this.schemaUri, this.format, this.location, this.properties, this.partitionStrategy, this.columnMapping, this.compressionType);
        }

        private InputStream open(URI location) throws IOException {
            if (RESOURCE_URI_SCHEME.equals(location.getScheme())) {
                return Resources.getResource(location.getRawSchemeSpecificPart()).openStream();
            }
            Path filePath = new Path(this.qualifiedUri(location));
            FileSystem fs = filePath.getFileSystem(this.conf);
            return fs.open(filePath);
        }

        private URI qualifiedUri(URI location) throws IOException {
            if (RESOURCE_URI_SCHEME.equals(location.getScheme())) {
                return null;
            }
            boolean useDefault = this.defaultFS.getScheme().equals(location.getScheme());
            return new Path(location).makeQualified(useDefault ? this.defaultFS : location, new Path("/")).toUri();
        }

        private static void checkPartitionStrategy(Schema schema, @Nullable PartitionStrategy strategy) {
            if (strategy == null) {
                return;
            }
            for (FieldPartitioner fp : strategy.getFieldPartitioners()) {
                Schema fieldSchema;
                if (fp instanceof ProvidedFieldPartitioner) continue;
                ValidationException.check(schema.getType() == Schema.Type.RECORD, "Cannot partition non-records: %s", schema);
                try {
                    fieldSchema = SchemaUtil.fieldSchema(schema, fp.getSourceName());
                }
                catch (IllegalArgumentException e) {
                    throw new ValidationException("Cannot partition on " + fp.getSourceName(), e);
                }
                ValidationException.check(SchemaUtil.isConsistentWithExpectedType(fieldSchema.getType(), fp.getSourceType()), "Field type %s does not match partitioner %s", new Object[]{fieldSchema.getType(), fp});
            }
        }
    }
}

