/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.shaded.org.apache.parquet.hadoop.metadata;

import java.util.Set;
import org.kitesdk.shaded.org.apache.parquet.column.Encoding;
import org.kitesdk.shaded.org.apache.parquet.column.statistics.Statistics;
import org.kitesdk.shaded.org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.kitesdk.shaded.org.apache.parquet.hadoop.metadata.ColumnChunkProperties;
import org.kitesdk.shaded.org.apache.parquet.hadoop.metadata.ColumnPath;
import org.kitesdk.shaded.org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.kitesdk.shaded.org.apache.parquet.schema.PrimitiveType;

class LongColumnChunkMetaData
extends ColumnChunkMetaData {
    private final long firstDataPageOffset;
    private final long dictionaryPageOffset;
    private final long valueCount;
    private final long totalSize;
    private final long totalUncompressedSize;
    private final Statistics statistics;

    LongColumnChunkMetaData(ColumnPath path, PrimitiveType.PrimitiveTypeName type, CompressionCodecName codec, Set<Encoding> encodings, Statistics statistics, long firstDataPageOffset, long dictionaryPageOffset, long valueCount, long totalSize, long totalUncompressedSize) {
        super(ColumnChunkProperties.get(path, type, codec, encodings));
        this.firstDataPageOffset = firstDataPageOffset;
        this.dictionaryPageOffset = dictionaryPageOffset;
        this.valueCount = valueCount;
        this.totalSize = totalSize;
        this.totalUncompressedSize = totalUncompressedSize;
        this.statistics = statistics;
    }

    @Override
    public long getFirstDataPageOffset() {
        return this.firstDataPageOffset;
    }

    @Override
    public long getDictionaryPageOffset() {
        return this.dictionaryPageOffset;
    }

    @Override
    public long getValueCount() {
        return this.valueCount;
    }

    @Override
    public long getTotalUncompressedSize() {
        return this.totalUncompressedSize;
    }

    @Override
    public long getTotalSize() {
        return this.totalSize;
    }

    @Override
    public Statistics getStatistics() {
        return this.statistics;
    }
}

