/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.predicates;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.kitesdk.data.spi.CharSequences;
import org.kitesdk.data.spi.SchemaUtil;
import org.kitesdk.shaded.com.google.common.base.Objects;
import org.kitesdk.shaded.com.google.common.base.Predicate;

public class Range<T>
implements Predicate<T> {
    public static final Pattern RANGE_PATTERN = Pattern.compile("([\\[\\(])([^,]*),([^\\]\\)]*)([\\]\\)])");
    private final Bound<T> lower;
    private final Bound<T> upper;
    private static Bound<Object> INF = new Bound<Object>(){

        @Override
        public boolean inclusive() {
            return false;
        }

        @Override
        public Object endpoint() {
            return null;
        }

        @Override
        public boolean isLessThan(Object other) {
            return true;
        }

        @Override
        public boolean isGreaterThan(Object other) {
            return true;
        }

        public String toString() {
            return "inf";
        }

        @Override
        public String toString(Schema _) {
            return "";
        }
    };

    public static <T> Range<T> fromString(String range, Schema schema) {
        Matcher match = RANGE_PATTERN.matcher(range);
        if (match.matches()) {
            boolean lIncl = "[".equals(match.group(1));
            T lower = match.group(2).isEmpty() ? null : (T)SchemaUtil.fromString(match.group(2), schema);
            T upper = match.group(3).isEmpty() ? null : (T)SchemaUtil.fromString(match.group(3), schema);
            boolean uIncl = "]".equals(match.group(4));
            return new Range<Object>(Range.bound(lower, lIncl), Range.bound(upper, uIncl));
        }
        return null;
    }

    Range(Bound<T> lower, Bound<T> upper) {
        this.lower = lower == null ? INF : lower;
        this.upper = upper == null ? INF : upper;
    }

    public boolean isLowerBoundOpen() {
        return !this.lower.inclusive();
    }

    public boolean isUpperBoundOpen() {
        return !this.upper.inclusive();
    }

    public boolean isLowerBoundClosed() {
        return this.lower.inclusive();
    }

    public boolean isUpperBoundClosed() {
        return this.upper.inclusive();
    }

    public boolean hasLowerBound() {
        return this.lower != INF;
    }

    public boolean hasUpperBound() {
        return this.upper != INF;
    }

    public T lowerEndpoint() {
        return this.lower.endpoint();
    }

    public T upperEndpoint() {
        return this.upper.endpoint();
    }

    public Range<T> intersection(Range<T> other) {
        Bound<T> newLower;
        if (other.lower == INF) {
            newLower = this.lower;
        } else {
            Bound<T> bound = newLower = this.lower.isLessThan(other.lower.endpoint()) ? other.lower : this.lower;
        }
        Bound<T> newUpper = other.upper == INF ? this.upper : (this.upper.isGreaterThan(other.upper.endpoint()) ? other.upper : this.upper);
        return new Range<T>(newLower, newUpper);
    }

    @Override
    public boolean apply(@Nullable T input) {
        return this.contains(input);
    }

    public boolean contains(T input) {
        return this.lower.isLessThan(input) && this.upper.isGreaterThan(input);
    }

    public String toString() {
        return (this.isLowerBoundClosed() ? "[" : "(") + this.lower.toString() + ", " + this.upper.toString() + (this.isUpperBoundClosed() ? "]" : ")");
    }

    public String toString(Schema schema) {
        return (this.isLowerBoundClosed() ? "[" : "(") + this.lower.toString(schema) + "," + this.upper.toString(schema) + (this.isUpperBoundClosed() ? "]" : ")");
    }

    @Override
    @SuppressWarnings(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"}, justification="Default annotation is not correct for equals")
    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        Range other = (Range)object;
        return Objects.equal(this.lower, other.lower) && Objects.equal(this.upper, other.upper);
    }

    public int hashCode() {
        return Objects.hashCode(this.lower, this.upper);
    }

    static <T> Bound<T> bound(T endpoint, boolean inclusive) {
        if (endpoint == null) {
            return INF;
        }
        if (endpoint instanceof CharSequence) {
            return new CharSequenceBound((CharSequence)endpoint, inclusive);
        }
        if (endpoint instanceof Comparable) {
            return new ComparableBound((Comparable)endpoint, inclusive, null);
        }
        throw new RuntimeException();
    }

    private static class ComparableBound<C extends Comparable<C>>
    extends AbstractBound<C> {
        private ComparableBound(C endpoint, boolean inclusive) {
            super(endpoint, inclusive);
        }

        @Override
        protected int compare(C left, C right) {
            return left.compareTo(right);
        }

        /* synthetic */ ComparableBound(Comparable x0, boolean x1, 1 x2) {
            this(x0, x1);
        }
    }

    private static class CharSequenceBound
    extends AbstractBound<CharSequence> {
        private CharSequenceBound(CharSequence endpoint, boolean inclusive) {
            super(endpoint, inclusive);
        }

        @Override
        protected int compare(CharSequence left, CharSequence right) {
            return CharSequences.compare(left, right);
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.inclusive(), CharSequences.hashCode((CharSequence)this.endpoint()));
        }
    }

    private static abstract class AbstractBound<T>
    implements Bound<T> {
        private final T endpoint;
        private final boolean inclusive;

        private AbstractBound(T endpoint, boolean inclusive) {
            this.endpoint = endpoint;
            this.inclusive = inclusive;
        }

        protected abstract int compare(T var1, T var2);

        @Override
        public boolean inclusive() {
            return this.inclusive;
        }

        @Override
        public T endpoint() {
            return this.endpoint;
        }

        @Override
        public boolean isLessThan(T other) {
            int cmp = this.compare(this.endpoint, other);
            if (cmp < 0) {
                return true;
            }
            if (cmp == 0) {
                return this.inclusive;
            }
            return false;
        }

        @Override
        public boolean isGreaterThan(T other) {
            int cmp = this.compare(other, this.endpoint);
            if (cmp < 0) {
                return true;
            }
            if (cmp == 0) {
                return this.inclusive;
            }
            return false;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            AbstractBound other = (AbstractBound)obj;
            return this.inclusive == other.inclusive && this.compare(this.endpoint, other.endpoint) == 0;
        }

        public int hashCode() {
            return Objects.hashCode(this.inclusive, this.endpoint);
        }

        public String toString() {
            return this.endpoint.toString();
        }

        @Override
        public String toString(Schema schema) {
            return SchemaUtil.toString(this.endpoint, schema);
        }
    }

    private static interface Bound<T> {
        public boolean inclusive();

        public T endpoint();

        public boolean isLessThan(T var1);

        public boolean isGreaterThan(T var1);

        public String toString(Schema var1);
    }
}

