/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.partition;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.kitesdk.data.spi.FieldPartitioner;
import org.kitesdk.shaded.com.google.common.base.Objects;
import org.kitesdk.shaded.com.google.common.base.Predicate;

@SuppressWarnings(value={"SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"}, justification="Implement if we intend to use in Serializable objects  (e.g., TreeMaps) and use java serialization.")
@Immutable
public class IdentityFieldPartitioner<S extends Comparable>
extends FieldPartitioner<S, S> {
    public IdentityFieldPartitioner(String sourceName, Class<S> type) {
        this(sourceName, null, type, -1);
    }

    public IdentityFieldPartitioner(String sourceName, @Nullable String name, Class<S> type) {
        this(sourceName, name, type, -1);
    }

    public IdentityFieldPartitioner(String sourceName, Class<S> type, int buckets) {
        this(sourceName, null, type, buckets);
    }

    public IdentityFieldPartitioner(String sourceName, @Nullable String name, Class<S> type, int buckets) {
        super(sourceName, name == null ? sourceName + "_copy" : name, type, type, buckets);
    }

    @Override
    public S apply(S value) {
        return value;
    }

    @Override
    public Predicate<S> project(Predicate<S> predicate) {
        return predicate;
    }

    @Override
    public Predicate<S> projectStrict(Predicate<S> predicate) {
        return predicate;
    }

    @Override
    public Class<? extends S> getType(Class<? extends S> sourceType) {
        return sourceType;
    }

    @Override
    @SuppressWarnings(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"}, justification="Default annotation is not correct for equals")
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        IdentityFieldPartitioner that = (IdentityFieldPartitioner)o;
        return Objects.equal(this.getSourceName(), that.getSourceName()) && Objects.equal(this.getName(), that.getName()) && Objects.equal(this.getType(), that.getType()) && Objects.equal(this.getCardinality(), that.getCardinality());
    }

    @Override
    public int compare(S o1, S o2) {
        return o1.compareTo(o2);
    }

    public int hashCode() {
        return Objects.hashCode(this.getSourceName(), this.getName(), this.getType(), this.getCardinality());
    }

    public String toString() {
        return Objects.toStringHelper(this).add("sourceName", this.getSourceName()).add("name", this.getName()).add("type", this.getType()).add("cardinality", this.getCardinality()).toString();
    }
}

