/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import java.io.EOFException;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.kitesdk.data.DatasetIOException;
import org.kitesdk.data.spi.AbstractDatasetReader;
import org.kitesdk.data.spi.DataModelUtil;
import org.kitesdk.data.spi.ReaderWriterState;
import org.kitesdk.shaded.com.google.common.base.Objects;
import org.kitesdk.shaded.com.google.common.base.Preconditions;
import org.kitesdk.shaded.org.apache.parquet.avro.AvroParquetReader;
import org.kitesdk.shaded.org.apache.parquet.avro.AvroReadSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ParquetFileSystemDatasetReader<E extends IndexedRecord>
extends AbstractDatasetReader<E> {
    private FileSystem fileSystem;
    private Path path;
    private Schema schema;
    private Schema readerSchema;
    private Class<E> type;
    private ReaderWriterState state;
    private AvroParquetReader<E> reader;
    private E next;
    private static final Logger LOG = LoggerFactory.getLogger(ParquetFileSystemDatasetReader.class);

    public ParquetFileSystemDatasetReader(FileSystem fileSystem, Path path, Schema schema, Class<E> type) {
        Preconditions.checkArgument(fileSystem != null, "FileSystem cannot be null");
        Preconditions.checkArgument(path != null, "Path cannot be null");
        Preconditions.checkArgument(schema != null, "Schema cannot be null");
        Preconditions.checkArgument(IndexedRecord.class.isAssignableFrom(type) || type == Object.class, "The entity type must implement IndexedRecord");
        this.fileSystem = fileSystem;
        this.path = path;
        this.schema = schema;
        this.type = type;
        this.readerSchema = DataModelUtil.getReaderSchema(type, schema);
        this.state = ReaderWriterState.NEW;
    }

    @Override
    public void initialize() {
        Preconditions.checkState(this.state.equals((Object)ReaderWriterState.NEW), "A reader may not be opened more than once - current state:%s", new Object[]{this.state});
        LOG.debug("Opening reader on path:{}", this.path);
        try {
            Configuration conf = this.fileSystem.getConf();
            AvroReadSupport.setAvroReadSchema(conf, this.readerSchema);
            this.reader = new AvroParquetReader(conf, this.fileSystem.makeQualified(this.path));
        }
        catch (IOException e) {
            throw new DatasetIOException("Unable to create reader path:" + this.path, e);
        }
        this.advance();
        this.state = ReaderWriterState.OPEN;
    }

    @Override
    public boolean hasNext() {
        Preconditions.checkState(this.state.equals((Object)ReaderWriterState.OPEN), "Attempt to read from a file in state:%s", new Object[]{this.state});
        return this.next != null;
    }

    @Override
    public E next() {
        Preconditions.checkState(this.state.equals((Object)ReaderWriterState.OPEN), "Attempt to read from a file in state:%s", new Object[]{this.state});
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        E current = this.next;
        this.advance();
        return current;
    }

    @Override
    public void close() {
        if (!this.state.equals((Object)ReaderWriterState.OPEN)) {
            return;
        }
        LOG.debug("Closing reader on path:{}", this.path);
        try {
            this.reader.close();
        }
        catch (IOException e) {
            this.state = ReaderWriterState.ERROR;
            throw new DatasetIOException("Unable to close reader path:" + this.path, e);
        }
        this.state = ReaderWriterState.CLOSED;
    }

    @Override
    public boolean isOpen() {
        return this.state.equals((Object)ReaderWriterState.OPEN);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("fileSystem", this.fileSystem).add("path", this.path).add("schema", this.schema).add("state", (Object)this.state).add("reader", this.reader).toString();
    }

    private void advance() {
        try {
            this.next = (IndexedRecord)this.reader.read();
        }
        catch (EOFException e) {
            this.next = null;
        }
        catch (IOException e) {
            this.state = ReaderWriterState.ERROR;
            throw new DatasetIOException("Unable to read next record from: " + this.path, e);
        }
    }
}

