/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.kitesdk.shaded.com.google.common.base.Preconditions;
import org.kitesdk.shaded.com.google.common.collect.ImmutableList;
import org.kitesdk.shaded.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class MultiLevelIterator<T>
implements Iterator<List<T>>,
Iterable<List<T>> {
    public static final Logger LOG = LoggerFactory.getLogger(MultiLevelIterator.class);
    private final int depth;
    private final LinkedList<T> current;
    private final LinkedList<Iterator<T>> iterators;
    private boolean initialized = false;
    private boolean hasNext = false;

    public MultiLevelIterator(int depth) {
        Preconditions.checkArgument(depth > 0, "Depth must be > 0");
        this.depth = depth;
        this.current = Lists.newLinkedList();
        this.iterators = Lists.newLinkedList();
        this.initialized = false;
    }

    public abstract Iterable<T> getLevel(List<T> var1);

    private void init() {
        this.iterators.add(this.getLevel(this.current).iterator());
        this.hasNext = this.advance();
    }

    @Override
    public boolean hasNext() {
        if (!this.initialized) {
            this.initialized = true;
            this.init();
        }
        return this.hasNext;
    }

    @Override
    public List<T> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.current.add(this.iterators.getLast().next());
        ImmutableList<T> copy = ImmutableList.copyOf(this.current);
        this.current.removeLast();
        this.hasNext = this.advance();
        return copy;
    }

    private boolean advance() {
        while (this.iterators.size() < this.depth || !this.iterators.getLast().hasNext()) {
            if (this.iterators.getLast().hasNext()) {
                this.current.add(this.iterators.getLast().next());
                this.iterators.add(this.getLevel(this.current).iterator());
                continue;
            }
            this.iterators.removeLast();
            if (this.iterators.isEmpty()) {
                return false;
            }
            this.current.removeLast();
        }
        return true;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public Iterator<List<T>> iterator() {
        return this;
    }
}

