/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.CombineFileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.CombineFileRecordReader;
import org.apache.hadoop.mapreduce.lib.input.CombineFileSplit;
import org.kitesdk.data.DatasetOperationException;
import org.kitesdk.data.spi.filesystem.AbstractCombineFileRecordReader;
import org.kitesdk.shaded.com.google.common.collect.Lists;

abstract class AbstractKiteCombineFileInputFormat<K, V>
extends CombineFileInputFormat<K, V> {
    AbstractKiteCombineFileInputFormat() {
    }

    abstract Class<? extends AbstractCombineFileRecordReader> getRecordReaderClass();

    public RecordReader<K, V> createRecordReader(InputSplit split, TaskAttemptContext taskContext) throws IOException {
        if (split instanceof KiteCombineFileSplit) {
            return new KiteCombineFileRecordReader((KiteCombineFileSplit)split, taskContext, this.getRecordReaderClass());
        }
        throw new DatasetOperationException("Split is not a KiteCombineFileSplit: %s:%s", split.getClass().getCanonicalName(), split);
    }

    public List<InputSplit> getSplits(JobContext job) throws IOException {
        ArrayList<InputSplit> kiteCombineSplits = Lists.newArrayList();
        for (InputSplit inputSplit : super.getSplits(job)) {
            kiteCombineSplits.add(new KiteCombineFileSplit((CombineFileSplit)inputSplit));
        }
        return kiteCombineSplits;
    }

    private static class KiteCombineFileRecordReader
    extends CombineFileRecordReader {
        public KiteCombineFileRecordReader(KiteCombineFileSplit kiteCombineSplit, TaskAttemptContext context, Class rrClass) throws IOException {
            super(kiteCombineSplit.getCombineFileSplit(), context, rrClass);
        }

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            if (!(split instanceof KiteCombineFileSplit)) {
                throw new DatasetOperationException("Split is not a KiteCombineFileSplit: %s:%s", split.getClass().getCanonicalName(), split);
            }
            KiteCombineFileSplit kiteCombineFileSplit = (KiteCombineFileSplit)split;
            super.initialize((InputSplit)kiteCombineFileSplit.getCombineFileSplit(), context);
        }
    }

    static class KiteCombineFileSplit
    extends InputSplit
    implements Writable {
        private CombineFileSplit delegate;

        public KiteCombineFileSplit() {
        }

        public KiteCombineFileSplit(CombineFileSplit delegate) {
            this.delegate = delegate;
        }

        public void readFields(DataInput in) throws IOException {
            this.delegate = new CombineFileSplit();
            this.delegate.readFields(in);
        }

        public void write(DataOutput out) throws IOException {
            this.delegate.write(out);
        }

        public long getLength() throws IOException, InterruptedException {
            return this.delegate.getLength();
        }

        public String[] getLocations() throws IOException, InterruptedException {
            return this.delegate.getLocations();
        }

        CombineFileSplit getCombineFileSplit() {
            return this.delegate;
        }
    }
}

