/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Comparator;
import javax.annotation.concurrent.Immutable;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.impl.Accessor;
import org.kitesdk.data.spi.FieldPartitioner;
import org.kitesdk.data.spi.Marker;

@Immutable
@SuppressWarnings(value={"SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"}, justification="Implement if we intend to use in Serializable objects  (e.g., TreeMaps) and use java serialization.")
public class MarkerComparator
implements Comparator<Marker> {
    private final PartitionStrategy strategy;

    public MarkerComparator(PartitionStrategy strategy) {
        this.strategy = strategy;
    }

    public boolean contains(Marker container, Marker test) {
        for (FieldPartitioner field : Accessor.getDefault().getFieldPartitioners(this.strategy)) {
            Object testValue;
            Object containerValue = container.valueFor(field);
            if (containerValue == null || (testValue = test.valueFor(field)) != null && field.compare(containerValue, testValue) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compare(Marker m1, Marker m2) {
        for (FieldPartitioner field : Accessor.getDefault().getFieldPartitioners(this.strategy)) {
            Object m1Value = m1.valueFor(field);
            Object m2Value = m2.valueFor(field);
            if (m1Value == null) {
                if (m2Value == null) continue;
                throw new IllegalStateException("Incomparable");
            }
            if (m2Value == null) {
                throw new IllegalStateException("Incomparable");
            }
            int cmp = field.compare(m1Value, m2Value);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    public int rightCompare(Marker m1, Marker m2) {
        for (FieldPartitioner field : Accessor.getDefault().getFieldPartitioners(this.strategy)) {
            Object m1Value = m1.valueFor(field);
            Object m2Value = m2.valueFor(field);
            if (m1Value == null) {
                if (m2Value == null) continue;
                return 1;
            }
            if (m2Value == null) {
                return -1;
            }
            int cmp = field.compare(m1Value, m2Value);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    public int leftCompare(Marker m1, Marker m2) {
        for (FieldPartitioner field : Accessor.getDefault().getFieldPartitioners(this.strategy)) {
            Object m1Value = m1.valueFor(field);
            Object m2Value = m2.valueFor(field);
            if (m1Value == null) {
                if (m2Value == null) continue;
                return -1;
            }
            if (m2Value == null) {
                return 1;
            }
            int cmp = field.compare(m1Value, m2Value);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarkerComparator that = (MarkerComparator)o;
        return this.strategy.equals(that.strategy);
    }

    public int hashCode() {
        return this.strategy.hashCode();
    }
}

