/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificRecord;
import org.kitesdk.data.spi.EntityAccessor;
import org.kitesdk.shaded.com.google.common.annotations.VisibleForTesting;

public class DataModelUtil {
    public static <E> GenericData getDataModelForType(Class<E> type) {
        if (SpecificRecord.class.isAssignableFrom(type)) {
            return new SpecificData(type.getClassLoader());
        }
        if (IndexedRecord.class.isAssignableFrom(type)) {
            return GenericData.get();
        }
        return AllowNulls.get();
    }

    public static boolean isGeneric(Class<?> type) {
        return !SpecificRecord.class.isAssignableFrom(type) && GenericRecord.class.isAssignableFrom(type);
    }

    public static <E> DatumReader<E> getDatumReaderForType(Class<E> type, Schema writerSchema) {
        Schema readerSchema = DataModelUtil.getReaderSchema(type, writerSchema);
        GenericData dataModel = DataModelUtil.getDataModelForType(type);
        if (dataModel instanceof ReflectData) {
            return new ReflectDatumReader(writerSchema, readerSchema, (ReflectData)dataModel);
        }
        if (dataModel instanceof SpecificData) {
            return new SpecificDatumReader(writerSchema, readerSchema, (SpecificData)dataModel);
        }
        return new GenericDatumReader(writerSchema, readerSchema, dataModel);
    }

    public static <E> Class<E> resolveType(Class<E> type, Schema schema) {
        if (type == Object.class) {
            type = ReflectData.get().getClass(schema);
        }
        if (type == null) {
            type = GenericData.Record.class;
        }
        return type;
    }

    public static <E> Schema getReaderSchema(Class<E> type, Schema schema) {
        Schema readerSchema = schema;
        GenericData dataModel = DataModelUtil.getDataModelForType(type);
        if (dataModel instanceof SpecificData) {
            readerSchema = ((SpecificData)dataModel).getSchema(type);
        }
        return readerSchema;
    }

    public static <E> Schema getWriterSchema(Class<E> type, Schema schema) {
        Schema writerSchema = schema;
        GenericData dataModel = DataModelUtil.getDataModelForType(type);
        if (dataModel instanceof AllowNulls) {
            dataModel = ReflectData.get();
        }
        if (dataModel instanceof SpecificData) {
            writerSchema = ((SpecificData)dataModel).getSchema(type);
        }
        return writerSchema;
    }

    public static <E> E createRecord(Class<E> type, Schema schema) {
        if (DataModelUtil.isGeneric(type) && !type.isInterface()) {
            if (GenericData.Record.class.equals(type)) {
                return (E)GenericData.get().newRecord(null, schema);
            }
            return (E)ReflectData.newInstance(type, schema);
        }
        return null;
    }

    public static <E> EntityAccessor<E> accessor(Class<E> type, Schema schema) {
        return new EntityAccessor<E>(type, schema);
    }

    @VisibleForTesting
    static class AllowNulls
    extends ReflectData {
        private static final AllowNulls INSTANCE = new AllowNulls();

        AllowNulls() {
        }

        public static AllowNulls get() {
            return INSTANCE;
        }

        @Override
        protected Schema createFieldSchema(Field field, Map<String, Schema> names) {
            Schema schema = super.createFieldSchema(field, names);
            if (field.getType().isPrimitive()) {
                return schema;
            }
            return AllowNulls.makeNullableSchema(schema);
        }

        public static Schema makeNullableSchema(Schema schema) {
            if (schema.getType() == Schema.Type.UNION) {
                for (Schema subType : schema.getTypes()) {
                    if (subType.getType() != Schema.Type.NULL) continue;
                    return schema;
                }
                ArrayList<Schema> withNull = new ArrayList<Schema>();
                withNull.add(Schema.create(Schema.Type.NULL));
                withNull.addAll(schema.getTypes());
                return Schema.createUnion(withNull);
            }
            return Schema.createUnion(Arrays.asList(Schema.create(Schema.Type.NULL), schema));
        }
    }
}

