/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.hbase.manager;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.client.HTablePool;
import org.kitesdk.data.hbase.avro.AvroEntitySchema;
import org.kitesdk.data.hbase.avro.AvroKeyEntitySchemaParser;
import org.kitesdk.data.hbase.avro.AvroUtils;
import org.kitesdk.data.hbase.avro.SpecificAvroDao;
import org.kitesdk.data.hbase.impl.Dao;
import org.kitesdk.data.hbase.impl.EntityScanner;
import org.kitesdk.data.hbase.manager.ManagedSchemaDao;
import org.kitesdk.data.hbase.manager.generated.ManagedSchema;
import org.kitesdk.data.spi.PartitionKey;

class ManagedSchemaHBaseDao
implements ManagedSchemaDao {
    public static final String DEFAULT_MANAGED_SCHEMA_TABLE = "managed_schemas";
    private static final AvroKeyEntitySchemaParser schemaParser = new AvroKeyEntitySchemaParser();
    private static final AvroEntitySchema managedSchemaEntity;
    private Dao<ManagedSchema> managedSchemaDao;

    public ManagedSchemaHBaseDao(HTablePool tablePool) {
        this(tablePool, DEFAULT_MANAGED_SCHEMA_TABLE);
    }

    public ManagedSchemaHBaseDao(HTablePool tablePool, String managedSchemaTable) {
        this.managedSchemaDao = new SpecificAvroDao<ManagedSchema>(tablePool, managedSchemaTable, managedSchemaEntity.getRawSchema(), ManagedSchema.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ManagedSchema> getManagedSchemas() {
        ArrayList<ManagedSchema> returnList = new ArrayList<ManagedSchema>();
        entityScanner.initialize();
        try (EntityScanner<ManagedSchema> entityScanner = this.managedSchemaDao.getScanner();){
            for (ManagedSchema entity : entityScanner) {
                returnList.add(entity);
            }
        }
        return returnList;
    }

    @Override
    public ManagedSchema getManagedSchema(String tableName, String entityName) {
        PartitionKey key = new PartitionKey(tableName, entityName);
        ManagedSchema managedSchemaRecord = this.managedSchemaDao.get(key);
        if (managedSchemaRecord == null) {
            return null;
        }
        return managedSchemaRecord;
    }

    @Override
    public boolean save(ManagedSchema schema) {
        return this.managedSchemaDao.put(schema);
    }

    @Override
    public boolean delete(ManagedSchema schema) {
        return this.managedSchemaDao.delete(schema);
    }

    static {
        String str = AvroUtils.inputStreamToString(ManagedSchemaHBaseDao.class.getResourceAsStream("/ManagedSchema.avsc"));
        managedSchemaEntity = schemaParser.parseEntitySchema(str);
    }
}

