/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.hbase.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hbase.client.HTablePool;
import org.kitesdk.data.ConcurrentSchemaModificationException;
import org.kitesdk.data.DatasetException;
import org.kitesdk.data.FieldMapping;
import org.kitesdk.data.IncompatibleSchemaException;
import org.kitesdk.data.SchemaNotFoundException;
import org.kitesdk.data.hbase.impl.EntitySchema;
import org.kitesdk.data.hbase.impl.KeyEntitySchemaParser;
import org.kitesdk.data.hbase.impl.KeySchema;
import org.kitesdk.data.hbase.impl.SchemaManager;
import org.kitesdk.data.hbase.manager.ManagedSchemaDao;
import org.kitesdk.data.hbase.manager.ManagedSchemaHBaseDao;
import org.kitesdk.data.hbase.manager.generated.ManagedSchema;
import org.kitesdk.shaded.com.google.common.collect.Lists;
import org.kitesdk.shaded.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSchemaManager
implements SchemaManager {
    private static Logger LOG = LoggerFactory.getLogger(DefaultSchemaManager.class);
    private volatile ConcurrentHashMap<String, ManagedSchema> managedSchemaMap;
    private ManagedSchemaDao managedSchemaDao;
    private ConcurrentHashMap<String, KeyEntitySchemaParser<?, ?>> schemaParsers = new ConcurrentHashMap();

    public DefaultSchemaManager(HTablePool tablePool) {
        this(new ManagedSchemaHBaseDao(tablePool));
    }

    public DefaultSchemaManager(HTablePool tablePool, String managedSchemaTable) {
        this(new ManagedSchemaHBaseDao(tablePool, managedSchemaTable));
    }

    public DefaultSchemaManager(ManagedSchemaDao managedSchemaDao) {
        this.managedSchemaDao = managedSchemaDao;
    }

    @Override
    public boolean hasManagedSchema(String tableName, String entityName) {
        ManagedSchema managedSchema;
        try {
            managedSchema = this.getManagedSchema(tableName, entityName);
        }
        catch (SchemaNotFoundException e) {
            managedSchema = null;
        }
        return managedSchema != null;
    }

    @Override
    public KeySchema getKeySchema(String tableName, String entityName) {
        ManagedSchema managedSchema = this.getManagedSchema(tableName, entityName);
        KeyEntitySchemaParser<?, ?> schemaParser = this.getSchemaParser(managedSchema.getSchemaType());
        String greatestVersionedSchema = this.getGreatestEntitySchemaString(managedSchema);
        return schemaParser.parseKeySchema(greatestVersionedSchema);
    }

    @Override
    public EntitySchema getEntitySchema(String tableName, String entityName) {
        ManagedSchema managedSchema = this.getManagedSchema(tableName, entityName);
        KeyEntitySchemaParser<?, ?> schemaParser = this.getSchemaParser(managedSchema.getSchemaType());
        String greatestVersionedSchema = this.getGreatestEntitySchemaString(managedSchema);
        return schemaParser.parseEntitySchema(greatestVersionedSchema);
    }

    private String getGreatestEntitySchemaString(ManagedSchema managedSchema) {
        int greatestVersion = -1;
        String greatestVersionedSchema = null;
        for (Map.Entry<String, String> entry : managedSchema.getEntitySchemas().entrySet()) {
            int version = Integer.parseInt(entry.getKey());
            if (version <= greatestVersion) continue;
            greatestVersion = version;
            greatestVersionedSchema = entry.getValue();
        }
        if (greatestVersionedSchema == null) {
            String msg = "No schema versions for " + managedSchema.getTable() + ", " + managedSchema.getName();
            LOG.error(msg);
            throw new SchemaNotFoundException(msg);
        }
        return greatestVersionedSchema;
    }

    @Override
    public EntitySchema getEntitySchema(String tableName, String entityName, int version) {
        String schema;
        ManagedSchema managedSchema = this.getManagedSchema(tableName, entityName);
        KeyEntitySchemaParser<?, ?> schemaParser = this.getSchemaParser(managedSchema.getSchemaType());
        if (!managedSchema.getEntitySchemas().containsKey(String.valueOf(version))) {
            this.refreshManagedSchemaCache(tableName, entityName);
            managedSchema = this.getManagedSchema(tableName, entityName);
        }
        if ((schema = managedSchema.getEntitySchemas().get(String.valueOf(version))) != null) {
            return schemaParser.parseEntitySchema(schema);
        }
        String msg = "Could not find managed schema for " + tableName + ", " + entityName + ", and version " + Integer.toString(version);
        LOG.error(msg);
        throw new SchemaNotFoundException(msg);
    }

    @Override
    public Map<Integer, EntitySchema> getEntitySchemas(String tableName, String entityName) {
        ManagedSchema managedSchema = this.getManagedSchema(tableName, entityName);
        KeyEntitySchemaParser<?, ?> schemaParser = this.getSchemaParser(managedSchema.getSchemaType());
        HashMap<Integer, EntitySchema> retMap = new HashMap<Integer, EntitySchema>();
        for (Map.Entry<String, String> entry : managedSchema.getEntitySchemas().entrySet()) {
            Object entitySchema = schemaParser.parseEntitySchema(entry.getValue());
            retMap.put(Integer.parseInt(entry.getKey()), (EntitySchema)entitySchema);
        }
        return retMap;
    }

    @Override
    public int getEntityVersion(String tableName, String entityName, EntitySchema schema) {
        for (Map.Entry<Integer, EntitySchema> entry : this.getEntitySchemas(tableName, entityName).entrySet()) {
            if (!schema.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        String msg = "Could not find managed version for " + tableName + ", " + entityName + " that matches " + schema;
        LOG.error(msg);
        throw new SchemaNotFoundException(msg);
    }

    @Override
    public boolean hasSchemaVersion(String tableName, String entityName, EntitySchema schema) {
        for (Map.Entry<Integer, EntitySchema> entry : this.getEntitySchemas(tableName, entityName).entrySet()) {
            if (!entry.getValue().equals(schema)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void createSchema(String tableName, String entityName, String entitySchemaStr, String schemaParserType, String keySerDeType, String entitySerDeType) {
        ManagedSchema managedSchema2;
        this.refreshManagedSchemaCache(tableName, entityName);
        KeyEntitySchemaParser<?, ?> schemaParser = this.getSchemaParser(schemaParserType);
        Object keySchema = schemaParser.parseKeySchema(entitySchemaStr);
        Object entitySchema = schemaParser.parseEntitySchema(entitySchemaStr);
        try {
            managedSchema2 = this.getManagedSchema(tableName, entityName);
            if (managedSchema2 != null) {
                throw new IncompatibleSchemaException("Cannot create schema when one already exists");
            }
        }
        catch (SchemaNotFoundException managedSchema2) {
            // empty catch block
        }
        this.validateCompatibleWithTableSchemas(tableName, (KeySchema)keySchema, (EntitySchema)entitySchema);
        managedSchema2 = ManagedSchema.newBuilder().setName(entityName).setTable(tableName).setEntitySchemas(new HashMap<String, String>()).setSchemaType(schemaParserType).setEntitySerDeType(entitySerDeType).setKeySerDeType(keySerDeType).build();
        managedSchema2.getEntitySchemas().put("0", ((EntitySchema)entitySchema).getRawSchema());
        if (!this.managedSchemaDao.save(managedSchema2)) {
            throw new ConcurrentSchemaModificationException("The schema has been updated concurrently.");
        }
        this.getManagedSchemaMap().put(this.getManagedSchemaMapKey(managedSchema2.getTable(), managedSchema2.getName()), managedSchema2);
    }

    @Override
    public void migrateSchema(String tableName, String entityName, String newSchemaStr) {
        this.refreshManagedSchemaCache(tableName, entityName);
        ManagedSchema managedSchema = this.getManagedSchema(tableName, entityName);
        KeyEntitySchemaParser<?, ?> schemaParser = this.getSchemaParser(managedSchema.getSchemaType());
        Object newEntitySchema = schemaParser.parseEntitySchema(newSchemaStr);
        Object newKeySchema = schemaParser.parseKeySchema(newSchemaStr);
        if (this.hasSchemaVersion(tableName, entityName, (EntitySchema)newEntitySchema)) {
            throw new IncompatibleSchemaException("Schema already exists as version: " + this.getEntityVersion(tableName, entityName, (EntitySchema)newEntitySchema));
        }
        int greatestSchemaVersion = 0;
        for (Map.Entry<String, String> entry : managedSchema.getEntitySchemas().entrySet()) {
            int version = Integer.parseInt(entry.getKey());
            if (version > greatestSchemaVersion) {
                greatestSchemaVersion = version;
            }
            String schemaString = entry.getValue();
            Object keySchema = schemaParser.parseKeySchema(schemaString);
            Object entitySchema = schemaParser.parseEntitySchema(schemaString);
            if (!((KeySchema)newKeySchema).compatible((KeySchema)keySchema)) {
                String msg = "StorageKey fields of entity schema not compatible with version " + Integer.toString(version) + ": Old schema: " + schemaString + " New schema: " + ((EntitySchema)newEntitySchema).getRawSchema();
                throw new IncompatibleSchemaException(msg);
            }
            if (((EntitySchema)newEntitySchema).compatible((EntitySchema)entitySchema)) continue;
            String msg = "Avro schema not compatible with version " + Integer.toString(version) + ": Old schema: " + schemaString + " New schema: " + ((EntitySchema)newEntitySchema).getRawSchema();
            throw new IncompatibleSchemaException(msg);
        }
        this.validateCompatibleWithTableSchemas(tableName, (KeySchema)newKeySchema, (EntitySchema)newEntitySchema);
        managedSchema.getEntitySchemas().put(Integer.toString(greatestSchemaVersion + 1), ((EntitySchema)newEntitySchema).getRawSchema());
        if (!this.managedSchemaDao.save(managedSchema)) {
            throw new ConcurrentSchemaModificationException("The schema has been updated concurrently.");
        }
    }

    @Override
    public void deleteSchema(String tableName, String entityName) {
        this.refreshManagedSchemaCache(tableName, entityName);
        ManagedSchema managedSchema = this.getManagedSchema(tableName, entityName);
        if (!this.managedSchemaDao.delete(managedSchema)) {
            throw new ConcurrentSchemaModificationException("The schema has been updated concurrently.");
        }
        this.getManagedSchemaMap().remove(this.getManagedSchemaMapKey(managedSchema.getTable(), managedSchema.getName()));
    }

    @Override
    public void refreshManagedSchemaCache(String tableName, String entityName) {
        ManagedSchema managedSchema = this.managedSchemaDao.getManagedSchema(tableName, entityName);
        if (managedSchema != null) {
            this.getManagedSchemaMap().put(this.getManagedSchemaMapKey(managedSchema.getTable(), managedSchema.getName()), managedSchema);
        }
    }

    @Override
    public List<String> getEntityNames(String tableName) {
        ArrayList<String> names = Lists.newArrayList();
        for (ManagedSchema managedSchema : this.managedSchemaMap.values()) {
            if (!managedSchema.getTable().equals(tableName)) continue;
            names.add(managedSchema.getName());
        }
        return names;
    }

    @Override
    public Collection<String> getTableNames() {
        HashSet<String> tables = Sets.newHashSet();
        for (ManagedSchema managedSchema : this.managedSchemaDao.getManagedSchemas()) {
            tables.add(managedSchema.getTable());
        }
        return tables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConcurrentHashMap<String, ManagedSchema> getManagedSchemaMap() {
        if (this.managedSchemaMap == null) {
            DefaultSchemaManager defaultSchemaManager = this;
            synchronized (defaultSchemaManager) {
                if (this.managedSchemaMap == null) {
                    this.managedSchemaMap = new ConcurrentHashMap();
                    this.populateManagedSchemaMap();
                }
            }
        }
        return this.managedSchemaMap;
    }

    private void populateManagedSchemaMap() {
        List<ManagedSchema> schemas = this.managedSchemaDao.getManagedSchemas();
        for (ManagedSchema managedSchema : schemas) {
            this.getManagedSchemaMap().put(this.getManagedSchemaMapKey(managedSchema.getTable(), managedSchema.getName()), managedSchema);
        }
    }

    private ManagedSchema getManagedSchemaFromSchemaMap(String tableName, String entityName) {
        return this.getManagedSchemaMap().get(this.getManagedSchemaMapKey(tableName, entityName));
    }

    private KeyEntitySchemaParser<?, ?> getSchemaParser(String schemaParserClassName) {
        if (this.schemaParsers.contains(schemaParserClassName)) {
            return this.schemaParsers.get(schemaParserClassName);
        }
        try {
            Class<?> schemaParserClass = Class.forName(schemaParserClassName);
            KeyEntitySchemaParser schemaParser = (KeyEntitySchemaParser)schemaParserClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.schemaParsers.putIfAbsent(schemaParserClassName, schemaParser);
            return schemaParser;
        }
        catch (Exception e) {
            throw new DatasetException("Could not instantiate schema parser class: " + schemaParserClassName, e);
        }
    }

    private Map<Integer, String> getManagedSchemaVersions(String tableName, String entityName) {
        ManagedSchema managedSchema = this.getManagedSchema(tableName, entityName);
        HashMap<Integer, String> returnMap = new HashMap<Integer, String>();
        for (Map.Entry<String, String> versionsEntry : managedSchema.getEntitySchemas().entrySet()) {
            returnMap.put(Integer.parseInt(versionsEntry.getKey()), versionsEntry.getValue());
        }
        return returnMap;
    }

    private ManagedSchema getManagedSchema(String tableName, String entityName) {
        ManagedSchema managedSchema = this.getManagedSchemaFromSchemaMap(tableName, entityName);
        if (managedSchema == null) {
            this.refreshManagedSchemaCache(tableName, entityName);
            managedSchema = this.getManagedSchemaFromSchemaMap(tableName, entityName);
            if (managedSchema == null) {
                String msg = "Could not find managed schemas for " + tableName + ", " + entityName;
                throw new SchemaNotFoundException(msg);
            }
        }
        return managedSchema;
    }

    private void validateCompatibleWithTableSchemas(String tableName, KeySchema keySchema, EntitySchema entitySchema) {
        ArrayList<ManagedSchema> entitiesForTable = new ArrayList<ManagedSchema>();
        for (Map.Entry<String, ManagedSchema> entry : this.getManagedSchemaMap().entrySet()) {
            if (!entry.getKey().startsWith(tableName + ":")) continue;
            entitiesForTable.add(entry.getValue());
        }
        for (ManagedSchema managedSchema : entitiesForTable) {
            if (managedSchema.getName().equals(entitySchema.getName())) continue;
            KeyEntitySchemaParser<?, ?> parser = this.getSchemaParser(managedSchema.getSchemaType());
            for (String schema : managedSchema.getEntitySchemas().values()) {
                Object otherEntitySchema = parser.parseEntitySchema(schema);
                Object otherKeySchema = parser.parseKeySchema(schema);
                if (!keySchema.compatible((KeySchema)otherKeySchema)) {
                    String msg = "StorageKey fields of schema not compatible with other schema for the table. Table: " + tableName + ". Other schema: " + ((EntitySchema)otherEntitySchema).getRawSchema() + " New schema: " + entitySchema.getRawSchema();
                    throw new IncompatibleSchemaException(msg);
                }
                if (!this.validateCompatibleWithTableColumns(entitySchema, (EntitySchema)otherEntitySchema)) {
                    String msg = "Column mappings of schema not compatible with other schema for the table. Table: " + tableName + ". Other schema: " + ((EntitySchema)otherEntitySchema).getRawSchema() + " New schema: " + entitySchema.getRawSchema();
                    throw new IncompatibleSchemaException(msg);
                }
                if (this.validateCompatibleWithTableOccVersion(entitySchema, (EntitySchema)otherEntitySchema)) continue;
                String msg = "OCCVersion mapping of schema not compatible with other schema for the table. Only one schema in the table can have one.Table: " + tableName + ". Other schema: " + ((EntitySchema)otherEntitySchema).getRawSchema() + " New schema: " + entitySchema.getRawSchema();
                throw new IncompatibleSchemaException(msg);
            }
        }
    }

    private boolean validateCompatibleWithTableColumns(EntitySchema entitySchema1, EntitySchema entitySchema2) {
        HashSet<String> entitySchema1Columns = new HashSet<String>();
        ArrayList<String> entitySchema1KeyAsColumns = new ArrayList<String>();
        for (FieldMapping fieldMapping1 : entitySchema1.getColumnMappingDescriptor().getFieldMappings()) {
            if (fieldMapping1.getMappingType() == FieldMapping.MappingType.COLUMN || fieldMapping1.getMappingType() == FieldMapping.MappingType.COUNTER) {
                entitySchema1Columns.add(DefaultSchemaManager.getColumnValue(fieldMapping1));
                continue;
            }
            if (fieldMapping1.getMappingType() != FieldMapping.MappingType.KEY_AS_COLUMN) continue;
            entitySchema1KeyAsColumns.add(DefaultSchemaManager.getColumnValue(fieldMapping1));
        }
        for (FieldMapping fieldMapping2 : entitySchema2.getColumnMappingDescriptor().getFieldMappings()) {
            if (fieldMapping2.getMappingType() == FieldMapping.MappingType.COLUMN || fieldMapping2.getMappingType() == FieldMapping.MappingType.COUNTER) {
                String value = DefaultSchemaManager.getColumnValue(fieldMapping2);
                if (entitySchema1Columns.contains(value)) {
                    LOG.warn("Field: " + fieldMapping2.getFieldName() + " has a table column conflict with a column mapped field in " + entitySchema1.getName());
                    return false;
                }
                for (String keyAsColumn : entitySchema1KeyAsColumns) {
                    if (!value.startsWith(keyAsColumn)) continue;
                    LOG.warn("Field: " + fieldMapping2.getFieldName() + " has a table column conflict with a keyAsColumn mapped field in " + entitySchema1.getName());
                    return false;
                }
                continue;
            }
            if (fieldMapping2.getMappingType() != FieldMapping.MappingType.KEY_AS_COLUMN) continue;
            String entitySchema2KeyAsColumn = DefaultSchemaManager.getColumnValue(fieldMapping2);
            for (String entitySchema1KeyAsColumn : entitySchema1KeyAsColumns) {
                if (!entitySchema1KeyAsColumn.startsWith(entitySchema2KeyAsColumn)) continue;
                LOG.warn("Field " + fieldMapping2.getFieldName() + " has a table keyAsColumn conflict with a keyAsColumn mapped field in " + entitySchema1.getName());
                return false;
            }
            for (String entitySchema1Column : entitySchema1Columns) {
                if (!entitySchema1Column.startsWith(entitySchema2KeyAsColumn)) continue;
                LOG.warn("Field " + fieldMapping2.getFieldName() + " has a table keyAsColumn conflict with a column mapped field in " + entitySchema1.getName());
                return false;
            }
        }
        return true;
    }

    private static String getColumnValue(FieldMapping fm) {
        switch (fm.getMappingType()) {
            case COLUMN: 
            case COUNTER: {
                return fm.getFamilyAsString() + ":" + fm.getQualifierAsString();
            }
            case KEY_AS_COLUMN: {
                return fm.getFamilyAsString() + ":" + (fm.getPrefix() == null ? "" : fm.getPrefix());
            }
        }
        return null;
    }

    private boolean validateCompatibleWithTableOccVersion(EntitySchema entitySchema1, EntitySchema entitySchema2) {
        boolean foundOccMapping = false;
        for (FieldMapping fieldMapping : entitySchema1.getColumnMappingDescriptor().getFieldMappings()) {
            if (fieldMapping.getMappingType() != FieldMapping.MappingType.OCC_VERSION) continue;
            foundOccMapping = true;
            break;
        }
        if (foundOccMapping) {
            for (FieldMapping fieldMapping : entitySchema2.getColumnMappingDescriptor().getFieldMappings()) {
                if (fieldMapping.getMappingType() != FieldMapping.MappingType.OCC_VERSION) continue;
                LOG.warn("Field: " + fieldMapping.getFieldName() + " in schema " + entitySchema2.getName() + " conflicts with an occVersion field in " + entitySchema1.getName());
                return false;
            }
        }
        return true;
    }

    private String getManagedSchemaMapKey(String tableName, String entityName) {
        return tableName + ":" + entityName;
    }
}

