/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.hbase.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.kitesdk.data.hbase.HBaseDatasetRepository;
import org.kitesdk.data.spi.DatasetRepository;
import org.kitesdk.data.spi.DefaultConfiguration;
import org.kitesdk.data.spi.Loadable;
import org.kitesdk.data.spi.OptionBuilder;
import org.kitesdk.data.spi.Registration;
import org.kitesdk.data.spi.URIPattern;
import org.kitesdk.shaded.com.google.common.annotations.VisibleForTesting;
import org.kitesdk.shaded.com.google.common.base.Joiner;
import org.kitesdk.shaded.com.google.common.base.Splitter;
import org.kitesdk.shaded.com.google.common.collect.Lists;

public class Loader
implements Loadable {
    @Override
    public void load() {
        Registration.register(new URIPattern("hbase::zk"), new URIPattern("hbase::zk/:dataset?namespace=default"), new OptionBuilder<DatasetRepository>(){

            @Override
            public DatasetRepository getFromOptions(Map<String, String> options) {
                Configuration conf = HBaseConfiguration.create((Configuration)DefaultConfiguration.get());
                String[] hostsAndPort = Loader.parseHostsAndPort(options.get("zk"));
                conf.set("hbase.zookeeper.quorum", hostsAndPort[0]);
                String port = hostsAndPort[1];
                if (port != null) {
                    conf.set("hbase.zookeeper.property.clientPort", port);
                }
                return new HBaseDatasetRepository.Builder().configuration(conf).build();
            }
        });
    }

    @VisibleForTesting
    public static String[] parseHostsAndPort(String zkQuorum) {
        ArrayList<String> hosts = Lists.newArrayList();
        String port = null;
        for (String hostPort : Splitter.on(',').split(zkQuorum)) {
            Iterator<String> split = Splitter.on(':').split(hostPort).iterator();
            hosts.add(split.next());
            if (!split.hasNext()) continue;
            String p = split.next();
            if (port == null) {
                port = p;
                continue;
            }
            if (port.equals(p)) continue;
            throw new IllegalArgumentException("Mismatched ports in " + zkQuorum);
        }
        return new String[]{Joiner.on(',').join(hosts), port};
    }
}

