/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.hbase.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.HTablePool;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.kitesdk.data.DatasetIOException;
import org.kitesdk.data.hbase.impl.BaseEntityBatch;
import org.kitesdk.data.hbase.impl.BaseEntityScanner;
import org.kitesdk.data.hbase.impl.Constants;
import org.kitesdk.data.hbase.impl.DeleteAction;
import org.kitesdk.data.hbase.impl.DeleteActionModifier;
import org.kitesdk.data.hbase.impl.EntityBatch;
import org.kitesdk.data.hbase.impl.EntityMapper;
import org.kitesdk.data.hbase.impl.EntityScannerBuilder;
import org.kitesdk.data.hbase.impl.GetModifier;
import org.kitesdk.data.hbase.impl.HBaseUtils;
import org.kitesdk.data.hbase.impl.KeySerDe;
import org.kitesdk.data.hbase.impl.PutAction;
import org.kitesdk.data.hbase.impl.PutActionModifier;
import org.kitesdk.data.hbase.impl.ScanModifier;
import org.kitesdk.data.hbase.impl.VersionCheckAction;
import org.kitesdk.data.spi.PartitionKey;
import org.kitesdk.shaded.com.google.common.annotations.VisibleForTesting;
import org.kitesdk.shaded.com.google.common.collect.ImmutableList;

public class HBaseClientTemplate {
    private final HTablePool pool;
    private final String tableName;
    private final List<GetModifier> getModifiers = new ArrayList<GetModifier>();
    private final List<PutActionModifier> putActionModifiers = new ArrayList<PutActionModifier>();
    private final List<DeleteActionModifier> deleteActionModifiers = new ArrayList<DeleteActionModifier>();
    private final List<ScanModifier> scanModifiers = new ArrayList<ScanModifier>();

    public HBaseClientTemplate(HTablePool pool, String tableName) {
        this.pool = pool;
        this.tableName = tableName;
    }

    public HBaseClientTemplate(HBaseClientTemplate clientTemplate) {
        this.pool = clientTemplate.pool;
        this.tableName = clientTemplate.tableName;
        this.getModifiers.addAll(clientTemplate.getModifiers);
        this.putActionModifiers.addAll(clientTemplate.putActionModifiers);
        this.deleteActionModifiers.addAll(clientTemplate.deleteActionModifiers);
        this.scanModifiers.addAll(clientTemplate.scanModifiers);
    }

    public void registerGetModifier(GetModifier getModifier) {
        int currentIndex = this.getModifiers.indexOf(getModifier);
        if (currentIndex == -1) {
            this.getModifiers.add(getModifier);
        } else {
            this.getModifiers.set(currentIndex, getModifier);
        }
    }

    public List<GetModifier> getGetModifiers() {
        return ImmutableList.copyOf(this.getModifiers);
    }

    public void registerPutActionModifier(PutActionModifier putActionModifier) {
        int currentIndex = this.putActionModifiers.indexOf(putActionModifier);
        if (currentIndex == -1) {
            this.putActionModifiers.add(putActionModifier);
        } else {
            this.putActionModifiers.set(currentIndex, putActionModifier);
        }
    }

    public List<PutActionModifier> getPutActionModifiers() {
        return ImmutableList.copyOf(this.putActionModifiers);
    }

    @VisibleForTesting
    public int countPutActionModifiers() {
        return this.putActionModifiers.size();
    }

    public void registerDeleteModifier(DeleteActionModifier deleteActionModifier) {
        int currentIndex = this.deleteActionModifiers.indexOf(deleteActionModifier);
        if (currentIndex == -1) {
            this.deleteActionModifiers.add(deleteActionModifier);
        } else {
            this.deleteActionModifiers.set(currentIndex, deleteActionModifier);
        }
    }

    public List<DeleteActionModifier> getDeleteActionModifiers() {
        return ImmutableList.copyOf(this.deleteActionModifiers);
    }

    public void registerScanModifier(ScanModifier scanModifier) {
        int currentIndex = this.scanModifiers.indexOf(scanModifier);
        if (currentIndex == -1) {
            this.scanModifiers.add(scanModifier);
        } else {
            this.scanModifiers.set(currentIndex, scanModifier);
        }
    }

    public List<ScanModifier> getScanModifiers() {
        return ImmutableList.copyOf(this.scanModifiers);
    }

    public void clearGetModifiers() {
        this.getModifiers.clear();
    }

    public void clearPutActionModifiers() {
        this.putActionModifiers.clear();
    }

    public void clearDeleteActionModifiers() {
        this.deleteActionModifiers.clear();
    }

    public void clearScanModifiers() {
        this.scanModifiers.clear();
    }

    public void clearAllModifiers() {
        this.clearGetModifiers();
        this.clearPutActionModifiers();
        this.clearDeleteActionModifiers();
        this.clearScanModifiers();
    }

    public String getTableName() {
        return this.tableName;
    }

    public Result get(Get get) {
        HTableInterface table = this.pool.getTable(this.tableName);
        try {
            for (GetModifier getModifier : this.getModifiers) {
                get = getModifier.modifyGet(get);
            }
            try {
                Result result = table.get(get);
                return result;
            }
            catch (IOException e) {
                throw new DatasetIOException("Error performing get", e);
            }
        }
        finally {
            if (table != null) {
                try {
                    table.close();
                }
                catch (IOException e) {
                    throw new DatasetIOException("Error putting table back into pool", e);
                }
            }
        }
    }

    public Result get(Get get, GetModifier getModifier) {
        if (getModifier != null) {
            get = getModifier.modifyGet(get);
        }
        return this.get(get);
    }

    public <E> E get(PartitionKey key, EntityMapper<E> entityMapper) {
        return this.get(key, null, entityMapper);
    }

    public <E> E get(PartitionKey key, GetModifier getModifier, EntityMapper<E> entityMapper) {
        byte[] keyBytes = entityMapper.getKeySerDe().serialize(key);
        Get get = new Get(keyBytes);
        HBaseUtils.addColumnsToGet(entityMapper.getRequiredColumns(), get);
        Result result = this.get(get, getModifier);
        if (result.isEmpty()) {
            return null;
        }
        return entityMapper.mapToEntity(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(PutAction putAction) {
        HTableInterface table = this.pool.getTable(this.tableName);
        try {
            boolean bl = this.put(putAction, table);
            return bl;
        }
        finally {
            if (table != null) {
                try {
                    table.close();
                }
                catch (IOException e) {
                    throw new DatasetIOException("Error putting table back into pool", e);
                }
            }
        }
    }

    public boolean put(PutAction putAction, HTableInterface table) {
        for (PutActionModifier putActionModifier : this.putActionModifiers) {
            putAction = putActionModifier.modifyPutAction(putAction);
        }
        Put put = putAction.getPut();
        if (putAction.getVersionCheckAction() != null) {
            byte[] versionBytes = null;
            long version = putAction.getVersionCheckAction().getVersion();
            if (version != 0L) {
                versionBytes = Bytes.toBytes((long)version);
            }
            try {
                return table.checkAndPut(put.getRow(), Constants.SYS_COL_FAMILY, Constants.VERSION_CHECK_COL_QUALIFIER, versionBytes, put);
            }
            catch (IOException e) {
                throw new DatasetIOException("Error putting row from table with checkAndPut", e);
            }
        }
        try {
            table.put(put);
            return true;
        }
        catch (IOException e) {
            throw new DatasetIOException("Error putting row from table", e);
        }
    }

    public boolean put(PutAction putAction, PutActionModifier putActionModifier) {
        if (putActionModifier != null) {
            putAction = putActionModifier.modifyPutAction(putAction);
        }
        return this.put(putAction);
    }

    public <E> boolean put(E entity, EntityMapper<E> entityMapper) {
        return this.put(entity, null, entityMapper);
    }

    public <E> boolean put(E entity, PutActionModifier putActionModifier, EntityMapper<E> entityMapper) {
        PutAction putAction = entityMapper.mapFromEntity(entity);
        return this.put(putAction, putActionModifier);
    }

    public <E> long increment(PartitionKey key, String fieldName, long amount, EntityMapper<E> entityMapper) {
        Result result;
        Increment increment = entityMapper.mapToIncrement(key, fieldName, amount);
        HTableInterface table = this.pool.getTable(this.tableName);
        try {
            result = table.increment(increment);
        }
        catch (IOException e) {
            throw new DatasetIOException("Error incrementing field.", e);
        }
        return entityMapper.mapFromIncrementResult(result, fieldName);
    }

    /*
     * Unable to fully structure code
     */
    public boolean delete(DeleteAction deleteAction) {
        table = this.pool.getTable(this.tableName);
        for (DeleteActionModifier deleteActionModifier : this.deleteActionModifiers) {
            deleteAction = deleteActionModifier.modifyDeleteAction(deleteAction);
        }
        delete = deleteAction.getDelete();
        if (deleteAction.getVersionCheckAction() != null) {
            versionBytes = Bytes.toBytes((long)deleteAction.getVersionCheckAction().getVersion());
            try {
                var5_7 = table.checkAndDelete(delete.getRow(), Constants.SYS_COL_FAMILY, Constants.VERSION_CHECK_COL_QUALIFIER, versionBytes, delete);
                return var5_7;
            }
            catch (IOException e) {
                throw new DatasetIOException("Error deleteing row from table with checkAndDelete", e);
            }
        }
        ** try [egrp 4[TRYBLOCK] [3 : 144->154)] { 
lbl-1000:
        // 1 sources

        {
            table.delete(delete);
            versionBytes = true;
            return versionBytes;
        }
lbl18:
        // 1 sources

        catch (IOException e) {
            throw new DatasetIOException("Error deleteing row from table", e);
        }
        finally {
            if (table != null) {
                try {
                    table.close();
                }
                catch (IOException e) {
                    throw new DatasetIOException("Error putting table back into pool", e);
                }
            }
        }
    }

    public boolean delete(DeleteAction deleteAction, DeleteActionModifier deleteActionModifier) {
        if (deleteActionModifier != null) {
            deleteAction = deleteActionModifier.modifyDeleteAction(deleteAction);
        }
        return this.delete(deleteAction);
    }

    public boolean delete(PartitionKey key, Set<String> columns, VersionCheckAction checkAction, KeySerDe keySerDe) {
        return this.delete(key, columns, checkAction, null, keySerDe);
    }

    public boolean delete(PartitionKey key, Set<String> columns, VersionCheckAction checkAction, DeleteActionModifier deleteActionModifier, KeySerDe keySerDe) {
        byte[] keyBytes = keySerDe.serialize(key);
        Delete delete = new Delete(keyBytes);
        for (String requiredColumn : columns) {
            String[] familyAndColumn = requiredColumn.split(":");
            if (familyAndColumn.length == 1) {
                delete.deleteFamily(Bytes.toBytes((String)familyAndColumn[0]));
                continue;
            }
            delete.deleteColumns(Bytes.toBytes((String)familyAndColumn[0]), Bytes.toBytes((String)familyAndColumn[1]));
        }
        return this.delete(new DeleteAction(delete, checkAction), deleteActionModifier);
    }

    public <E> EntityScannerBuilder<E> getScannerBuilder(EntityMapper<E> entityMapper) {
        BaseEntityScanner.Builder<E> builder = new BaseEntityScanner.Builder<E>(this.pool, this.tableName, entityMapper);
        for (ScanModifier scanModifier : this.scanModifiers) {
            builder.addScanModifier(scanModifier);
        }
        return builder;
    }

    public <E> EntityBatch<E> createBatch(EntityMapper<E> entityMapper, long writeBufferSize) {
        return new BaseEntityBatch<E>(this, entityMapper, this.pool, this.tableName, writeBufferSize);
    }

    public <E> EntityBatch<E> createBatch(EntityMapper<E> entityMapper) {
        return new BaseEntityBatch<E>(this, entityMapper, this.pool, this.tableName);
    }
}

