/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.hbase.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.kitesdk.data.FieldMapping;
import org.kitesdk.data.ValidationException;
import org.kitesdk.data.hbase.impl.Constants;
import org.kitesdk.data.hbase.impl.EntityComposer;
import org.kitesdk.data.hbase.impl.PutAction;
import org.kitesdk.data.hbase.impl.VersionCheckAction;

public abstract class EntitySerDe<E> {
    private final EntityComposer<E> entityComposer;

    public EntitySerDe(EntityComposer<E> entityComposer) {
        this.entityComposer = entityComposer;
    }

    public PutAction serialize(byte[] keyBytes, FieldMapping fieldMapping, Object fieldValue) {
        Put put = new Put(keyBytes);
        PutAction putAction = new PutAction(put);
        String fieldName = fieldMapping.getFieldName();
        if (fieldMapping.getMappingType() == FieldMapping.MappingType.COLUMN || fieldMapping.getMappingType() == FieldMapping.MappingType.COUNTER) {
            this.serializeColumn(fieldName, fieldMapping.getFamily(), fieldMapping.getQualifier(), fieldValue, put);
        } else if (fieldMapping.getMappingType() == FieldMapping.MappingType.KEY_AS_COLUMN) {
            this.serializeKeyAsColumn(fieldName, fieldMapping.getFamily(), fieldMapping.getPrefix(), fieldValue, put);
        } else if (fieldMapping.getMappingType() == FieldMapping.MappingType.OCC_VERSION) {
            this.serializeOCCColumn(fieldValue, putAction);
        } else {
            throw new ValidationException("Invalid field mapping for field with name: " + fieldMapping.getFieldName());
        }
        return putAction;
    }

    public Object deserialize(FieldMapping fieldMapping, Result result) {
        String fieldName = fieldMapping.getFieldName();
        FieldMapping.MappingType mappingType = fieldMapping.getMappingType();
        if (mappingType == FieldMapping.MappingType.COLUMN || mappingType == FieldMapping.MappingType.COUNTER) {
            return this.deserializeColumn(fieldMapping.getFieldName(), fieldMapping.getFamily(), fieldMapping.getQualifier(), result);
        }
        if (mappingType == FieldMapping.MappingType.KEY_AS_COLUMN) {
            return this.deserializeKeyAsColumn(fieldMapping.getFieldName(), fieldMapping.getFamily(), fieldMapping.getPrefix(), result);
        }
        if (mappingType == FieldMapping.MappingType.OCC_VERSION) {
            return this.deserializeOCCColumn(result);
        }
        throw new ValidationException("Invalid field mapping for field with name: " + fieldName);
    }

    public abstract byte[] serializeColumnValueToBytes(String var1, Object var2);

    public abstract byte[] serializeKeyAsColumnValueToBytes(String var1, CharSequence var2, Object var3);

    public abstract byte[] serializeKeyAsColumnKeyToBytes(String var1, CharSequence var2);

    public abstract Object deserializeColumnValueFromBytes(String var1, byte[] var2);

    public abstract Object deserializeKeyAsColumnValueFromBytes(String var1, byte[] var2, byte[] var3);

    public abstract CharSequence deserializeKeyAsColumnKeyFromBytes(String var1, byte[] var2);

    public abstract Object getDefaultValue(String var1);

    public EntityComposer<E> getEntityComposer() {
        return this.entityComposer;
    }

    private void serializeColumn(String fieldName, byte[] family, byte[] qualifier, Object fieldValue, Put put) {
        byte[] bytes = this.serializeColumnValueToBytes(fieldName, fieldValue);
        put.add(family, qualifier, bytes);
    }

    private void serializeKeyAsColumn(String fieldName, byte[] family, String prefix, Object fieldValue, Put put) {
        Map<CharSequence, Object> keyAsColumnValues = this.entityComposer.extractKeyAsColumnValues(fieldName, fieldValue);
        for (Map.Entry<CharSequence, Object> entry : keyAsColumnValues.entrySet()) {
            byte[] qualifierBytes;
            CharSequence qualifier = entry.getKey();
            byte[] columnKeyBytes = this.serializeKeyAsColumnKeyToBytes(fieldName, qualifier);
            if (prefix != null) {
                byte[] prefixBytes = prefix.getBytes();
                qualifierBytes = new byte[prefixBytes.length + columnKeyBytes.length];
                System.arraycopy(prefixBytes, 0, qualifierBytes, 0, prefixBytes.length);
                System.arraycopy(columnKeyBytes, 0, qualifierBytes, prefixBytes.length, columnKeyBytes.length);
            } else {
                qualifierBytes = columnKeyBytes;
            }
            byte[] bytes = this.serializeKeyAsColumnValueToBytes(fieldName, qualifier, entry.getValue());
            put.add(family, qualifierBytes, bytes);
        }
    }

    private void serializeOCCColumn(Object fieldValue, PutAction putAction) {
        Long currVersion = (Long)fieldValue;
        VersionCheckAction versionCheckAction = new VersionCheckAction(currVersion);
        putAction.getPut().add(Constants.SYS_COL_FAMILY, Constants.VERSION_CHECK_COL_QUALIFIER, Bytes.toBytes((long)(currVersion + 1L)));
        putAction.setVersionCheckAction(versionCheckAction);
    }

    private Object deserializeColumn(String fieldName, byte[] family, byte[] qualifier, Result result) {
        byte[] bytes = result.getValue(family, qualifier);
        if (bytes == null) {
            return this.getDefaultValue(fieldName);
        }
        return this.deserializeColumnValueFromBytes(fieldName, bytes);
    }

    private Object deserializeKeyAsColumn(String fieldName, byte[] family, String prefix, Result result) {
        byte[] prefixBytes = prefix != null ? prefix.getBytes() : null;
        HashMap<CharSequence, Object> fieldValueAsMap = new HashMap<CharSequence, Object>();
        NavigableMap familyMap = result.getFamilyMap(family);
        for (Map.Entry entry : familyMap.entrySet()) {
            byte[] qualifier = (byte[])entry.getKey();
            if (prefixBytes != null && qualifier.length > prefixBytes.length && Arrays.equals(Arrays.copyOf(qualifier, prefixBytes.length), prefixBytes)) {
                qualifier = Arrays.copyOfRange(qualifier, prefixBytes.length, qualifier.length);
            }
            byte[] columnBytes = (byte[])entry.getValue();
            CharSequence keyAsColumnKey = this.deserializeKeyAsColumnKeyFromBytes(fieldName, qualifier);
            Object keyAsColumnValue = this.deserializeKeyAsColumnValueFromBytes(fieldName, qualifier, columnBytes);
            fieldValueAsMap.put(keyAsColumnKey, keyAsColumnValue);
        }
        return this.entityComposer.buildKeyAsColumnField(fieldName, fieldValueAsMap);
    }

    private Object deserializeOCCColumn(Result result) {
        byte[] versionBytes = result.getValue(Constants.SYS_COL_FAMILY, Constants.VERSION_CHECK_COL_QUALIFIER);
        if (versionBytes == null) {
            return null;
        }
        return Bytes.toLong((byte[])versionBytes);
    }
}

