/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.hbase.filters;

import java.lang.reflect.Constructor;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.kitesdk.data.DatasetException;
import org.kitesdk.data.FieldMapping;
import org.kitesdk.data.hbase.filters.EntityFilter;
import org.kitesdk.data.hbase.impl.EntitySchema;
import org.kitesdk.data.hbase.impl.EntitySerDe;

public class RegexEntityFilter
implements EntityFilter {
    private final Filter filter;

    public RegexEntityFilter(EntitySchema entitySchema, EntitySerDe<?> entitySerDe, String fieldName, String regex, boolean isEqual) {
        FieldMapping fieldMapping = entitySchema.getColumnMappingDescriptor().getFieldMapping(fieldName);
        if (fieldMapping.getMappingType() != FieldMapping.MappingType.COLUMN) {
            throw new DatasetException("SingleColumnValueFilter only compatible with COLUMN mapping types.");
        }
        this.filter = this.constructFilter(regex, isEqual, fieldMapping);
    }

    private Filter constructFilter(String regex, boolean isEqual, FieldMapping fieldMapping) {
        byte[] family = fieldMapping.getFamily();
        byte[] qualifier = fieldMapping.getQualifier();
        try {
            Class<?> c = Class.forName("org.apache.hadoop.hbase.filter.SingleColumnValueFilter");
            for (Constructor<?> cons : c.getConstructors()) {
                if (cons.getParameterTypes().length != 4 || cons.getParameterTypes()[3].isArray()) continue;
                Object regexStringComparator = Class.forName("org.apache.hadoop.hbase.filter.RegexStringComparator").getConstructor(String.class).newInstance(regex);
                return (Filter)cons.newInstance(family, qualifier, isEqual ? CompareFilter.CompareOp.EQUAL : CompareFilter.CompareOp.NOT_EQUAL, regexStringComparator);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DatasetException("Cannot create RegexEntityFilter.", e);
        }
        throw new DatasetException("Cannot create RegexEntityFilter (no constructor found).");
    }

    public RegexEntityFilter(EntitySchema entitySchema, EntitySerDe<?> entitySerDe, String fieldName, String regex) {
        this(entitySchema, entitySerDe, fieldName, regex, true);
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }
}

