/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.hbase.avro.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.avro.io.Encoder;
import org.apache.avro.util.Utf8;

public class MemcmpEncoder
extends Encoder {
    private OutputStream out;

    public MemcmpEncoder(OutputStream out) {
        this.out = out;
    }

    @Override
    public void flush() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
    }

    @Override
    public void writeNull() throws IOException {
    }

    @Override
    public void writeBoolean(boolean b) throws IOException {
        this.out.write(b ? 1 : 0);
    }

    @Override
    public void writeInt(int n) throws IOException {
        byte[] intBytes = new byte[]{(byte)(n >>> 24 ^ 0x80), (byte)(n >>> 16), (byte)(n >>> 8), (byte)n};
        this.out.write(intBytes);
    }

    @Override
    public void writeLong(long n) throws IOException {
        byte[] intBytes = new byte[]{(byte)(n >>> 56 ^ 0x80L), (byte)(n >>> 48), (byte)(n >>> 40), (byte)(n >>> 32), (byte)(n >>> 24), (byte)(n >>> 16), (byte)(n >>> 8), (byte)n};
        this.out.write(intBytes);
    }

    @Override
    public void writeFloat(float f) throws IOException {
        int n = Float.floatToIntBits(f);
        if (n >>> 31 > 0) {
            n ^= Integer.MAX_VALUE;
        }
        this.writeInt(n);
    }

    @Override
    public void writeDouble(double d) throws IOException {
        long n = Double.doubleToLongBits(d);
        if (n >>> 63 > 0L) {
            n ^= Long.MAX_VALUE;
        }
        this.writeLong(n);
    }

    @Override
    public void writeString(Utf8 utf8) throws IOException {
        this.writeBytes(utf8.getBytes(), 0, utf8.getByteLength());
    }

    @Override
    public void writeFixed(byte[] bytes, int start, int len) throws IOException {
        this.out.write(bytes, start, len);
    }

    @Override
    public void writeBytes(ByteBuffer bytes) throws IOException {
        this.writeBytes(bytes.array(), bytes.position(), bytes.remaining());
    }

    @Override
    public void writeBytes(byte[] bytes, int start, int len) throws IOException {
        for (int i = start; i < start + len; ++i) {
            if (bytes[i] == 0) {
                this.out.write(0);
                this.out.write(1);
                continue;
            }
            this.out.write(bytes[i]);
        }
        this.out.write(0);
        this.out.write(0);
    }

    @Override
    public void writeEnum(int e) throws IOException {
        this.writeInt(e);
    }

    @Override
    public void writeArrayStart() throws IOException {
    }

    @Override
    public void setItemCount(long itemCount) throws IOException {
    }

    @Override
    public void startItem() throws IOException {
        this.out.write(1);
    }

    @Override
    public void writeArrayEnd() throws IOException {
        this.out.write(0);
    }

    @Override
    public void writeMapStart() throws IOException {
        throw new IOException("MemcmpEncoder does not support writing Map types.");
    }

    @Override
    public void writeMapEnd() throws IOException {
        throw new IOException("MemcmpEncoder does not support writing Map types.");
    }

    @Override
    public void writeIndex(int unionIndex) throws IOException {
        this.writeInt(unionIndex);
    }
}

