/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.hbase;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTablePool;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetIOException;
import org.kitesdk.data.DatasetOperationException;
import org.kitesdk.data.RandomAccessDataset;
import org.kitesdk.data.URIBuilder;
import org.kitesdk.data.hbase.DaoDataset;
import org.kitesdk.data.hbase.HBaseMetadataProvider;
import org.kitesdk.data.hbase.avro.GenericAvroDao;
import org.kitesdk.data.hbase.avro.SpecificAvroDao;
import org.kitesdk.data.hbase.impl.BaseDao;
import org.kitesdk.data.hbase.impl.Dao;
import org.kitesdk.data.hbase.impl.SchemaManager;
import org.kitesdk.data.hbase.manager.DefaultSchemaManager;
import org.kitesdk.data.spi.AbstractDatasetRepository;
import org.kitesdk.shaded.com.google.common.base.Preconditions;

public class HBaseDatasetRepository
extends AbstractDatasetRepository {
    private static final String DEFAULT_NAMESPACE = "default";
    private HTablePool tablePool;
    private SchemaManager schemaManager;
    private HBaseMetadataProvider metadataProvider;
    private final URI repositoryUri;

    HBaseDatasetRepository(HBaseAdmin hBaseAdmin, HTablePool tablePool, URI repositoryUri) {
        this.tablePool = tablePool;
        this.schemaManager = new DefaultSchemaManager(tablePool);
        this.metadataProvider = new HBaseMetadataProvider(hBaseAdmin, this.schemaManager);
        this.repositoryUri = repositoryUri;
    }

    public <E> RandomAccessDataset<E> create(String namespace, String name, DatasetDescriptor descriptor, Class<E> type) {
        Preconditions.checkArgument(DEFAULT_NAMESPACE.equals(namespace), "Non-default namespaces are not supported");
        Preconditions.checkNotNull(name, "Dataset name cannot be null");
        Preconditions.checkNotNull(descriptor, "Descriptor cannot be null");
        DatasetDescriptor newDescriptor = this.metadataProvider.create(namespace, name, descriptor);
        return this.newDataset(namespace, name, newDescriptor, type);
    }

    public <E> RandomAccessDataset<E> create(String namespace, String name, DatasetDescriptor descriptor) {
        return this.create(namespace, name, descriptor, Object.class);
    }

    public <E> RandomAccessDataset<E> update(String namespace, String name, DatasetDescriptor descriptor, Class<E> type) {
        Preconditions.checkArgument(DEFAULT_NAMESPACE.equals(namespace), "Non-default namespaces are not supported");
        Preconditions.checkNotNull(name, "Dataset name cannot be null");
        Preconditions.checkNotNull(descriptor, "Descriptor cannot be null");
        DatasetDescriptor newDescriptor = this.metadataProvider.update(namespace, name, descriptor);
        return this.newDataset(namespace, name, newDescriptor, type);
    }

    public <E> RandomAccessDataset<E> update(String namespace, String name, DatasetDescriptor descriptor) {
        return this.update(namespace, name, descriptor, Object.class);
    }

    public <E> RandomAccessDataset<E> load(String namespace, String name, Class<E> type) {
        Preconditions.checkArgument(DEFAULT_NAMESPACE.equals(namespace), "Non-default namespaces are not supported");
        Preconditions.checkNotNull(name, "Dataset name cannot be null");
        String tableName = HBaseMetadataProvider.getTableName(name);
        String entityName = HBaseMetadataProvider.getEntityName(name);
        if (entityName.contains(".")) {
            ArrayList<DatasetDescriptor> descriptors = new ArrayList<DatasetDescriptor>();
            for (String subEntityName : entityName.split("\\.")) {
                DatasetDescriptor descriptor = this.metadataProvider.load(namespace, tableName + "." + subEntityName);
                descriptors.add(descriptor);
            }
            return this.newCompositeDataset(namespace, name, tableName, descriptors, type);
        }
        DatasetDescriptor descriptor = this.metadataProvider.load(namespace, name);
        return this.newDataset(namespace, name, descriptor, type);
    }

    public <E> RandomAccessDataset<E> load(String namespace, String name) {
        return this.load(namespace, name, Object.class);
    }

    @Override
    public URI getUri() {
        return this.repositoryUri;
    }

    private <E> RandomAccessDataset<E> newCompositeDataset(String namespace, String name, String tableName, List<DatasetDescriptor> descriptors, Class<E> type) {
        ArrayList subEntityClasses = new ArrayList();
        for (DatasetDescriptor descriptor : descriptors) {
            try {
                Class<?> subEntityClass = Class.forName(descriptor.getSchema().getFullName());
                subEntityClasses.add(subEntityClass);
            }
            catch (ClassNotFoundException e) {
                throw new DatasetOperationException("Failed to resolve sub-type", e);
            }
        }
        Dao dao = SpecificAvroDao.buildCompositeDaoWithEntityManager(this.tablePool, tableName, subEntityClasses, this.schemaManager);
        return new DaoDataset(namespace, name, dao, descriptors.get(0), new URIBuilder(this.repositoryUri, namespace, name).build(), type);
    }

    private <E> RandomAccessDataset<E> newDataset(String namespace, String name, DatasetDescriptor descriptor, Class<E> type) {
        String tableName = HBaseMetadataProvider.getTableName(name);
        String entityName = HBaseMetadataProvider.getEntityName(name);
        BaseDao dao = HBaseDatasetRepository.isSpecific(descriptor) ? new SpecificAvroDao(this.tablePool, tableName, entityName, this.schemaManager) : new GenericAvroDao(this.tablePool, tableName, entityName, this.schemaManager);
        return new DaoDataset(namespace, name, dao, descriptor, new URIBuilder(this.repositoryUri, namespace, name).build(), type);
    }

    private static boolean isSpecific(DatasetDescriptor descriptor) {
        try {
            Class.forName(descriptor.getSchema().getFullName());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Override
    public boolean delete(String namespace, String name) {
        Preconditions.checkArgument(DEFAULT_NAMESPACE.equals(namespace), "Non-default namespaces are not supported");
        Preconditions.checkNotNull(name, "Dataset name cannot be null");
        return this.metadataProvider.delete(namespace, name);
    }

    @Override
    public boolean moveToTrash(String namespace, String name) {
        throw new UnsupportedOperationException("Moving datasets to trash is not supported for HBase.");
    }

    @Override
    public boolean exists(String namespace, String name) {
        Preconditions.checkArgument(DEFAULT_NAMESPACE.equals(namespace), "Non-default namespaces are not supported");
        Preconditions.checkNotNull(name, "Dataset name cannot be null");
        return this.metadataProvider.exists(namespace, name);
    }

    @Override
    public Collection<String> namespaces() {
        return this.metadataProvider.namespaces();
    }

    @Override
    public Collection<String> datasets(String namespace) {
        return this.metadataProvider.datasets(namespace);
    }

    public static class Builder {
        private Configuration configuration;

        public Builder configuration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        public HBaseDatasetRepository build() {
            HBaseAdmin admin;
            HTablePool pool = new HTablePool(this.configuration, 10);
            try {
                admin = new HBaseAdmin(this.configuration);
            }
            catch (MasterNotRunningException e) {
                throw new DatasetOperationException("Problem creating HBaseDatasetRepository.", e);
            }
            catch (ZooKeeperConnectionException e) {
                throw new DatasetOperationException("Problem creating HBaseDatasetRepository.", e);
            }
            catch (IOException e) {
                throw new DatasetIOException("Problem creating HBaseDatasetRepository.", e);
            }
            return new HBaseDatasetRepository(admin, pool, this.getRepositoryUri(this.configuration));
        }

        private URI getRepositoryUri(Configuration conf) {
            return URI.create(String.format("repo:hbase:%s:%s", conf.get("hbase.zookeeper.quorum"), conf.get("hbase.zookeeper.property.clientPort")));
        }
    }
}

