/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.kitesdk.data.DatasetIOException;
import org.kitesdk.data.spi.ColumnMappingParser;
import org.kitesdk.shaded.com.google.common.base.Objects;

@Immutable
public class FieldMapping {
    private static final String SYS_COL_FAMILY = "_s";
    private static final String OCC_QUALIFIER = "w";
    private final String fieldName;
    private final MappingType mappingType;
    private final String prefix;
    private final String familyString;
    private final byte[] family;
    private final String qualifierString;
    private final byte[] qualifier;

    public static FieldMapping key(String name) {
        return new FieldMapping(name, MappingType.KEY, null, null, null);
    }

    public static FieldMapping column(String name, String family, String qualifier) {
        return new FieldMapping(name, MappingType.COLUMN, family, qualifier, null);
    }

    public static FieldMapping keyAsColumn(String name, String family) {
        return new FieldMapping(name, MappingType.KEY_AS_COLUMN, family, null, null);
    }

    public static FieldMapping keyAsColumn(String name, String family, @Nullable String qualifierPrefix) {
        return new FieldMapping(name, MappingType.KEY_AS_COLUMN, family, null, qualifierPrefix);
    }

    public static FieldMapping counter(String name, String family, String qualifier) {
        return new FieldMapping(name, MappingType.COUNTER, family, qualifier, null);
    }

    public static FieldMapping occ(String name) {
        return new FieldMapping(name, MappingType.OCC_VERSION, SYS_COL_FAMILY, OCC_QUALIFIER, null);
    }

    public static FieldMapping version(String name) {
        return FieldMapping.occ(name);
    }

    private FieldMapping(String fieldName, MappingType mappingType, @Nullable String family, @Nullable String qualifier, @Nullable String prefix) {
        this.fieldName = fieldName;
        this.mappingType = mappingType;
        this.familyString = family;
        this.family = (byte[])(family != null ? FieldMapping.encodeUtf8(family) : null);
        this.qualifierString = qualifier;
        this.qualifier = (byte[])(qualifier != null ? FieldMapping.encodeUtf8(qualifier) : null);
        this.prefix = prefix != null && !prefix.isEmpty() ? prefix : null;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public MappingType getMappingType() {
        return this.mappingType;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP"}, justification="Defensive copy is needlessly expensive")
    public byte[] getFamily() {
        return this.family;
    }

    public String getFamilyAsString() {
        return this.familyString;
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP"}, justification="Defensive copy is needlessly expensive")
    public byte[] getQualifier() {
        return this.qualifier;
    }

    public String getQualifierAsString() {
        return this.qualifierString;
    }

    private static byte[] encodeUtf8(String str) {
        if (str == null) {
            return new byte[0];
        }
        try {
            return str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new DatasetIOException("[FATAL] Cannot decode UTF-8", e);
        }
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.fieldName, this.mappingType, Arrays.hashCode(this.family), Arrays.hashCode(this.qualifier), this.prefix});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FieldMapping other = (FieldMapping)obj;
        return Objects.equal(this.fieldName, other.fieldName) && Objects.equal((Object)this.mappingType, (Object)other.mappingType) && Arrays.equals(this.family, other.family) && Arrays.equals(this.qualifier, other.qualifier) && Objects.equal(this.prefix, other.prefix);
    }

    public String toString() {
        return ColumnMappingParser.toString(this);
    }

    public static enum MappingType {
        KEY,
        COLUMN,
        KEY_AS_COLUMN,
        COUNTER,
        OCC_VERSION;

    }
}

