/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.shaded.org.apache.parquet.hadoop.example;

import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.kitesdk.shaded.org.apache.parquet.Preconditions;
import org.kitesdk.shaded.org.apache.parquet.example.data.Group;
import org.kitesdk.shaded.org.apache.parquet.example.data.GroupWriter;
import org.kitesdk.shaded.org.apache.parquet.hadoop.api.WriteSupport;
import org.kitesdk.shaded.org.apache.parquet.io.api.RecordConsumer;
import org.kitesdk.shaded.org.apache.parquet.schema.MessageType;
import org.kitesdk.shaded.org.apache.parquet.schema.MessageTypeParser;

public class GroupWriteSupport
extends WriteSupport<Group> {
    public static final String PARQUET_EXAMPLE_SCHEMA = "parquet.example.schema";
    private MessageType schema;
    private GroupWriter groupWriter;

    public static void setSchema(MessageType schema, Configuration configuration) {
        configuration.set(PARQUET_EXAMPLE_SCHEMA, schema.toString());
    }

    public static MessageType getSchema(Configuration configuration) {
        return MessageTypeParser.parseMessageType(Preconditions.checkNotNull(configuration.get(PARQUET_EXAMPLE_SCHEMA), PARQUET_EXAMPLE_SCHEMA));
    }

    @Override
    public WriteSupport.WriteContext init(Configuration configuration) {
        this.schema = GroupWriteSupport.getSchema(configuration);
        return new WriteSupport.WriteContext(this.schema, new HashMap<String, String>());
    }

    @Override
    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.groupWriter = new GroupWriter(recordConsumer, this.schema);
    }

    @Override
    public void write(Group record) {
        this.groupWriter.write(record);
    }
}

