/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.predicates;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.avro.Schema;
import org.kitesdk.shaded.com.google.common.base.Preconditions;
import org.kitesdk.shaded.com.google.common.base.Predicate;
import org.kitesdk.shaded.com.google.common.collect.Maps;

public abstract class RegisteredPredicate<T>
implements Predicate<T> {
    private static final Pattern NAME = Pattern.compile("\\w+");
    private static final Pattern FUNCTION = Pattern.compile("(\\w+)\\(([^\\)]*)\\)");
    private static final Map<String, Factory> REGISTRY = Maps.newHashMap();

    public static void register(String name, Factory factory) {
        Preconditions.checkArgument(NAME.matcher(name).matches(), "Invalid name, must be alphanumeric (plus _): " + name);
        REGISTRY.put(name, factory);
    }

    public static String toString(RegisteredPredicate<?> predicate, Schema schema) {
        Preconditions.checkArgument(REGISTRY.containsKey(predicate.getName()), "Predicate is not registered: " + predicate.getName());
        return predicate.getName() + "(" + predicate.toString(schema) + ")";
    }

    public static String toNormalizedString(RegisteredPredicate<?> predicate, Schema schema) {
        Preconditions.checkArgument(REGISTRY.containsKey(predicate.getName()), "Predicate is not registered: " + predicate.getName());
        return predicate.getName() + "(" + predicate.toNormalizedString(schema) + ")";
    }

    public static <T> RegisteredPredicate<T> fromString(String predicate, Schema schema) {
        Matcher match = FUNCTION.matcher(predicate);
        if (match.matches()) {
            return REGISTRY.get(match.group(1)).fromString(match.group(2), schema);
        }
        return null;
    }

    public abstract String getName();

    public abstract String toString(Schema var1);

    public String toNormalizedString(Schema schema) {
        return this.toString(schema);
    }

    public static interface Factory {
        public <T> RegisteredPredicate<T> fromString(String var1, Schema var2);
    }
}

