/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.predicates;

import java.util.Set;
import org.apache.avro.Schema;
import org.kitesdk.data.DatasetException;
import org.kitesdk.data.spi.CharSequences;
import org.kitesdk.data.spi.predicates.Exists;
import org.kitesdk.data.spi.predicates.In;
import org.kitesdk.data.spi.predicates.Range;
import org.kitesdk.data.spi.predicates.RegisteredPredicate;
import org.kitesdk.shaded.com.google.common.base.Predicate;
import org.kitesdk.shaded.com.google.common.collect.Iterables;

public abstract class Predicates {
    public static <T> Exists<T> exists() {
        return Exists.INSTANCE;
    }

    public static <T> In<T> in(Set<T> set) {
        Object item = Iterables.getFirst(set, null);
        if (item != null && item instanceof CharSequence) {
            return new In<CharSequence>(new CharSequences.ImmutableCharSequenceSet(set));
        }
        return new In<T>(set);
    }

    public static <T> In<T> in(T ... set) {
        T item = set[0];
        if (item != null && item instanceof CharSequence) {
            return new In<CharSequence>(new CharSequences.ImmutableCharSequenceSet(set));
        }
        return new In<T>(set);
    }

    public static <T> String toString(Predicate<T> predicate, Schema schema) {
        if (predicate instanceof Exists) {
            return "";
        }
        if (predicate instanceof Range) {
            return ((Range)predicate).toString(schema);
        }
        if (predicate instanceof In) {
            String values = ((In)predicate).toString(schema);
            if (values.length() != 0) {
                return values;
            }
            return "in()";
        }
        if (predicate instanceof RegisteredPredicate) {
            return RegisteredPredicate.toString((RegisteredPredicate)predicate, schema);
        }
        throw new DatasetException("Unknown predicate: " + predicate);
    }

    public static <T> String toNormalizedString(Predicate<T> predicate, Schema schema) {
        if (predicate instanceof Exists) {
            return "";
        }
        if (predicate instanceof Range) {
            return ((Range)predicate).toString(schema);
        }
        if (predicate instanceof In) {
            String values = ((In)predicate).toNormalizedString(schema);
            if (values.length() != 0) {
                return values;
            }
            return "in()";
        }
        if (predicate instanceof RegisteredPredicate) {
            return RegisteredPredicate.toNormalizedString((RegisteredPredicate)predicate, schema);
        }
        throw new DatasetException("Unknown predicate: " + predicate);
    }

    public static <T> Predicate<T> fromString(String pString, Schema schema) {
        if (pString.length() == 0) {
            return Predicates.exists();
        }
        Predicate predicate = Range.fromString(pString, schema);
        if (predicate != null) {
            return predicate;
        }
        predicate = RegisteredPredicate.fromString(pString, schema);
        if (predicate != null) {
            return predicate;
        }
        predicate = In.fromString(pString, schema);
        if (predicate != null) {
            return predicate;
        }
        throw new DatasetException("Unknown predicate: " + pString);
    }

    public static <T> Set<T> asSet(In<T> in) {
        return in.getSet();
    }
}

