/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.hive;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.kitesdk.compat.Hadoop;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetException;
import org.kitesdk.data.DatasetIOException;
import org.kitesdk.data.DatasetOperationException;
import org.kitesdk.data.Format;
import org.kitesdk.data.Formats;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.UnknownFormatException;
import org.kitesdk.data.impl.Accessor;
import org.kitesdk.data.spi.FieldPartitioner;
import org.kitesdk.data.spi.SchemaUtil;
import org.kitesdk.data.spi.hive.HiveSchemaConverter;
import org.kitesdk.shaded.com.google.common.annotations.VisibleForTesting;
import org.kitesdk.shaded.com.google.common.base.Joiner;
import org.kitesdk.shaded.com.google.common.base.Preconditions;
import org.kitesdk.shaded.com.google.common.base.Splitter;
import org.kitesdk.shaded.com.google.common.collect.ImmutableMap;
import org.kitesdk.shaded.com.google.common.collect.Lists;

class HiveUtils {
    static final String HDFS_SCHEME = "hdfs";
    private static final String CUSTOM_PROPERTIES_PROPERTY_NAME = "kite.custom.property.names";
    private static final String PARTITION_EXPRESSION_PROPERTY_NAME = "kite.partition.expression";
    private static final String COMPRESSION_TYPE_PROPERTY_NAME = "kite.compression.type";
    private static final String OLD_CUSTOM_PROPERTIES_PROPERTY_NAME = "cdk.custom.property.names";
    private static final String OLD_PARTITION_EXPRESSION_PROPERTY_NAME = "cdk.partition.expression";
    private static final String AVRO_SCHEMA_URL_PROPERTY_NAME = "avro.schema.url";
    private static final String AVRO_SCHEMA_LITERAL_PROPERTY_NAME = "avro.schema.literal";
    private static final Splitter NAME_SPLITTER = Splitter.on(',');
    private static final Joiner NAME_JOINER = Joiner.on(',');
    private static final Map<Format, String> FORMAT_TO_SERDE = ImmutableMap.builder().put(Formats.AVRO, "org.apache.hadoop.hive.serde2.avro.AvroSerDe").put(Formats.PARQUET, HiveUtils.getHiveParquetSerde()).build();
    private static final Map<String, Format> SERDE_TO_FORMAT = ImmutableMap.builder().put("org.apache.hadoop.hive.serde2.avro.AvroSerDe", Formats.AVRO).put("org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe", Formats.PARQUET).put("parquet.hive.serde.ParquetHiveSerDe", Formats.PARQUET).build();
    private static final Map<Format, String> FORMAT_TO_INPUT_FORMAT = ImmutableMap.builder().put(Formats.AVRO, "org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat").put(Formats.PARQUET, HiveUtils.getHiveParquetInputFormat()).build();
    private static final Map<Format, String> FORMAT_TO_OUTPUT_FORMAT = ImmutableMap.builder().put(Formats.AVRO, "org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat").put(Formats.PARQUET, HiveUtils.getHiveParquetOutputFormat()).build();
    private static final Map<String, String> PROVIDED_TYPES = ImmutableMap.builder().put("tinyint", "int").put("smallint", "int").put("int", "int").put("bigint", "long").build();

    HiveUtils() {
    }

    static DatasetDescriptor descriptorForTable(Configuration conf, Table table) {
        String schemaUrlString;
        DatasetDescriptor.Builder builder = new DatasetDescriptor.Builder();
        String serializationLib = table.getSd().getSerdeInfo().getSerializationLib();
        if (!SERDE_TO_FORMAT.containsKey(serializationLib)) {
            throw new UnknownFormatException("Unknown format for serde:" + serializationLib);
        }
        Format format = SERDE_TO_FORMAT.get(serializationLib);
        builder.format(format);
        Path dataLocation = new Path(table.getSd().getLocation());
        FileSystem fs = HiveUtils.fsForPath(conf, dataLocation);
        builder.location(fs.makeQualified(dataLocation));
        Map properties = table.getParameters();
        String namesProperty = HiveUtils.coalesce((String)properties.get(CUSTOM_PROPERTIES_PROPERTY_NAME), (String)properties.get(OLD_CUSTOM_PROPERTIES_PROPERTY_NAME));
        if (namesProperty != null) {
            for (String property : NAME_SPLITTER.split(namesProperty)) {
                builder.property(property, (String)properties.get(property));
            }
        }
        PartitionStrategy partitionStrategy = null;
        if (HiveUtils.isPartitioned(table)) {
            String partitionProperty = HiveUtils.coalesce((String)properties.get(PARTITION_EXPRESSION_PROPERTY_NAME), (String)properties.get(OLD_PARTITION_EXPRESSION_PROPERTY_NAME));
            partitionStrategy = partitionProperty != null ? Accessor.getDefault().fromExpression(partitionProperty) : HiveUtils.fromPartitionColumns(HiveUtils.getPartCols(table));
            builder.partitionStrategy(partitionStrategy);
        }
        if ((schemaUrlString = (String)properties.get(AVRO_SCHEMA_URL_PROPERTY_NAME)) != null) {
            try {
                builder.schemaUri(URI.create(schemaUrlString));
            }
            catch (IOException e) {
                throw new DatasetIOException("Could not read schema", e);
            }
        } else {
            String schemaLiteral = (String)properties.get(AVRO_SCHEMA_LITERAL_PROPERTY_NAME);
            if (schemaLiteral != null) {
                builder.schemaLiteral(schemaLiteral);
            } else {
                builder.schema(HiveSchemaConverter.convertTable(table.getTableName(), table.getSd().getCols(), partitionStrategy));
            }
        }
        String compressionType = (String)properties.get(COMPRESSION_TYPE_PROPERTY_NAME);
        if (compressionType != null) {
            builder.compressionType(compressionType);
        }
        try {
            return builder.build();
        }
        catch (IllegalStateException ex) {
            throw new DatasetException("Cannot find schema: missing metadata");
        }
    }

    private static boolean isPartitioned(Table table) {
        return HiveUtils.getPartCols(table).size() != 0;
    }

    private static List<FieldSchema> getPartCols(Table table) {
        ArrayList partKeys = table.getPartitionKeys();
        if (partKeys == null) {
            partKeys = new ArrayList();
            table.setPartitionKeys(partKeys);
        }
        return partKeys;
    }

    @SafeVarargs
    private static <T> T coalesce(T ... values) {
        for (T value : values) {
            if (value == null) continue;
            return value;
        }
        return null;
    }

    static Table tableForDescriptor(String namespace, String name, DatasetDescriptor descriptor, boolean external) {
        return HiveUtils.tableForDescriptor(namespace, name, descriptor, external, true);
    }

    static Table tableForDescriptor(String namespace, String name, DatasetDescriptor descriptor, boolean external, boolean includeSchema) {
        Table table = HiveUtils.createEmptyTable(namespace, name);
        if (external) {
            table.setTableType(TableType.EXTERNAL_TABLE.toString());
            table.getParameters().put("EXTERNAL", "TRUE");
            table.getSd().setLocation(descriptor.getLocation().toString());
        } else {
            table.setTableType(TableType.MANAGED_TABLE.toString());
        }
        HiveUtils.addPropertiesForDescriptor(table, descriptor);
        Format format = descriptor.getFormat();
        if (!FORMAT_TO_SERDE.containsKey(format)) {
            throw new UnknownFormatException("No known serde for format:" + format.getName());
        }
        table.getSd().getSerdeInfo().setSerializationLib(FORMAT_TO_SERDE.get(format));
        table.getSd().setInputFormat(FORMAT_TO_INPUT_FORMAT.get(format));
        table.getSd().setOutputFormat(FORMAT_TO_OUTPUT_FORMAT.get(format));
        if (includeSchema) {
            URL schemaURL = descriptor.getSchemaUrl();
            if (HiveUtils.useSchemaURL(schemaURL)) {
                table.getParameters().put(AVRO_SCHEMA_URL_PROPERTY_NAME, descriptor.getSchemaUrl().toExternalForm());
            } else {
                table.getParameters().put(AVRO_SCHEMA_LITERAL_PROPERTY_NAME, descriptor.getSchema().toString());
            }
        }
        table.getParameters().put(COMPRESSION_TYPE_PROPERTY_NAME, descriptor.getCompressionType().getName());
        table.getSd().setCols(HiveSchemaConverter.convertSchema(descriptor.getSchema()));
        if (descriptor.isPartitioned()) {
            PartitionStrategy ps = descriptor.getPartitionStrategy();
            table.getParameters().put(PARTITION_EXPRESSION_PROPERTY_NAME, Accessor.getDefault().toExpression(ps));
            table.setPartitionKeys(HiveUtils.partitionColumns(ps, descriptor.getSchema()));
        }
        return table;
    }

    private static boolean useSchemaURL(@Nullable URL schemaURL) {
        try {
            return schemaURL != null && HDFS_SCHEME.equals(schemaURL.toURI().getScheme());
        }
        catch (URISyntaxException ex) {
            return false;
        }
    }

    static Table createEmptyTable(String namespace, String name) {
        Table table = new Table();
        table.setDbName(namespace);
        table.setTableName(name);
        table.setPartitionKeys(new ArrayList());
        table.setParameters(new HashMap());
        StorageDescriptor sd = new StorageDescriptor();
        sd.setSerdeInfo(new SerDeInfo());
        sd.setNumBuckets(-1);
        sd.setBucketCols(new ArrayList());
        sd.setCols(new ArrayList());
        sd.setParameters(new HashMap());
        sd.setSortCols(new ArrayList());
        sd.getSerdeInfo().setParameters(new HashMap());
        SkewedInfo skewInfo = new SkewedInfo();
        skewInfo.setSkewedColNames(new ArrayList());
        skewInfo.setSkewedColValues(new ArrayList());
        skewInfo.setSkewedColValueLocationMaps(new HashMap());
        sd.setSkewedInfo(skewInfo);
        table.setSd(sd);
        return table;
    }

    public static void updateTableSchema(Table table, DatasetDescriptor descriptor) {
        URL schemaURL = descriptor.getSchemaUrl();
        if (table.getParameters().get(AVRO_SCHEMA_LITERAL_PROPERTY_NAME) != null) {
            if (HiveUtils.useSchemaURL(schemaURL)) {
                table.getParameters().remove(AVRO_SCHEMA_LITERAL_PROPERTY_NAME);
                table.getParameters().put(AVRO_SCHEMA_URL_PROPERTY_NAME, schemaURL.toExternalForm());
            } else {
                table.getParameters().put(AVRO_SCHEMA_LITERAL_PROPERTY_NAME, descriptor.getSchema().toString());
            }
        } else if (table.getParameters().get(AVRO_SCHEMA_URL_PROPERTY_NAME) != null) {
            if (schemaURL == null) {
                throw new DatasetOperationException("Cannot update avro.schema.url since descriptor schema URL is not set.", new Object[0]);
            }
            table.getParameters().put(AVRO_SCHEMA_URL_PROPERTY_NAME, schemaURL.toExternalForm());
        } else if (HiveUtils.useSchemaURL(schemaURL)) {
            table.getParameters().put(AVRO_SCHEMA_URL_PROPERTY_NAME, schemaURL.toExternalForm());
        } else if (descriptor.getSchema() != null) {
            table.getParameters().put(AVRO_SCHEMA_LITERAL_PROPERTY_NAME, descriptor.getSchema().toString());
        } else {
            throw new DatasetException("Table schema cannot be updated since it is not set on the descriptor.");
        }
        if (descriptor.isPartitioned()) {
            PartitionStrategy ps = descriptor.getPartitionStrategy();
            table.getParameters().put(PARTITION_EXPRESSION_PROPERTY_NAME, Accessor.getDefault().toExpression(ps));
        }
        HiveUtils.addPropertiesForDescriptor(table, descriptor);
        table.getSd().setCols(HiveSchemaConverter.convertSchema(descriptor.getSchema()));
    }

    static FileSystem fsForPath(Configuration conf, Path path) {
        try {
            return path.getFileSystem(conf);
        }
        catch (IOException ex) {
            throw new DatasetIOException("Cannot access FileSystem for uri:" + path, ex);
        }
    }

    private static void addPropertiesForDescriptor(Table table, DatasetDescriptor descriptor) {
        if (!descriptor.listProperties().isEmpty()) {
            for (String property : descriptor.listProperties()) {
                table.getParameters().put(property, descriptor.getProperty(property));
            }
            table.getParameters().put(CUSTOM_PROPERTIES_PROPERTY_NAME, NAME_JOINER.join(descriptor.listProperties()));
        }
    }

    static Path pathForDataset(Path root, String namespace, String name) {
        Preconditions.checkNotNull(namespace, "Namespace cannot be null");
        Preconditions.checkNotNull(name, "Dataset name cannot be null");
        return new Path(root, new Path(namespace, name.replace('.', '/')));
    }

    static List<FieldSchema> partitionColumns(PartitionStrategy strategy, Schema schema) {
        ArrayList<FieldSchema> columns = Lists.newArrayList();
        for (FieldPartitioner fp : Accessor.getDefault().getFieldPartitioners(strategy)) {
            columns.add(new FieldSchema(fp.getName(), HiveUtils.getHiveType(SchemaUtil.getPartitionType(fp, schema)), "Partition column derived from '" + fp.getSourceName() + "' column, generated by Kite."));
        }
        return columns;
    }

    @VisibleForTesting
    static PartitionStrategy fromPartitionColumns(List<FieldSchema> fields) {
        PartitionStrategy.Builder builder = new PartitionStrategy.Builder();
        for (FieldSchema hiveSchema : fields) {
            TypeInfo type = HiveSchemaConverter.parseTypeInfo(hiveSchema.getType());
            builder.provided(hiveSchema.getName(), PROVIDED_TYPES.get(type.getTypeName()));
        }
        return builder.build();
    }

    private static String getHiveType(Class<?> type) {
        String typeName = PrimitiveObjectInspectorUtils.getTypeNameFromPrimitiveJava(type);
        if (typeName == null) {
            throw new DatasetException("Unsupported FieldPartitioner type: " + type);
        }
        return typeName;
    }

    private static String getHiveParquetInputFormat() {
        String newClass = "org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat";
        String oldClass = "parquet.hive.DeprecatedParquetInputFormat";
        try {
            Class.forName(newClass);
            return newClass;
        }
        catch (ClassNotFoundException ex) {
            return oldClass;
        }
    }

    private static String getHiveParquetOutputFormat() {
        String newClass = "org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat";
        String oldClass = "parquet.hive.DeprecatedParquetOutputFormat";
        try {
            Class.forName(newClass);
            return newClass;
        }
        catch (ClassNotFoundException ex) {
            return oldClass;
        }
    }

    private static String getHiveParquetSerde() {
        String newClass = "org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe";
        String oldClass = "parquet.hive.serde.ParquetHiveSerDe";
        try {
            Class.forName(newClass);
            return newClass;
        }
        catch (ClassNotFoundException ex) {
            return oldClass;
        }
    }

    public static void addResource(Configuration hiveConf, Configuration conf) {
        if (Hadoop.Configuration.addResource.isNoop()) {
            for (Map.Entry entry : conf) {
                hiveConf.set((String)entry.getKey(), (String)entry.getValue());
            }
        } else {
            Hadoop.Configuration.addResource.invoke(hiveConf, conf);
        }
    }
}

