/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlEngine;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.spi.FieldPartitioner;
import org.kitesdk.data.spi.partition.PartitionFunctions;
import org.kitesdk.shaded.com.google.common.base.Objects;
import org.kitesdk.shaded.com.google.common.collect.Lists;

class PartitionExpression {
    private JexlEngine engine = new JexlEngine();
    private Expression expression;
    private boolean isStrict;

    public PartitionExpression(String expression, boolean isStrict) {
        HashMap<String, Object> fns = new HashMap<String, Object>();
        fns.put(null, PartitionFunctions.class);
        this.engine.setFunctions(fns);
        this.engine.setStrict(true);
        this.engine.setSilent(false);
        this.engine.setCache(10);
        this.expression = this.engine.createExpression(expression);
        this.isStrict = isStrict;
    }

    public PartitionStrategy evaluate() {
        Object object = this.expression.evaluate(null);
        if (object instanceof FieldPartitioner) {
            return new PartitionStrategy(Lists.newArrayList((FieldPartitioner)object));
        }
        if (object instanceof Object[]) {
            ArrayList<FieldPartitioner> partitioners = Lists.newArrayList();
            for (Object o : (Object[])object) {
                partitioners.add((FieldPartitioner)o);
            }
            return new PartitionStrategy(partitioners);
        }
        throw new IllegalArgumentException("Partition expression did not produce FieldPartitioner result (or array) for value:" + object);
    }

    public static String toExpression(PartitionStrategy partitionStrategy) {
        List<FieldPartitioner> fieldPartitioners = partitionStrategy.getFieldPartitioners();
        if (fieldPartitioners.size() == 1) {
            return PartitionFunctions.toExpression(fieldPartitioners.get(0));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (FieldPartitioner fieldPartitioner : fieldPartitioners) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append(PartitionFunctions.toExpression(fieldPartitioner));
        }
        sb.append("]");
        return sb.toString();
    }

    public String toString() {
        return Objects.toStringHelper(this).add("expression", this.expression).add("isStrict", this.isStrict).add("engine", this.engine).toString();
    }
}

