/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.maven;

import java.util.HashMap;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Path;
import org.jruby.embed.ScriptingContainer;
import org.jruby.maven.AbstractJRubyMojo;

public class ClasspathMojo
extends AbstractJRubyMojo {
    protected String baseDirectory = null;
    protected String targetDirectory = "target";
    protected String classpathRb = null;
    protected String scope = null;
    protected String pluginVersion = null;

    public void execute() throws MojoExecutionException {
        String options = "";
        if (this.classpathRb == null) {
            this.classpathRb = this.targetDirectory + System.getProperty("file.separator") + "classpath.rb";
        } else {
            options = options + " -Djruby.classpath.rb='" + this.classpathRb + "'";
        }
        if (this.scope == null) {
            this.scope = "runtime";
        } else {
            options = options + " -Djruby.classpath.scope=" + this.scope;
        }
        Project project = null;
        try {
            project = this.getProject();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("error resolving dependencies", (Exception)((Object)e));
        }
        HashMap<String, String> maven = new HashMap<String, String>();
        maven.put("basedir", this.baseDirectory);
        maven.put("classpath_rb", this.classpathRb);
        maven.put("options", options);
        maven.put("scope", this.scope);
        maven.put("version", this.pluginVersion);
        Path p = (Path)project.getReference("maven." + this.scope + ".classpath");
        if (p == null) {
            throw new MojoExecutionException("error: could not find path maven." + this.scope + ".classpath from scope " + this.scope);
        }
        maven.put("classpath", p.toString());
        this.getLog().info((CharSequence)("Creating classpath script: " + this.classpathRb));
        ScriptingContainer container = new ScriptingContainer();
        container.put("maven", maven);
        container.runScriptlet(((Object)((Object)this)).getClass().getResourceAsStream("/dump_classpath.rb"), "dump_classpath.rb");
    }
}

