package org.jruby.parser;

public class Ruby19YyTables {
   private static short[] combine(short[] t1, short[] t2, 
                                  short[] t3, short[] t4) {
      short[] t = new short[t1.length + t2.length + t3.length + t4.length];
      int index = 0;
      System.arraycopy(t1, 0, t, index, t1.length);
      index += t1.length;
      System.arraycopy(t2, 0, t, index, t2.length);
      index += t2.length;
      System.arraycopy(t3, 0, t, index, t3.length);
      index += t3.length;
      System.arraycopy(t4, 0, t, index, t4.length);
      return t;
   }

   public static final short[] yyTable() {
      return combine(yyTable1(), yyTable2(), yyTable3(), yyTable4());
   }

   public static final short[] yyCheck() {
      return combine(yyCheck1(), yyCheck2(), yyCheck3(), yyCheck4());
   }
   private static final short[] yyTable1() {
      return new short[] {

          197,  197,  268,   91,  271,  597,  300,  621,  627,  411, 
          251,  251,  289,  270,  251,  609,  196,  533,  510,  210, 
          265,  197,  212,  431,  288,  291,   99,    8,  546,  564, 
          546,  224,  224,  224,   78,  400,  663,    8,  298,  210, 
          369,  464,  212,  511,  465,  534,  197,  380,  286,  290, 
          506,  117,  117,  372,  282,  596,  486,  273,  546,  546, 
          373,  117,  306,  844,  320,  267,  232,  232,  284,  256, 
          230,  233,  779,   78,   78,  618,  554,  560,  232,  567, 
          568,  773,  374,  786,  400,   78,    8,   69,  511,  632, 
          694,  480,  510,  546,  232,  485,  117,  794,  366,  660, 
          264,  748,  591,  455,   70,  546,  260,  546,  546,  287, 
          317,  682,   68,  232,  784,  231,  231,  492,  906,  486, 
          273,   81,  554,  560,  350,  306,  697,  231,  486,  263, 
          506,  541,  377,  267,  317,  343,  591,  511,   67,  117, 
          659,  362,  546,  231,  319,  546,  391,  486,  363,  541, 
          608,  492,  413,  392,  546,   70,  336,   76,  341,  689, 
          344,  339,  231,   66,  506,  342,  492,  591,  486,  337, 
          340,  338,   74,   71,  306,  399,  546,  724,   79,  506, 
          683,  844,  400,  264,  906,  492,  546,  591,  841,  412, 
          577,  318,  690,  319,  263,  236,  486,  861,  510,  745, 
          492,   72,  498,   91,  718,   86,  279,  723,   76,  442, 
          423,  424,  425,  752,  546,  318,  461,  498,  729,   83, 
           83,  118,  118,   74,   71,   83,  226,  226,  226,   79, 
          674,  241,  226,  226,  639,  546,  226,   91,  746,   86, 
          760,  779,  468,  331,   77,  399,  399,   86,   75,  786, 
          460,  399,   72,  311,   91,  251,   86,  251,  251,  224, 
          224,  890,   83,  226,  437,  546,  296,  639,  226,  664, 
          582,  798,  461,   93,  346,  784,  443,  444,  348,  349, 
          267,  236,  313,  546,  276,   73,  462,  395,  439,  282, 
          441,  784,  400,   53,  462,   77,  604,  416,  417,   75, 
          384,  510,  486,   78,  546,  638,  463,  364,  638,  296, 
          918,  546,  546,  546,  546,  277,  278,  805,  546,  569, 
          270,  572,  595,  809,  402,  581,  584,  226,  357,   83, 
          575,  365,  546,  727,  583,  402,   73,  624,  939,  378, 
          381,  117,  511,  379,  838,  815,  224,  224,  224,  224, 
          546,  522,  523,  546,  562,  394,  251,  579,  366,  546, 
          605,  370,  437,  400,  546,   78,   63,   63,  113,  113, 
          113,  486,   63,   70,  474,  475,  282,  575,  240,  533, 
          562,  477,  251,  511,  517,  518,  519,  520,  437,    8, 
          634,  636,  793,  366,  289,  266,  586,  607,  610,  521, 
          562,  749,  251,  236,  637,  755,  758,  534,  437,   63, 
          546,  598,  492,  295,  562,  117,  251,  236,   69,  511, 
          361,  468,  437,  350,  636,  506,   76,  289,  576,  366, 
          885,  644,  576,   83,  875,   70,  546,  653,  556,  197, 
          382,   74,   71,   68,   78,  562,  366,   79,  492,   91, 
          486,  273,  511,  883,  226,  226,  295,  210,  576,  486, 
          212,  506,  366,   87,  556,  562,  343,  251,  645,  670, 
           72,  611,   91,  437,   86,  622,   63,  226,  506,  226, 
          226,  492,   94,  226,  556,  226,  371,  336,   76,  341, 
           83,  344,  339,  909,  506,  936,  342,   83,  556,  492, 
          337,  340,  338,   74,   71,  329,  330,  680,  101,   79, 
          390,  296,  828,   77,  693,  693,  498,   75,  266,   78, 
          117,  276,  546,  462,  510,  696,  468,  396,  276,  556, 
          462,  462,   72,  525,   91,  714,   86,  546,  462,  387, 
          709,  226,  226,  226,  226,   83,  226,  226,  914,  556, 
          407,  693,  398,  701,   73,  703,  401,  270,  546,  707, 
          329,  330,  546,  546,  270,  588,  710,  712,  703,  703, 
          408,  421,  709,  546,  281,   77,   95,   95,  226,   75, 
           63,  226,   95,  226,   83,  296,  407,  226,  226,  731, 
           83,  409,  703,  546,  709,  591,  197,  197,  410,  754, 
          626,  626,  759,   14,  226,   83,  226,  734,  709,  882, 
          738,  224,  730,  610,  472,  210,   73,   83,  212,   95, 
           83,  610,  546,  413,  226,  117,  488,  415,   83,  425, 
          767,  489,  880,  700,  425,  709,  418,   63,  226,  706, 
          387,  281,  670,  770,   63,   81,  700,  700,  422,  722, 
          375,  376,   14,  801,  803,  224,  426,  359,  295,  806, 
           92,   94,   67,  226,  360,   83,  427,  468,  546,  546, 
          700,  430,   16,  706,  448,  680,  474,  475,  476,   93, 
          814,  762,  763,  477,  764,  331,   95,  546,  546,  226, 
          296,  680,   63,  753,  440,  452,  693,  453,   95,  390, 
          667,  117,  491,  492,  493,  494,  456,  277,  739,  608, 
           94,  457,  834,   93,  309,  310,  454,  546,  546,  459, 
          331,   16,  466,   96,  252,  258,  467,  473,  259,   15, 
           93,   63,  295,  668,  711,  713,  515,   63,   87,   87, 
          119,  119,  462,  670,   87,  670,  483,  390,   59,   60, 
          242,  346,   63,  487,  390,  348,  349,  350,  351,   88, 
          270,  224,   90,   90,   63,  872,  117,   63,   90,  580, 
          446,  721,   96,  608,  243,   63,  385,  874,   15,  117, 
          390,   87,  613,  386,  728,  297,  623,  405,  641,  647, 
           95,  680,  654,   88,  406,  296,   91,  665,   90,  830, 
          666,   89,  449,  675,  524,   90,  226,   83,  419,  281, 
           88,  676,   63,  677,  679,  420,  670,  892,   83,  685, 
          687,  698,  699,  450,  704,   83,  546,  546,  297,  705, 
          451,  716,   90,  719,  725,   89,  610,  295,  732,  736, 
          524,  747,  771,  276,  742,  743,  744,   95,   87,   90, 
          226,  470,   89,  757,   95,   14,   14,   14,  471,  799, 
          640,   14,   14,  670,   14,  670,  642,  643,  810,  878, 
          811,  296,   90,  562,  819,  251,  879,  385,   83,  525, 
           67,  437,  528,  651,  926,  821,  652,  474,  475,   99, 
          709,  832,  831,  670,  477,  100,  281,  482,  833,   83, 
           83,  839,   95,  769,  842,  117,  818,  846,  848,   83, 
          849,   83,  891,  850,   83,  226,  226,  610,   94,  851, 
          562,  226,  546,  546,   16,   16,   16,  546,  546,  546, 
           16,   16,  612,   16,   14,   47,  296,  626,   99,  853, 
          620,   95,  295,  855,  277,   47,  858,   95,   93,  825, 
          859,  277,   87,   83,   63,   14,  226,  556,  862,  864, 
          866,  867,   95,  871,  877,   63,   83,   83,   83,  432, 
          276,  435,   63,  868,   95,  886,   90,   95,  887,  462, 
           96,   15,   15,   15,  889,   95,  462,   15,   15,  901, 
           15,   58,  907,  524,   47,  908,  919,  270,  921,  925, 
          928,   58,  930,   16,  270,  717,  932,  935,  276,   87, 
           93,  938,  949,   98,  546,   83,   87,  533,  295,  546, 
          535,  534,   95,  276,   16,   63,  726,  226,   88,  524, 
          297,   99,  535,   90,   83,  539,  539,   97,  541,  535, 
           90,  524,  474,  475,  479,   83,   63,   63,  524,  477, 
           58,  535,  322,  524,  546,  276,   63,  120,   63,  546, 
           15,   63,   98,  199,   87,  876,  903,   90,  525,  937, 
           89,  528,  783,  756,  524,  899,   95,  524,  323,  244, 
          276,   15,  915,  295,  524,  768,   97,  276,   90,  524, 
           88,  646,  525,   83,  525,  893,  824,  226,    0,   83, 
           63,  772,    0,   87,  297,   83,    0,    0,    0,   87, 
          524,    0,    0,   63,   63,   63,  525,    0,  528,  528, 
            0,    0,    0,  525,   87,   95,  528,   90,  525,   90, 
            0,  524,   89,   90,    0,    0,   87,  735,    0,   87, 
          782,   46,  785,    0,    0,  789,   99,   87,   90,  525, 
            0,   46,  528,    0,    0,  820,    0,  390,    0,    0, 
           90,    0,   63,   90,   95,  667,  101,  491,  492,  493, 
          494,   90,    0,    0,  667,   95,  491,  492,  493,  494, 
          528,   63,   95,    0,   87,    0,    0,    0,  100,    0, 
          761,    0,   63,    0,    0,  528,  840,   47,   47,   47, 
           46,  845,   47,   47,   47,    0,   47,  276,   90,  297, 
           92,  780,  781,    0,  276,  101,   47,    0,    0,  525, 
            0,  796,  113,  797,    0,    0,  800,  528,   47,   47, 
           47,   47,   47,    0,    0,   95,    0,  100,    0,    0, 
           63,  474,  475,  481,   92,    0,   63,  270,  477,    0, 
            0,    0,   63,   58,   58,   58,   95,   95,   58,   58, 
           58,   92,   58,    0,    0,  829,   95,    0,   95,  277, 
           98,   95,   58,   58,    0,    0,   47,    0,  835,  836, 
          837,   58,   58,  525,   58,   58,   58,   58,   58,    0, 
            0,  277,  276,    0,   97,    0,    0,   47,  776,  276, 
          491,  492,  493,  494,  525,    0,    0,  528,  895,    0, 
           95,  474,  475,  484,  297,    0,    0,  902,  477,  904, 
          679,    0,  276,   95,   95,   95,   87,  869,    0,    0, 
            0,  525,   58,   95,    0,   58,    0,   87,  525,    0, 
          429,  429,  429,  525,   87,    0,  390,  429,  250,  250, 
           90,    0,  250,   58,    0,  528,    0,  881,  419,  419, 
          419,   90,  528,    0,  525,  419,   48,  524,   90,    0, 
            0,    0,   95,    0,  274,  276,   48,    0,    0,    0, 
          250,  250,    0,  299,  301,  944,    0,    0,  528,    0, 
          297,   95,    0,    0,  390,    0,    0,   87,  766,    0, 
            0,  390,   95,   46,   46,   46,    0,    0,   46,   46, 
           46,  916,   46,    0,    0,    0,  528,  917,   87,   87, 
            0,   90,   46,  101,    0,   48,   87,  390,   87,    0, 
           87,   46,   46,   87,   46,   46,   46,   46,   46,    0, 
            0,    0,   90,   90,    0,  100,    0,    0,    0,    0, 
           95,    0,   90,    0,   90,  297,   95,   90,    0,    0, 
           87,    0,   95,    0,  528,   88,    0,    0,  826,    0, 
            0,  528,   87,    0,    0,    0,  524,   87,    0,   92, 
          114,  114,   46,    0,  270,   87,   87,   87,    0,    0, 
          114,  270,  827,    0,  528,    0,   90,  528,  324,  325, 
          326,  327,  328,   46,  262,    0,  277,  390,    0,   90, 
           90,   90,  524,  277,  262,    0,    0,  114,  114,    0, 
            0,    0,    0,  114,  114,  114,  114,    0,  277,    0, 
            0,    0,    0,    0,   87,  277,    0,    0,  533,  533, 
          533,   92,    0,    0,  533,  533,    0,  533,  257,    0, 
            0,    0,    0,   87,    0,    0,    0,  667,   90,  491, 
          492,  493,  494,  262,   87,    0,    0,  788,  114,  491, 
          492,  493,  494,    0,    0,  686,  688,   90,    0,  250, 
          250,  250,  301,    0,    0,    0,    0,    0,   90,    0, 
          668,    0,    0,  250,  119,  250,  250,    0,  669,   90, 
          495,    0,    0,   89,  447,    0,    0,    0,  497,  498, 
          499,  500,   87,  534,  534,  534,    0,  533,   87,  534, 
          534,    0,  534,    0,   87,    0,    0,    0,   48,   48, 
           48,    0,    0,   48,   48,   48,   90,   48,  533,    0, 
            0,    0,   90,    0,    0,    0,  525,   48,   90,    0, 
          528,    0,    0,    0,    0,    0,   48,   48,    0,   48, 
           48,   48,   48,   48,  524,  525,  526,  527,  528,  529, 
          530,  531,  532,  533,  534,  535,  536,  537,  538,  539, 
          540,  541,  542,  543,  544,  545,  546,  547,  548,  549, 
            0,    0,  534,    0,  250,   87,  390,  570,    0,  573, 
           96,  524,    0,  250,  585,    0,    0,   48,    0,    0, 
            0,    0,  667,  534,  491,  492,  493,  494,    0,    0, 
          250,  260,  114,  114,  114,  114,    0,  178,   48,  250, 
            0,  260,    0,    0,    0,    0,    0,    0,    0,    0, 
          250,  570,  619,  585,  390,  668,  250,  114,    0,  524, 
            0,  390,    0,  843,  250,    0,  524,   87,    0,  250, 
          250,  524,    0,  250,    0,  258,  262,  262,  262,    0, 
          114,  262,  262,  262,    0,  262,  178,  390,    0,    0, 
          260,    0,  524,    0,    0,  648,  649,  650,    0,    0, 
            0,    0,    0,  250,    0,    0,  250,  262,  262,  262, 
          262,  262,    0,    0,    0,  250,    0,  114,  114,  114, 
          114,  114,  114,  114,  114,  114,  114,  114,  114,  114, 
          114,  114,  114,  114,  114,  114,  114,  114,  114,  114, 
          114,  114,  114,    0,   98,  525,    0,    0,   97,  528, 
          267,  847,  262,    0,  114,  262,    0,    0,    0,  852, 
          854,    0,  856,    0,  857,    0,  860,    0,  863,  865, 
            0,    0,    0,    0,    0,    0,  262,    0,  774,    0, 
            0,    0,  114,    0,    0,    0,    0,    0,  787,    0, 
            0,  791,    0,  525,  114,  114,  114,  528,    0,  114, 
          525,    0,    0,  356,  528,  525,    0,    0,    0,  524, 
            0,    0,  114,  114,  250,    0,  114,    0,    0,  490, 
            0,  491,  492,  493,  494,    0,  525,    0,    0,    0, 
          528,    0,  667,    0,  491,  492,  493,  494,  114,  114, 
          114,    0,    0,    0,    0,  201,  114,    0,    0,  114, 
            0,    0,  495,  496,    0,  201,    0,    0,    0,  114, 
          497,  498,  499,  500,    0,  495,    0,    0,    0,    0, 
            0,  920,  922,  923,  924,  499,  500,  927,  250,  929, 
          931,  933,  934,    0,    0,    0,    0,    0,    0,  201, 
            0,    0,    0,  260,  260,  260,  171,    0,  260,  260, 
          260,    0,  260,  201,  201,    0,    0,    0,  201,  250, 
            0,    0,    0,    0,    0,    0,    0,  947,    0,    0, 
          948,  950,  951,  952,  260,  260,  260,  260,  260,    0, 
          954,    0,    0,  178,    0,  178,  178,  178,  178,    0, 
            0,  802,  804,    0,    0,  171,    0,  807,  808,    0, 
            0,    0,  894,    0,  896,  456,  897,  114,  812,  250, 
          900,    0,  456,  816,  114,  905,  178,  178,    0,  260, 
            0,    0,  260,  331,  178,  178,  178,  178,  336,  337, 
            0,    0,    0,    0,    0,  802,  804,  807,  450,  344, 
          345,  250,    0,  260,    0,    0,    0,    0,  450,    0, 
            0,    0,    0,    0,  346,    0,  347,    0,  348,  349, 
          350,  351,  352,  353,  354,    0,  355,    0,    0,    0, 
            0,  114,  940,    0,    0,    0,    0,    0,    0,  943, 
            0,  945,  450,  946,    0,    0,    0,    0,    0,    0, 
          114,    0,  870,    0,    0,    0,  450,  450,    0,  450, 
          953,  450,  114,  873,    0,    0,  250,  331,  332,  333, 
          334,  335,  336,  337,  338,  339,  340,  341,    0,  342, 
          343,    0,    0,  344,  345,  873,    0,    0,    0,  450, 
            0,    0,    0,    0,    0,    0,    0,    0,  346,    0, 
          347,  114,  348,  349,  350,  351,  352,  353,  354,    0, 
          355,  114,  114,    0,    0,  114,  114,  201,  201,  201, 
            0,  453,  201,  201,  201,    0,  201,    0,  114,    0, 
            0,  453,    0,  250,    0,    0,  201,  201,  114,  114, 
          114,    0,    0,    0,  114,  201,  201,    0,  201,  201, 
          201,  201,  201,    0,  331,    0,    0,    0,    0,    0, 
          201,    0,    0,    0,    0,  453,    0,    0,    0,    0, 
          344,  345,    0,    0,    0,    0,    0,    0,    0,  453, 
          453,    0,  453,    0,  453,  346,    0,  347,    0,  348, 
          349,  350,  351,  201,    0,  114,  201,    0,    0,  201, 
            0,  201,  171,  331,  171,  171,  171,  171,    0,  114, 
            0,    0,  453,    0,    0,    0,    0,  201,    0,  344, 
          345,    0,    0,    0,  455,    0,    0,    0,  114,  201, 
            0,  455,    0,    0,  346,  171,  171,    0,  348,  349, 
          350,  351,    0,  171,  171,  171,  171,  181,    0,    0, 
            0,    0,    0,    0,  114,  521,  521,  521,    0,  521, 
          450,  450,  450,  521,  521,  450,  450,  450,  521,  450, 
          521,  521,  521,  521,  521,  521,  521,  450,  521,  450, 
          450,  521,  521,  521,  521,  521,  521,  521,  450,  450, 
          521,  450,  450,  450,  450,  450,  181,  521,    0,    0, 
          521,  521,  521,  450,  521,  521,  521,  521,  521,  521, 
          521,  521,  521,  521,  521,  450,  450,  450,  450,  450, 
          450,  450,  450,  450,  450,  450,  450,  450,  450,    0, 
            0,  450,  450,  450,  521,  450,  450,  521,  521,  450, 
          521,  521,  450,  521,  450,  521,  450,  521,  450,  521, 
          450,  450,  450,  450,  450,  450,  450,  521,  450,  521, 
          450,    0,  521,  521,  521,  521,  521,  521,    0,    0, 
          166,  521,  450,  521,  521,    0,  521,  521,  522,  522, 
          522,    0,  522,  453,  453,  453,  522,  522,  453,  453, 
          453,  522,  453,  522,  522,  522,  522,  522,  522,  522, 
          453,  522,  453,  453,  522,  522,  522,  522,  522,  522, 
          522,  453,  453,  522,  453,  453,  453,  453,  453,  166, 
          522,    0,    0,  522,  522,  522,  453,  522,  522,  522, 
          522,  522,  522,  522,  522,  522,  522,  522,  453,  453, 
          453,  453,  453,  453,  453,  453,  453,  453,  453,  453, 
          453,  453,    0,    0,  453,  453,  453,  522,  453,  453, 
          522,  522,  453,  522,  522,  453,  522,  453,  522,  453, 
          522,  453,  522,  453,  453,  453,  453,  453,  453,  453, 
          522,  453,  522,  453,    0,  522,  522,  522,  522,  522, 
          522,  524,    0,    0,  522,  453,  522,  522,    0,  522, 
          522,  524,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  490,    0,  491,  492,  493, 
          494,    0,    0,    0,    0,  524,    0,  490,    0,  491, 
          492,  493,  494,  181,    0,  181,  181,  181,  181,  524, 
          524,    0,   96,    0,  524,    0,    0,    0,  495,  599, 
            0,    0,    0,    0,    0,  457,  497,  498,  499,  500, 
          495,    0,  457,    0,    0,    0,  181,  181,  497,  498, 
          499,  500,  524,    0,  181,  181,  181,  181,    0,    0, 
            0,  551,  552,    0,    0,  553,    0,    0,    0,  166, 
          167,    0,  168,  169,  170,  171,  172,  173,  174,    0, 
            0,  175,  176,    0,  525,    0,  177,  178,  179,  180, 
            0,    0,    0,    0,  525,  263,    0,    0,    0,    0, 
            0,    0,  182,  183,    0,  184,  185,  186,  187,  188, 
          189,  190,  191,  192,  193,  194,    0,    0,  195,  788, 
            0,  491,  492,  493,  494,    0,    0,    0,  525,    0, 
            0,    0,    0,    0,    0,    0,  166,    0,  166,  166, 
          166,  166,  525,  525,    0,   98,    0,  525,    0,    0, 
            0,  331,  495,    0,    0,    0,    0,    0,  458,    0, 
          497,  498,  499,  500,    0,  458,    0,  344,  345,  166, 
          166,    0,    0,    0,    0,  525,    0,  166,  166,  166, 
          166,    0,  346,    0,  347,    0,  348,  349,  350,  351, 
            0,  148,  354,    0,  355,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  524,  524, 
          524,    0,  524,  524,  524,  524,  524,  524,  524,  524, 
          524,  524,  524,  524,  524,  524,  524,  524,  524,  524, 
          148,  524,  524,  524,  524,  524,  524,  524,  524,  524, 
          524,  524,  524,  524,  524,  524,  524,  524,  524,    0, 
          524,    0,    0,  524,  524,  524,  524,  524,  524,  524, 
          524,  524,  524,  524,  524,  524,  524,  524,  524,  524, 
          524,  524,  524,  524,  524,  524,  524,  524,  524,  524, 
          524,  524,    0,    0,  524,  524,  524,  524,    0,  524, 
          524,  524,  524,  524,  524,  524,  524,  524,  524,  524, 
          524,  524,  524,  524,  524,  524,  524,  524,  524,  524, 
          524,  524,  524,  524,    0,  524,  524,  524,  524,  524, 
          524,    0,    0,  149,  524,  524,  524,  524,    0,  524, 
          524,  525,  525,  525,    0,  525,  525,  525,  525,  525, 
          525,  525,  525,  525,  525,  525,  525,  525,  525,  525, 
          525,  525,  525,    0,  525,  525,  525,  525,  525,  525, 
          525,  525,  525,  525,  525,  525,  525,  525,  525,  525, 
          525,  525,  149,  525,    0,    0,  525,  525,  525,  525, 
          525,  525,  525,  525,  525,  525,  525,  525,  525,  525, 
          525,  525,  525,  525,  525,  525,  525,  525,  525,  525, 
          525,  525,  525,  525,  525,    0,    0,  525,  525,  525, 
          525,    0,  525,  525,  525,  525,  525,  525,  525,  525, 
          525,  525,  525,  525,  525,  525,  525,  525,  525,  525, 
          525,  525,  525,  525,  525,  525,  525,    0,  525,  525, 
          525,  525,  525,  525,  528,    0,    0,  525,  525,  525, 
          525,    0,  525,  525,  528,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  148,    0,  148, 
          148,  148,  148,    0,    0,    0,    0,    0,  528,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  460, 
            0,    0,  528,  528,    0,   97,  460,  528,    0,    0, 
          148,  148,    0,    0,    0,    0,    0,    0,  148,  148, 
          148,  148,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  528,    0,  557,  558,    0, 
            0,  559,    0,    0,    0,  166,  167,    0,  168,  169, 
          170,  171,  172,  173,  174,    0,    0,  175,  176,    0, 
            0,    0,  177,  178,  179,  180,    0,  271,    0,    0, 
            0,  263,    0,    0,    0,    0,    0,  271,  182,  183, 
            0,  184,  185,  186,  187,  188,  189,  190,  191,  192, 
          193,  194,    0,    0,  195,    0,  331,  332,  333,  334, 
          335,  336,  337,  338,  339,  340,  341,    0,    0,    0, 
            0,  271,  344,  345,    0,    0,    0,    0,    0,  149, 
            0,  149,  149,  149,  149,  271,  271,  346,    0,  347, 
          271,  348,  349,  350,  351,  352,  353,  354,    0,  355, 
            0,  459,    0,    0,    0,    0,    0,    0,  459,    0, 
            0,    0,  149,  149,    0,    0,    0,    0,  271,    0, 
          149,  149,  149,  149,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  524,  524,  524,    0,  524,  528,  528,  528,  524, 
          524,  528,  528,  528,  524,  528,  524,  524,  524,  524, 
          524,  524,  524,    0,  528,  528,  528,  524,  524,  524, 
          524,  524,  524,  524,  528,  528,  524,  528,  528,  528, 
          528,  528,  267,  524,    0,    0,  524,  524,  524,  528, 
          524,  524,  524,  524,  524,  524,  524,  524,  524,  524, 
          524,  528,  528,  528,  528,  528,  528,  528,  528,  528, 
          528,  528,  528,  528,  528,    0,    0,  528,  528,  528, 
          524,    0,  528,  524,  524,  528,  524,  524,  528,  524, 
          528,  524,  528,  524,  528,  524,  528,  528,  528,  528, 
          528,  528,  528,  524,  528,  528,  528,    0,  524,  524, 
          524,  524,  524,  524,    0,    0,  150,  524,  528,  524, 
          524,    0,  524,  524,  523,  523,  523,    0,  523,  271, 
          271,  271,  523,  523,  271,  271,  271,  523,  271,  523, 
          523,  523,  523,  523,  523,  523,    0,  523,  271,  271, 
          523,  523,  523,  523,  523,  523,  523,  271,  271,  523, 
          271,  271,  271,  271,  271,  150,  523,    0,    0,  523, 
          523,  523,  271,  523,  523,  523,  523,  523,  523,  523, 
          523,  523,  523,  523,  271,  271,  271,  271,  271,  271, 
          271,  271,  271,  271,  271,  271,  271,  271,    0,    0, 
          271,  271,  271,  523,    0,  271,  523,  523,  271,  523, 
          523,  271,  523,  271,  523,  271,  523,  271,  523,  271, 
          271,  271,  271,  271,  271,  271,  523,  271,  523,  271, 
            0,  523,  523,  523,  523,  523,  523,  529,    0,    0, 
          523,  271,  523,  523,    0,  523,  523,  529,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  529,    0,    0,    0,    0,    0,    0,    0,    4, 
            5,    6,    0,    8,    0,  529,  529,    9,   10,    0, 
          529,    0,   11,    0,   12,   13,   14,  100,  101,   17, 
           18,    0,    0,    0,    0,  102,   20,   21,   22,   23, 
           24,   25,    0,    0,  105,    0,    0,    0,  529,    0, 
            0,   28,    0,    0,   31,   32,   33,    0,   34,   35, 
           36,   37,   38,   39,  246,   40,   41,   42,   43,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          530,    0,    0,    0,    0,    0,    0,    0,  222,    0, 
          530,  112,    0,    0,   46,   47,    0,   48,    0,  247, 
            0,  248,    0,   50,    0,    0,    0,    0,    0,    0, 
            0,  249,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,  530,   58,    0,   59,   60,    0, 
           61,   62,  150,    0,  150,  150,  150,  150,  530,  530, 
            0,    0,    0,  530,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  461,    0,    0,    0,    0,    0, 
            0,  461,    0,    0,    0,  150,  150,    0,    0,    0, 
            0,  530,    0,  150,  150,  150,  150,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  107,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  526,  526,  526,    0,  526,  529, 
          529,  529,  526,  526,  529,  529,  529,  526,  529,  526, 
          526,  526,  526,  526,  526,  526,  107,  529,  529,  529, 
          526,  526,  526,  526,  526,  526,  526,  529,  529,  526, 
          529,  529,  529,  529,  529,    0,  526,    0,    0,  526, 
          526,  526,  529,  526,  526,  526,  526,  526,  526,  526, 
          526,  526,  526,  526,  529,  529,  529,  529,  529,  529, 
          529,  529,  529,  529,  529,  529,  529,  529,    0,    0, 
          529,  529,  529,  526,    0,  529,  526,  526,  529,  526, 
          526,  529,  526,  529,  526,  529,  526,  529,  526,  529, 
          529,  529,  529,  529,  529,  529,  526,  529,  529,  529, 
            0,  526,  526,  526,  526,  526,  526,    0,    0,  108, 
          526,  529,  526,  526,    0,  526,  526,  527,  527,  527, 
            0,  527,  530,  530,  530,  527,  527,  530,  530,  530, 
          527,  530,  527,  527,  527,  527,  527,  527,  527,    0, 
          530,  530,  530,  527,  527,  527,  527,  527,  527,  527, 
          530,  530,  527,  530,  530,  530,  530,  530,  108,  527, 
            0,    0,  527,  527,  527,  530,  527,  527,  527,  527, 
          527,  527,  527,  527,  527,  527,  527,  530,  530,  530, 
          530,  530,  530,  530,  530,  530,  530,  530,  530,  530, 
          530,    0,    0,  530,  530,  530,  527,    0,  530,  527, 
          527,  530,  527,  527,  530,  527,  530,  527,  530,  527, 
          530,  527,  530,  530,  530,  530,  530,  530,  530,  527, 
          530,  530,  530,    0,  527,  527,  527,  527,  527,  527, 
          276,    0,    0,  527,  530,  527,  527,    0,  527,  527, 
          276,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  107,    0,  107,  107,  107,  107,    0, 
            0,    0,    0,    0,  276,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  450,    0,    0,  276,  276, 
            0,   99,  450,  276,    0,    0,  107,  107,    0,    0, 
            0,    0,    0,    0,  107,  107,  107,  107,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  276,    0,  565,  552,    0,    0,  566,    0,    0, 
            0,  166,  167,    0,  168,  169,  170,  171,  172,  173, 
          174,    0,    0,  175,  176,    0,    0,    0,  177,  178, 
          179,  180,    0,  389,    0,    0,    0,  263,    0,    0, 
            0,    0,    0,  389,  182,  183,    0,  184,  185,  186, 
          187,  188,  189,  190,  191,  192,  193,  194,    0,    0, 
          195,    0,  331,  332,  333,  334,  335,  336,  337,  338, 
            0,  340,  341,    0,    0,    0,    0,  389,  344,  345, 
            0,    0,    0,    0,    0,  108,    0,  108,  108,  108, 
          108,    0,  389,  346,    0,  347,  389,  348,  349,  350, 
          351,  352,  353,  354,    0,  355,    0,  453,    0,    0, 
            0,    0,    0,    0,  453,    0,    0,    0,  108,  108, 
            0,    0,    0,    0,  389,    0,  108,  108,  108,  108, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  525,  525,  525, 
            0,  525,  276,  276,  276,  525,  525,  276,  276,  276, 
          525,  276,  525,  525,  525,  525,  525,  525,  525,    0, 
            0,  276,  276,  525,  525,  525,  525,  525,  525,  525, 
          276,  276,  525,  276,  276,  276,  276,  276,  267,  525, 
            0,    0,  525,  525,  525,  276,  525,  525,  525,  525, 
          525,  525,  525,  525,  525,  525,  525,  276,  276,  276, 
          276,  276,  276,  276,  276,  276,  276,  276,  276,  276, 
          276,    0,    0,  276,  276,  276,  525,    0,  276,  525, 
          525,  276,  525,  525,  276,  525,  276,  525,  276,  525, 
          276,  525,  276,  276,  276,  276,  276,  276,  276,  525, 
          276,    0,  276,    0,  525,  525,  525,  525,  525,  525, 
            0,    0,    0,  525,  276,  525,  525,    0,  525,  525, 
          250,  250,  250,    0,  250,  389,  389,  389,  250,  250, 
          389,  389,  389,  250,  389,  250,  250,  250,  250,  250, 
          250,  250,    0,  389,  389,  389,  250,  250,  250,  250, 
          250,  250,  250,  389,  389,  250,  389,  389,  389,  389, 
          389,    0,  250,    0,    0,  250,  250,  250,  356,  250, 
          250,  250,  250,  250,  250,  250,  250,  250,  250,  250, 
          389,  389,  389,  389,  389,  389,  389,  389,  389,  389, 
          389,  389,  389,  389,    0,    0,  389,  389,  389,  250, 
            0,  389,  250,    0,  389,  250,  250,  389,  250,  389, 
          250,  389,  250,  389,  250,  389,  389,  389,  389,  389, 
          389,  389,  250,  389,  389,  389,    0,  250,  250,  250, 
          250,  250,  250,  546,    0,    0,  250,    0,  250,  250, 
            0,  250,  250,  546,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  546,    0,    0, 
            0,    0,    0,    0,    0,    4,    5,    6,    0,    8, 
            0,    0,  546,    9,   10,    0,  546,    0,   11,    0, 
           12,   13,   14,   15,   16,   17,   18,    0,    0,    0, 
            0,   19,   20,   21,   22,   23,   24,   25,    0,    0, 
           26,    0,    0,    0,  546,    0,    0,   28,    0,    0, 
           31,   32,   33,    0,   34,   35,   36,   37,   38,   39, 
            0,   40,   41,   42,   43,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  283,    0,    0,    0, 
            0,    0,    0,    0,  222,    0,  283,  112,    0,    0, 
           46,   47,    0,   48,    0,    0,    0,    0,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,   51,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
          283,   58,  715,   59,   60,    0,   61,   62,    0,    0, 
            0,    0,    0,    0,    0,  283,    0,    0,    0,  283, 
            0,    0,  331,  332,  333,  334,  335,  336,  337,  338, 
          339,  340,  341,    0,  342,  343,    0,    0,  344,  345, 
            0,    0,    0,    0,    0,    0,    0,  283,    0,    0, 
            0,    0,    0,  346,    0,  347,    0,  348,  349,  350, 
          351,  352,  353,  354,    0,  355,    0,    0,    0,    0, 
            0,    0,    0,    0,  547,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  547,    0,    0,    0,    0,    0, 
          250,  250,  250,    0,  250,  546,  546,  546,  250,  250, 
          546,  546,  546,  250,  546,  250, 
      };
   }

   private static final short[] yyTable2() {
      return new short[] {

          250,  250,  250,  250,  250,  250,    0,  546,  546,  546, 
          250,  250,  250,  250,  250,  250,  250,  546,  546,  250, 
          546,  546,  546,  546,  546,    0,  250,  547,  356,  250, 
          250,  250,    0,  250,  250,  250,  250,  250,  250,  250, 
          250,  250,  250,  250,  546,  546,  546,  546,  546,  546, 
          546,  546,  546,  546,  546,  546,  546,  546,    0,    0, 
          546,  546,  546,  250,    0,  546,  250,    0,  546,  250, 
          250,  546,  250,  546,  250,  546,  250,  546,  250,  546, 
          546,  546,  546,  546,  546,  546,  250,  546,  546,  546, 
            0,  250,  250,  250,  250,  250,  250,  356,    0,    0, 
          250,    0,  250,  250,    0,  250,  250,  250,  250,  250, 
            0,  250,  283,  283,  283,  250,  250,  283,  283,  283, 
          250,  283,  250,  250,  250,  250,  250,  250,  250,    0, 
            0,  283,  283,  250,  250,  250,  250,  250,  250,  250, 
          283,  283,  250,  283,  283,  283,  283,  283,    0,  250, 
            0,    0,  250,  250,  250,    0,  250,  250,  250,  250, 
          250,  250,  250,  250,  250,  250,  250,  283,  283,  283, 
          283,  283,  283,  283,  283,  283,  283,  283,  283,  283, 
          283,    0,    0,  283,  283,  283,  250,    0,  283,  250, 
            0,  283,  250,  250,  283,  250,  283,  250,  283,  250, 
          283,  250,  283,  283,  283,  283,  283,  283,  283,  250, 
          283,  524,  283,    0,  250,  250,  250,  250,  250,  250, 
            0,  524,    0,  250,    0,  250,  250,    0,  250,  250, 
          547,  547,  547,    0,    0,  547,  547,  547,    0,  547, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  547, 
          547,    0,    0,    0,    0,   88,    0,    0,  547,  547, 
            0,  547,  547,  547,  547,  547,    0,    0,    0,    0, 
          524,    0,   96,    0,  524,    0,    0,    0,    0,    0, 
            0,    0,  331,  332,  333,  334,  335,  336,  337,  338, 
          339,  340,  341,    0,  342,  343,    0,    0,  344,  345, 
            0,    0,  524,    0,    0,    0,    0,    0,    0,  547, 
            0,    0,  547,  346,  547,  347,    0,  348,  349,  350, 
          351,  352,  353,  354,    0,  355,    0,    0,    0,    0, 
          547,  720,    0,    0,  525,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  525,    0,    0,    0,    0,    0, 
            0,  331,  332,  333,  334,  335,  336,  337,  338,  339, 
          340,  341,    0,  342,  343,    0,    0,  344,  345,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   90,    0, 
            0,    0,  346,    0,  347,    0,  348,  349,  350,  351, 
          352,  353,  354,  525,  355,   98,    0,  525,    0,    0, 
            0,  592,  558,    0,    0,  593,    0,    0,    0,  166, 
          167,    0,  168,  169,  170,  171,  172,  173,  174,    0, 
            0,  175,  176,    0,    0,  525,  177,  178,  179,  180, 
            0,    0,    0,    0,    0,  263,    0,    0,    0,    0, 
            0,    0,  182,  183,    0,  184,  185,  186,  187,  188, 
          189,  190,  191,  192,  193,  194,    0,   40,  195,    0, 
            0,    0,    0,    0,    0,    0,    0,   40,  524,  524, 
          524,    0,  524,  524,  524,  524,  524,  524,    0,  524, 
          524,  524,  524,  524,  524,  524,  524,  524,  524,  524, 
            0,  524,    0,    0,  524,  524,  524,  524,  524,  524, 
          524,  524,  524,  524,  524,  524,  524,  524,  524,    0, 
          524,    0,    0,  524,  524,  524,   40,  524,  524,  524, 
          524,  524,  524,  524,  524,  524,  524,  524,  524,  524, 
          524,  524,  524,  524,  524,  524,  524,  524,  524,  524, 
          524,  524,    0,    0,  524,  524,  524,  524,    0,    0, 
          524,  524,  524,  524,  524,    0,  524,    0,  524,  524, 
          524,  524,  524,  524,  524,  524,  524,  524,  524,  524, 
          524,  524,  524,  524,    0,  524,  524,  524,  524,  524, 
          524,    0,    0,    0,  524,    0,  524,  524,    0,  524, 
          524,  525,  525,  525,    0,  525,  525,  525,  525,  525, 
          525,    0,  525,  525,  525,  525,  525,  525,  525,  525, 
          525,  525,  525,    0,  525,    0,    0,  525,  525,  525, 
          525,  525,  525,  525,  525,  525,  525,  525,  525,  525, 
          525,  525,    0,  525,    0,    0,  525,  525,  525,    0, 
          525,  525,  525,  525,  525,  525,  525,  525,  525,  525, 
          525,  525,  525,  525,  525,  525,  525,  525,  525,  525, 
          525,  525,  525,  525,  525,    0,    0,  525,  525,  525, 
          525,    0,    0,  525,  525,  525,  525,  525,    0,  525, 
            0,  525,  525,  525,  525,  525,  525,  525,  525,  525, 
          525,  525,  525,  525,  525,  525,  525,    0,  525,  525, 
          525,  525,  525,  525,  528,    0,    0,  525,    0,  525, 
          525,    0,  525,  525,  528,    0,    0,    0,    0,   40, 
           40,   40,    0,    0,    0,   40,   40,    0,   40,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   89,    0, 
           40,   40,   40,   40,   40,    0,    0,    0,    0,    0, 
            0,    0,    0,  528,    0,   97,    0,  528,  331,  332, 
          333,  334,  335,  336,  337,    0,    0,  340,  341,    0, 
            0,    0,    0,    0,  344,  345,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  528,    0,    0,   40,  346, 
            0,  347,    0,  348,  349,  350,  351,  352,  353,  354, 
            0,  355,    0,    4,    5,    6,    0,    8,    0,   40, 
            0,    9,   10,    0,    0,    0,   11,  276,   12,   13, 
           14,  100,  101,   17,   18,    0,    0,  276,    0,  102, 
          103,  104,   22,   23,   24,   25,    0,    0,  105,    0, 
            0,    0,    0,    0,    0,  106,    0,    0,   31,   32, 
           33,    0,  107,   35,   36,   37,  108,   39,    0,   40, 
            0,   91,  109,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  276,    0,   99,  110, 
          276,    0,  111,    0,    0,  112,    0,    0,   46,   47, 
            0,   48,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  276,    0, 
           52,   53,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          546,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          546,  524,  524,  524,    0,  524,  528,  528,  528,  524, 
          524,    0,  528,  528,  524,  528,  524,  524,  524,  524, 
          524,  524,  524,    0,  528,    0,    0,  524,  524,  524, 
          524,  524,  524,  524,  528,  528,  524,  528,  528,  528, 
          528,  528,    0,  524,    0,    0,  524,  524,  524,  546, 
          524,  524,  524,  524,  524,  524,  524,  524,  524,  524, 
          524,  528,  528,  528,  528,  528,  528,  528,  528,  528, 
          528,  528,  528,  528,  528,    0,    0,  528,  528,  528, 
          524,    0,    0,  524,  524,  528,  524,  524,    0,  524, 
            0,  524,  528,  524,  528,  524,  528,  528,  528,  528, 
          528,  528,  528,  524,  528,  528,  528,    0,  524,  524, 
          524,  524,  524,  524,    0,    0,    0,  524,    0,  524, 
          524,    0,  524,  524,  525,  525,  525,    0,  525,  276, 
          276,  276,  525,  525,    0,  276,  276,  525,  276,  525, 
          525,  525,  525,  525,  525,  525,    0,    0,    0,    0, 
          525,  525,  525,  525,  525,  525,  525,  276,  276,  525, 
          276,  276,  276,  276,  276,    0,  525,    0,    0,  525, 
          525,  525,  294,  525,  525,  525,  525,  525,  525,  525, 
          525,  525,  525,  525,  276,  276,  276,  276,  276,  276, 
          276,  276,  276,  276,  276,  276,  276,  276,    0,    0, 
          276,  276,  276,  525,    0,    0,  525,  525,  276,  525, 
          525,    0,  525,    0,  525,  276,  525,  276,  525,  276, 
          276,  276,  276,  276,  276,  276,  525,  276,    0,  276, 
            0,  525,  525,  525,  525,  525,  525,    0,    0,    0, 
          525,    0,  525,  525,    0,  525,  525,  250,  250,  250, 
            0,  250,  546,  546,  546,  250,  250,  546,  546,  546, 
          250,  546,  250,  250,  250,  250,  250,  250,  250,    0, 
            0,  546,    0,  250,  250,  250,  250,  250,  250,  250, 
          546,  546,  250,  546,  546,  546,  546,  546,    0,  250, 
            0,    0,  250,  250,  250,    0,  250,  250,  250,  250, 
          250,  250,  250,  250,  250,  250,  250,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  390,  546,    0, 
            0,    0,    0,    0,    0,  546,  250,  390,    0,  250, 
            0,  546,  250,  250,    0,  250,    0,  250,    0,  250, 
            0,  250,    0,    0,    0,    0,    0,    0,    0,  250, 
            0,    0,  546,    0,  250,  250,  250,  250,  250,  250, 
            0,  390,    0,  250,    0,  250,  250,    0,  250,  250, 
            0,    0,    0,    0,    0,  390,  390,    0,   95,    0, 
          390,    0,    0,    0,    0,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,  100,  101,   17,   18,    0,  390,    0, 
            0,  102,  103,  104,   22,   23,   24,   25,  389,    0, 
          105,    0,    0,    0,    0,    0,    0,  106,  389,    0, 
           31,   32,   33,    0,   34,   35,   36,   37,   38,   39, 
            0,   40,    0,    0,  109,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  389,    0,  293,    0,    0,  112,    0,    0, 
           46,   47,    0,   48,    0,    0,  389,  389,    0,    0, 
            0,  389,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,    0,  389, 
          614,  552,    0,    0,  615,    0,    0,    0,  166,  167, 
            0,  168,  169,  170,  171,  172,  173,  174,    0,    0, 
          175,  176,  462,    0,    0,  177,  178,  179,  180,    0, 
            0,    0,  462,    0,  263,    0,    0,    0,    0,    0, 
            0,  182,  183,    0,  184,  185,  186,  187,  188,  189, 
          190,  191,  192,  193,  194,    0,    0,  195,    0,    0, 
            0,    0,    0,    0,    0,    0,  462,    0,    0,  390, 
          390,  390,    0,    0,  390,  390,  390,    0,  390,    0, 
          462,  462,    0,   94,    0,  462,    0,  390,  390,  390, 
            0,    0,    0,    0,    0,    0,    0,  390,  390,    0, 
          390,  390,  390,  390,  390,    0,    0,    0,    0,    0, 
            0,    0,  390,  462,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  390,  390,  390,  390,  390,  390, 
          390,  390,  390,  390,  390,  390,  390,  390,    0,    0, 
          390,  390,  390,    0,    0,  390,    0,    0,  390,    0, 
            0,  390,    0,  390,    0,  390,  546,  390,    0,  390, 
          390,  390,  390,  390,  390,  390,  546,  390,  390,  390, 
          389,  389,  389,    0,    0,  389,  389,  389,    0,  389, 
            0,  390,    0,    0,    0,    0,    0,    0,  389,  389, 
          389,    0,    0,    0,    0,    0,    0,    0,  389,  389, 
          546,  389,  389,  389,  389,  389,    0,    0,    0,    0, 
            0,    0,    0,  389,  546,  546,    0,    0,    0,  546, 
            0,    0,    0,    0,    0,  389,  389,  389,  389,  389, 
          389,  389,  389,  389,  389,  389,  389,  389,  389,    0, 
            0,  389,  389,  389,    0,    0,  389,  546,    0,  389, 
            0,    0,  389,    0,  389,    0,  389,    0,  389,    0, 
          389,  389,  389,  389,  389,  389,  389,    0,  389,  389, 
          389,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  389,    0,  462,  462,  462,    0,    0,  462, 
          462,  462,    0,  462,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  462,  462,    0,    0,    0,    0,    0, 
            0,    0,  462,  462,    0,  462,  462,  462,  462,  462, 
            0,    0,    0,    0,    0,    0,    0,  462,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  462, 
          462,  462,  462,  462,  462,  462,  462,  462,  462,  462, 
          462,  462,  462,    0,  270,  462,  462,  462,    0,  463, 
          462,    0,    0,  462,  270,    0,  462,    0,  462,    0, 
          462,    0,  462,    0,  462,  462,  462,  462,  462,  462, 
          462,    0,  462,    0,  462,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  462,    0,  270,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  270,  270,    0,  101,    0,  270,  546,  546, 
          546,    0,    0,  546,  546,  546,    0,  546,    0,    0, 
            0,    0,    0,    0,    0,    0,  546,  546,  546,    0, 
            0,    0,    0,    0,    0,  270,  546,  546,    0,  546, 
          546,  546,  546,  546,    0,    0,    0,    0,    0,    0, 
            0,  546,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  546,  546,  546,  546,  546,  546,  546, 
          546,  546,  546,  546,  546,  546,  546,    0,  277,  546, 
          546,  546,    0,    0,  546,    0,    0,  546,  277,    0, 
          546,    0,  546,    0,  546,    0,  546,    0,  546,  546, 
          546,  546,  546,  546,  546,    0,  546,  546,  546,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          546,    0,  277,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  616,  558,  277,  277,  617,  100, 
            0,  277,  166,  167,    0,  168,  169,  170,  171,  172, 
          173,  174,    0,    0,  175,  176,    0,    0,    0,  177, 
          178,  179,  180,    0,    0,    0,    0,    0,  263,  277, 
            0,    0,    0,    0,    0,  182,  183,    0,  184,  185, 
          186,  187,  188,  189,  190,  191,  192,  193,  194,    0, 
            0,  195,  410,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  410,    0,    0,    0,  270,  270,  270,    0, 
            0,  270,  270,  270,    0,  270,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  270,  270,    0,    0,    0, 
            0,    0,    0,    0,  270,  270,  410,  270,  270,  270, 
          270,  270,    0,    0,    0,    0,    0,    0,    0,  270, 
          410,  410,    0,    0,    0,  410,    0,    0,    0,    0, 
            0,  270,  270,  270,  270,  270,  270,  270,  270,  270, 
          270,  270,  270,  270,  270,    0,    0,  270,  270,  270, 
            0,    0,  270,  410,    0,  270,    0,    0,  270,    0, 
          270,    0,  270,  288,  270,    0,  270,  270,  270,  270, 
          270,  270,  270,  288,  270,    0,  270,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  270,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  288,    0,    0, 
          277,  277,  277,    0,    0,  277,  277,  277,    0,  277, 
            0,  288,  288,    0,    0,    0,  288,    0,    0,  277, 
          277,    0,    0,    0,    0,    0,    0,    0,  277,  277, 
            0,  277,  277,  277,  277,  277,    0,    0,    0,    0, 
            0,    0,    0,  277,  288,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  277,  277,  277,  277,  277, 
          277,  277,  277,  277,  277,  277,  277,  277,  277,    0, 
            0,  277,  277,  277,    0,    0,  277,    0,    0,  277, 
            0,    0,  277,    0,  277,    0,  277,    0,  277,    0, 
          277,  277,  277,  277,  277,  277,  277,  234,  277,    0, 
          277,    0,    0,    0,    0,    0,    0,  234,    0,    0, 
            0,    0,  277,    0,  410,  410,  410,    0,    0,  410, 
          410,  410,    0,  410,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  410,  410,    0,    0,    0,    0,    0, 
            0,  234,  410,  410,    0,  410,  410,  410,  410,  410, 
            0,    0,    0,    0,    0,  234,  234,  410,    0,    0, 
          234,    0,    0,    0,    0,    0,    0,    0,    0,  410, 
          410,  410,  410,  410,  410,  410,  410,  410,  410,  410, 
          410,  410,  410,    0,    0,  410,  410,  410,  320,    0, 
          410,    0,    0,  410,    0,    0,  410,    0,  410,    0, 
          410,  283,  410,    0,  410,  410,  410,  410,  410,  410, 
          410,  283,  410,    0,  410,  288,  288,  288,    0,    0, 
          288,  288,  288,    0,  288,    0,  410,    0,    0,    0, 
            0,    0,    0,    0,  288,  288,    0,    0,    0,    0, 
            0,    0,    0,  288,  288,  283,  288,  288,  288,  288, 
          288,    0,    0,    0,    0,    0,    0,    0,  288,  283, 
          283,    0,    0,    0,  283,    0,    0,    0,    0,    0, 
          288,  288,  288,  288,  288,  288,  288,  288,  288,  288, 
          288,  288,  288,  288,    0,    0,  288,  288,  288,    0, 
            0,  288,  283,    0,  288,    0,    0,  288,    0,  288, 
            0,  288,    0,  288,    0,  288,  288,  288,  288,  288, 
          288,  288,    0,  288,  448,  288,    0,    0,    0,    0, 
            0,    0,    0,    0,  448,    0,    0,  288,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  448,  234, 
          234,  234,    0,    0,  234,  234,  234,    0,  234,    0, 
            0,    0,  448,  448,    0,    0,    0,  448,  234,  234, 
            0,    0,    0,    0,    0,    0,    0,  234,  234,    0, 
          234,  234,  234,  234,  234,    0,    0,    0,    0,    0, 
            0,    0,  234,    0,    0,  448,    0,    0,    0,    0, 
            0,    0,    0,    0,  234,  234,  234,  234,  234,  234, 
          234,  234,  234,  234,  234,  320,  234,  234,    0,    0, 
          234,  234,  320,    0,    0,  234,    0,    0,  234,    0, 
            0,  234,    0,  234,    0,  234,  449,  234,    0,  234, 
          234,  234,  234,  234,  234,  234,  449,  234,    0,  234, 
            0,    0,    0,  283,  283,  283,    0,    0,  283,  283, 
          283,  234,  283,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  283,  283,    0,    0,    0,    0,    0,    0, 
          449,  283,  283,    0,  283,  283,  283,  283,  283,    0, 
            0,    0,    0,    0,  449,  449,  283,    0,    0,  449, 
            0,    0,    0,    0,    0,    0,    0,    0,  283,  283, 
          283,  283,  283,  283,  283,  283,  283,  283,  283,  283, 
          283,  283,    0,    0,  283,  283,  283,  449,    0,  283, 
            0,    0,  283,    0,    0,  283,    0,  283,    0,  283, 
            0,  283,    0,  283,  283,  283,  283,  283,  283,  283, 
            0,  283,  212,  283,    0,    0,    0,    0,    0,    0, 
            0,    0,  212,    0,    0,  283,  448,  448,  448,    0, 
            0,  448,  448,  448,    0,  448,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  448,  448,    0,    0,    0, 
            0,    0,    0,    0,  448,  448,  212,  448,  448,  448, 
          448,  448,    0,    0,    0,    0,    0,    0,    0,  448, 
          212,  212,    0,    0,    0,  212,    0,    0,    0,    0, 
            0,    0,  448,  448,  448,  448,  448,  448,  448,  448, 
          448,  448,  448,  448,  448,    0,    0,  448,  448,  448, 
            0,    0,  448,    0,    0,  448,    0,    0,  448,    0, 
          448,    0,  448,  208,  448,    0,  448,  448,  448,  448, 
          448,  448,  448,  208,  448,    0,  448,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  448,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  208,  449,  449, 
          449,    0,    0,  449,  449,  449,    0,  449,    0,    0, 
            0,  208,  208,    0,    0,    0,  208,  449,  449,    0, 
            0,    0,    0,    0,    0,    0,  449,  449,    0,  449, 
          449,  449,  449,  449,    0,    0,    0,    0,    0,    0, 
            0,  449,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  449,  449,  449,  449,  449,  449, 
          449,  449,  449,  449,  449,  449,  449,    0,  205,  449, 
          449,  449,    0,    0,  449,    0,    0,  449,  205,    0, 
          449,    0,  449,    0,  449,    0,  449,    0,  449,  449, 
          449,  449,  449,  449,  449,    0,  449,    0,  449,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          449,    0,  205,    0,  212,  212,  212,    0,    0,  212, 
          212,  212,    0,  212,    0,    0,  205,  205,    0,    0, 
            0,  205,    0,  212,  212,    0,    0,    0,    0,    0, 
            0,    0,  212,  212,    0,  212,  212,  212,  212,  212, 
            0,    0,    0,    0,    0,    0,    0,  212,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          212,  212,  212,  212,  212,  212,  212,  212,  212,  212, 
            0,  212,  212,    0,    0,  212,  212,    0,    0,    0, 
          212,    0,    0,  212,    0,    0,  212,    0,  212,    0, 
          212,  207,  212,    0,  212,  212,  212,  212,  212,  212, 
          212,  207,  212,    0,  212,  208,  208,  208,    0,    0, 
          208,  208,  208,    0,  208,    0,  212,    0,    0,    0, 
            0,    0,    0,    0,  208,  208,    0,    0,    0,    0, 
            0,    0,    0,  208,  208,  207,  208,  208,  208,  208, 
          208,    0,    0,    0,    0,    0,    0,    0,  208,  207, 
          207,    0,    0,    0,  207,    0,    0,    0,    0,    0, 
            0,  208,  208,  208,  208,  208,  208,  208,  208,  208, 
          208,    0,  208,  208,    0,    0,  208,  208,    0,    0, 
            0,  208,    0,    0,  208,    0,    0,  208,    0,  208, 
            0,  208,    0,  208,    0,  208,  208,  208,  208,  208, 
          208,  208,    0,  208,    0,  208,  206,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  206,  208,    0,    0, 
          205,  205,  205,    0,    0,  205,  205,  205,    0,  205, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  205, 
          205,    0,    0,    0,    0,    0,    0,    0,  205,  205, 
          206,  205,  205,  205,  205,  205,    0,    0,    0,    0, 
            0,    0,    0,  205,  206,  206,    0,    0,    0,  206, 
            0,    0,    0,    0,    0,    0,  205,  205,  205,  205, 
          205,  205,  205,  205,  205,  205,    0,  205,  205,    0, 
            0,  205,  205,    0,    0,    0,  205,    0,    0,  205, 
            0,    0,  205,    0,  205,    0,  205,  209,  205,    0, 
          205,  205,  205,  205,  205,  205,  205,  209,  205,    0, 
          205,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  205,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  209,    0,  207,  207,  207,    0,    0,  207,  207, 
          207,    0,  207,    0,    0,  209,  209,    0,    0,    0, 
          209,    0,  207,  207,    0,    0,    0,    0,    0,    0, 
            0,  207,  207,    0,  207,  207,  207,  207,  207,    0, 
            0,    0,    0,    0,    0,    0,  207,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  207, 
          207,  207,  207,  207,  207,  207,  207,  207,  207,    0, 
          207,  207,    0,  210,  207,  207,    0,    0,    0,  207, 
            0,    0,  207,  210,    0,  207,    0,  207,    0,  207, 
            0,  207,    0,  207,  207,  207,  207,  207,  207,  207, 
            0,  207,    0,  207,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  207,    0,  210,  206,  206, 
          206,    0,    0,  206,  206,  206,    0,  206,    0,    0, 
            0,  210,  210,    0,    0,    0,  210,  206,  206,    0, 
            0,    0,    0,    0,    0,    0,  206,  206,    0,  206, 
          206,  206,  206,  206,    0,    0,    0,    0,    0,    0, 
            0,  206,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  206,  206,  206,  206,  206,  206, 
          206,  206,  206,  206,    0,  206,  206,    0,    0,  206, 
          206,    0,    0,    0,  206,    0,    0,  206,    0,    0, 
          206,    0,  206,    0,  206,  203,  206,    0,  206,  206, 
          206,  206,  206,  206,  206,  203,  206,    0,  206,  209, 
          209,  209,    0,    0,  209,  209,  209,    0,  209,    0, 
          206,    0,    0,    0,    0,    0,    0,    0,  209,  209, 
            0,    0,    0,    0,    0,    0,    0,  209,  209,  203, 
          209,  209,  209,  209,  209,    0,    0,    0,    0,    0, 
            0,    0,  209,  203,  203,    0,    0,    0,  203,    0, 
            0,    0,    0,    0,    0,  209,  209,  209,  209,  209, 
          209,  209,  209,  209,  209,    0,  209,  209,    0,    0, 
          209,  209,    0,    0,    0,  209,    0,    0,  209,    0, 
            0,  209,    0,  209,    0,  209,    0,  209,    0,  209, 
          209,  209,  209,  209,  209,  209,    0,  209,  204,  209, 
            0,    0,    0,    0,    0,    0,    0,    0,  204,    0, 
            0,  209,    0,    0,    0,  210,  210,  210,    0,    0, 
          210,  210,  210,    0,  210,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  210,  210,    0,    0,    0,    0, 
            0,    0,  204,  210,  210,    0,  210,  210,  210,  210, 
          210,    0,    0,    0,    0,    0,  204,  204,  210,    0, 
            0,  204,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  210,  210,  210,  210,  210,  210,  210,  210,  210, 
          210,    0,  210,  210,    0,    0,  210,  210,    0,    0, 
            0,  210,    0,    0,  210,    0,    0,  210,    0,  210, 
            0,  210,  228,  210,    0,  210,  210,  210,  210,  210, 
          210,  210,  228,  210,    0,  210,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  210,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  228,  203,  203,  203, 
            0,    0,  203,  203,  203,    0,  203,    0,    0,    0, 
          228,  228,    0,    0,    0,  228,  203,  203,    0,    0, 
            0,    0,    0,    0,    0,  203,  203,    0,  203,  203, 
          203,  203,  203,    0,    0,    0,    0,    0,    0,    0, 
          203,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  203,  203,  203,  203,  203,  203,  203, 
          203,  203,  203,    0,  203,  203,    0,    0,  203,  203, 
            0,    0,    0,  203,  229,    0,  203,    0,    0,  203, 
            0,  203,    0,    0,  229,  203,    0,    0,    0,  203, 
          203,  203,  203,  203,    0,  203,    0,  203,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  203, 
          204,  204,  204,    0,    0,  204,  204,  204,  229,  204, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  204, 
          204,    0,  229,  229,    0,    0,    0,  229,  204,  204, 
            0,  204,  204,  204,  204,  204,    0,    0,    0,    0, 
            0,    0,    0,  204,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  204,  204,  204,  204, 
          204,  204,  204,  204,  204,  204,    0,  204,  204,    0, 
            0,  204,  204,    0,    0,    0,  204,    0,    0,  204, 
            0,    0,  204,    0,  204,    0,    0,  215,  204,    0, 
            0,    0,  204,  204,  204,  204,  204,  215,  204,    0, 
          204,    0,    0,    0,  228,  228,  228,    0,    0,  228, 
          228,  228,  204,  228,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  228,  228,    0,    0,    0,    0,    0, 
            0,  215,  228,  228,    0,  228,  228,  228,  228,  228, 
            0,    0,    0,    0,    0,  215,  215,  228,    0,    0, 
          215,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          228,  228,  228,  228,  228,  228,  228,  228,  228,  228, 
            0,  228,  228,    0,    0,  228,  228,    0,    0,    0, 
          228,    0,    0,  228,    0,    0,  228,    0,  228,    0, 
            0,    0,  228,    0,    0,    0,    0,    0,  228,  228, 
          228,    0,  228,    0,  228,  213,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  213,  228,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  229,  229,  229,    0, 
            0,  229,  229,  229,    0,  229,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  229,  229,    0,    0,  213, 
            0,    0,    0,    0,  229,  229,    0,  229,  229,  229, 
          229,  229,    0,  213,  213,    0,    0,    0,  213,  229, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  229,  229,  229,  229,  229,  229,  229,  229, 
          229,  229,    0,  229,  229,    0,    0,  229,  229,    0, 
            0,    0,  229,    0,    0,  229,    0,    0,  229,    0, 
          229,    0,    0,  214,  229,    0,    0,    0,    0,    0, 
          229,  229,  229,  214,  229,    0,  229,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  229,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  215, 
          215,  215,    0,    0,  215,  215,  215,  214,  215,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  215,  215, 
            0,  214,  214,    0,    0,    0,  214,  215,  215,    0, 
          215,  215,  215,  215,  215,    0,    0,    0,    0,    0, 
            0,    0,  215,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  215,  215,  215,  215,  215, 
          215,  215,  215,  215,  215,    0,  215,  215,    0,    0, 
            0,    0,  218,    0,    0,  215,    0,    0,  215,    0, 
            0,  215,  218,  215,    0,    0,    0,  215,    0,    0, 
            0,    0,    0,  215,  215,  215,    0,  215,    0,  215, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  215,    0,    0,    0,    0,  218,  213,  213,  213, 
            0,    0,  213,  213,  213,    0,  213,    0,    0,    0, 
          218,  218,    0,    0,    0,  218,  213,  213,    0,    0, 
            0,    0,    0,    0,    0,  213,  213,    0,  213,  213, 
          213,  213,  213,    0,    0,    0,    0,    0,    0,    0, 
          213,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  213,  213,  213,  213,  213,  213,  213, 
          213,  213,  213,    0,  213,  213,    0,    0,    0,    0, 
            0,    0,  220,  213,    0,    0,  213,    0,    0,  213, 
            0,  213,  220,    0,    0,    0,    0,    0,    0,    0, 
            0,  213,  213,  213,    0,  213,    0,  213,    0,    0, 
            0,    0,    0,    0,    0,  214,  214,  214,    0,  213, 
          214,  214,  214,    0,  214,    0,  220,    0,    0,    0, 
            0,    0,    0,    0,  214,  214,    0,    0,    0,    0, 
          220,  220,    0,  214,  214,  220,  214,  214,  214,  214, 
          214,    0,    0,    0,    0,    0,    0,    0,  214,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  214,  214,  214,  214,  214,  214,  214,  214,  214, 
          214,    0,  214,  214,    0,    0,    0,    0,    0,    0, 
            0,  214,    0,    0,  214,    0,    0,  214,    0,  214, 
            0,    0,  219,    0,    0,    0,    0,    0,    0,  214, 
          214,  214,  219,  214,    0,  214,    0,    0,    0,    0, 
            0,    0,    0,    0,  218,  218,  218,  214,    0,  218, 
          218,  218,    0,  218,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  218,  218,    0,  219,    0,    0,    0, 
            0,    0,  218,  218,    0,  218,  218,  218,  218,  218, 
          219,  219,    0,    0,    0,  219,    0,  218,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          218,  218,  218,  218,  218,  218,  218,  218,  218,  218, 
            0,  218,  218,    0,    0,    0,    0,    0,    0,  217, 
          218,    0,    0,  218,    0,    0,  218,    0,  218,  217, 
            0,    0,    0,    0,    0,    0,    0,    0,  218,  218, 
            0,    0,    0,    0,  218,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  218,    0,    0,    0, 
            0,    0,    0,  217,  220,  220,  220,    0,    0,  220, 
          220,  220,    0,  220,    0,    0,    0,  217,  217,    0, 
            0,    0,  217,  220,  220,    0,    0,    0,    0,    0, 
            0,    0,  220,  220,    0,  220,  220,  220,  220,  220, 
            0,    0,    0,    0,    0,    0, 
      };
   }

   private static final short[] yyTable3() {
      return new short[] {

            0,  220,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  220,  220,  220,  220,  220,  220, 
          220,  220,  220,  220,    0,  220,  220,    0,    0,    0, 
            0,  216,    0,    0,  220,    0,    0,  220,    0,    0, 
          220,  216,  220,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  220,  220,    0,    0,    0,    0,  220,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          220,    0,    0,    0,    0,  216,    0,    0,  219,  219, 
          219,    0,    0,  219,  219,  219,    0,  219,    0,  216, 
          216,    0,    0,    0,  216,    0,    0,  219,  219,    0, 
            0,    0,    0,    0,    0,    0,  219,  219,    0,  219, 
          219,  219,  219,  219,    0,    0,    0,    0,    0,    0, 
            0,  219,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  219,  219,  219,  219,  219,  219, 
          219,  219,  219,  219,    0,  219,  219,    0,    0,    0, 
            0,    0,    0,  221,  219,    0,    0,  219,    0,    0, 
          219,    0,  219,  221,    0,    0,    0,    0,    0,    0, 
            0,    0,  219,  219,    0,  217,  217,  217,  219,    0, 
          217,  217,  217,    0,  217,    0,    0,    0,    0,    0, 
          219,    0,    0,    0,  217,  217,    0,  221,    0,    0, 
            0,    0,    0,  217,  217,    0,  217,  217,  217,  217, 
          217,  221,  221,    0,    0,    0,  221,    0,  217,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  217,  217,  217,  217,  217,  217,  217,  217,  217, 
          217,    0,  217,  217,    0,    0,    0,    0,    0,    0, 
            0,  217,    0,    0,  217,    0,    0,  217,    0,  217, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  217, 
          217,  222,    0,    0,    0,  217,    0,    0,    0,    0, 
            0,  222,    0,    0,    0,    0,    0,  217,    0,    0, 
            0,    0,    0,  216,  216,  216,    0,    0,  216,  216, 
          216,    0,  216,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  216,  216,    0,  222,    0,    0,    0,    0, 
            0,  216,  216,    0,  216,  216,  216,  216,  216,  222, 
          222,    0,    0,    0,  222,    0,  216,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  216,  216,    0,    0,    0, 
          216,  216,    0,    0,    0,    0,    0,    0,  223,  216, 
            0,    0,  216,    0,    0,  216,    0,  216,  223,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  216,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  216,    0,    0,    0,    0, 
            0,    0,  223,    0,    0,  221,  221,  221,    0,    0, 
          221,  221,  221,    0,  221,    0,  223,  223,    0,    0, 
            0,  223,    0,    0,  221,  221,    0,    0,    0,    0, 
            0,    0,    0,  221,  221,    0,  221,  221,  221,  221, 
          221,    0,    0,    0,  230,    0,    0,    0,  221,    0, 
            0,    0,    0,    0,  230,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  221,  221,    0, 
            0,    0,  221,  221,    0,    0,    0,    0,    0,    0, 
            0,  221,    0,    0,  221,    0,    0,  221,  230,  221, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  230,  230,    0,  221,    0,  230,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  221,    0,    0, 
            0,    0,    0,  222,  222,  222,    0,    0,  222,  222, 
          222,    0,  222,    0,  224,    0,    0,    0,    0,    0, 
            0,    0,  222,  222,  224,    0,    0,    0,    0,    0, 
            0,  222,  222,    0,  222,  222,  222,  222,  222,    0, 
            0,    0,    0,    0,    0,    0,  222,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  224,    0, 
            0,    0,    0,    0,    0,  222,  222,    0,    0,    0, 
          222,  222,  224,  224,    0,    0,    0,  224,    0,  222, 
            0,    0,  222,    0,    0,  222,    0,  222,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          223,  223,  223,  222,    0,  223,  223,  223,    0,  223, 
            0,  225,    0,    0,    0,  222,    0,    0,    0,  223, 
          223,  225,    0,    0,    0,    0,    0,    0,  223,  223, 
            0,  223,  223,  223,  223,  223,    0,    0,    0,    0, 
            0,    0,    0,  223,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  225,    0,    0,    0,    0, 
            0,    0,  223,  223,    0,    0,    0,  223,  223,  225, 
          225,    0,    0,    0,  225,    0,  223,    0,    0,  223, 
            0,    0,  223,    0,  223,    0,  230,  230,  230,    0, 
            0,  230,  230,  230,    0,  230,    0,  231,    0,    0, 
          223,    0,    0,    0,    0,  230,  230,  231,    0,    0, 
            0,    0,  223,    0,  230,  230,    0,  230,  230,  230, 
          230,  230,    0,    0,    0,    0,    0,    0,    0,  230, 
            0,    0,    0,    0,    0,   38,    0,    0,    0,    0, 
            0,  231,    0,    0,    0,   38,    0,    0,  230,  230, 
            0,    0,    0,  230,  230,  231,  231,    0,    0,    0, 
          231,    0,  230,    0,    0,  230,    0,    0,  230,    0, 
          230,    0,    0,    0,    0,    0,  224,  224,  224,  256, 
            0,  224,  224,  224,    0,  224,  230,  202,    0,    0, 
            0,    0,    0,    0,   38,  224,  224,  202,  230,    0, 
            0,    0,    0,    0,  224,  224,    0,  224,  224,  224, 
          224,  224,    0,    0,    0,    0,    0,    0,    0,  224, 
            0,    0,    0,    0,    0,    0,    0,  232,    0,    0, 
            0,  202,    0,    0,    0,    0,    0,  232,  224,  224, 
            0,    0,    0,  224,  224,  202,  202,    0,    0,    0, 
          202,    0,  224,    0,    0,  224,    0,    0,  224,    0, 
          224,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  232,    0,  225,  225,  225,  224,    0,  225,  225, 
          225,    0,  225,    0,    0,  232,  232,    0,  224,    0, 
            0,    0,  225,  225,    0,    0,    0,    0,    0,    0, 
            0,  225,  225,    0,  225,  225,  225,  225,  225,    0, 
            0,    0,  200,    0,    0,    0,  225,    0,    0,    0, 
            0,    0,  200,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  225,  225,    0,    0,    0, 
          225,  225,    0,    0,    0,    0,    0,    0,    0,  225, 
            0,    0,  225,    0,    0,  225,  200,  225,    0,  231, 
          231,  231,    0,    0,  231,  231,  231,    0,  231,    0, 
          200,  200,    0,  225,    0,    0,    0,    0,  231,  231, 
            0,    0,    0,    0,    0,  225,    0,  231,  231,    0, 
          231,  231,  231,  231,  231,    0,    0,   38,   38,   38, 
            0,    0,  231,   38,   38,    0,   38,    0,  199,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  199,    0, 
            0,    0,  231,    0,    0,    0,  231,  231,   38,   38, 
           38,   38,   38,    0,    0,  231,    0,    0,  231,    0, 
            0,  231,    0,  231,    0,    0,    0,    0,    0,  202, 
          202,  202,  199,    0,  202,  202,  202,    0,  202,  231, 
            0,    0,    0,    0,    0,    0,  199,  199,  202,  202, 
            0,  231,    0,    0,    0,    0,   38,  202,  202,    0, 
          202,  202,  202,  202,  202,    0,    0,    0,    0,  232, 
          232,  232,  202,  195,  232,  232,  232,   38,  232,    0, 
            0,    0,    0,  195,    0,    0,    0,    0,  232,  232, 
            0,    0,    0,    0,    0,    0,    0,  232,  232,    0, 
          232,  232,  232,  232,  232,  202,    0,    0,  202,    0, 
            0,  202,  232,  202,    0,    0,    0,  195,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  202, 
            0,  195,  195,    0,  196,    0,    0,    0,    0,    0, 
            0,  202,    0,    0,  196,  232,    0,    0,  232,    0, 
            0,  232,    0,  232,  200,  200,  200,    0,    0,  200, 
          200,  200,    0,  200,    0,    0,    0,    0,    0,  232, 
            0,    0,    0,  200,  200,    0,    0,    0,  196,    0, 
            0,  232,  200,  200,    0,  200,  200,  200,  200,  200, 
            0,    0,  196,  196,    0,    0,    0,  200,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          200,  197,    0,  200,    0,    0,  200,    0,  200,    0, 
            0,  197,    0,    0,    0,    0,    0,    0,    0,    0, 
          199,  199,  199,    0,  200,  199,  199,  199,    0,  199, 
            0,    0,    0,    0,    0,    0,  200,    0,    0,  199, 
          199,    0,    0,    0,    0,  197,    0,    0,  199,  199, 
            0,  199,  199,  199,  199,  199,    0,    0,    0,  197, 
          197,    0,    0,  199,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  198,    0,    0, 
            0,    0,    0,    0,    0,    0,  199,  198,    0,  199, 
            0,    0,  199,    0,  199,  195,  195,  195,    0,    0, 
          195,  195,  195,    0,  195,    0,    0,    0,    0,    0, 
          199,    0,    0,    0,  195,  195,    0,    0,    0,    0, 
            0,  198,  199,  195,  195,    0,  195,  195,  195,  195, 
          195,    0,    0,    0,    0,  198,  198,    0,  195,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  196,  196,  196,    0, 
            0,  196,  196,  196,    0,  196,    0,    0,    0,    0, 
            0,  195,    0,    0,  195,  196,  196,  195,    0,  195, 
            0,    0,    0,    0,  196,  196,  191,  196,  196,  196, 
          196,  196,    0,    0,    0,  195,  191,    0,    0,  196, 
            0,    0,    0,    0,    0,    0,    0,  195,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          191,    0,  196,    0,    0,  196,    0,    0,  196,    0, 
          196,    0,    0,    0,  191,  191,    0,  193,    0,    0, 
            0,    0,    0,  197,  197,  197,  196,  193,  197,  197, 
          197,    0,  197,    0,    0,    0,    0,    0,  196,    0, 
            0,    0,  197,  197,    0,    0,    0,    0,    0,    0, 
            0,  197,  197,    0,  197,  197,  197,  197,  197,    0, 
            0,  193,    0,    0,    0,    0,  197,    0,    0,    0, 
            0,    0,    0,    0,    0,  193,  193,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  197, 
            0,    0,  197,  233,    0,  197,    0,  197,    0,  198, 
          198,  198,    0,  233,  198,  198,  198,    0,  198,    0, 
            0,    0,    0,  197,    0,    0,    0,    0,  198,  198, 
            0,    0,    0,    0,    0,  197,    0,  198,  198,    0, 
          198,  198,  198,  198,  198,    0,    0,  233,    0,    0, 
            0,    0,  198,    0,    0,    0,    0,    0,    0,    0, 
            0,  233,  233,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  198,    0,    0,  198,    0, 
            0,  198,    0,  198,    0,    0,    0,    0,    0,    0, 
          194,    0,    0,    0,    0,    0,    0,    0,    0,  198, 
          194,    0,    0,    0,    0,    0,    0,    0,  191,  191, 
          191,  198,    0,  191,  191,  191,    0,  191,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  191,  191,    0, 
            0,    0,    0,    0,  194,    0,  191,  191,    0,  191, 
          191,  191,  191,  191,    0,    0,    0,  261,  194,  194, 
            0,  191,    0,    0,    0,    0,    0,  261,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  193, 
          193,  193,    0,    0,  193,  193,  193,    0,  193,    0, 
            0,    0,    0,    0,  191,    0,    0,  191,  193,  193, 
          191,  259,  191,    0,    0,    0,    0,  193,  193,  235, 
          193,  193,  193,  193,  193,    0,  261,    0,  191,  235, 
            0,    0,  193,    0,    0,    0,    0,    0,    0,    0, 
          191,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  235,    0,  193,    0,    0,  193,    0, 
            0,  193,    0,  193,    0,  233,  233,  233,  235,    0, 
          233,  233,  233,    0,  233,    0,    0,    0,    0,  193, 
            0,    0,    0,    0,  233,  233,    0,    0,    0,    0, 
            0,  193,    0,  233,  233,  192,  233,  233,  233,  233, 
          233,    0,    0,    0,    0,  192,    0,    0,  233,    0, 
            0,   22,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   22,    0,    0,    0,    0,    0,    0,    0,    0, 
          190,    0,    0,    0,    0,    0,    0,    0,    0,  192, 
          190,  233,    0,    0,  233,    0,    0,  233,    0,  233, 
            0,    0,    0,  192,  192,    0,    0,    0,    0,    0, 
            0,    0,  194,  194,  194,  233,    0,  194,  194,  194, 
           22,  194,    0,    0,  190,    0,    0,  233,    0,    0, 
            0,  194,  194,    0,    0,    0,    0,    0,  190,  190, 
          194,  194,    0,  194,  194,  194,  194,  194,    0,    0, 
            0,    0,    0,    0,    0,  194,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  261, 
          261,  261,    0,    0,  261,  261,  261,    0,  261,    0, 
            0,    0,    0,    0,    0,  102,    0,    0,  194,    0, 
            0,  194,    0,    0,  194,    0,  194,    0,    0,    0, 
          261,  261,  261,  261,  261,    0,    0,    0,    0,    0, 
            0,    0,  194,    0,    0,    0,    0,    0,    0,    0, 
            0,  235,  235,  235,  194,    0,  235,  235,  235,    0, 
          235,    0,    0,    0,  102,    0,    0,    0,    0,    0, 
          235,  235,    0,    0,    0,  261,    0,    0,  261,  235, 
          235,    0,  235,  235,  235,  235,  235,    0,    0,    0, 
            0,    0,    0,    0,  235,    0,  450,    0,    0,  261, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  235,    0,    0, 
          235,    0,    0,  235,    0,  235,    0,  192,  192,  192, 
            0,  103,  192,  192,  192,    0,  192,    0,    0,    0, 
            0,  235,    0,   22,   22,   22,  192,  192,    0,   22, 
           22,    0,   22,  235,    0,  192,  192,    0,  192,  192, 
          192,  192,  190,  190,  190,    0,    0,  190,  190,  190, 
          192,  190,    0,    0,   22,   22,   22,   22,   22,    0, 
          103,  190,  190,    0,    0,    0,    0,    0,    0,    0, 
          190,  190,    0,  190,  190,  190,  190,    0,    0,    0, 
            0,    0,    0,  192,    0,  190,  192,    0,    0,  192, 
            0,  192,  453,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   22,    0,    0,    0,    0,  192,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  190,  192, 
            0,  190,    0,   22,  190,    0,  190,    0,    0,    0, 
            0,  102,  102,  102,  102,  102,  102,  102,  102,  102, 
          102,  102,  190,  102,  102,  102,    0,  102,  102,  102, 
          102,  102,  102,  102,  190,  521,    0,    0,  102,  102, 
          102,  102,  102,  102,  102,    0,    0,  102,    0,    0, 
            0,    0,    0,  102,  102,    0,  102,  102,  102,  102, 
            0,  102,  102,  102,  102,  102,  102,    0,  102,  102, 
          102,  102,  102,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  450,    0,    0,    0,    0,    0,    0, 
          450,  102,    0,    0,  102,  521,    0,  102,  102,    0, 
          102,    0,  102,    0,  528,    0,  102,    0,    0,    0, 
            0,  102,    0,    0,  102,    0,  521,    0,    0,  102, 
          102,  102,  102,  102,  102,    0,    0,    0,  102,    0, 
          102,  102,    0,  102,  102,    0,    0,  103,  103,  103, 
          103,  103,  103,  103,  103,  103,  103,  103,    0,  103, 
          103,  103,    0,  103,  103,  103,  103,  103,  103,  103, 
            0,  522,    0,    0,  103,  103,  103,  103,  103,  103, 
          103,    0,    0,  103,    0,    0,    0,    0,    0,  103, 
          103,    0,  103,  103,  103,  103,    0,  103,  103,  103, 
          103,  103,  103,    0,  103,  103,  103,  103,  103,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  453, 
            0,    0,    0,    0,    0,    0,  453,  103,    0,    0, 
          103,  522,    0,  103,  103,    0,  103,    0,  103,    0, 
          276,    0,  103,    0,    0,    0,    0,  103,    0,    0, 
          103,    0,  522,    0,    0,  103,  103,  103,  103,  103, 
          103,    0,    0,    0,  103,    0,  103,  103,    0,  103, 
          103,    0,    0,    0,    0,    0,    0,    0,    0,  102, 
          102,  102,  102,  102,  102,  102,  102,  102,  102,  102, 
            0,  103,  102,  102,    0,  102,  102,  102,  102,  102, 
          102,  102,    0,  528,    0,    0,  102,  102,  102,  102, 
          102,  102,  102,    0,    0,  102,    0,    0,    0,    0, 
            0,  102,  102,    0,  102,  102,  102,  102,    0,  102, 
          102,  102,  102,  102,  102,    0,  102,  102,  102,  102, 
          103,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  528,    0,    0,    0,    0,    0,    0,  528,  102, 
            0,    0,  102,  524,    0,  102,  102,    0,  102,    0, 
          102,    0,  277,    0,  102,    0,    0,    0,    0,  102, 
            0,    0,  102,    0,  528,    0,    0,  102,  102,  102, 
          102,  102,  102,    0,    0,    0,  102,    0,  102,  102, 
            0,  102,  102,    0,    0,  103,  103,  103,  103,  103, 
          103,  103,  103,  103,  103,  103,    0,  321,  103,  103, 
            0,  103,  103,  103,  103,  103,  103,  103,    0,    0, 
            0,    0,  103,  103,  103,  103,  103,  103,  103,    0, 
            0,  103,    0,    0,    0,    0,    0,  103,  103,    0, 
          103,  103,  103,  103,    0,  103,  103,  103,  103,  103, 
          103,    0,  103,  103,  103,  103,  321,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  276,    0,    0, 
            0,    0,    0,    0,  276,  103,    0,    0,  103,  525, 
            0,  103,  103,    0,  103,    0,  103,    0,    0,    0, 
          103,    0,    0,    0,    0,  103,    0,    0,  103,    0, 
            0,    0,    0,  103,  103,  103,  103,  103,  103,    0, 
            0,    0,  103,    0,  103,  103,    0,  103,  103,    0, 
            0,    0,    0,    0,    0,    0,    0,  103,  103,  103, 
          103,  103,  103,  103,  103,  103,  103,  103,    0,  546, 
          103,  103,    0,  103,  103,  103,  103,  103,  103,  103, 
            0,    0,    0,    0,  103,  103,  103,  103,  103,  103, 
          103,    0,    0,  103,    0,    0,    0,    0,    0,  103, 
          103,    0,  103,  103,  103,  103,    0,  103,  103,  103, 
          103,  103,  103,    0,  103,  103,  103,  103,  546,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  277, 
            0,    0,    0,    0,    0,    0,  277,  103,    0,    0, 
          103,    0,    0,  103,  103,    0,  103,    0,  103,    0, 
            0,    0,  103,    0,    0,    0,    0,  103,    0,    0, 
          103,    0,    0,    0,    0,  103,  103,  103,  103,  103, 
          103,    0,    0,    0,  103,    0,  103,  103,    0,  103, 
          103,    0,    0,  321,  321,  321,  321,  321,  321,  321, 
          321,  321,  321,  321,    0,  321,  321,  321,  321,  321, 
          321,  321,  321,  321,  321,  321,  546,    0,    0,    0, 
          321,  321,  321,  321,  321,  321,  321,    0,    0,  321, 
            0,    0,    0,    0,    0,  321,  321,    0,  321,  321, 
          321,  321,    0,  321,  321,  321,  321,  321,  321,    0, 
          321,  321,  321,  321,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  546,    0,    0,    0,    0, 
            0,    0,    0,  321,    0,    0,  321,    0,    0,  321, 
          321,    0,  321,    0,  321,    0,    0,    0,  321,    0, 
            0,    0,    0,    0,    0,    0,  321,    0,    0,    0, 
            0,  321,  321,  321,  321,  321,  321,    0,    0,    0, 
          321,    0,  321,  321,    0,  321,  321,    0,    0,    0, 
            0,    0,    0,    0,    0,  546,  546,  546,  546,  546, 
          546,    0,    0,  546,  546,  546,    0,    0,    0,  546, 
          232,  546,  546,  546,  546,  546,  546,  546,    0,    0, 
            0,    0,  546,  546,  546,  546,  546,  546,  546,    0, 
            0,  546,    0,    0,    0,    0,    0,  546,  546,    0, 
          546,  546,  546,  546,    0,  546,  546,  546,  546,  546, 
          546,    0,  546,  546,  546,  546,    0,    0,    0,  231, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  546,    0,    0,  546,    0, 
            0,  546,  546,    0,  546,    0,  546,    0,    0,    0, 
          546,    0,    0,    0,    0,    0,    0,    0,  546,    0, 
            0,    0,    0,  546,  546,  546,  546,  546,  546,    0, 
            0,    0,  546,    0,  546,  546,    0,  546,  546,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  546,  546,  546,  546,  546,  546,    0,    0, 
            0,  546,  546,    0,    0,    0,  546,    0,  546,  546, 
          546,  546,  546,  546,  546,    0,    0,  190,    0,  546, 
          546,  546,  546,  546,  546,  546,    0,  190,  546,    0, 
            0,    0,    0,    0,  546,  546,    0,  546,  546,  546, 
          546,    0,  546,  546,  546,  546,  546,  546,    0,  546, 
          546,  546,  546,    0,    0,    0,    0,    0,    0,    0, 
            0,  235,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  546,    0,    0,  546,  190,    0,  546,  546, 
            0,  546,    0,  546,    0,    0,    0,  546,    0,    0, 
            0,    0,    0,    0,    0,  546,    0,  390,  546,    0, 
          546,  546,  546,  546,  546,  546,    0,  390,    0,  546, 
            0,  546,  546,    0,  546,  546,    0,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,   15,   16,   17,   18,    0, 
            0,   87,    0,   19,   20,   21,   22,   23,   24,   25, 
            0,    0,   26,    0,    0,    0,  390,    0,   95,   28, 
          390,    0,   31,   32,   33,    0,   34,   35,   36,   37, 
           38,   39,    0,   40,   41,   42,   43,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  390,    0, 
            0,    0,    0,    0,    0,    0,  222,    0,  316,  112, 
            0,    0,   46,   47,    0,   48,    0,    0,  316,    0, 
            0,   50,    0,    0,    0,    0,    0,    0,    0,   51, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
            0,    0,  316,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  316,    0,    0, 
            0,  316,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  190, 
          190,  190,    0,    0,    0,  190,  190,    0,  190,  316, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  317,    0,    0,  190,  190,    0, 
          190,  190,  190,  190,  317,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  317,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  190,  390, 
          390,  390,    0,  317,    0,  390,  390,  317,  390,    0, 
            0,    0,    0,    0,    0,    0,    0,  390,    0,  190, 
            0,    0,    0,    0,    0,    0,    0,  390,  390,    0, 
          390,  390,  390,  390,  390,  317,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  390,  390,  390,  390,  390,  390, 
          390,  390,  390,  390,  390,  390,  390,  390,    0,    0, 
          390,  390,  390,    0,    0,    0,    0,    0,  390,    0, 
            0,    0,    0,    0,    0,  390,  280,  390,    0,  390, 
          390,  390,  390,  390,  390,  390,  280,  390,  390,  390, 
          316,  316,  316,    0,    0,  316,  316,  316,    0,  316, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  316, 
            0,    0,    0,    0,    0,    0,    0,    0,  316,  316, 
          280,  316,  316,  316,  316,  316,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  280,    0,    0,    0,  280, 
            0,    0,    0,    0,    0,  316,  316,  316,  316,  316, 
          316,  316,  316,  316,  316,  316,  316,  316,  316,    0, 
            0,  316,  316,  316,    0,    0,    0,  280,    0,  316, 
            0,    0,    0,    0,    0,    0,  316,    0,  316,  462, 
          316,  316,  316,  316,  316,  316,  316,    0,  316,  462, 
          316,    0,    0,    0,    0,    0,  317,  317,  317,    0, 
            0,  317,  317,  317,    0,  317,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  317,    0,    0,    0,    0, 
            0,    0,    0,   86,  317,  317,    0,  317,  317,  317, 
          317,  317,    0,    0,    0,    0,    0,    0,  462,    0, 
           94,    0,  462,    0,    0,    0,    0,    0,    0,    0, 
            0,  317,  317,  317,  317,  317,  317,  317,  317,  317, 
          317,  317,  317,  317,  317,    0,    0,  317,  317,  317, 
          462,    0,    0,    0,    0,  317,    0,    0,    0,    0, 
            0,    0,  317,    0,  317,    0,  317,  317,  317,  317, 
          317,  317,  317,  270,  317,    0,  317,    0,    0,    0, 
            0,    0,    0,  270,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   93,  280,  280, 
          280,    0,    0,  280,  280,  280,    0,  280,    0,    0, 
            0,    0,  270,    0,  101,    0,  270,  280,    0,    0, 
            0,    0,    0,    0,    0,    0,  280,  280,    0,  280, 
          280,  280,  280,  280,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  270,    0,    0,    0,    0,    0, 
            0,    0,    0,  280,  280,  280,  280,  280,  280,  280, 
          280,  280,  280,  280,  280,  280,  280,    0,    0,  280, 
          280,  280,    0,    0,    0,    0,    0,  280,    0,    0, 
            0,    0,    0,    0,  280,    0,  280,  277,  280,  280, 
          280,  280,  280,  280,  280,    0,  280,  277,  280,    0, 
            0,  462,  462,  462,    0,    0,    0,  462,  462,    0, 
          462,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  462, 
          462,   92,  462,  462,  462,  462,  462,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  277,    0,  100,    0, 
          277,    0,    0,    0,    0,    0,  462,  462,  462,  462, 
          462,  462,  462,  462,  462,  462,  462,  462,  462,  462, 
            0,    0,  462,  462,  462,    0,  463,    0,  277,    0, 
          462,    0,    0,    0,    0,    0,    0,  462,    0,  462, 
            0,  462,  462,  462,  462,  462,  462,  462,  256,  462, 
            0,  462,    0,    0,    0,    0,    0,    0,  256,    0, 
            0,    0,    0,    0,    0,  270,  270,  270,    0,    0, 
            0,  270,  270,    0,  270,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  258,  256,  270,  270,    0,  270,  270,  270,  270, 
          270,  258,    0,    0,    0,    0,    0,  256,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          270,  270,  270,  270,  270,  270,  270,  270,  270,  270, 
          270,  270,  270,  270,    0,  258,  270,  270,  270,    0, 
            0,    0,    0,    0,  270,    0,    0,    0,    0,    0, 
          258,  270,  254,  270,    0,  270,  270,  270,  270,  270, 
          270,  270,  254,  270,    0,  270,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   60,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   60,  277, 
          277,  277,    0,    0,    0,  277,  277,    0,  277,    0, 
            0,  254,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  277,  277,    0, 
          277,  277,  277,  277,  277,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   60,    0,    0, 
            0,    0,    0,    0,  277,  277,  277,  277,  277,  277, 
          277,  277,  277,  277,  277,  277,  277,  277,    0,    0, 
          277,  277,  277,   62,    0,    0,    0,    0,  277,    0, 
            0,    0,    0,   62,    0,  277,    0,  277,    0,  277, 
          277,  277,  277,  277,  277,  277,    0,  277,    0,  277, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          256,  256,  256,    0,    0,  256,  256,  256,    0,  256, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  256, 
          256,    0,   62,    0,    0,    0,    0,   53,  256,  256, 
            0,  256,  256,  256,  256,  256,    0,   53,    0,    0, 
            0,    0,    0,  258,  258,  258,    0,    0,  258,  258, 
          258,    0,  258,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  258,  258,    0,    0,    0,    0,    0,    0, 
            0,  258,  258,    0,  258,  258,  258,  258,  258,  256, 
            0,    0,  256,    0,  256,    0,   53,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          256,    0,    0,    0,  254,  254,  254,    0,    0,  254, 
          254,  254,    0,  254,  578,    0,    0,    0,    0,    0, 
            0,    0,  258,  254,  254,  258,    0,  258,    0,    0, 
            0,    0,  254,  254,    0,  254,  254,  254,  254,  254, 
           60,   60,   60,  258,    0,   60,   60,   60,    0,   60, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   60, 
           60,    0,    0,    0,    0,    0,    0,    0,   60,   60, 
            0,   60,   60,   60,   60,   60,    0,    0,    0,    0, 
            0,    0,    0,  254,    0,    0,  254,    0,  254,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  254,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   60, 
            0,    0,   60,    0,    0,   62,   62,   62,    0,    0, 
           62,   62,   62,    0,   62,    0,    0,    0,    0,    0, 
           60,    0,    0,    0,   62,   62,    0,    0,    0,    0, 
            0,    0,  415,   62,   62,    0,   62,   62,   62,   62, 
           62,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   53, 
           53,   53,    0,    0,   53,   53,   53,    0,   53,    0, 
            0,    0,    0,    0,   62,    0,    0,   62,   53,    0, 
            0,    0,    0,    0,    0,    0,    0,   53,   53,    0, 
           53,   53,   53,   53,   53,   62,    0,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,  100,  101,   17,   18,    0, 
            0,    0,    0,  102,  103,  104,   22,   23,   24,   25, 
            0,    0,  105,    0,    0,    0,    0,    0,   53,  106, 
            0,    0,   31,   32,   33,  415,   34,   35,   36,   37, 
           38,   39,    0,   40,    0,    0,  109,    0,    0,   53, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  293,    0,    0,  112, 
            0,    0,   46,   47,    0,   48,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0, 
      };
   }

   private static final short[] yyTable4() {
      return new short[] {

            0,    0,    0,    0,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,    4,    5,    6,    7,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   15,   16,   17,   18,    0,    0,    0,    0, 
           19,   20,   21,   22,   23,   24,   25,    0,    0,   26, 
            0,    0,    0,    0,    0,   27,   28,   29,   30,   31, 
           32,   33,    0,   34,   35,   36,   37,   38,   39,    0, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   44,    0,    0,   45,    0,    0,   46, 
           47,    0,   48,    0,   49,    0,    0,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,   51,    0,    0,    0, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,    4,    5,    6, 
            7,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,   15,   16,   17,   18,    0, 
            0,    0,    0,   19,   20,   21,   22,   23,   24,   25, 
            0,    0,   26,    0,    0,    0,    0,    0,   27,   28, 
            0,   30,   31,   32,   33,    0,   34,   35,   36,   37, 
           38,   39,    0,   40,   41,   42,   43,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   44,    0,    0,   45, 
            0,    0,   46,   47,    0,   48,    0,   49,    0,    0, 
            0,   50,    0,    0,    0,    0,    0,    0,    0,   51, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
            3,    4,    5,    6,    7,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   15, 
           16,   17,   18,    0,    0,    0,    0,   19,   20,   21, 
           22,   23,   24,   25,    0,    0,   26,    0,    0,    0, 
            0,    0,   27,   28,   29,   30,   31,   32,   33,    0, 
           34,   35,   36,   37,   38,   39,    0,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           44,    0,    0,   45,    0,    0,   46,   47,    0,   48, 
            0,   49,    0,    0,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,   51,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,  216,    4,    5,    6,    7,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,   15,   16,   17,   18,    0,    0,    0, 
            0,   19,   20,   21,   22,   23,   24,   25,    0,    0, 
           26,    0,    0,    0,    0,    0,   27,   28,    0,   30, 
           31,   32,   33,    0,   34,   35,   36,   37,   38,   39, 
            0,   40,   41,   42,   43,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   44,    0,    0,   45,    0,    0, 
           46,   47,    0,   48,    0,   49,    0,    0,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,   51,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,  216,    4, 
            5,    6,    7,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,   15,   16,   17, 
           18,    0,    0,    0,    0,   19,   20,   21,   22,   23, 
           24,   25,    0,    0,   26,    0,    0,    0,    0,    0, 
           27,   28,    0,   30,   31,   32,   33,    0,   34,   35, 
           36,   37,   38,   39,    0,   40,   41,   42,   43,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   44,    0, 
            0,  280,    0,    0,   46,   47,    0,   48,    0,   49, 
            0,    0,    0,   50,    0,    0,    0,    0,    0,    0, 
            0,   51,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,    4,    5,    6,    7,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
           15,   16,   17,   18,    0,    0,    0,    0,   19,   20, 
           21,   22,   23,   24,   25,    0,    0,   26,    0,    0, 
            0,    0,    0,   27,   28,   29,   30,   31,   32,   33, 
            0,   34,   35,   36,   37,   38,   39,    0,   40,   41, 
           42,   43,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   44,    0,    0,   45,    0,    0,   46,   47,    0, 
           48,    0,   49,    0,    0,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,   51,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,    4,    5,    6,    7,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,   15,   16,   17,   18,    0,    0,    0, 
            0,   19,   20,   21,   22,   23,   24,   25,    0,    0, 
           26,    0,    0,    0,    0,    0,   27,   28,    0,   30, 
           31,   32,   33,    0,   34,   35,   36,   37,   38,   39, 
            0,   40,   41,   42,   43,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   44,    0,    0,   45,    0,    0, 
           46,   47,    0,   48,    0,   49,    0,    0,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,   51,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,  100,  101,   17,   18, 
            0,    0,    0,    0,  102,   20,   21,   22,   23,   24, 
           25,    0,    0,  105,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,   31,   32,   33,    0,   34,   35,   36, 
           37,   38,   39,  246,   40,   41,   42,   43,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  222,    0,    0, 
          112,    0,    0,   46,   47,    0,   48,    0,  247,    0, 
          248,    0,   50,    0,    0,    0,    0,    0,    0,    0, 
          249,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,  100, 
          101,   17,   18,    0,    0,    0,    0,  102,  103,  104, 
           22,   23,   24,   25,    0,    0,  105,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,   31,   32,   33,    0, 
           34,   35,   36,   37,   38,   39,  246,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          222,    0,    0,  112,    0,    0,   46,   47,    0,   48, 
            0,  635,    0,  248,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,  249,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,  250,  250,  250,    0,  250,    0, 
            0,    0,  250,  250,    0,    0,    0,  250,    0,  250, 
          250,  250,  250,  250,  250,  250,    0,    0,    0,    0, 
          250,  250,  250,  250,  250,  250,  250,    0,    0,  250, 
            0,    0,    0,    0,    0,    0,  250,    0,    0,  250, 
          250,  250,    0,  250,  250,  250,  250,  250,  250,  250, 
          250,  250,  250,  250,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  250,    0,    0,  250,    0,    0,  250, 
          250,    0,  250,    0,  250,    0,  250,    0,  250,    0, 
            0,    0,    0,    0,    0,    0,  250,    0,    0,    0, 
            0,  250,  250,  250,  250,  250,  250,    0,    0,    0, 
          250,    0,  250,  250,    0,  250,  250,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,  100,  101,   17,   18,    0, 
            0,    0,    0,  102,  103,  104,   22,   23,   24,   25, 
            0,    0,  105,    0,    0,    0,    0,    0,    0,   28, 
            0,    0,   31,   32,   33,    0,   34,   35,   36,   37, 
           38,   39,  246,   40,   41,   42,   43,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  222,    0,    0,  112, 
            0,    0,   46,   47,    0,   48,    0,  247,    0,    0, 
            0,   50,    0,    0,    0,    0,    0,    0,    0,  249, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,  100,  101, 
           17,   18,    0,    0,    0,    0,  102,  103,  104,   22, 
           23,   24,   25,    0,    0,  105,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,   31,   32,   33,    0,   34, 
           35,   36,   37,   38,   39,  246,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  222, 
            0,    0,  112,    0,    0,   46,   47,    0,   48,    0, 
            0,    0,  248,    0,   50,    0,    0,    0,    0,    0, 
            0,    0,  249,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,  100,  101,   17,   18,    0,    0,    0,    0,  102, 
          103,  104,   22,   23,   24,   25,    0,    0,  105,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,   31,   32, 
           33,    0,   34,   35,   36,   37,   38,   39,  246,   40, 
           41,   42,   43,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  222,    0,    0,  112,    0,    0,   46,   47, 
            0,   48,    0,  635,    0,    0,    0,   50,    0,    0, 
            0,    0,    0,    0,    0,  249,    0,    0,    0,    0, 
           52,   53,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,  100,  101,   17,   18,    0,    0, 
            0,    0,  102,  103,  104,   22,   23,   24,   25,    0, 
            0,  105,    0,    0,    0,    0,    0,    0,   28,    0, 
            0,   31,   32,   33,    0,   34,   35,   36,   37,   38, 
           39,  246,   40,   41,   42,   43,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  222,    0,    0,  112,    0, 
            0,   46,   47,    0,   48,    0,    0,    0,    0,    0, 
           50,    0,    0,    0,    0,    0,    0,    0,  249,    0, 
            0,    0,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,    4, 
            5,    6,    0,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,  100,  101,   17, 
           18,    0,    0,    0,    0,  102,  103,  104,   22,   23, 
           24,   25,    0,    0,  105,    0,    0,    0,    0,    0, 
            0,   28,    0,    0,   31,   32,   33,    0,   34,   35, 
           36,   37,   38,   39,    0,   40,   41,   42,   43,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  222,    0, 
            0,  112,  446,    0,   46,   47,    0,   48,    0,    0, 
            0,    0,    0,   50,    0,    0,    0,    0,    0,    0, 
            0,  249,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
           15,   16,   17,   18,    0,    0,    0,    0,   19,   20, 
           21,   22,   23,   24,   25,    0,    0,  105,    0,    0, 
            0,    0,    0,    0,   28,    0,    0,   31,   32,   33, 
            0,   34,   35,   36,   37,   38,   39,    0,   40,   41, 
           42,   43,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  222,    0,    0,  112,    0,    0,   46,   47,    0, 
           48,    0,  571,    0,    0,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,  249,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,  100,  101,   17,   18,    0,    0,    0, 
            0,  102,  103,  104,   22,   23,   24,   25,    0,    0, 
          105,    0,    0,    0,    0,    0,    0,   28,    0,    0, 
           31,   32,   33,    0,   34,   35,   36,   37,   38,   39, 
            0,   40,   41,   42,   43,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  222,    0,    0,  112,    0,    0, 
           46,   47,    0,   48,    0,  571,    0,    0,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,  249,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,  100,  101,   17,   18, 
            0,    0,    0,    0,  102,  103,  104,   22,   23,   24, 
           25,    0,    0,  105,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,   31,   32,   33,    0,   34,   35,   36, 
           37,   38,   39,    0,   40,   41,   42,   43,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  222,    0,    0, 
          112,    0,    0,   46,   47,    0,   48,    0,  247,    0, 
            0,    0,   50,    0,    0,    0,    0,    0,    0,    0, 
          249,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,  100, 
          101,   17,   18,    0,    0,    0,    0,  102,  103,  104, 
           22,   23,   24,   25,    0,    0,  105,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,   31,   32,   33,    0, 
           34,   35,   36,   37,   38,   39,    0,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          222,    0,    0,  112,    0,    0,   46,   47,    0,   48, 
            0,  813,    0,    0,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,  249,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,  100,  101,   17,   18,    0,    0,    0,    0, 
          102,  103,  104,   22,   23,   24,   25,    0,    0,  105, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,   31, 
           32,   33,    0,   34,   35,   36,   37,   38,   39,    0, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  222,    0,    0,  112,    0,    0,   46, 
           47,    0,   48,    0,  635,    0,    0,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,  249,    0,    0,    0, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,  535,  535,  535, 
            0,  535,    0,    0,    0,  535,  535,    0,    0,    0, 
          535,    0,  535,  535,  535,  535,  535,  535,  535,    0, 
            0,    0,    0,  535,  535,  535,  535,  535,  535,  535, 
            0,    0,  535,    0,    0,    0,    0,    0,    0,  535, 
            0,    0,  535,  535,  535,    0,  535,  535,  535,  535, 
          535,  535,    0,  535,  535,  535,  535,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  535,    0,    0,  535, 
          535,    0,  535,  535,    0,  535,    0,    0,    0,    0, 
            0,  535,    0,    0,    0,    0,    0,    0,    0,  535, 
            0,    0,    0,    0,  535,  535,  535,  535,  535,  535, 
            0,    0,    0,  535,    0,  535,  535,    0,  535,  535, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   15,   16, 
           17,   18,    0,    0,    0,    0,   19,   20,   21,   22, 
           23,   24,   25,    0,    0,   26,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,   31,   32,   33,    0,   34, 
           35,   36,   37,   38,   39,    0,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  222, 
            0,    0,  112,    0,    0,   46,   47,    0,   48,    0, 
            0,    0,    0,    0,   50,    0,    0,    0,    0,    0, 
            0,    0,   51,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,  100,  101,   17,   18,    0,    0,    0,    0,  102, 
          103,  104,   22,   23,   24,   25,    0,    0,  105,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,   31,   32, 
           33,    0,   34,   35,   36,   37,   38,   39,    0,   40, 
           41,   42,   43,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  222,    0,    0,  112,    0,    0,   46,   47, 
            0,   48,    0,    0,    0,    0,    0,   50,    0,    0, 
            0,    0,    0,    0,    0,  249,    0,    0,    0,    0, 
           52,   53,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,   15,   16,   17,   18,    0,    0, 
            0,    0,   19,   20,   21,   22,   23,   24,   25,    0, 
            0,  105,    0,    0,    0,    0,    0,    0,   28,    0, 
            0,   31,   32,   33,    0,   34,   35,   36,   37,   38, 
           39,    0,   40,   41,   42,   43,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  222,    0,    0,  112,    0, 
            0,   46,   47,    0,   48,    0,    0,    0,    0,    0, 
           50,    0,    0,    0,    0,    0,    0,    0,  249,    0, 
            0,    0,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,  535, 
          535,  535,    0,  535,    0,    0,    0,  535,  535,    0, 
            0,    0,  535,    0,  535,  535,  535,  535,  535,  535, 
          535,    0,    0,    0,    0,  535,  535,  535,  535,  535, 
          535,  535,    0,    0,  535,    0,    0,    0,    0,    0, 
            0,  535,    0,    0,  535,  535,  535,    0,  535,  535, 
          535,  535,  535,  535,    0,  535,  535,  535,  535,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  535,    0, 
            0,  535,    0,    0,  535,  535,    0,  535,    0,    0, 
            0,    0,    0,  535,    0,    0,    0,    0,    0,    0, 
            0,  535,    0,    0,    0,    0,  535,  535,  535,  535, 
          535,  535,    0,    0,    0,  535,    0,  535,  535,    0, 
          535,  535,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
          100,  101,   17,   18,    0,    0,    0,    0,  102,  103, 
          104,   22,   23,   24,   25,    0,    0,  105,    0,    0, 
            0,    0,    0,    0,  106,    0,    0,   31,   32,   33, 
            0,   34,   35,   36,   37,   38,   39,    0,   40,    0, 
            0,  109,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  239,    0,    0,   45,    0,    0,   46,   47,    0, 
           48,    0,   49,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,  100,  101,   17,   18,    0,    0,    0, 
            0,  102,  103,  104,   22,   23,   24,   25,    0,    0, 
          105,    0,    0,    0,    0,    0,    0,  106,    0,    0, 
           31,   32,   33,    0,   34,   35,   36,   37,   38,   39, 
            0,   40,    0,    0,  109,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  293,    0,    0,  367,    0,    0, 
           46,   47,    0,   48,    0,  368,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,  100,  101,   17,   18, 
            0,    0,    0,    0,  102,  103,  104,   22,   23,   24, 
           25,    0,    0,  105,    0,    0,    0,    0,    0,    0, 
          106,    0,    0,   31,   32,   33,    0,  107,   35,   36, 
           37,  108,   39,    0,   40,    0,    0,  109,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  111,    0,    0, 
          112,    0,    0,   46,   47,    0,   48,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,  100, 
          101,   17,   18,    0,    0,    0,    0,  102,  103,  104, 
           22,   23,   24,   25,    0,    0,  105,    0,    0,    0, 
            0,    0,    0,  106,    0,    0,   31,   32,   33,    0, 
           34,   35,   36,   37,   38,   39,    0,   40,    0,    0, 
          109,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          293,    0,    0,  367,    0,    0,   46,   47,    0,   48, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,  100,  101,   17,   18,    0,    0,    0,    0, 
          102,  103,  104,   22,   23,   24,   25,    0,    0,  105, 
            0,    0,    0,    0,    0,    0,  106,    0,    0,   31, 
           32,   33,    0,   34,   35,   36,   37,   38,   39,    0, 
           40,    0,    0,  109,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  823,    0,    0,  112,    0,    0,   46, 
           47,    0,   48,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,  100,  101,   17,   18,    0, 
            0,    0,    0,  102,  103,  104,   22,   23,   24,   25, 
            0,    0,  105,    0,    0,    0,    0,    0,    0,  106, 
            0,    0,   31,   32,   33,    0,   34,   35,   36,   37, 
           38,   39,    0,   40,    0,    0,  109,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  898,    0,    0,  112, 
            0,    0,   46,   47,    0,   48,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
          121,  122,  123,  124,  125,  126,  127,  128,    0,    0, 
          129,  130,  131,  132,  133,    0,    0,  134,  135,  136, 
          137,  138,  139,  140,    0,    0,  141,  142,  143,  201, 
          202,  203,  204,  148,  149,  150,  151,  152,  153,  154, 
          155,  156,  157,  158,  159,  205,  206,  207,    0,  208, 
          164,  269,    0,  209,    0,    0,    0,  166,  167,    0, 
          168,  169,  170,  171,  172,  173,  174,    0,    0,  175, 
          176,    0,    0,    0,  177,  178,  179,  180,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          182,  183,    0,  184,  185,  186,  187,  188,  189,  190, 
          191,  192,  193,  194,    0,    0,  195,   52,  121,  122, 
          123,  124,  125,  126,  127,  128,    0,    0,  129,  130, 
          131,  132,  133,    0,    0,  134,  135,  136,  137,  138, 
          139,  140,    0,    0,  141,  142,  143,  201,  202,  203, 
          204,  148,  149,  150,  151,  152,  153,  154,  155,  156, 
          157,  158,  159,  205,  206,  207,    0,  208,  164,    0, 
            0,  209,    0,    0,    0,  166,  167,    0,  168,  169, 
          170,  171,  172,  173,  174,    0,    0,  175,  176,    0, 
            0,    0,  177,  178,  179,  180,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  182,  183, 
            0,  184,  185,  186,  187,  188,  189,  190,  191,  192, 
          193,  194,    0,    0,  195,   52,  121,  122,  123,  124, 
          125,  126,  127,  128,    0,    0,  129,  130,  131,  132, 
          133,    0,    0,  134,  135,  136,  137,  138,  139,  140, 
            0,    0,  141,  142,  143,  144,  145,  146,  147,  148, 
          149,  150,  151,  152,  153,  154,  155,  156,  157,  158, 
          159,  160,  161,  162,    0,  163,  164,   36,   37,  165, 
           39,    0,    0,  166,  167,    0,  168,  169,  170,  171, 
          172,  173,  174,    0,    0,  175,  176,    0,    0,    0, 
          177,  178,  179,  180,    0,    0,    0,    0,    0,  181, 
            0,    0,    0,    0,    0,    0,  182,  183,    0,  184, 
          185,  186,  187,  188,  189,  190,  191,  192,  193,  194, 
            0,    0,  195,  121,  122,  123,  124,  125,  126,  127, 
          128,    0,    0,  129,  130,  131,  132,  133,    0,    0, 
          134,  135,  136,  137,  138,  139,  140,    0,    0,  141, 
          142,  143,  201,  202,  203,  204,  148,  149,  150,  151, 
          152,  153,  154,  155,  156,  157,  158,  159,  205,  206, 
          207,    0,  208,  164,  302,  303,  209,  304,    0,    0, 
          166,  167,    0,  168,  169,  170,  171,  172,  173,  174, 
            0,    0,  175,  176,    0,    0,    0,  177,  178,  179, 
          180,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  182,  183,    0,  184,  185,  186,  187, 
          188,  189,  190,  191,  192,  193,  194,    0,    0,  195, 
          121,  122,  123,  124,  125,  126,  127,  128,    0,    0, 
          129,  130,  131,  132,  133,    0,    0,  134,  135,  136, 
          137,  138,  139,  140,    0,    0,  141,  142,  143,  201, 
          202,  203,  204,  148,  149,  150,  151,  152,  153,  154, 
          155,  156,  157,  158,  159,  205,  206,  207,    0,  208, 
          164,    0,    0,  209,    0,    0,    0,  166,  167,    0, 
          168,  169,  170,  171,  172,  173,  174,    0,    0,  175, 
          176,    0,    0,    0,  177,  178,  179,  180,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          182,  183,    0,  184,  185,  186,  187,  188,  189,  190, 
          191,  192,  193,  194,  628,  552,  195,    0,  629,    0, 
            0,    0,  166,  167,    0,  168,  169,  170,  171,  172, 
          173,  174,    0,    0,  175,  176,    0,    0,    0,  177, 
          178,  179,  180,    0,    0,    0,    0,    0,  263,    0, 
            0,    0,    0,    0,    0,  182,  183,    0,  184,  185, 
          186,  187,  188,  189,  190,  191,  192,  193,  194,  630, 
          558,  195,    0,  631,    0,    0,    0,  166,  167,    0, 
          168,  169,  170,  171,  172,  173,  174,    0,    0,  175, 
          176,    0,    0,    0,  177,  178,  179,  180,    0,    0, 
            0,    0,    0,  263,    0,    0,    0,    0,    0,    0, 
          182,  183,    0,  184,  185,  186,  187,  188,  189,  190, 
          191,  192,  193,  194,  655,  552,  195,    0,  656,    0, 
            0,    0,  166,  167,    0,  168,  169,  170,  171,  172, 
          173,  174,    0,    0,  175,  176,    0,    0,    0,  177, 
          178,  179,  180,    0,    0,    0,    0,    0,  263,    0, 
            0,    0,    0,    0,    0,  182,  183,    0,  184,  185, 
          186,  187,  188,  189,  190,  191,  192,  193,  194,  657, 
          558,  195,    0,  658,    0,    0,    0,  166,  167,    0, 
          168,  169,  170,  171,  172,  173,  174,    0,    0,  175, 
          176,    0,    0,    0,  177,  178,  179,  180,    0,    0, 
            0,    0,    0,  263,    0,    0,    0,    0,    0,    0, 
          182,  183,    0,  184,  185,  186,  187,  188,  189,  190, 
          191,  192,  193,  194,  910,  552,  195,    0,  911,    0, 
            0,    0,  166,  167,    0,  168,  169,  170,  171,  172, 
          173,  174,    0,    0,  175,  176,    0,    0,    0,  177, 
          178,  179,  180,    0,    0,    0,    0,    0,  263,    0, 
            0,    0,    0,    0,    0,  182,  183,    0,  184,  185, 
          186,  187,  188,  189,  190,  191,  192,  193,  194,  912, 
          558,  195,    0,  913,    0,    0,    0,  166,  167,    0, 
          168,  169,  170,  171,  172,  173,  174,    0,    0,  175, 
          176,    0,    0,    0,  177,  178,  179,  180,    0,    0, 
            0,    0,    0,  263,    0,    0,    0,    0,    0,    0, 
          182,  183,    0,  184,  185,  186,  187,  188,  189,  190, 
          191,  192,  193,  194,  941,  558,  195,    0,  942,    0, 
            0,    0,  166,  167,    0,  168,  169,  170,  171,  172, 
          173,  174,    0,    0,  175,  176,    0,    0,    0,  177, 
          178,  179,  180,    0,    0,    0,    0,    0,  263,    0, 
            0,    0,    0,    0,    0,  182,  183,    0,  184,  185, 
          186,  187,  188,  189,  190,  191,  192,  193,  194,  565, 
          552,  195,    0,  566,    0,    0,    0,  166,  167,    0, 
          168,  169,  170,  171,  172,  173,  174,    0,    0,  175, 
          176,    0,    0,    0,  177,  178,  179,  180,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          182,  183,    0,  184,  185,  186,  187,  188,  189,  190, 
          191,  192,  193,  194,    0,    0,  195, 
      };
   }

   private static final short[] yyCheck1() {
      return new short[] {

            6,    7,   26,    2,   28,  388,   51,  412,  417,  230, 
           15,   16,   48,   27,   19,  397,    6,    0,  316,    7, 
           21,   27,    7,  255,   47,   48,    3,    0,   10,  361, 
           10,    9,   10,   11,   10,   10,   32,   10,   49,   27, 
           92,  288,   27,   59,  291,    0,   52,  111,   47,   48, 
          316,    4,    5,   97,   45,  387,   59,  361,   10,   10, 
           97,   14,   52,  771,   65,   10,   10,   10,   46,   44, 
           10,   11,  679,    2,    3,  407,  359,  360,   10,  362, 
          363,  674,  106,  687,   59,   61,   59,   10,   10,  421, 
          514,  308,  390,   10,   10,  312,   49,  690,   10,  473, 
           21,   44,  385,  280,   10,   10,  340,   59,   59,   47, 
          280,  305,   10,   10,  685,   59,   59,   10,  864,   10, 
           10,   44,  405,  406,   59,   10,  550,   59,   10,  340, 
           10,  344,  110,   10,  280,   10,  419,   59,   61,   92, 
          472,  328,   59,   59,   65,  305,  328,   10,  335,  362, 
          269,   44,  271,  335,   59,   61,   10,   10,   10,  325, 
           10,   10,   59,   61,   44,   10,   59,  450,   59,   10, 
           10,   10,   10,   10,   59,  219,    0,  596,   10,   59, 
          374,  889,  219,  104,  930,   44,   10,  470,  769,  233, 
          367,  361,  358,  114,  340,   11,   59,  790,  496,  618, 
           59,   10,   44,   10,  578,   10,  310,  590,   61,  308, 
          246,  247,  248,  632,  374,  361,   10,   59,  601,    2, 
            3,    4,    5,   61,   61,    8,    9,   10,   11,   61, 
          496,   14,   15,   16,  430,   59,   19,   44,  620,   44, 
          659,  848,  294,  317,   10,  263,  264,   44,   10,  853, 
           44,  269,   61,   32,   61,  260,   61,  262,  263,  237, 
          238,  842,   45,   46,  263,   10,   49,  463,   51,  486, 
          370,  695,   10,   44,  348,  846,  375,  376,  352,  353, 
           10,   97,   32,   10,   91,   10,   91,  216,  266,  280, 
          268,  862,  267,  365,   91,   61,  396,  237,  238,   61, 
          116,  599,  305,  279,   10,  427,   44,  337,  430,   92, 
          891,  262,  263,  264,   59,  378,  379,  701,  269,  364, 
           91,  366,  386,  707,  267,  370,  371,  110,  282,  112, 
          366,   44,   59,  599,  370,  267,   61,  281,  919,  306, 
          256,  294,  358,  310,  753,  719,  324,  325,  326,  327, 
          267,  329,  330,   59,  360,   44,  361,  368,   61,  341, 
          396,   61,  361,  338,  344,  341,    2,    3,    4,    5, 
            6,  374,    8,  279,  370,  371,  367,  413,   14,  362, 
          386,  377,  387,  305,  324,  325,  326,  327,  387,  362, 
          426,  427,  690,  305,  430,  340,  373,  396,  397,  328, 
          406,  622,  407,  219,  427,  637,  653,  362,  407,   45, 
          362,  389,  305,   49,  420,  368,  421,  233,  341,  341, 
           91,  473,  421,  358,  460,  305,  279,  463,  366,  341, 
          835,  445,  370,  216,  817,  341,  341,  460,  359,  445, 
          356,  279,  279,  341,  373,  451,  358,  279,  341,  448, 
          341,  341,  374,  835,  237,  238,   92,  445,  396,  341, 
          445,  341,  374,   44,  385,  471,  341,  472,  446,  495, 
          279,  400,  279,  472,  279,  413,  112,  260,  358,  262, 
          263,  374,  279,  266,  405,  268,  337,  341,  341,  341, 
          273,  341,  341,  876,  374,  914,  341,  280,  419,  358, 
          341,  341,  341,  341,  341,  290,  291,  506,  279,  341, 
           91,  294,  733,  279,  513,  514,  358,  279,  340,  448, 
          473,  328,  267,  328,  822,  549,  578,  262,  335,  450, 
          335,  328,  341,  340,  341,  571,  341,  264,  335,   91, 
          564,  324,  325,  326,  327,  328,  329,  330,  880,  470, 
           91,  550,  264,  554,  279,  554,  310,  328,  264,  560, 
          290,  291,  268,  269,  335,  381,  567,  568,  567,  568, 
          337,   91,  596,   10,   45,  341,    2,    3,  361,  341, 
          216,  364,    8,  366,  367,  368,   91,  370,  371,  603, 
          373,   61,  591,  338,  618,  878,  602,  603,  337,  635, 
          416,  417,  654,   10,  387,  388,  389,  606,  632,  830, 
          609,  589,  602,  612,   91,  603,  341,  400,  603,   45, 
          403,  620,   59,  271,  407,  578,  372,   59,  411,  372, 
          666,  377,   91,  554,  377,  659,  310,  273,  421,  560, 
           91,  112,  668,  669,  280,   44,  567,  568,  279,  589, 
          378,  379,   59,  698,  699,  633,  338,  328,  294,  704, 
           44,   10,   61,  446,  335,  448,   44,  719,   10,   10, 
          591,   44,   10,  594,  361,  674,  370,  371,  372,   10, 
          716,  308,  309,  377,  311,  317,  112,  263,  264,  472, 
          473,  690,  328,  633,  266,  317,  695,  317,  279,  280, 
          306,  654,  308,  309,  310,  311,  341,   91,  268,  269, 
           59,  283,  748,   44,   54,   55,  337,   59,   59,  344, 
          317,   59,  362,   10,   15,   16,  310,   44,   19,   10, 
           61,  367,  368,  339,  567,  568,  346,  373,    2,    3, 
            4,    5,   91,  769,    8,  771,  372,  328,  375,  376, 
           14,  348,  388,  372,  335,  352,  353,  354,  355,   10, 
           91,  739,    2,    3,  400,  810,  719,  403,    8,   44, 
          340,  587,   59,  269,   14,  411,  328,  813,   59,  732, 
          361,   45,  267,  335,  600,   49,  264,  328,  341,  362, 
          216,  790,   44,   44,  335,  578,   44,   32,   10,  739, 
           61,   10,  273,  306,   91,   45,  589,  590,  328,  280, 
           61,  306,  448,   44,   59,  335,  842,  843,  601,   44, 
           44,  337,  337,  328,  337,  608,  263,  264,   92,  337, 
          335,   44,   44,   44,  264,   44,  835,  473,  338,  263, 
           91,  264,   44,   91,  337,  337,  337,  273,  112,   61, 
          633,  328,   61,  362,  280,  262,  263,  264,  335,   58, 
          432,  268,  269,  889,  271,  891,  438,  439,  337,  328, 
          344,  654,  112,  879,  264,  880,  335,  328,  661,   91, 
          279,  880,   91,  455,  335,  264,  458,  370,  371,   10, 
          914,  337,  264,  919,  377,  279,  367,  380,  264,  682, 
          683,  362,  328,   44,   44,  858,  722,   44,   44,  692, 
          264,  694,   44,  362,  697,  698,  699,  916,  267,   44, 
          926,  704,  264,  264,  262,  263,  264,  269,  269,  271, 
          268,  269,  403,  271,  341,    0,  719,  753,   59,   44, 
          411,  367,  578,   44,  328,   10,   61,  373,  279,  732, 
           44,  335,  216,  736,  590,  362,  739,  878,   44,   44, 
          358,  264,  388,  264,  310,  601,  749,  750,  751,  260, 
           91,  262,  608,  362,  400,  264,  216,  403,  264,  328, 
          267,  262,  263,  264,   44,  411,  335,  268,  269,  358, 
          271,    0,  362,  280,   59,  264,   44,  328,   44,  310, 
           44,   10,   44,  341,  335,  577,   44,  264,   44,  273, 
          341,  264,   44,   10,  344,  798,  280,  271,  654,  362, 
          340,  271,  448,   59,  362,  661,  598,  810,  279,  280, 
          294,  279,  341,  273,  817,  362,  344,   10,  344,   58, 
          280,  328,  370,  371,  372,  828,  682,  683,  335,  377, 
           59,  344,   67,  340,  264,   91,  692,    5,  694,  358, 
          341,  697,   59,    6,  328,  822,  862,  279,  280,  916, 
          279,  280,  685,  645,  361,  858,   10,  328,   71,   14, 
          328,  362,  881,  719,  335,  668,   59,  335,  328,  340, 
          341,  448,  340,  876,   91,  848,  732,  880,   -1,  882, 
          736,  673,   -1,  367,  368,  888,   -1,   -1,   -1,  373, 
          361,   -1,   -1,  749,  750,  751,  328,   -1,   91,  328, 
           -1,   -1,   -1,  335,  388,   59,  335,  367,  340,  341, 
           -1,  340,  341,  373,   -1,   -1,  400,  608,   -1,  403, 
          685,    0,  687,   -1,   -1,  690,  267,  411,  388,  361, 
           -1,   10,  361,   -1,   -1,  727,   -1,   91,   -1,   -1, 
          400,   -1,  798,  403,  590,  306,   10,  308,  309,  310, 
          311,  411,   -1,   -1,  306,  601,  308,  309,  310,  311, 
           44,  817,  608,   -1,  448,   -1,   -1,   -1,   10,   -1, 
          661,   -1,  828,   -1,   -1,   59,  768,  262,  263,  264, 
           59,  773,  267,  268,  269,   -1,  271,  328,  448,  473, 
           10,  682,  683,   -1,  335,   59,  281,   -1,   -1,  340, 
           -1,  692,  858,  694,   -1,   -1,  697,   91,  293,  294, 
          295,  296,  297,   -1,   -1,  661,   -1,   59,   -1,   -1, 
          876,  370,  371,  372,   44,   -1,  882,   91,  377,   -1, 
           -1,   -1,  888,  262,  263,  264,  682,  683,  267,  268, 
          269,   61,  271,   -1,   -1,  736,  692,   -1,  694,   91, 
          267,  697,  281,  282,   -1,   -1,  341,   -1,  749,  750, 
          751,  290,  291,  280,  293,  294,  295,  296,  297,   -1, 
           -1,   91,  328,   -1,  267,   -1,   -1,  362,  306,  335, 
          308,  309,  310,  311,  340,   -1,   -1,  280,  853,   -1, 
          736,  370,  371,  372,  578,   -1,   -1,  862,  377,  864, 
           59,   -1,  358,  749,  750,  751,  590,  798,   -1,   -1, 
           -1,  328,  341,  267,   -1,  344,   -1,  601,  335,   -1, 
          370,  371,  372,  340,  608,   -1,  280,  377,   15,   16, 
          590,   -1,   19,  362,   -1,  328,   -1,  828,  370,  371, 
          372,  601,  335,   -1,  361,  377,    0,  340,  608,   -1, 
           -1,   -1,  798,   -1,   41,   42,   10,   -1,   -1,   -1, 
           47,   48,   -1,   50,   51,  930,   -1,   -1,  361,   -1, 
          654,  817,   -1,   -1,  328,   -1,   -1,  661,  662,   -1, 
           -1,  335,  828,  262,  263,  264,   -1,   -1,  267,  268, 
          269,  882,  271,   -1,   -1,   -1,  280,  888,  682,  683, 
           -1,  661,  281,  267,   -1,   59,   10,  361,  692,   -1, 
          694,  290,  291,  697,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,  682,  683,   -1,  267,   -1,   -1,   -1,   -1, 
          876,   -1,  692,   -1,  694,  719,  882,  697,   -1,   -1, 
           44,   -1,  888,   -1,  328,   44,   -1,   -1,  732,   -1, 
           -1,  335,  736,   -1,   -1,   -1,  340,   61,   -1,  279, 
            4,    5,  341,   -1,  328,  749,  750,  751,   -1,   -1, 
           14,  335,  732,   -1,  358,   -1,  736,  361,  293,  294, 
          295,  296,  297,  362,    0,   -1,  328,   91,   -1,  749, 
          750,  751,   91,  335,   10,   -1,   -1,   41,   42,   -1, 
           -1,   -1,   -1,   47,   48,   49,   50,   -1,  328,   -1, 
           -1,   -1,   -1,   -1,  798,  335,   -1,   -1,  262,  263, 
          264,  341,   -1,   -1,  268,  269,   -1,  271,   44,   -1, 
           -1,   -1,   -1,  817,   -1,   -1,   -1,  306,  798,  308, 
          309,  310,  311,   59,  828,   -1,   -1,  306,   92,  308, 
          309,  310,  311,   -1,   -1,  508,  509,  817,   -1,  246, 
          247,  248,  249,   -1,   -1,   -1,   -1,   -1,  828,   -1, 
          339,   -1,   -1,  260,  858,  262,  263,   -1,  347,   44, 
          339,   -1,   -1,   44,  271,   -1,   -1,   -1,  347,  348, 
          349,  350,  876,  262,  263,  264,   -1,  341,  882,  268, 
          269,   -1,  271,   -1,  888,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,  876,  271,  362,   -1, 
           -1,   -1,  882,   -1,   -1,   -1,   91,  281,  888,   -1, 
           91,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,  331,  332,  333,  334,  335,  336, 
          337,  338,  339,  340,  341,  342,  343,  344,  345,  346, 
          347,  348,  349,  350,  351,  352,  353,  354,  355,  356, 
           -1,   -1,  341,   -1,  361,  279,  280,  364,   -1,  366, 
          279,  280,   -1,  370,  371,   -1,   -1,  341,   -1,   -1, 
           -1,   -1,  306,  362,  308,  309,  310,  311,   -1,   -1, 
          387,    0,  246,  247,  248,  249,   -1,   10,  362,  396, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          407,  408,  409,  410,  328,  339,  413,  271,   -1,  328, 
           -1,  335,   -1,  347,  421,   -1,  335,  341,   -1,  426, 
          427,  340,   -1,  430,   -1,   44,  262,  263,  264,   -1, 
          294,  267,  268,  269,   -1,  271,   59,  361,   -1,   -1, 
           59,   -1,  361,   -1,   -1,  452,  453,  454,   -1,   -1, 
           -1,   -1,   -1,  460,   -1,   -1,  463,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,  472,   -1,  331,  332,  333, 
          334,  335,  336,  337,  338,  339,  340,  341,  342,  343, 
          344,  345,  346,  347,  348,  349,  350,  351,  352,  353, 
          354,  355,  356,   -1,  279,  280,   -1,   -1,  279,  280, 
           10,  774,  338,   -1,  368,  341,   -1,   -1,   -1,  782, 
          783,   -1,  785,   -1,  787,   -1,  789,   -1,  791,  792, 
           -1,   -1,   -1,   -1,   -1,   -1,  362,   -1,  677,   -1, 
           -1,   -1,  396,   -1,   -1,   -1,   -1,   -1,  687,   -1, 
           -1,  690,   -1,  328,  408,  409,  410,  328,   -1,  413, 
          335,   -1,   -1,   63,  335,  340,   -1,   -1,   -1,  340, 
           -1,   -1,  426,  427,  571,   -1,  430,   -1,   -1,  306, 
           -1,  308,  309,  310,  311,   -1,  361,   -1,   -1,   -1, 
          361,   -1,  306,   -1,  308,  309,  310,  311,  452,  453, 
          454,   -1,   -1,   -1,   -1,    0,  460,   -1,   -1,  463, 
           -1,   -1,  339,  340,   -1,   10,   -1,   -1,   -1,  473, 
          347,  348,  349,  350,   -1,  339,   -1,   -1,   -1,   -1, 
           -1,  894,  895,  896,  897,  349,  350,  900,  635,  902, 
          903,  904,  905,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
           -1,   -1,   -1,  262,  263,  264,   10,   -1,  267,  268, 
          269,   -1,  271,   58,   59,   -1,   -1,   -1,   63,  666, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  940,   -1,   -1, 
          943,  944,  945,  946,  293,  294,  295,  296,  297,   -1, 
          953,   -1,   -1,  306,   -1,  308,  309,  310,  311,   -1, 
           -1,  698,  699,   -1,   -1,   59,   -1,  704,  705,   -1, 
           -1,   -1,  851,   -1,  853,  328,  855,  571,  715,  716, 
          859,   -1,  335,  720,  578,  864,  339,  340,   -1,  338, 
           -1,   -1,  341,  317,  347,  348,  349,  350,  322,  323, 
           -1,   -1,   -1,   -1,   -1,  742,  743,  744,    0,  333, 
          334,  748,   -1,  362,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,  348,   -1,  350,   -1,  352,  353, 
          354,  355,  356,  357,  358,   -1,  360,   -1,   -1,   -1, 
           -1,  635,  921,   -1,   -1,   -1,   -1,   -1,   -1,  928, 
           -1,  930,   44,  932,   -1,   -1,   -1,   -1,   -1,   -1, 
          654,   -1,  799,   -1,   -1,   -1,   58,   59,   -1,   61, 
          949,   63,  666,  810,   -1,   -1,  813,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,   -1,  329, 
          330,   -1,   -1,  333,  334,  832,   -1,   -1,   -1,   91, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  348,   -1, 
          350,  705,  352,  353,  354,  355,  356,  357,  358,   -1, 
          360,  715,  716,   -1,   -1,  719,  720,  262,  263,  264, 
           -1,    0,  267,  268,  269,   -1,  271,   -1,  732,   -1, 
           -1,   10,   -1,  880,   -1,   -1,  281,  282,  742,  743, 
          744,   -1,   -1,   -1,  748,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,  317,   -1,   -1,   -1,   -1,   -1, 
          305,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,   -1, 
          333,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58, 
           59,   -1,   61,   -1,   63,  348,   -1,  350,   -1,  352, 
          353,  354,  355,  338,   -1,  799,  341,   -1,   -1,  344, 
           -1,  346,  306,  317,  308,  309,  310,  311,   -1,  813, 
           -1,   -1,   91,   -1,   -1,   -1,   -1,  362,   -1,  333, 
          334,   -1,   -1,   -1,  328,   -1,   -1,   -1,  832,  374, 
           -1,  335,   -1,   -1,  348,  339,  340,   -1,  352,  353, 
          354,  355,   -1,  347,  348,  349,  350,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,  858,  257,  258,  259,   -1,  261, 
          262,  263,  264,  265,  266,  267,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,  279,  280,  281, 
          282,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,   59,  299,   -1,   -1, 
          302,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,  337,  338,  339,  340,  341, 
          342,  343,  344,  345,  346,  347,  348,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
          362,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           10,  373,  374,  375,  376,   -1,  378,  379,  257,  258, 
          259,   -1,  261,  262,  263,  264,  265,  266,  267,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
          279,  280,  281,  282,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,  293,  294,  295,  296,  297,   59, 
          299,   -1,   -1,  302,  303,  304,  305,  306,  307,  308, 
          309,  310,  311,  312,  313,  314,  315,  316,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,   -1,  333,  334,  335,  336,  337,  338, 
          339,  340,  341,  342,  343,  344,  345,  346,  347,  348, 
          349,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,  362,   -1,  364,  365,  366,  367,  368, 
          369,    0,   -1,   -1,  373,  374,  375,  376,   -1,  378, 
          379,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  306,   -1,  308,  309,  310, 
          311,   -1,   -1,   -1,   -1,   44,   -1,  306,   -1,  308, 
          309,  310,  311,  306,   -1,  308,  309,  310,  311,   58, 
           59,   -1,   61,   -1,   63,   -1,   -1,   -1,  339,  340, 
           -1,   -1,   -1,   -1,   -1,  328,  347,  348,  349,  350, 
          339,   -1,  335,   -1,   -1,   -1,  339,  340,  347,  348, 
          349,  350,   91,   -1,  347,  348,  349,  350,   -1,   -1, 
           -1,  306,  307,   -1,   -1,  310,   -1,   -1,   -1,  314, 
          315,   -1,  317,  318,  319,  320,  321,  322,  323,   -1, 
           -1,  326,  327,   -1,    0,   -1,  331,  332,  333,  334, 
           -1,   -1,   -1,   -1,   10,  340,   -1,   -1,   -1,   -1, 
           -1,   -1,  347,  348,   -1,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,   -1,   -1,  363,  306, 
           -1,  308,  309,  310,  311,   -1,   -1,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  306,   -1,  308,  309, 
          310,  311,   58,   59,   -1,   61,   -1,   63,   -1,   -1, 
           -1,  317,  339,   -1,   -1,   -1,   -1,   -1,  328,   -1, 
          347,  348,  349,  350,   -1,  335,   -1,  333,  334,  339, 
          340,   -1,   -1,   -1,   -1,   91,   -1,  347,  348,  349, 
          350,   -1,  348,   -1,  350,   -1,  352,  353,  354,  355, 
           -1,   10,  358,   -1,  360,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,  258, 
          259,   -1,  261,  262,  263,  264,  265,  266,  267,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
           59,  280,  281,  282,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,  293,  294,  295,  296,  297,   -1, 
          299,   -1,   -1,  302,  303,  304,  305,  306,  307,  308, 
          309,  310,  311,  312,  313,  314,  315,  316,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,   -1,  333,  334,  335,  336,   -1,  338, 
          339,  340,  341,  342,  343,  344,  345,  346,  347,  348, 
          349,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,  362,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   10,  373,  374,  375,  376,   -1,  378, 
          379,  257,  258,  259,   -1,  261,  262,  263,  264,  265, 
          266,  267,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,   -1,  280,  281,  282,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,  292,  293,  294,  295, 
          296,  297,   59,  299,   -1,   -1,  302,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,   -1,  338,  339,  340,  341,  342,  343,  344,  345, 
          346,  347,  348,  349,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,  362,   -1,  364,  365, 
          366,  367,  368,  369,    0,   -1,   -1,  373,  374,  375, 
          376,   -1,  378,  379,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  306,   -1,  308, 
          309,  310,  311,   -1,   -1,   -1,   -1,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  328, 
           -1,   -1,   58,   59,   -1,   61,  335,   63,   -1,   -1, 
          339,  340,   -1,   -1,   -1,   -1,   -1,   -1,  347,  348, 
          349,  350,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   91,   -1,  306,  307,   -1, 
           -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317,  318, 
          319,  320,  321,  322,  323,   -1,   -1,  326,  327,   -1, 
           -1,   -1,  331,  332,  333,  334,   -1,    0,   -1,   -1, 
           -1,  340,   -1,   -1,   -1,   -1,   -1,   10,  347,  348, 
           -1,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,   -1,   -1,  363,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,   -1,   -1,   -1, 
           -1,   44,  333,  334,   -1,   -1,   -1,   -1,   -1,  306, 
           -1,  308,  309,  310,  311,   58,   59,  348,   -1,  350, 
           63,  352,  353,  354,  355,  356,  357,  358,   -1,  360, 
           -1,  328,   -1,   -1,   -1,   -1,   -1,   -1,  335,   -1, 
           -1,   -1,  339,  340,   -1,   -1,   -1,   -1,   91,   -1, 
          347,  348,  349,  350,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  257,  258,  259,   -1,  261,  262,  263,  264,  265, 
          266,  267,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,   -1,  280,  281,  282,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,  292,  293,  294,  295, 
          296,  297,   10,  299,   -1,   -1,  302,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,   -1,  338,  339,  340,  341,  342,  343,  344,  345, 
          346,  347,  348,  349,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,  362,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   10,  373,  374,  375, 
          376,   -1,  378,  379,  257,  258,  259,   -1,  261,  262, 
          263,  264,  265,  266,  267,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,   -1,  280,  281,  282, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,  292, 
          293,  294,  295,  296,  297,   59,  299,   -1,   -1,  302, 
          303,  304,  305,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,  336,   -1,  338,  339,  340,  341,  342, 
          343,  344,  345,  346,  347,  348,  349,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,  362, 
           -1,  364,  365,  366,  367,  368,  369,    0,   -1,   -1, 
          373,  374,  375,  376,   -1,  378,  379,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257, 
          258,  259,   -1,  261,   -1,   58,   59,  265,  266,   -1, 
           63,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   91,   -1, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,  312,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1, 
           10,  339,   -1,   -1,  342,  343,   -1,  345,   -1,  347, 
           -1,  349,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   44,  373,   -1,  375,  376,   -1, 
          378,  379,  306,   -1,  308,  309,  310,  311,   58,   59, 
           -1,   -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  328,   -1,   -1,   -1,   -1,   -1, 
           -1,  335,   -1,   -1,   -1,  339,  340,   -1,   -1,   -1, 
           -1,   91,   -1,  347,  348,  349,  350,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261,  262, 
          263,  264,  265,  266,  267,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,   59,  280,  281,  282, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,  292, 
          293,  294,  295,  296,  297,   -1,  299,   -1,   -1,  302, 
          303,  304,  305,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,  336,   -1,  338,  339,  340,  341,  342, 
          343,  344,  345,  346,  347,  348,  349,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,  362, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   10, 
          373,  374,  375,  376,   -1,  378,  379,  257,  258,  259, 
           -1,  261,  262,  263,  264,  265,  266,  267,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,   -1, 
          280,  281,  282,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,   59,  299, 
           -1,   -1,  302,  303,  304,  305,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,   -1,  338,  339, 
          340,  341,  342,  343,  344,  345,  346,  347,  348,  349, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,  362,   -1,  364,  365,  366,  367,  368,  369, 
            0,   -1,   -1,  373,  374,  375,  376,   -1,  378,  379, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  306,   -1,  308,  309,  310,  311,   -1, 
           -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  328,   -1,   -1,   58,   59, 
           -1,   61,  335,   63,   -1,   -1,  339,  340,   -1,   -1, 
           -1,   -1,   -1,   -1,  347,  348,  349,  350,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   91,   -1,  306,  307,   -1,   -1,  310,   -1,   -1, 
           -1,  314,  315,   -1,  317,  318,  319,  320,  321,  322, 
          323,   -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332, 
          333,  334,   -1,    0,   -1,   -1,   -1,  340,   -1,   -1, 
           -1,   -1,   -1,   10,  347,  348,   -1,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,   -1,   -1, 
          363,   -1,  317,  318,  319,  320,  321,  322,  323,  324, 
           -1,  326,  327,   -1,   -1,   -1,   -1,   44,  333,  334, 
           -1,   -1,   -1,   -1,   -1,  306,   -1,  308,  309,  310, 
          311,   -1,   59,  348,   -1,  350,   63,  352,  353,  354, 
          355,  356,  357,  358,   -1,  360,   -1,  328,   -1,   -1, 
           -1,   -1,   -1,   -1,  335,   -1,   -1,   -1,  339,  340, 
           -1,   -1,   -1,   -1,   91,   -1,  347,  348,  349,  350, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,  258,  259, 
           -1,  261,  262,  263,  264,  265,  266,  267,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,  281,  282,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,   10,  299, 
           -1,   -1,  302,  303,  304,  305,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,   -1,  338,  339, 
          340,  341,  342,  343,  344,  345,  346,  347,  348,  349, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,   -1,  362,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,  374,  375,  376,   -1,  378,  379, 
          257,  258,  259,   -1,  261,  262,  263,  264,  265,  266, 
          267,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,   -1,  280,  281,  282,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,  294,  295,  296, 
          297,   -1,  299,   -1,   -1,  302,  303,  304,   63,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,  336, 
           -1,  338,  339,   -1,  341,  342,  343,  344,  345,  346, 
          347,  348,  349,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  361,  362,   -1,  364,  365,  366, 
          367,  368,  369,    0,   -1,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261, 
           -1,   -1,   59,  265,  266,   -1,   63,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   91,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   10,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,   -1,   -1,   -1,   -1,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           44,  373,  297,  375,  376,   -1,  378,  379,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   59,   -1,   -1,   -1,   63, 
           -1,   -1,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,   -1,  329,  330,   -1,   -1,  333,  334, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1, 
           -1,   -1,   -1,  348,   -1,  350,   -1,  352,  353,  354, 
          355,  356,  357,  358,   -1,  360,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
          257,  258,  259,   -1,  261,  262,  263,  264,  265,  266, 
          267,  268,  269,  270,  271,  272, 
      };
   }

   private static final short[] yyCheck2() {
      return new short[] {

          273,  274,  275,  276,  277,  278,   -1,  280,  281,  282, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,  292, 
          293,  294,  295,  296,  297,   -1,  299,   59,   63,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,  336,   -1,  338,  339,   -1,  341,  342, 
          343,  344,  345,  346,  347,  348,  349,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,  362, 
           -1,  364,  365,  366,  367,  368,  369,   63,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  257,  258,  259, 
           -1,  261,  262,  263,  264,  265,  266,  267,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,  281,  282,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,   -1,  338,  339, 
           -1,  341,  342,  343,  344,  345,  346,  347,  348,  349, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,    0,  362,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   10,   -1,  373,   -1,  375,  376,   -1,  378,  379, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   44,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           59,   -1,   61,   -1,   63,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,   -1,  329,  330,   -1,   -1,  333,  334, 
           -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1,  341, 
           -1,   -1,  344,  348,  346,  350,   -1,  352,  353,  354, 
          355,  356,  357,  358,   -1,  360,   -1,   -1,   -1,   -1, 
          362,  297,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,   -1,  329,  330,   -1,   -1,  333,  334,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1, 
           -1,   -1,  348,   -1,  350,   -1,  352,  353,  354,  355, 
          356,  357,  358,   59,  360,   61,   -1,   63,   -1,   -1, 
           -1,  306,  307,   -1,   -1,  310,   -1,   -1,   -1,  314, 
          315,   -1,  317,  318,  319,  320,  321,  322,  323,   -1, 
           -1,  326,  327,   -1,   -1,   91,  331,  332,  333,  334, 
           -1,   -1,   -1,   -1,   -1,  340,   -1,   -1,   -1,   -1, 
           -1,   -1,  347,  348,   -1,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,   -1,    0,  363,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,  257,  258, 
          259,   -1,  261,  262,  263,  264,  265,  266,   -1,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
           -1,  280,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,  293,  294,  295,  296,  297,   -1, 
          299,   -1,   -1,  302,  303,  304,   59,  306,  307,  308, 
          309,  310,  311,  312,  313,  314,  315,  316,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,   -1,  333,  334,  335,  336,   -1,   -1, 
          339,  340,  341,  342,  343,   -1,  345,   -1,  347,  348, 
          349,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,  362,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378, 
          379,  257,  258,  259,   -1,  261,  262,  263,  264,  265, 
          266,   -1,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,   -1,  280,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,  292,  293,  294,  295, 
          296,  297,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,   -1,   -1,  339,  340,  341,  342,  343,   -1,  345, 
           -1,  347,  348,  349,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,  362,   -1,  364,  365, 
          366,  367,  368,  369,    0,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,   10,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,   -1,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   59,   -1,   61,   -1,   63,  317,  318, 
          319,  320,  321,  322,  323,   -1,   -1,  326,  327,   -1, 
           -1,   -1,   -1,   -1,  333,  334,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,  341,  348, 
           -1,  350,   -1,  352,  353,  354,  355,  356,  357,  358, 
           -1,  360,   -1,  257,  258,  259,   -1,  261,   -1,  362, 
           -1,  265,  266,   -1,   -1,   -1,  270,    0,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   10,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
           -1,   44,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   61,  333, 
           63,   -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343, 
           -1,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,  257,  258,  259,   -1,  261,  262,  263,  264,  265, 
          266,   -1,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,   -1,  280,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,  292,  293,  294,  295, 
          296,  297,   -1,  299,   -1,   -1,  302,  303,  304,   59, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,   -1,   -1,  339,  340,  341,  342,  343,   -1,  345, 
           -1,  347,  348,  349,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,  362,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  257,  258,  259,   -1,  261,  262, 
          263,  264,  265,  266,   -1,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,  292, 
          293,  294,  295,  296,  297,   -1,  299,   -1,   -1,  302, 
          303,  304,   44,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,  336,   -1,   -1,  339,  340,  341,  342, 
          343,   -1,  345,   -1,  347,  348,  349,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,   -1,  362, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  257,  258,  259, 
           -1,  261,  262,  263,  264,  265,  266,  267,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,  281,   -1,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,  328,   -1, 
           -1,   -1,   -1,   -1,   -1,  335,  336,   10,   -1,  339, 
           -1,  341,  342,  343,   -1,  345,   -1,  347,   -1,  349, 
           -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359, 
           -1,   -1,  362,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   44,   -1,  373,   -1,  375,  376,   -1,  378,  379, 
           -1,   -1,   -1,   -1,   -1,   58,   59,   -1,   61,   -1, 
           63,   -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   91,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,    0,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   10,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,   -1,   -1,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,  336,   -1,   -1,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,   -1,   58,   59,   -1,   -1, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,   -1,   91, 
          306,  307,   -1,   -1,  310,   -1,   -1,   -1,  314,  315, 
           -1,  317,  318,  319,  320,  321,  322,  323,   -1,   -1, 
          326,  327,    0,   -1,   -1,  331,  332,  333,  334,   -1, 
           -1,   -1,   10,   -1,  340,   -1,   -1,   -1,   -1,   -1, 
           -1,  347,  348,   -1,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,   -1,   -1,  363,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           58,   59,   -1,   61,   -1,   63,   -1,  280,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,   91,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,   -1,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,  348,    0,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,   10,  360,  361,  362, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,  374,   -1,   -1,   -1,   -1,   -1,   -1,  280,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           44,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,   58,   59,   -1,   -1,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,   -1,   -1,  338,   91,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,  348,   -1,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   -1,  360,  361, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  374,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,    0,  333,  334,  335,   -1,  337, 
          338,   -1,   -1,  341,   10,   -1,  344,   -1,  346,   -1, 
          348,   -1,  350,   -1,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,   -1,  362,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  374,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   58,   59,   -1,   61,   -1,   63,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  280,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   91,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,    0,  333, 
          334,  335,   -1,   -1,  338,   -1,   -1,  341,   10,   -1, 
          344,   -1,  346,   -1,  348,   -1,  350,   -1,  352,  353, 
          354,  355,  356,  357,  358,   -1,  360,  361,  362,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          374,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  306,  307,   58,   59,  310,   61, 
           -1,   63,  314,  315,   -1,  317,  318,  319,  320,  321, 
          322,  323,   -1,   -1,  326,  327,   -1,   -1,   -1,  331, 
          332,  333,  334,   -1,   -1,   -1,   -1,   -1,  340,   91, 
           -1,   -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,   -1, 
           -1,  363,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   44,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
           58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
           -1,   -1,  338,   91,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,  348,    0,  350,   -1,  352,  353,  354,  355, 
          356,  357,  358,   10,  360,   -1,  362,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  374,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   58,   59,   -1,   -1,   -1,   63,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,   91,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,  348,   -1,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,    0,  360,   -1, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,  374,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   58,   59,  305,   -1,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,   91,   -1, 
          338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1, 
          348,    0,  350,   -1,  352,  353,  354,  355,  356,  357, 
          358,   10,  360,   -1,  362,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,  374,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   44,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   58, 
           59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,   -1, 
           -1,  338,   91,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,  348,   -1,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   -1,  360,    0,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,  374,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   58,   59,   -1,   -1,   -1,   63,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,   -1,   -1,   91,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,   -1,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,  348,    0,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,   10,  360,   -1,  362, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,  374,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   58,   59,  305,   -1,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,   -1,  333,  334,  335,   91,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1,  348, 
           -1,  350,   -1,  352,  353,  354,  355,  356,  357,  358, 
           -1,  360,    0,  362,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,  374,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   44,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
           58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,  348,    0,  350,   -1,  352,  353,  354,  355, 
          356,  357,  358,   10,  360,   -1,  362,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  374,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   58,   59,   -1,   -1,   -1,   63,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,    0,  333, 
          334,  335,   -1,   -1,  338,   -1,   -1,  341,   10,   -1, 
          344,   -1,  346,   -1,  348,   -1,  350,   -1,  352,  353, 
          354,  355,  356,  357,  358,   -1,  360,   -1,  362,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          374,   -1,   44,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   58,   59,   -1,   -1, 
           -1,   63,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
           -1,  329,  330,   -1,   -1,  333,  334,   -1,   -1,   -1, 
          338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1, 
          348,    0,  350,   -1,  352,  353,  354,  355,  356,  357, 
          358,   10,  360,   -1,  362,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,  374,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   44,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   58, 
           59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1,   -1, 
           -1,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,   -1,  329,  330,   -1,   -1,  333,  334,   -1,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,  348,   -1,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   -1,  360,   -1,  362,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,  374,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           44,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,   58,   59,   -1,   -1,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,   -1,  329,  330,   -1, 
           -1,  333,  334,   -1,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,  348,    0,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   10,  360,   -1, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  374,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   58,   59,   -1,   -1,   -1, 
           63,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,   -1, 
          329,  330,   -1,    0,  333,  334,   -1,   -1,   -1,  338, 
           -1,   -1,  341,   10,   -1,  344,   -1,  346,   -1,  348, 
           -1,  350,   -1,  352,  353,  354,  355,  356,  357,  358, 
           -1,  360,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  374,   -1,   44,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   58,   59,   -1,   -1,   -1,   63,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   -1,  333, 
          334,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,   -1,  346,   -1,  348,    0,  350,   -1,  352,  353, 
          354,  355,  356,  357,  358,   10,  360,   -1,  362,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
          374,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   44, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,   58,   59,   -1,   -1,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,   -1,  329,  330,   -1,   -1, 
          333,  334,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,  348,   -1,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,    0,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,  374,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   58,   59,  305,   -1, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,   -1,  329,  330,   -1,   -1,  333,  334,   -1,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,  348,    0,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   10,  360,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  374,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           58,   59,   -1,   -1,   -1,   63,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,   -1,  329,  330,   -1,   -1,  333,  334, 
           -1,   -1,   -1,  338,    0,   -1,  341,   -1,   -1,  344, 
           -1,  346,   -1,   -1,   10,  350,   -1,   -1,   -1,  354, 
          355,  356,  357,  358,   -1,  360,   -1,  362,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  374, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   44,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   58,   59,   -1,   -1,   -1,   63,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,   -1,  329,  330,   -1, 
           -1,  333,  334,   -1,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,   -1,    0,  350,   -1, 
           -1,   -1,  354,  355,  356,  357,  358,   10,  360,   -1, 
          362,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,  374,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   58,   59,  305,   -1,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
           -1,  329,  330,   -1,   -1,  333,  334,   -1,   -1,   -1, 
          338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1, 
           -1,   -1,  350,   -1,   -1,   -1,   -1,   -1,  356,  357, 
          358,   -1,  360,   -1,  362,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,  374,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   44, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   58,   59,   -1,   -1,   -1,   63,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,   -1,  329,  330,   -1,   -1,  333,  334,   -1, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,   -1,    0,  350,   -1,   -1,   -1,   -1,   -1, 
          356,  357,  358,   10,  360,   -1,  362,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  374,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   44,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   58,   59,   -1,   -1,   -1,   63,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,   -1,  329,  330,   -1,   -1, 
           -1,   -1,    0,   -1,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,   10,  346,   -1,   -1,   -1,  350,   -1,   -1, 
           -1,   -1,   -1,  356,  357,  358,   -1,  360,   -1,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  374,   -1,   -1,   -1,   -1,   44,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           58,   59,   -1,   -1,   -1,   63,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,   -1,  329,  330,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,  338,   -1,   -1,  341,   -1,   -1,  344, 
           -1,  346,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  356,  357,  358,   -1,  360,   -1,  362,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,  374, 
          267,  268,  269,   -1,  271,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           58,   59,   -1,  290,  291,   63,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,   -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,  356, 
          357,  358,   10,  360,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,  374,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           58,   59,   -1,   -1,   -1,   63,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
           -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
          338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  356,  357, 
           -1,   -1,   -1,   -1,  362,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  374,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   63,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1, 
      };
   }

   private static final short[] yyCheck3() {
      return new short[] {

           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,   10,  346,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  356,  357,   -1,   -1,   -1,   -1,  362,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          374,   -1,   -1,   -1,   -1,   44,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   58, 
           59,   -1,   -1,   -1,   63,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   -1,   -1, 
           -1,   -1,   -1,    0,  338,   -1,   -1,  341,   -1,   -1, 
          344,   -1,  346,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  356,  357,   -1,  262,  263,  264,  362,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
          374,   -1,   -1,   -1,  281,  282,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   58,   59,   -1,   -1,   -1,   63,   -1,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,   -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  356, 
          357,    0,   -1,   -1,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,  374,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   58, 
           59,   -1,   -1,   -1,   63,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  324,  325,   -1,   -1,   -1, 
          329,  330,   -1,   -1,   -1,   -1,   -1,   -1,    0,  338, 
           -1,   -1,  341,   -1,   -1,  344,   -1,  346,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  374,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   58,   59,   -1,   -1, 
           -1,   63,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,    0,   -1,   -1,   -1,  305,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  324,  325,   -1, 
           -1,   -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,   44,  346, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   58,   59,   -1,  362,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  374,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,   -1,  324,  325,   -1,   -1,   -1, 
          329,  330,   58,   59,   -1,   -1,   -1,   63,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,  362,   -1,  267,  268,  269,   -1,  271, 
           -1,    0,   -1,   -1,   -1,  374,   -1,   -1,   -1,  281, 
          282,   10,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,   -1,  324,  325,   -1,   -1,   -1,  329,  330,   58, 
           59,   -1,   -1,   -1,   63,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,    0,   -1,   -1, 
          362,   -1,   -1,   -1,   -1,  281,  282,   10,   -1,   -1, 
           -1,   -1,  374,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
           -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,   -1,   -1,   10,   -1,   -1,  324,  325, 
           -1,   -1,   -1,  329,  330,   58,   59,   -1,   -1,   -1, 
           63,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   44, 
           -1,  267,  268,  269,   -1,  271,  362,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   59,  281,  282,   10,  374,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,   10,  324,  325, 
           -1,   -1,   -1,  329,  330,   58,   59,   -1,   -1,   -1, 
           63,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,  262,  263,  264,  362,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   58,   59,   -1,  374,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  324,  325,   -1,   -1,   -1, 
          329,  330,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,   44,  346,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           58,   59,   -1,  362,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   -1,  374,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,  262,  263,  264, 
           -1,   -1,  305,  268,  269,   -1,  271,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,  325,   -1,   -1,   -1,  329,  330,  293,  294, 
          295,  296,  297,   -1,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   44,   -1,  267,  268,  269,   -1,  271,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   58,   59,  281,  282, 
           -1,  374,   -1,   -1,   -1,   -1,  341,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,  262, 
          263,  264,  305,    0,  267,  268,  269,  362,  271,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,  338,   -1,   -1,  341,   -1, 
           -1,  344,  305,  346,   -1,   -1,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  362, 
           -1,   58,   59,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,  374,   -1,   -1,   10,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,  362, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   44,   -1, 
           -1,  374,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   58,   59,   -1,   -1,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          338,    0,   -1,  341,   -1,   -1,  344,   -1,  346,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,  362,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,  374,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   44,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   58, 
           59,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  338,   10,   -1,  341, 
           -1,   -1,  344,   -1,  346,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
          362,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   44,  374,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   58,   59,   -1,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,  338,   -1,   -1,  341,  281,  282,  344,   -1,  346, 
           -1,   -1,   -1,   -1,  290,  291,    0,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,  362,   10,   -1,   -1,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  374,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,   -1,   -1,   58,   59,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,  362,   10,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,  374,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   44,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   58,   59,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338, 
           -1,   -1,  341,    0,   -1,  344,   -1,  346,   -1,  262, 
          263,  264,   -1,   10,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,  362,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   -1,  374,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   44,   -1,   -1, 
           -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   58,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  362, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,  374,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   44,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,    0,   58,   59, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,  338,   -1,   -1,  341,  281,  282, 
          344,   44,  346,   -1,   -1,   -1,   -1,  290,  291,    0, 
          293,  294,  295,  296,  297,   -1,   59,   -1,  362,   10, 
           -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          374,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,  262,  263,  264,   59,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,  362, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,  374,   -1,  290,  291,    0,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   10,   -1,   -1,  305,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
           10,  338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,  362,   -1,  267,  268,  269, 
           59,  271,   -1,   -1,   44,   -1,   -1,  374,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   58,   59, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,  338,   -1, 
           -1,  341,   -1,   -1,  344,   -1,  346,   -1,   -1,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,  374,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   59,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,  338,   -1,   -1,  341,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  305,   -1,   91,   -1,   -1,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,   -1,  346,   -1,  262,  263,  264, 
           -1,   10,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,  362,   -1,  262,  263,  264,  281,  282,   -1,  268, 
          269,   -1,  271,  374,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  262,  263,  264,   -1,   -1,  267,  268,  269, 
          305,  271,   -1,   -1,  293,  294,  295,  296,  297,   -1, 
           59,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,   -1,   -1,   -1, 
           -1,   -1,   -1,  338,   -1,  305,  341,   -1,   -1,  344, 
           -1,  346,   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  341,   -1,   -1,   -1,   -1,  362,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,  374, 
           -1,  341,   -1,  362,  344,   -1,  346,   -1,   -1,   -1, 
           -1,  256,  257,  258,  259,  260,  261,  262,  263,  264, 
          265,  266,  362,   10,  269,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,  374,  280,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,  298,  299,   -1,  301,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  328,   -1,   -1,   -1,   -1,   -1,   -1, 
          335,  336,   -1,   -1,  339,  340,   -1,  342,  343,   -1, 
          345,   -1,  347,   -1,   91,   -1,  351,   -1,   -1,   -1, 
           -1,  356,   -1,   -1,  359,   -1,  361,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,  373,   -1, 
          375,  376,   -1,  378,  379,   -1,   -1,  256,  257,  258, 
          259,  260,  261,  262,  263,  264,  265,  266,   -1,   10, 
          269,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,  280,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298, 
          299,   -1,  301,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   59,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  328, 
           -1,   -1,   -1,   -1,   -1,   -1,  335,  336,   -1,   -1, 
          339,  340,   -1,  342,  343,   -1,  345,   -1,  347,   -1, 
           91,   -1,  351,   -1,   -1,   -1,   -1,  356,   -1,   -1, 
          359,   -1,  361,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378, 
          379,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256, 
          257,  258,  259,  260,  261,  262,  263,  264,  265,  266, 
           -1,   10,  269,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,  280,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,  298,  299,   -1,  301,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
           59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  328,   -1,   -1,   -1,   -1,   -1,   -1,  335,  336, 
           -1,   -1,  339,  340,   -1,  342,  343,   -1,  345,   -1, 
          347,   -1,   91,   -1,  351,   -1,   -1,   -1,   -1,  356, 
           -1,   -1,  359,   -1,  361,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,   -1,   -1,  256,  257,  258,  259,  260, 
          261,  262,  263,  264,  265,  266,   -1,   10,  269,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299,   -1, 
          301,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,   59,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  328,   -1,   -1, 
           -1,   -1,   -1,   -1,  335,  336,   -1,   -1,  339,  340, 
           -1,  342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1, 
          351,   -1,   -1,   -1,   -1,  356,   -1,   -1,  359,   -1, 
           -1,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,  257,  258, 
          259,  260,  261,  262,  263,  264,  265,  266,   -1,   10, 
          269,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298, 
          299,   -1,  301,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   59,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  328, 
           -1,   -1,   -1,   -1,   -1,   -1,  335,  336,   -1,   -1, 
          339,   -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1, 
           -1,   -1,  351,   -1,   -1,   -1,   -1,  356,   -1,   -1, 
          359,   -1,   -1,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378, 
          379,   -1,   -1,  256,  257,  258,  259,  260,  261,  262, 
          263,  264,  265,  266,   -1,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,   10,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   59,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  256,  257,  258,  259,  260, 
          261,   -1,   -1,  264,  265,  266,   -1,   -1,   -1,  270, 
           10,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299,   -1, 
          301,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,   -1,   -1,   -1,   59, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1, 
           -1,  342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1, 
          351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1, 
           -1,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  256,  257,  258,  259,  260,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,    0,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   10,  292,   -1, 
           -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  336,   -1,   -1,  339,   59,   -1,  342,  343, 
           -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  359,   -1,    0,  362,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   10,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,   -1,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   44,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   59,   -1,   61,  299, 
           63,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,    0,  339, 
           -1,   -1,  342,  343,   -1,  345,   -1,   -1,   10,   -1, 
           -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359, 
           -1,   -1,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378,  379, 
           -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   -1, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,   -1,  268,  269,   -1,  271,   91, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,    0,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  341,  262, 
          263,  264,   -1,   59,   -1,  268,  269,   63,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  280,   -1,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   91,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,   -1,   -1,   -1,   -1,   -1,  341,   -1, 
           -1,   -1,   -1,   -1,   -1,  348,    0,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,   10,  360,  361,  362, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           44,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   59,   -1,   -1,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,   -1,   -1,   -1,   91,   -1,  341, 
           -1,   -1,   -1,   -1,   -1,   -1,  348,   -1,  350,    0, 
          352,  353,  354,  355,  356,  357,  358,   -1,  360,   10, 
          362,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1, 
           61,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
           91,   -1,   -1,   -1,   -1,  341,   -1,   -1,   -1,   -1, 
           -1,   -1,  348,   -1,  350,   -1,  352,  353,  354,  355, 
          356,  357,  358,    0,  360,   -1,  362,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   59,   -1,   61,   -1,   63,  281,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1, 
           -1,   -1,   -1,   -1,  348,   -1,  350,    0,  352,  353, 
          354,  355,  356,  357,  358,   -1,  360,   10,  362,   -1, 
           -1,  262,  263,  264,   -1,   -1,   -1,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   44,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   61,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,   -1,  337,   -1,   91,   -1, 
          341,   -1,   -1,   -1,   -1,   -1,   -1,  348,   -1,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,    0,  360, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
           -1,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,   44,  290,  291,   -1,  293,  294,  295,  296, 
          297,   10,   -1,   -1,   -1,   -1,   -1,   59,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   44,  333,  334,  335,   -1, 
           -1,   -1,   -1,   -1,  341,   -1,   -1,   -1,   -1,   -1, 
           59,  348,    0,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   10,  360,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,  262, 
          263,  264,   -1,   -1,   -1,  268,  269,   -1,  271,   -1, 
           -1,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   -1, 
           -1,   -1,   -1,   -1,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,    0,   -1,   -1,   -1,   -1,  341,   -1, 
           -1,   -1,   -1,   10,   -1,  348,   -1,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,   -1,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   59,   -1,   -1,   -1,   -1,    0,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,  341, 
           -1,   -1,  344,   -1,  346,   -1,   59,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          362,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   44,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  341,  281,  282,  344,   -1,  346,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
          262,  263,  264,  362,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  362,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  341, 
           -1,   -1,  344,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
          362,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   59,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,  341,   -1,   -1,  344,  281,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,  362,   -1,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  341,  299, 
           -1,   -1,  302,  303,  304,   59,  306,  307,  308,  309, 
          310,  311,   -1,  313,   -1,   -1,  316,   -1,   -1,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339, 
           -1,   -1,  342,  343,   -1,  345,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1, 
      };
   }

   private static final short[] yyCheck4() {
      return new short[] {

           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  257,  258,  259,  260,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,  300,  301,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  257,  258,  259, 
          260,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299, 
           -1,  301,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339, 
           -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1,   -1, 
           -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359, 
           -1,   -1,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378,  379, 
          256,  257,  258,  259,  260,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,  298,  299,  300,  301,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  256,  257,  258,  259,  260,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,  256,  257, 
          258,  259,  260,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
          298,  299,   -1,  301,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1, 
           -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1,  347, 
           -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1, 
          378,  379,  257,  258,  259,  260,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,  298,  299,  300,  301,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1, 
          345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,  373,   -1, 
          375,  376,   -1,  378,  379,  257,  258,  259,  260,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,  312,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1, 
          339,   -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1, 
          349,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          359,   -1,   -1,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378, 
          379,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,  347,   -1,  349,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,  347,   -1,  349,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339, 
           -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1,   -1, 
           -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359, 
           -1,   -1,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378,  379, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336, 
           -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1, 
           -1,   -1,  349,   -1,  351,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343, 
           -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1, 
           -1,  342,  343,   -1,  345,   -1,   -1,   -1,   -1,   -1, 
          351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1, 
           -1,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,  257, 
          258,  259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1, 
           -1,  339,  340,   -1,  342,  343,   -1,  345,   -1,   -1, 
           -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1, 
          378,  379,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1, 
          345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,  373,   -1, 
          375,  376,   -1,  378,  379,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1, 
          339,   -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1, 
           -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          359,   -1,   -1,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378, 
          379,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339, 
          340,   -1,  342,  343,   -1,  345,   -1,   -1,   -1,   -1, 
           -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359, 
           -1,   -1,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378,  379, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336, 
           -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1, 
           -1,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343, 
           -1,  345,   -1,   -1,   -1,   -1,   -1,  351,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1, 
           -1,  342,  343,   -1,  345,   -1,   -1,   -1,   -1,   -1, 
          351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1, 
           -1,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,  257, 
          258,  259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1, 
           -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1,   -1, 
           -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1, 
          378,  379,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,   -1, 
           -1,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1, 
          345,   -1,  347,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,  373,   -1, 
          375,  376,   -1,  378,  379,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,   -1,   -1,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,   -1,   -1,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1, 
          339,   -1,   -1,  342,  343,   -1,  345,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378, 
          379,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,   -1,   -1, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,   -1,   -1,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,   -1,   -1,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339, 
           -1,   -1,  342,  343,   -1,  345,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378,  379, 
          257,  258,  259,  260,  261,  262,  263,  264,   -1,   -1, 
          267,  268,  269,  270,  271,   -1,   -1,  274,  275,  276, 
          277,  278,  279,  280,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,  294,  295,  296, 
          297,  298,  299,  300,  301,  302,  303,  304,   -1,  306, 
          307,  308,   -1,  310,   -1,   -1,   -1,  314,  315,   -1, 
          317,  318,  319,  320,  321,  322,  323,   -1,   -1,  326, 
          327,   -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          347,  348,   -1,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,   -1,   -1,  363,  364,  257,  258, 
          259,  260,  261,  262,  263,  264,   -1,   -1,  267,  268, 
          269,  270,  271,   -1,   -1,  274,  275,  276,  277,  278, 
          279,  280,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,  293,  294,  295,  296,  297,  298, 
          299,  300,  301,  302,  303,  304,   -1,  306,  307,   -1, 
           -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317,  318, 
          319,  320,  321,  322,  323,   -1,   -1,  326,  327,   -1, 
           -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  347,  348, 
           -1,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,   -1,   -1,  363,  364,  257,  258,  259,  260, 
          261,  262,  263,  264,   -1,   -1,  267,  268,  269,  270, 
          271,   -1,   -1,  274,  275,  276,  277,  278,  279,  280, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,  298,  299,  300, 
          301,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,   -1,  314,  315,   -1,  317,  318,  319,  320, 
          321,  322,  323,   -1,   -1,  326,  327,   -1,   -1,   -1, 
          331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1,  340, 
           -1,   -1,   -1,   -1,   -1,   -1,  347,  348,   -1,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
           -1,   -1,  363,  257,  258,  259,  260,  261,  262,  263, 
          264,   -1,   -1,  267,  268,  269,  270,  271,   -1,   -1, 
          274,  275,  276,  277,  278,  279,  280,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,  298,  299,  300,  301,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,   -1, 
          314,  315,   -1,  317,  318,  319,  320,  321,  322,  323, 
           -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332,  333, 
          334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  347,  348,   -1,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,   -1,   -1,  363, 
          257,  258,  259,  260,  261,  262,  263,  264,   -1,   -1, 
          267,  268,  269,  270,  271,   -1,   -1,  274,  275,  276, 
          277,  278,  279,  280,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,  294,  295,  296, 
          297,  298,  299,  300,  301,  302,  303,  304,   -1,  306, 
          307,   -1,   -1,  310,   -1,   -1,   -1,  314,  315,   -1, 
          317,  318,  319,  320,  321,  322,  323,   -1,   -1,  326, 
          327,   -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          347,  348,   -1,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  306,  307,  363,   -1,  310,   -1, 
           -1,   -1,  314,  315,   -1,  317,  318,  319,  320,  321, 
          322,  323,   -1,   -1,  326,  327,   -1,   -1,   -1,  331, 
          332,  333,  334,   -1,   -1,   -1,   -1,   -1,  340,   -1, 
           -1,   -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  306, 
          307,  363,   -1,  310,   -1,   -1,   -1,  314,  315,   -1, 
          317,  318,  319,  320,  321,  322,  323,   -1,   -1,  326, 
          327,   -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1, 
           -1,   -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,   -1, 
          347,  348,   -1,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  306,  307,  363,   -1,  310,   -1, 
           -1,   -1,  314,  315,   -1,  317,  318,  319,  320,  321, 
          322,  323,   -1,   -1,  326,  327,   -1,   -1,   -1,  331, 
          332,  333,  334,   -1,   -1,   -1,   -1,   -1,  340,   -1, 
           -1,   -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  306, 
          307,  363,   -1,  310,   -1,   -1,   -1,  314,  315,   -1, 
          317,  318,  319,  320,  321,  322,  323,   -1,   -1,  326, 
          327,   -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1, 
           -1,   -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,   -1, 
          347,  348,   -1,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  306,  307,  363,   -1,  310,   -1, 
           -1,   -1,  314,  315,   -1,  317,  318,  319,  320,  321, 
          322,  323,   -1,   -1,  326,  327,   -1,   -1,   -1,  331, 
          332,  333,  334,   -1,   -1,   -1,   -1,   -1,  340,   -1, 
           -1,   -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  306, 
          307,  363,   -1,  310,   -1,   -1,   -1,  314,  315,   -1, 
          317,  318,  319,  320,  321,  322,  323,   -1,   -1,  326, 
          327,   -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1, 
           -1,   -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,   -1, 
          347,  348,   -1,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  306,  307,  363,   -1,  310,   -1, 
           -1,   -1,  314,  315,   -1,  317,  318,  319,  320,  321, 
          322,  323,   -1,   -1,  326,  327,   -1,   -1,   -1,  331, 
          332,  333,  334,   -1,   -1,   -1,   -1,   -1,  340,   -1, 
           -1,   -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  306, 
          307,  363,   -1,  310,   -1,   -1,   -1,  314,  315,   -1, 
          317,  318,  319,  320,  321,  322,  323,   -1,   -1,  326, 
          327,   -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          347,  348,   -1,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,   -1,   -1,  363, 
      };
   }

}
