/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Map;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class GVarAliasInstr
extends Instr {
    private Operand newName;
    private Operand oldName;

    public GVarAliasInstr(Operand newName, Operand oldName) {
        super(Operation.GVAR_ALIAS);
        this.newName = newName;
        this.oldName = oldName;
    }

    @Override
    public Operand[] getOperands() {
        return new Operand[]{this.newName, this.oldName};
    }

    @Override
    public String toString() {
        return this.getOperation().toString() + "(" + this.newName + ", " + this.oldName + ")";
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
        this.oldName = this.oldName.getSimplifiedOperand(valueMap, force);
        this.newName = this.newName.getSimplifiedOperand(valueMap, force);
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return new GVarAliasInstr(this.newName.cloneForInlining(ii), this.oldName.cloneForInlining(ii));
    }

    @Override
    public Object interpret(ThreadContext context, DynamicScope currDynScope, IRubyObject self2, Object[] temp, Block block) {
        String newNameString = this.newName.retrieve(context, self2, currDynScope, temp).toString();
        String oldNameString = this.oldName.retrieve(context, self2, currDynScope, temp).toString();
        context.runtime.getGlobalVariables().alias(newNameString, oldNameString);
        return null;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.GVarAliasInstr(this);
    }
}

