/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jcodings.Encoding;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyClassPathVariable;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.java.addons.ArrayJavaAddons;
import org.jruby.java.addons.IOJavaAddons;
import org.jruby.java.addons.KernelJavaAddons;
import org.jruby.java.addons.StringJavaAddons;
import org.jruby.java.codegen.RealClassGenerator;
import org.jruby.java.dispatch.CallableSelector;
import org.jruby.java.invokers.RubyToJavaInvoker;
import org.jruby.java.proxies.ArrayJavaProxy;
import org.jruby.java.proxies.ArrayJavaProxyCreator;
import org.jruby.java.proxies.ConcreteJavaProxy;
import org.jruby.java.proxies.InterfaceJavaProxy;
import org.jruby.java.proxies.JavaInterfaceTemplate;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.java.proxies.MapJavaProxy;
import org.jruby.java.proxies.RubyObjectHolderProxy;
import org.jruby.java.util.BlankSlateWrapper;
import org.jruby.java.util.SystemPropertiesMap;
import org.jruby.javasupport.JavaArray;
import org.jruby.javasupport.JavaArrayUtilities;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaConstructor;
import org.jruby.javasupport.JavaField;
import org.jruby.javasupport.JavaMethod;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaProxyMethods;
import org.jruby.javasupport.JavaSupport;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.JavaUtilities;
import org.jruby.javasupport.ParameterTypes;
import org.jruby.javasupport.binding.Initializer;
import org.jruby.javasupport.proxy.JavaProxyClass;
import org.jruby.javasupport.proxy.JavaProxyClassFactory;
import org.jruby.javasupport.proxy.JavaProxyConstructor;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;
import org.jruby.util.ByteList;
import org.jruby.util.ClassCache;
import org.jruby.util.ClassProvider;
import org.jruby.util.IdUtil;
import org.jruby.util.SafePropertyAccessor;
import org.jruby.util.cli.Options;
import org.jruby.util.collections.IntHashMap;

@JRubyModule(name={"Java"})
public class Java
implements Library {
    public static final boolean NEW_STYLE_EXTENSION = Options.JI_NEWSTYLEEXTENSION.load();
    public static final boolean OBJECT_PROXY_CACHE = Options.JI_OBJECTPROXYCACHE.load();
    private static final Pattern CAMEL_CASE_PACKAGE_SPLITTER = Pattern.compile("([a-z][0-9]*)([A-Z])");
    static final boolean JAVA8;

    @Override
    public void load(Ruby runtime, boolean wrap2) throws IOException {
        Java.createJavaModule(runtime);
        RubyModule jpmt = runtime.defineModule("JavaPackageModuleTemplate");
        jpmt.getSingletonClass().setSuperClass(new BlankSlateWrapper(runtime, jpmt.getMetaClass().getSuperClass(), runtime.getKernel()));
        runtime.getLoadService().require("jruby/java");
        RubyClass ArrayJavaProxy2 = runtime.getClass("ArrayJavaProxy");
        ArrayJavaProxy2.setSuperClass(runtime.getJavaSupport().getObjectJavaClass().getProxyClass());
        ArrayJavaProxy2.includeModule(runtime.getEnumerable());
        RubyClassPathVariable.createClassPathVariable(runtime);
        runtime.setJavaProxyClassFactory(JavaProxyClassFactory.createFactory());
        SystemPropertiesMap systemProperties = new SystemPropertiesMap();
        RubyClass proxyClass = (RubyClass)Java.getProxyClass(runtime, SystemPropertiesMap.class);
        runtime.getObject().setConstantQuiet("ENV_JAVA", new MapJavaProxy(runtime, proxyClass, systemProperties));
    }

    public static RubyModule createJavaModule(Ruby runtime) {
        ThreadContext context = runtime.getCurrentContext();
        RubyModule Java2 = runtime.defineModule("Java");
        Java2.defineAnnotatedMethods(Java.class);
        RubyClass _JavaObject = JavaObject.createJavaObjectClass(runtime, Java2);
        JavaArray.createJavaArrayClass(runtime, Java2, _JavaObject);
        JavaClass.createJavaClassClass(runtime, Java2, _JavaObject);
        JavaMethod.createJavaMethodClass(runtime, Java2);
        JavaConstructor.createJavaConstructorClass(runtime, Java2);
        JavaField.createJavaFieldClass(runtime, Java2);
        JavaProxyMethods.createJavaProxyMethods(context);
        JavaProxy.createJavaProxy(context);
        ArrayJavaProxyCreator.createArrayJavaProxyCreator(context);
        ConcreteJavaProxy.createConcreteJavaProxy(context);
        InterfaceJavaProxy.createInterfaceJavaProxy(context);
        ArrayJavaProxy.createArrayJavaProxy(context);
        MapJavaProxy.createMapJavaProxy(runtime);
        JavaProxyClass.createJavaProxyClasses(runtime, Java2);
        JavaInterfaceTemplate.createJavaInterfaceTemplateModule(context);
        runtime.defineModule("JavaUtilities").defineAnnotatedMethods(JavaUtilities.class);
        JavaArrayUtilities.createJavaArrayUtilitiesModule(runtime);
        runtime.getArray().defineAnnotatedMethods(ArrayJavaAddons.class);
        runtime.getKernel().defineAnnotatedMethods(KernelJavaAddons.class);
        runtime.getString().defineAnnotatedMethods(StringJavaAddons.class);
        runtime.getIO().defineAnnotatedMethods(IOJavaAddons.class);
        if (runtime.getObject().isConstantDefined("StringIO")) {
            ((RubyClass)runtime.getObject().getConstant("StringIO")).defineAnnotatedMethods(IOJavaAddons.AnyIO.class);
        }
        Java.addNameClassMappings(runtime, runtime.getJavaSupport().getNameClassMap());
        runtime.getJavaSupport().setObjectJavaClass(JavaClass.get(runtime, Object.class));
        return Java2;
    }

    private static void addNameClassMappings(Ruby runtime, Map<String, JavaClass> nameClassMap) {
        JavaClass booleanClass = JavaClass.get(runtime, Boolean.class);
        nameClassMap.put("boolean", JavaClass.get(runtime, Boolean.TYPE));
        nameClassMap.put("Boolean", booleanClass);
        nameClassMap.put("java.lang.Boolean", booleanClass);
        JavaClass byteClass = JavaClass.get(runtime, Byte.class);
        nameClassMap.put("byte", JavaClass.get(runtime, Byte.TYPE));
        nameClassMap.put("Byte", byteClass);
        nameClassMap.put("java.lang.Byte", byteClass);
        JavaClass shortClass = JavaClass.get(runtime, Short.class);
        nameClassMap.put("short", JavaClass.get(runtime, Short.TYPE));
        nameClassMap.put("Short", shortClass);
        nameClassMap.put("java.lang.Short", shortClass);
        JavaClass charClass = JavaClass.get(runtime, Character.class);
        nameClassMap.put("char", JavaClass.get(runtime, Character.TYPE));
        nameClassMap.put("Character", charClass);
        nameClassMap.put("Char", charClass);
        nameClassMap.put("java.lang.Character", charClass);
        JavaClass intClass = JavaClass.get(runtime, Integer.class);
        nameClassMap.put("int", JavaClass.get(runtime, Integer.TYPE));
        nameClassMap.put("Integer", intClass);
        nameClassMap.put("Int", intClass);
        nameClassMap.put("java.lang.Integer", intClass);
        JavaClass longClass = JavaClass.get(runtime, Long.class);
        nameClassMap.put("long", JavaClass.get(runtime, Long.TYPE));
        nameClassMap.put("Long", longClass);
        nameClassMap.put("java.lang.Long", longClass);
        JavaClass floatClass = JavaClass.get(runtime, Float.class);
        nameClassMap.put("float", JavaClass.get(runtime, Float.TYPE));
        nameClassMap.put("Float", floatClass);
        nameClassMap.put("java.lang.Float", floatClass);
        JavaClass doubleClass = JavaClass.get(runtime, Double.class);
        nameClassMap.put("double", JavaClass.get(runtime, Double.TYPE));
        nameClassMap.put("Double", doubleClass);
        nameClassMap.put("java.lang.Double", doubleClass);
        JavaClass bigintClass = JavaClass.get(runtime, BigInteger.class);
        nameClassMap.put("big_int", bigintClass);
        nameClassMap.put("big_integer", bigintClass);
        nameClassMap.put("BigInteger", bigintClass);
        nameClassMap.put("java.math.BigInteger", bigintClass);
        JavaClass bigdecimalClass = JavaClass.get(runtime, BigDecimal.class);
        nameClassMap.put("big_decimal", bigdecimalClass);
        nameClassMap.put("BigDecimal", bigdecimalClass);
        nameClassMap.put("java.math.BigDecimal", bigdecimalClass);
        JavaClass objectClass = JavaClass.get(runtime, Object.class);
        nameClassMap.put("object", objectClass);
        nameClassMap.put("Object", objectClass);
        nameClassMap.put("java.lang.Object", objectClass);
        JavaClass stringClass = JavaClass.get(runtime, String.class);
        nameClassMap.put("string", stringClass);
        nameClassMap.put("String", stringClass);
        nameClassMap.put("java.lang.String", stringClass);
        nameClassMap.put("void", JavaClass.get(runtime, Void.TYPE));
        nameClassMap.put("Void", JavaClass.get(runtime, Void.class));
    }

    public static IRubyObject create_proxy_class(IRubyObject self2, IRubyObject name2, IRubyObject javaClass, IRubyObject module) {
        Ruby runtime = self2.getRuntime();
        if (!(module instanceof RubyModule)) {
            throw runtime.newTypeError(module, runtime.getModule());
        }
        RubyModule proxyClass = Java.get_proxy_class(self2, javaClass);
        String constName = name2.asJavaString();
        IRubyObject existing = ((RubyModule)module).getConstantNoConstMissing(constName);
        if (existing != null && existing != RubyBasicObject.UNDEF && existing != proxyClass) {
            runtime.getWarnings().warn("replacing " + existing + " with " + proxyClass + " in constant '" + constName + " on class/module " + module);
        }
        ((RubyModule)module).setConstantQuiet(name2.asJavaString(), proxyClass);
        return proxyClass;
    }

    public static IRubyObject get_java_class(IRubyObject self2, IRubyObject name2) {
        try {
            return JavaClass.for_name(self2, name2);
        }
        catch (Exception e) {
            self2.getRuntime().getJavaSupport().handleNativeException(e, null);
            return self2.getRuntime().getNil();
        }
    }

    public static IRubyObject getInstance(Ruby runtime, Object rawJavaObject) {
        return Java.getInstance(runtime, rawJavaObject, false);
    }

    public static IRubyObject getInstance(Ruby runtime, Object rawJavaObject, boolean forceCache) {
        if (rawJavaObject != null) {
            RubyClass proxyClass = (RubyClass)Java.getProxyClass(runtime, rawJavaObject.getClass());
            if (OBJECT_PROXY_CACHE || forceCache || proxyClass.getCacheProxy()) {
                return runtime.getJavaSupport().getObjectProxyCache().getOrCreate(rawJavaObject, proxyClass);
            }
            return Java.allocateProxy(rawJavaObject, proxyClass);
        }
        return runtime.getNil();
    }

    public static RubyModule getInterfaceModule(Ruby runtime, JavaClass javaClass) {
        return Java.getInterfaceModule(runtime, javaClass.javaClass());
    }

    public static RubyModule getInterfaceModule(Ruby runtime, Class javaClass) {
        return Java.getProxyClass(runtime, javaClass);
    }

    public static RubyModule get_interface_module(Ruby runtime, IRubyObject javaClassObject) {
        JavaClass javaClass;
        if (javaClassObject instanceof RubyString) {
            javaClass = JavaClass.forNameVerbose(runtime, javaClassObject.asJavaString());
        } else if (javaClassObject instanceof JavaClass) {
            javaClass = (JavaClass)javaClassObject;
        } else {
            throw runtime.newArgumentError("expected JavaClass, got " + javaClassObject);
        }
        return Java.getInterfaceModule(runtime, javaClass);
    }

    public static RubyModule get_proxy_class(IRubyObject self2, IRubyObject java_class2) {
        JavaClass javaClass;
        Ruby runtime = self2.getRuntime();
        if (java_class2 instanceof RubyString) {
            javaClass = JavaClass.for_name(self2, java_class2);
        } else if (java_class2 instanceof JavaClass) {
            javaClass = (JavaClass)java_class2;
        } else {
            throw runtime.newTypeError(java_class2, runtime.getJavaSupport().getJavaClassClass());
        }
        return Java.getProxyClass(runtime, javaClass);
    }

    public static RubyClass getProxyClassForObject(Ruby runtime, Object object) {
        return (RubyClass)Java.getProxyClass(runtime, object.getClass());
    }

    public static RubyModule getProxyClass(Ruby runtime, JavaClass javaClass) {
        return Java.getProxyClass(runtime, javaClass.javaClass());
    }

    public static RubyModule getProxyClass(Ruby runtime, Class<?> clazz) {
        RubyModule proxy2 = runtime.getJavaSupport().getUnfinishedProxy(clazz);
        if (proxy2 != null) {
            return proxy2;
        }
        return runtime.getJavaSupport().getProxyClassFromCache(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RubyModule createProxyClassForClass(Ruby runtime, Class<?> clazz) {
        RubyModule proxy2;
        JavaSupport javaSupport = runtime.getJavaSupport();
        RubyClass superClass = null;
        if (clazz.isInterface()) {
            proxy2 = (RubyModule)runtime.getJavaSupport().getJavaInterfaceTemplate().dup();
        } else {
            superClass = clazz.isArray() ? javaSupport.getArrayProxyClass() : (clazz.isPrimitive() ? javaSupport.getConcreteProxyClass() : (clazz == Object.class ? javaSupport.getConcreteProxyClass() : (RubyClass)Java.getProxyClass(runtime, clazz.getSuperclass())));
            proxy2 = RubyClass.newClass(runtime, superClass);
        }
        javaSupport.beginProxy(clazz, proxy2);
        try {
            if (clazz.isInterface()) {
                Java.generateInterfaceProxy(runtime, clazz, proxy2);
            } else {
                Java.generateClassProxy(runtime, clazz, (RubyClass)proxy2, superClass, javaSupport);
            }
        }
        finally {
            javaSupport.endProxy(clazz);
        }
        return proxy2;
    }

    private static void generateInterfaceProxy(Ruby runtime, Class javaClass, RubyModule proxy2) {
        assert (javaClass.isInterface()) : "not an interface: " + javaClass;
        Class<?>[] extended2 = javaClass.getInterfaces();
        int i2 = extended2.length;
        while (--i2 >= 0) {
            RubyModule extModule = Java.getInterfaceModule(runtime, extended2[i2]);
            proxy2.includeModule(extModule);
        }
        Initializer.setupProxyModule(runtime, javaClass, proxy2);
        Java.addToJavaPackageModule(proxy2);
    }

    private static void generateClassProxy(Ruby runtime, Class<?> clazz, RubyClass proxy2, RubyClass superClass, JavaSupport javaSupport) {
        if (clazz.isArray()) {
            Java.createProxyClass(runtime, proxy2, clazz, true);
            if (clazz.getComponentType() == Byte.TYPE) {
                proxy2.defineAnnotatedMethods(ByteArrayProxyMethods.class);
            }
        } else if (clazz.isPrimitive()) {
            Java.createProxyClass(runtime, proxy2, clazz, true);
        } else if (clazz == Object.class) {
            Java.createProxyClass(runtime, proxy2, clazz, true);
            if (NEW_STYLE_EXTENSION) {
                proxy2.getMetaClass().defineAnnotatedMethods(NewStyleExtensionInherited.class);
            } else {
                proxy2.getMetaClass().defineAnnotatedMethods(OldStyleExtensionInherited.class);
            }
            Java.addToJavaPackageModule(proxy2);
        } else {
            Java.createProxyClass(runtime, proxy2, clazz, false);
            Class<?>[] interfaces2 = clazz.getInterfaces();
            int i2 = interfaces2.length;
            while (--i2 >= 0) {
                proxy2.includeModule(Java.getInterfaceModule(runtime, interfaces2[i2]));
            }
            if (Modifier.isPublic(clazz.getModifiers())) {
                Java.addToJavaPackageModule(proxy2);
            }
        }
        if (Modifier.isFinal(clazz.getModifiers())) {
            final String clazzName = clazz.getCanonicalName();
            proxy2.getMetaClass().addMethod("inherited", new org.jruby.internal.runtime.methods.JavaMethod((RubyModule)proxy2, Visibility.PUBLIC){

                @Override
                public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
                    throw context.runtime.newTypeError("can not extend final Java class: " + clazzName);
                }
            });
        }
    }

    private static RubyClass createProxyClass(Ruby runtime, RubyClass proxyClass, Class<?> javaClass, boolean invokeInherited) {
        RubyClass superClass = proxyClass.getSuperClass();
        proxyClass.makeMetaClass(superClass.getMetaClass());
        if (Map.class.isAssignableFrom(javaClass)) {
            proxyClass.setAllocator(runtime.getJavaSupport().getMapJavaProxyClass().getAllocator());
            proxyClass.defineAnnotatedMethods(MapJavaProxy.class);
            proxyClass.includeModule(runtime.getEnumerable());
        } else {
            proxyClass.setAllocator(superClass.getAllocator());
        }
        proxyClass.defineAnnotatedMethods(JavaProxy.ClassMethods.class);
        if (invokeInherited) {
            proxyClass.inherit(superClass);
        }
        Initializer.setupProxyClass(runtime, javaClass, proxyClass);
        return proxyClass;
    }

    public static IRubyObject concrete_proxy_inherited(IRubyObject clazz, IRubyObject subclazz) {
        Ruby runtime = clazz.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        JavaSupport javaSupport = runtime.getJavaSupport();
        RubyClass javaProxyClass = javaSupport.getJavaProxyClass().getMetaClass();
        Helpers.invokeAs(context, javaProxyClass, clazz, "inherited", subclazz, Block.NULL_BLOCK);
        if (!(subclazz instanceof RubyClass)) {
            throw runtime.newTypeError(subclazz, runtime.getClassClass());
        }
        Java.setupJavaSubclass(context, (RubyClass)subclazz);
        return context.nil;
    }

    private static void setupJavaSubclass(ThreadContext context, RubyClass subclass) {
        subclass.getInstanceVariables().setInstanceVariable("@java_proxy_class", context.nil);
        subclass.setCacheProxy(true);
        RubyClass subclassSingleton = subclass.getSingletonClass();
        subclassSingleton.addReadWriteAttribute(context, "java_proxy_class");
        subclassSingleton.addMethod("java_interfaces", new JavaMethod.JavaMethodZero(subclassSingleton, Visibility.PUBLIC){

            @Override
            public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2) {
                IRubyObject javaInterfaces = self2.getInstanceVariables().getInstanceVariable("@java_interfaces");
                if (javaInterfaces != null) {
                    return javaInterfaces.dup();
                }
                return context.nil;
            }
        });
        subclass.addMethod("__jcreate!", new JavaMethod.JavaMethodN(subclassSingleton, Visibility.PUBLIC){
            private final IntHashMap<JavaProxyConstructor> cache = CallableSelector.newCallableCache();

            @Override
            public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2) {
                ParameterTypes[] constructors2;
                int argsLength;
                ArrayList forArity;
                IRubyObject proxyClass = self2.getMetaClass().getInstanceVariables().getInstanceVariable("@java_proxy_class");
                if (proxyClass == null || proxyClass.isNil()) {
                    proxyClass = JavaProxyClass.get_with_class(self2, self2.getMetaClass());
                    self2.getMetaClass().getInstanceVariables().setInstanceVariable("@java_proxy_class", proxyClass);
                }
                if ((forArity = Java.findCallablesForArity((int)(argsLength = args2.length), (ParameterTypes[])(constructors2 = ((JavaProxyClass)proxyClass).getConstructors()))).size() == 0) {
                    throw context.runtime.newArgumentError("wrong number of arguments for constructor");
                }
                JavaProxyConstructor matching = (JavaProxyConstructor)CallableSelector.matchingCallableArityN((Ruby)context.runtime, this.cache, (ParameterTypes[])forArity.toArray(new JavaProxyConstructor[forArity.size()]), (IRubyObject[])args2);
                if (matching == null) {
                    throw context.runtime.newArgumentError("wrong number of arguments for constructor");
                }
                Object[] javaArgs = RubyToJavaInvoker.convertArguments(matching, args2);
                JavaObject newObject2 = matching.newInstance(self2, javaArgs);
                return JavaUtilities.set_java_object(self2, self2, newObject2);
            }
        });
    }

    static <T extends ParameterTypes> ArrayList<T> findCallablesForArity(int arity2, T[] callables) {
        ArrayList<T> forArity = new ArrayList<T>(callables.length);
        for (int i2 = 0; i2 < callables.length; ++i2) {
            T callable = callables[i2];
            int callableArity = callable.getArity();
            if (callableArity == arity2) {
                forArity.add(callable);
                continue;
            }
            if (!callable.isVarArgs() || callableArity - 1 > arity2) continue;
            forArity.add(callable);
        }
        return forArity;
    }

    private static void addToJavaPackageModule(RubyModule proxyClass) {
        String className;
        RubyModule parentModule;
        Ruby runtime = proxyClass.getRuntime();
        Class clazz = (Class)proxyClass.dataGetStruct();
        String fullName = clazz.getName();
        if (fullName == null) {
            return;
        }
        if (fullName.indexOf(36) != -1) {
            Class<?> declaringClass = clazz.getDeclaringClass();
            if (declaringClass == null) {
                return;
            }
            parentModule = Java.getProxyClass(runtime, JavaClass.get(runtime, clazz));
            className = clazz.getSimpleName();
        } else {
            int endPackage = fullName.lastIndexOf(46);
            String packageString = endPackage < 0 ? "" : fullName.substring(0, endPackage);
            parentModule = Java.getJavaPackageModule(runtime, packageString);
            String string2 = className = parentModule == null ? fullName : fullName.substring(endPackage + 1);
        }
        if (parentModule != null && IdUtil.isConstant(className) && parentModule.getConstantAt(className) == null) {
            parentModule.setConstant(className, proxyClass);
        }
    }

    public static RubyModule getJavaPackageModule(Ruby runtime, Package pkg) {
        return Java.getJavaPackageModule(runtime, pkg == null ? "" : pkg.getName());
    }

    private static RubyModule getJavaPackageModule(Ruby runtime, String packageString) {
        String packageName;
        int length2 = packageString.length();
        if (length2 == 0) {
            packageName = "Default";
        } else {
            StringBuilder name2 = new StringBuilder(length2);
            int start2 = 0;
            while (start2 < length2) {
                int offset2 = packageString.indexOf(46, start2);
                if (offset2 == -1) {
                    offset2 = length2;
                }
                name2.append(Character.toUpperCase(packageString.charAt(start2))).append(packageString.substring(start2 + 1, offset2));
                start2 = offset2 + 1;
            }
            packageName = name2.toString();
        }
        RubyModule javaModule = runtime.getJavaSupport().getJavaModule();
        IRubyObject packageModule = javaModule.getConstantAt(packageName);
        if (packageModule == null) {
            return Java.createPackageModule(runtime, javaModule, packageName, packageString);
        }
        if (packageModule instanceof RubyModule) {
            return (RubyModule)packageModule;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RubyModule createPackageModule(Ruby runtime, RubyModule parentModule, String name2, String packageString) {
        RubyModule packageModule = (RubyModule)runtime.getJavaSupport().getPackageModuleTemplate().dup();
        String package_name = packageString.length() > 0 ? packageString + '.' : packageString;
        packageModule.setInstanceVariable("@package_name", runtime.newString(package_name));
        packageModule.addClassProvider(JavaPackageClassProvider.INSTANCE);
        RubyModule rubyModule = parentModule;
        synchronized (rubyModule) {
            IRubyObject packageAlreadySet = parentModule.fetchConstant(name2);
            if (packageAlreadySet != null) {
                return (RubyModule)packageAlreadySet;
            }
            parentModule.setConstant(name2.intern(), packageModule);
            MetaClass metaClass = (MetaClass)packageModule.getMetaClass();
            metaClass.setAttached(packageModule);
        }
        return packageModule;
    }

    private static RubyModule getPackageModule(Ruby runtime, String name2) {
        String packageName;
        RubyModule javaModule = runtime.getJavaSupport().getJavaModule();
        IRubyObject packageModule = javaModule.getConstantAt(name2);
        if (packageModule instanceof RubyModule) {
            return (RubyModule)packageModule;
        }
        if ("Default".equals(name2)) {
            packageName = "";
        } else {
            Matcher match2 = CAMEL_CASE_PACKAGE_SPLITTER.matcher(name2);
            packageName = match2.replaceAll("$1.$2").toLowerCase();
        }
        return Java.createPackageModule(runtime, javaModule, name2, packageName);
    }

    public static RubyModule get_package_module(IRubyObject self2, IRubyObject name2) {
        return Java.getPackageModule(self2.getRuntime(), name2.asJavaString());
    }

    public static IRubyObject get_package_module_dot_format(IRubyObject self2, IRubyObject dottedName) {
        Ruby runtime = self2.getRuntime();
        RubyModule module = Java.getJavaPackageModule(runtime, dottedName.asJavaString());
        return module == null ? runtime.getNil() : module;
    }

    private static RubyModule getProxyOrPackageUnderPackage(ThreadContext context, RubyModule parentPackage, String name2, boolean cacheMethod) {
        RubyModule result2;
        block14: {
            Ruby runtime = context.runtime;
            if (name2.length() == 0) {
                throw runtime.newArgumentError("empty class or package name");
            }
            IRubyObject package_name = parentPackage.getInstanceVariable("@package_name");
            if (package_name == null) {
                throw runtime.newArgumentError("invalid package module");
            }
            String parentPackageName = package_name.asJavaString();
            String fullName = parentPackageName + name2;
            if (!Character.isUpperCase(name2.charAt(0))) {
                Java.checkJavaReservedNames(runtime, name2, false);
                RubyModule proxyClass = Java.getProxyClassOrNull(runtime, fullName);
                if (proxyClass != null) {
                    result2 = proxyClass;
                } else {
                    RubyModule packageModule = Java.getJavaPackageModule(runtime, fullName);
                    if (packageModule == null) {
                        return null;
                    }
                    result2 = packageModule;
                }
            } else {
                try {
                    RubyModule javaClass = Java.getProxyClassOrNull(runtime, fullName);
                    if (javaClass != null) {
                        result2 = javaClass;
                        break block14;
                    }
                    if (Java.allowUppercasePackageNames(runtime)) {
                        result2 = Java.getJavaPackageModule(runtime, fullName);
                        if (result2 == null) {
                            throw runtime.newNameError("missing class (or package) name (`" + fullName + "')", fullName);
                        }
                        break block14;
                    }
                    throw runtime.newNameError("missing class name (`" + fullName + "')", fullName);
                }
                catch (RuntimeException e) {
                    if (e instanceof RaiseException) {
                        throw e;
                    }
                    throw runtime.newNameError("missing class or uppercase package name (`" + fullName + "'), caused by " + e.getMessage(), fullName);
                }
            }
        }
        if (cacheMethod) {
            Java.bindJavaPackageOrClassMethod(parentPackage, name2, result2);
        }
        return result2;
    }

    private static boolean allowUppercasePackageNames(Ruby runtime) {
        return runtime.getInstanceConfig().getAllowUppercasePackageNames();
    }

    private static void checkJavaReservedNames(Ruby runtime, String name2, boolean allowPrimitives) {
        if (!allowPrimitives && JavaClass.isPrimitiveName(name2)) {
            throw runtime.newArgumentError("illegal package name component: " + name2);
        }
    }

    private static RubyModule getProxyClassOrNull(Ruby runtime, String className) {
        return Java.getProxyClassOrNull(runtime, className, true);
    }

    private static RubyModule getProxyClassOrNull(Ruby runtime, String className, boolean initJavaClass) {
        Class clazz;
        try {
            clazz = runtime.getJavaSupport().loadJavaClass(className);
        }
        catch (ExceptionInInitializerError ex) {
            throw runtime.newNameError("cannot initialize Java class " + className, className, ex, false);
        }
        catch (LinkageError ex) {
            throw runtime.newNameError("cannot link Java class " + className, className, ex, false);
        }
        catch (SecurityException ex) {
            throw runtime.newSecurityError(ex.getLocalizedMessage());
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
        if (initJavaClass) {
            return Java.getProxyClass(runtime, JavaClass.get(runtime, clazz));
        }
        return Java.getProxyClass(runtime, clazz);
    }

    public static IRubyObject get_proxy_or_package_under_package(ThreadContext context, IRubyObject self2, IRubyObject parentPackage, IRubyObject name2) {
        Ruby runtime = context.runtime;
        if (!(parentPackage instanceof RubyModule)) {
            throw runtime.newTypeError(parentPackage, runtime.getModule());
        }
        RubyModule result2 = Java.getProxyOrPackageUnderPackage(context, (RubyModule)parentPackage, name2.asJavaString(), true);
        return result2 != null ? result2 : context.nil;
    }

    private static RubyModule getTopLevelProxyOrPackage(Ruby runtime, String name2, boolean cacheMethod) {
        RubyModule result2;
        if (name2.length() == 0) {
            throw runtime.newArgumentError("empty class or package name");
        }
        if (Character.isLowerCase(name2.charAt(0))) {
            RubyModule proxyClass = Java.getProxyClassOrNull(runtime, name2);
            if (proxyClass != null) {
                result2 = proxyClass;
            } else {
                Java.checkJavaReservedNames(runtime, name2, true);
                RubyModule packageModule = Java.getJavaPackageModule(runtime, name2);
                if (packageModule == null) {
                    return null;
                }
                result2 = packageModule;
            }
        } else {
            RubyModule javaClass = Java.getProxyClassOrNull(runtime, name2);
            result2 = javaClass != null ? javaClass : Java.getPackageModule(runtime, name2);
        }
        if (cacheMethod) {
            Java.bindJavaPackageOrClassMethod(runtime, name2, result2);
        }
        return result2;
    }

    private static boolean bindJavaPackageOrClassMethod(Ruby runtime, String name2, RubyModule packageOrClass) {
        RubyModule javaPackage = runtime.getJavaSupport().getJavaModule();
        return Java.bindJavaPackageOrClassMethod(javaPackage, name2, packageOrClass);
    }

    private static boolean bindJavaPackageOrClassMethod(RubyModule parentPackage, String name2, RubyModule packageOrClass) {
        if (parentPackage.getMetaClass().isMethodBound(name2, false)) {
            return false;
        }
        RubyClass singleton = parentPackage.getSingletonClass();
        singleton.addMethod(name2.intern(), new JavaAccessor(singleton, packageOrClass, parentPackage));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(meta=true)
    public static IRubyObject const_missing(ThreadContext context, IRubyObject self2, IRubyObject name2) {
        Ruby runtime = context.runtime;
        String constName = name2.asJavaString();
        RubyModule packageOrClass = Java.getTopLevelProxyOrPackage(runtime, constName, false);
        if (packageOrClass != null) {
            RubyModule Java2;
            RubyModule rubyModule = Java2 = (RubyModule)self2;
            synchronized (rubyModule) {
                IRubyObject alreadySet = Java2.fetchConstant(constName);
                if (alreadySet != null) {
                    return (RubyModule)alreadySet;
                }
                Java2.setConstant(constName, packageOrClass);
            }
            return packageOrClass;
        }
        return context.nil;
    }

    @JRubyMethod(name={"method_missing"}, meta=true, required=1)
    public static IRubyObject method_missing(ThreadContext context, IRubyObject self2, IRubyObject name2) {
        RubyModule result2 = Java.getTopLevelProxyOrPackage(context.runtime, name2.asJavaString(), true);
        if (result2 != null) {
            return result2;
        }
        return context.nil;
    }

    @JRubyMethod(name={"method_missing"}, meta=true, rest=true)
    public static IRubyObject method_missing(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        IRubyObject name2 = args2[0];
        if (args2.length > 1) {
            int count2 = args2.length - 1;
            throw context.runtime.newArgumentError("Java does not have a method `" + name2 + "' with " + count2 + " arguments");
        }
        return Java.method_missing(context, self2, name2);
    }

    public static IRubyObject get_top_level_proxy_or_package(ThreadContext context, IRubyObject self2, IRubyObject name2) {
        RubyModule result2 = Java.getTopLevelProxyOrPackage(context.runtime, name2.asJavaString(), true);
        return result2 != null ? result2 : context.nil;
    }

    public static IRubyObject wrap(Ruby runtime, IRubyObject java_object2) {
        return Java.getInstance(runtime, ((JavaObject)java_object2).getValue());
    }

    @Deprecated
    @JRubyMethod(frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject java_to_ruby(IRubyObject recv2, IRubyObject object, Block unusedBlock) {
        try {
            return JavaUtil.java_to_ruby(recv2.getRuntime(), object);
        }
        catch (RuntimeException e) {
            recv2.getRuntime().getJavaSupport().handleNativeException(e, null);
            return recv2.getRuntime().getNil();
        }
    }

    @Deprecated
    @JRubyMethod(frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject ruby_to_java(IRubyObject recv2, IRubyObject object, Block unusedBlock) {
        return JavaUtil.ruby_to_java(recv2, object, unusedBlock);
    }

    @Deprecated
    @JRubyMethod(frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject java_to_primitive(IRubyObject recv2, IRubyObject object, Block unusedBlock) {
        return JavaUtil.java_to_primitive(recv2, object, unusedBlock);
    }

    @JRubyMethod(required=2, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject new_proxy_instance2(IRubyObject recv2, IRubyObject wrapper, IRubyObject ifcs, Block block) {
        IRubyObject[] javaClasses = ((RubyArray)ifcs).toJavaArray();
        Class[] interfaces2 = new Class[javaClasses.length];
        for (int i2 = 0; i2 < javaClasses.length; ++i2) {
            if (!(javaClasses[i2] instanceof JavaClass) || !((JavaClass)javaClasses[i2]).interface_p().isTrue()) {
                throw recv2.getRuntime().newArgumentError("Java interface expected. got: " + javaClasses[i2]);
            }
            interfaces2[i2] = ((JavaClass)javaClasses[i2]).javaClass();
        }
        return Java.newInterfaceImpl(wrapper, interfaces2);
    }

    public static IRubyObject newInterfaceImpl(final IRubyObject wrapper, Class[] interfaces2) {
        final Ruby runtime = wrapper.getRuntime();
        Class[] tmp_interfaces = interfaces2;
        interfaces2 = new Class[tmp_interfaces.length + 1];
        System.arraycopy(tmp_interfaces, 0, interfaces2, 0, tmp_interfaces.length);
        interfaces2[tmp_interfaces.length] = RubyObjectHolderProxy.class;
        if (!RubyInstanceConfig.INTERFACES_USE_PROXY) {
            Class proxyImplClass;
            ClassLoader classLoader;
            int interfacesHashCode = Java.interfacesHashCode(interfaces2);
            if (wrapper.getMetaClass().isSingleton() && wrapper.getMetaClass().getRealClass() == runtime.getProc()) {
                interfacesHashCode = 31 * interfacesHashCode + runtime.getProc().hashCode();
                classLoader = runtime.getJRubyClassLoader();
            } else {
                interfacesHashCode = 31 * interfacesHashCode + wrapper.getMetaClass().getRealClass().hashCode();
                classLoader = new ClassCache.OneShotClassLoader(runtime.getJRubyClassLoader());
            }
            String implClassName = "org.jruby.gen.InterfaceImpl" + Math.abs(interfacesHashCode);
            try {
                proxyImplClass = Class.forName(implClassName, true, runtime.getJRubyClassLoader());
            }
            catch (ClassNotFoundException cnfe) {
                proxyImplClass = RealClassGenerator.createOldStyleImplClass(interfaces2, wrapper.getMetaClass(), runtime, implClassName, classLoader);
            }
            try {
                Constructor proxyConstructor = proxyImplClass.getConstructor(IRubyObject.class);
                return JavaObject.wrap(runtime, proxyConstructor.newInstance(wrapper));
            }
            catch (NoSuchMethodException nsme) {
                throw runtime.newTypeError("Exception instantiating generated interface impl:\n" + nsme);
            }
            catch (InvocationTargetException ite) {
                throw runtime.newTypeError("Exception instantiating generated interface impl:\n" + ite);
            }
            catch (InstantiationException ie) {
                throw runtime.newTypeError("Exception instantiating generated interface impl:\n" + ie);
            }
            catch (IllegalAccessException iae) {
                throw runtime.newTypeError("Exception instantiating generated interface impl:\n" + iae);
            }
        }
        Object proxyObject = Proxy.newProxyInstance(runtime.getJRubyClassLoader(), interfaces2, new InvocationHandler(){
            private final Map<Method, Class[]> parameterTypeCache = new ConcurrentHashMap<Method, Class[]>();

            @Override
            public Object invoke(Object proxy2, Method method2, Object[] nargs) throws Throwable {
                int length2;
                String methodName = method2.getName();
                int n = length2 = nargs == null ? 0 : nargs.length;
                if (methodName.equals("toString") && length2 == 0) {
                    return proxy2.getClass().getName();
                }
                if (methodName.equals("hashCode") && length2 == 0) {
                    return proxy2.getClass().hashCode();
                }
                if (methodName.equals("equals") && length2 == 1) {
                    Class[] parameterTypes = this.parameterTypeCache.get(method2);
                    if (parameterTypes == null) {
                        parameterTypes = method2.getParameterTypes();
                        this.parameterTypeCache.put(method2, parameterTypes);
                    }
                    if (parameterTypes[0].equals(Object.class)) {
                        return proxy2 == nargs[0];
                    }
                } else if (methodName == "__ruby_object" && length2 == 0) {
                    return wrapper;
                }
                IRubyObject[] rubyArgs = JavaUtil.convertJavaArrayToRuby(runtime, nargs);
                try {
                    return Helpers.invoke(runtime.getCurrentContext(), wrapper, methodName, rubyArgs).toJava(method2.getReturnType());
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    throw e;
                }
            }
        });
        return JavaObject.wrap(runtime, proxyObject);
    }

    public static Class generateRealClass(RubyClass clazz) {
        Class proxyImplClass;
        block3: {
            Ruby runtime = clazz.getRuntime();
            Class[] interfaces2 = Java.getInterfacesFromRubyClass(clazz);
            int interfacesHashCode = Java.interfacesHashCode(interfaces2);
            interfacesHashCode = 31 * interfacesHashCode + clazz.hashCode();
            String implClassName = clazz.getBaseName() == null ? "anon_class" + Math.abs(System.identityHashCode(clazz)) + "_" + Math.abs(interfacesHashCode) : clazz.getName().replaceAll("::", "\\$\\$") + "_" + Math.abs(interfacesHashCode);
            try {
                proxyImplClass = Class.forName(implClassName, true, runtime.getJRubyClassLoader());
            }
            catch (ClassNotFoundException cnfe) {
                Class<RubyObject> superClass = clazz.getSuperClass().getRealClass().getReifiedClass();
                if (superClass == null) {
                    superClass = RubyObject.class;
                }
                proxyImplClass = RealClassGenerator.createRealImplClass(superClass, interfaces2, clazz, runtime, implClassName);
                if (!NEW_STYLE_EXTENSION || RubyBasicObject.class.isAssignableFrom(proxyImplClass) || clazz.getMethods().containsKey("initialize")) break block3;
                clazz.addMethod("initialize", new JavaMethod.JavaMethodZero(clazz, Visibility.PRIVATE){

                    @Override
                    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2) {
                        return context.nil;
                    }
                });
            }
        }
        clazz.setReifiedClass(proxyImplClass);
        clazz.setRubyClassAllocator(proxyImplClass);
        return proxyImplClass;
    }

    public static Constructor getRealClassConstructor(Ruby runtime, Class<?> proxyImplClass) {
        try {
            return proxyImplClass.getConstructor(Ruby.class, RubyClass.class);
        }
        catch (NoSuchMethodException nsme) {
            throw runtime.newTypeError("Exception instantiating generated interface impl:\n" + nsme);
        }
    }

    public static IRubyObject constructProxy(Ruby runtime, Constructor proxyConstructor, RubyClass clazz) {
        try {
            return (IRubyObject)proxyConstructor.newInstance(runtime, clazz);
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
            throw runtime.newTypeError("Exception instantiating generated interface impl:\n" + ite);
        }
        catch (InstantiationException ie) {
            throw runtime.newTypeError("Exception instantiating generated interface impl:\n" + ie);
        }
        catch (IllegalAccessException iae) {
            throw runtime.newTypeError("Exception instantiating generated interface impl:\n" + iae);
        }
    }

    public static IRubyObject allocateProxy(Object javaObject, RubyClass clazz) {
        if (clazz.getSuperClass() == clazz.getRuntime().getJavaSupport().getArrayProxyClass()) {
            return new ArrayJavaProxy(clazz.getRuntime(), clazz, javaObject, JavaUtil.getJavaConverter(javaObject.getClass().getComponentType()));
        }
        IRubyObject proxy2 = clazz.allocate();
        if (proxy2 instanceof JavaProxy) {
            ((JavaProxy)proxy2).setObject(javaObject);
        } else {
            JavaObject wrappedObject = JavaObject.wrap(clazz.getRuntime(), javaObject);
            proxy2.dataWrapStruct(wrappedObject);
        }
        return proxy2;
    }

    public static IRubyObject wrapJavaObject(Ruby runtime, Object object) {
        return Java.allocateProxy(object, Java.getProxyClassForObject(runtime, object));
    }

    public static Class[] getInterfacesFromRubyClass(RubyClass klass) {
        HashSet interfaces2 = new HashSet();
        while (klass != null) {
            IRubyObject maybeInterfaces = klass.getInstanceVariables().getInstanceVariable("@java_interfaces");
            if (maybeInterfaces instanceof RubyArray) {
                RubyArray moreInterfaces = (RubyArray)maybeInterfaces;
                if (!moreInterfaces.isFrozen()) {
                    moreInterfaces.setFrozen(true);
                }
                interfaces2.addAll(moreInterfaces);
            }
            klass = klass.getSuperClass();
        }
        return interfaces2.toArray(new Class[interfaces2.size()]);
    }

    private static int interfacesHashCode(Class[] a) {
        if (a == null) {
            return 0;
        }
        int result2 = 1;
        for (Class element : a) {
            result2 = 31 * result2 + (element == null ? 0 : element.hashCode());
        }
        return result2;
    }

    @Deprecated
    private static void addToJavaPackageModule(RubyModule proxyClass, JavaClass javaClass) {
        Java.addToJavaPackageModule(proxyClass);
    }

    @Deprecated
    private static RubyClass createProxyClass(Ruby runtime, RubyClass baseType, JavaClass javaClass, boolean invokeInherited) {
        return Java.createProxyClass(runtime, RubyClass.newClass(runtime, baseType), javaClass, invokeInherited);
    }

    public static Method getFunctionalInterfaceMethod(Class<?> iface) {
        assert (iface.isInterface());
        Method single = null;
        for (Method method2 : iface.getMethods()) {
            int mod = method2.getModifiers();
            if (Modifier.isStatic(mod) || !Modifier.isAbstract(mod)) continue;
            try {
                Object.class.getMethod(method2.getName(), method2.getParameterTypes());
                continue;
            }
            catch (NoSuchMethodException e) {
            }
            catch (SecurityException e) {
                // empty catch block
            }
            if (single == null) {
                single = method2;
                continue;
            }
            return null;
        }
        return single;
    }

    static boolean isDefaultMethod(Method method2) {
        if (JAVA8) {
            try {
                return (Boolean)Method.class.getMethod("isDefault", new Class[0]).invoke((Object)method2, new Object[0]);
            }
            catch (NoSuchMethodException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        return false;
    }

    static {
        boolean java8 = false;
        String version = SafePropertyAccessor.getProperty("java.version", "0.0");
        if (version.length() > 2) {
            int v = Character.getNumericValue(version.charAt(0));
            if (v > 8) {
                java8 = true;
            } else if (v == 1 && (v = Character.getNumericValue(version.charAt(2))) < 10 && v >= 8) {
                java8 = true;
            }
        }
        JAVA8 = java8;
    }

    static final class ProcToInterface
    extends DynamicMethod {
        ProcToInterface(RubyClass singletonClass) {
            super(singletonClass, Visibility.PUBLIC, CallConfiguration.FrameNoneScopeNone);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            IRubyObject[] newArgs;
            if (!(self2 instanceof RubyProc)) {
                throw context.runtime.newTypeError("interface impl method_missing for block used with non-Proc object");
            }
            RubyProc proc2 = (RubyProc)self2;
            switch (args2.length) {
                case 1: {
                    newArgs = IRubyObject.NULL_ARRAY;
                    break;
                }
                case 2: {
                    newArgs = new IRubyObject[]{args2[1]};
                    break;
                }
                case 3: {
                    newArgs = new IRubyObject[]{args2[1], args2[2]};
                    break;
                }
                default: {
                    newArgs = new IRubyObject[args2.length - 1];
                    System.arraycopy(args2, 1, newArgs, 0, newArgs.length);
                }
            }
            return proc2.call(context, newArgs);
        }

        @Override
        public DynamicMethod dup() {
            return this;
        }
    }

    private static class JavaAccessor
    extends org.jruby.internal.runtime.methods.JavaMethod {
        private final RubyModule packageOrClass;
        private final RubyModule parentPackage;

        JavaAccessor(RubyClass singleton, RubyModule packageOrClass, RubyModule parentPackage) {
            super(singleton, Visibility.PUBLIC);
            this.parentPackage = parentPackage;
            this.packageOrClass = packageOrClass;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            if (args2.length != 0) {
                IRubyObject packageName = this.parentPackage.callMethod("package_name");
                throw context.runtime.newArgumentError("Java package `" + packageName + "' does not have a method `" + name2 + "'");
            }
            return this.call(context, self2, clazz, name2);
        }

        @Override
        public final IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2) {
            return this.packageOrClass;
        }

        @Override
        public final IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, Block block) {
            return this.packageOrClass;
        }

        @Override
        public Arity getArity() {
            return Arity.noArguments();
        }
    }

    public static class ByteArrayProxyMethods {
        @JRubyMethod
        public static IRubyObject to_s(ThreadContext context, IRubyObject self2) {
            Encoding ascii8bit = context.runtime.getEncodingService().getAscii8bitEncoding();
            ByteList bytes2 = new ByteList((byte[])((ArrayJavaProxy)self2).getObject(), ascii8bit);
            return RubyString.newStringLight(context.runtime, bytes2);
        }
    }

    @Deprecated
    public static class JavaProxyClassMethods
    extends JavaProxy.ClassMethods {
    }

    private static class JavaPackageClassProvider
    implements ClassProvider {
        static final JavaPackageClassProvider INSTANCE = new JavaPackageClassProvider();

        private JavaPackageClassProvider() {
        }

        @Override
        public RubyClass defineClassUnder(RubyModule pkg, String name2, RubyClass superClazz) {
            if (superClazz != null) {
                return null;
            }
            String packageName = JavaPackageClassProvider.getPackageName(pkg);
            if (packageName == null) {
                return null;
            }
            Ruby runtime = pkg.getRuntime();
            JavaClass javaClass = JavaClass.forNameVerbose(runtime, packageName + name2);
            return (RubyClass)Java.get_proxy_class(runtime.getJavaSupport().getJavaUtilitiesModule(), javaClass);
        }

        @Override
        public RubyModule defineModuleUnder(RubyModule pkg, String name2) {
            String packageName = JavaPackageClassProvider.getPackageName(pkg);
            if (packageName == null) {
                return null;
            }
            Ruby runtime = pkg.getRuntime();
            JavaClass javaClass = JavaClass.forNameVerbose(runtime, packageName + name2);
            return Java.get_interface_module(runtime, javaClass);
        }

        private static String getPackageName(RubyModule pkg) {
            IRubyObject package_name = pkg.getInstanceVariables().getInstanceVariable("@package_name");
            return package_name == null ? null : package_name.asJavaString();
        }
    }

    public static class NewStyleExtensionInherited {
        @JRubyMethod
        public static IRubyObject inherited(IRubyObject self2, IRubyObject arg0) {
            Ruby runtime = self2.getRuntime();
            if (!(arg0 instanceof RubyClass)) {
                throw runtime.newTypeError(arg0, runtime.getClassClass());
            }
            JavaInterfaceTemplate.addRealImplClassNew((RubyClass)arg0);
            return runtime.getNil();
        }
    }

    public static class OldStyleExtensionInherited {
        @JRubyMethod
        public static IRubyObject inherited(IRubyObject self2, IRubyObject arg0) {
            return Java.concrete_proxy_inherited(self2, arg0);
        }
    }
}

